/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.tasklist.core.export;

import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.util.ResourceBundle;
import javax.swing.AbstractButton;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JFileChooser;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import org.netbeans.modules.tasklist.core.util.SimpleWizardPanel;
import org.openide.DialogDisplayer;
import org.openide.NotifyDescriptor;
import org.openide.awt.Mnemonics;
import org.openide.util.NbBundle;

public class SaveFilePanel
extends JPanel {
    private JFileChooser fc = new JFileChooser();
    private SimpleWizardPanel panel;
    private JButton jButtonChoose;
    private JCheckBox jCheckBoxOpen;
    private JLabel jLabel1;
    private JTextField jTextFieldFile;

    public SaveFilePanel() {
        this.initComponents();
        this.fc.setDialogType(1);
        this.jTextFieldFile.getDocument().addDocumentListener(new DocumentListener(){

            public void insertUpdate(DocumentEvent documentEvent) {
                SaveFilePanel.this.check();
            }

            public void removeUpdate(DocumentEvent documentEvent) {
                SaveFilePanel.this.check();
            }

            public void changedUpdate(DocumentEvent documentEvent) {
                SaveFilePanel.this.check();
            }
        });
        this.jCheckBoxOpen.setVisible(false);
    }

    public void setOpenFileCheckBoxVisible(boolean bl) {
        this.jCheckBoxOpen.setVisible(bl);
    }

    public boolean getOpenExportedFile() {
        return this.jCheckBoxOpen.isSelected();
    }

    public void setWizardPanel(SimpleWizardPanel simpleWizardPanel) {
        this.panel = simpleWizardPanel;
    }

    private void initComponents() {
        this.jLabel1 = new JLabel();
        this.jTextFieldFile = new JTextField();
        this.jButtonChoose = new JButton();
        this.jCheckBoxOpen = new JCheckBox();
        this.setLayout(new GridBagLayout());
        this.setName(NbBundle.getBundle(SaveFilePanel.class).getString("ChooseFile"));
        Mnemonics.setLocalizedText((JLabel)this.jLabel1, (String)NbBundle.getBundle(SaveFilePanel.class).getString("File"));
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.insets = new Insets(0, 0, 11, 12);
        this.add((Component)this.jLabel1, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(0, 0, 11, 12);
        this.add((Component)this.jTextFieldFile, gridBagConstraints);
        Mnemonics.setLocalizedText((AbstractButton)this.jButtonChoose, (String)"...");
        this.jButtonChoose.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                SaveFilePanel.this.jButtonChooseActionPerformed(actionEvent);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.insets = new Insets(0, 0, 11, 0);
        this.add((Component)this.jButtonChoose, gridBagConstraints);
        this.jCheckBoxOpen.setText(ResourceBundle.getBundle("org/netbeans/modules/tasklist/core/export/Bundle").getString("OpenExportedFile"));
        this.jCheckBoxOpen.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 0));
        this.jCheckBoxOpen.setMargin(new Insets(0, 0, 0, 0));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.gridwidth = 3;
        gridBagConstraints.anchor = 18;
        this.add((Component)this.jCheckBoxOpen, gridBagConstraints);
    }

    private void jButtonChooseActionPerformed(ActionEvent actionEvent) {
        this.fc.setSelectedFile(new File(this.jTextFieldFile.getText()));
        if (this.fc.showSaveDialog(this) != 0) {
            return;
        }
        if (this.fc.getSelectedFile().exists()) {
            NotifyDescriptor.Confirmation confirmation = new NotifyDescriptor.Confirmation((Object)NbBundle.getMessage(SaveFilePanel.class, (String)"FileExistsOverwrite"), NbBundle.getMessage(SaveFilePanel.class, (String)"Warning"), 2);
            if (DialogDisplayer.getDefault().notify((NotifyDescriptor)confirmation) != NotifyDescriptor.OK_OPTION) {
                return;
            }
        }
        this.jTextFieldFile.setText(this.fc.getSelectedFile().getAbsolutePath());
    }

    public JFileChooser getFileChooser() {
        return this.fc;
    }

    public void setFile(File file) {
        this.jTextFieldFile.setText(file.getAbsolutePath());
        this.fc.setSelectedFile(file);
        this.check();
    }

    public File getFile() {
        return new File(this.jTextFieldFile.getText());
    }

    private void check() {
        String string = this.jTextFieldFile.getText().trim();
        if (string.length() == 0) {
            this.panel.setErrorMessage(NbBundle.getMessage(SaveFilePanel.class, (String)"EmptyFileName"));
            return;
        }
        File file = new File(string);
        if (file.isDirectory()) {
            this.panel.setErrorMessage(NbBundle.getMessage(SaveFilePanel.class, (String)"NotAFile"));
            return;
        }
        File file2 = file.getParentFile();
        if (file2 == null || !file2.isDirectory()) {
            this.panel.setErrorMessage(NbBundle.getMessage(SaveFilePanel.class, (String)"NoParent"));
            return;
        }
        if (!file.isAbsolute()) {
            this.panel.setErrorMessage(NbBundle.getMessage(SaveFilePanel.class, (String)"NotAnAbsolutePath"));
            return;
        }
        try {
            System.getSecurityManager().checkWrite(file.getAbsolutePath());
            this.panel.setErrorMessage(null);
        }
        catch (SecurityException securityException) {
            this.panel.setErrorMessage(securityException.getLocalizedMessage());
        }
    }

    public void setOpenFileCheckBox(boolean bl) {
        this.jCheckBoxOpen.setSelected(bl);
    }
}

