/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.tasklist.core.filter;

import java.io.IOException;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;
import javax.swing.JComponent;
import javax.swing.JTextField;
import org.netbeans.modules.tasklist.core.filter.OneOfFilterCondition;
import org.netbeans.modules.tasklist.core.filter.Util;
import org.w3c.dom.DOMException;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class DateFilterCondition
extends OneOfFilterCondition {
    public static final int EQUALS = 0;
    public static final int NOTEQUALS = 1;
    public static final int EARLIERTHAN = 2;
    public static final int LATERTHAN = 3;
    public static final int ISTODAY = 4;
    public static final int ISUNDEFINED = 5;
    private static String[] NAME_KEYS = new String[]{"Equals", "NotEquals", "EarlierThan", "LaterThan", "IsToday", "IsUndefined"};
    private Date constant = new Date();
    private static SimpleDateFormat sdf = new SimpleDateFormat();
    private long today = -1L;

    public static DateFilterCondition[] createConditions() {
        return new DateFilterCondition[]{new DateFilterCondition(2), new DateFilterCondition(3), new DateFilterCondition(0), new DateFilterCondition(1), new DateFilterCondition(4), new DateFilterCondition(5)};
    }

    public DateFilterCondition(int n) {
        super(NAME_KEYS, n);
    }

    public DateFilterCondition(DateFilterCondition dateFilterCondition) {
        super(dateFilterCondition);
        this.constant = dateFilterCondition.constant == null ? null : (Date)dateFilterCondition.constant.clone();
    }

    public Object clone() {
        return new DateFilterCondition(this);
    }

    DateFilterCondition() {
        super(NAME_KEYS);
        this.constant = null;
    }

    public JComponent createConstantComponent() {
        if (this.getId() != 4 && this.getId() != 5) {
            JTextField jTextField = new JTextField();
            jTextField.setText(sdf.format(this.constant));
            jTextField.setToolTipText(Util.getString("date_desc"));
            return jTextField;
        }
        return null;
    }

    public void getConstantFrom(JComponent jComponent) {
        JTextField jTextField = (JTextField)jComponent;
        try {
            this.constant = sdf.parse(jTextField.getText());
        }
        catch (ParseException parseException) {
            // empty catch block
        }
    }

    public boolean isTrue(Object object) {
        int n = object != null ? ((Date)object).compareTo(this.constant) : 0;
        switch (this.getId()) {
            case 0: {
                return object != null && n == 0;
            }
            case 1: {
                return object != null && n != 0;
            }
            case 2: {
                return object != null && n < 0;
            }
            case 3: {
                return object != null && n > 0;
            }
            case 4: {
                long l;
                if (object == null) {
                    return false;
                }
                if (this.today < 0L || System.currentTimeMillis() - this.today >= 86400000L) {
                    Calendar calendar = Calendar.getInstance();
                    calendar.set(11, 0);
                    calendar.set(12, 0);
                    calendar.set(13, 0);
                    calendar.set(14, 0);
                    this.today = calendar.getTimeInMillis();
                }
                return (l = ((Date)object).getTime() - this.today) >= 0L && l < 86400000L;
            }
            case 5: {
                return object == null;
            }
        }
        throw new InternalError("wrong id");
    }

    private static class Convertor
    extends OneOfFilterCondition.Convertor {
        private static final String ELEM_DATE_CONDITION = "DateCondition";
        private static final String ATTR_DATE = "date";

        public Convertor() {
            super(ELEM_DATE_CONDITION, NAME_KEYS);
        }

        public static Convertor create() {
            return new Convertor();
        }

        protected Object readElement(Element element) throws IOException, ClassNotFoundException {
            DateFilterCondition dateFilterCondition = new DateFilterCondition();
            super.readCondition(element, dateFilterCondition);
            dateFilterCondition.constant = new Date(Long.parseLong(element.getAttribute(ATTR_DATE)));
            return dateFilterCondition;
        }

        protected void writeElement(Document document, Element element, Object object) throws IOException, DOMException {
            DateFilterCondition dateFilterCondition = (DateFilterCondition)object;
            super.writeElement(document, element, dateFilterCondition);
            element.setAttribute(ATTR_DATE, Long.toString(dateFilterCondition.constant.getTime()));
        }
    }
}

