/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.tasklist.core.filter;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.IOException;
import java.util.Iterator;
import org.netbeans.modules.tasklist.core.filter.Filter;
import org.netbeans.modules.tasklist.core.filter.FilterRepository;
import org.netbeans.spi.settings.DOMConvertor;
import org.netbeans.spi.settings.Saver;
import org.openide.ErrorManager;
import org.openide.filesystems.FileObject;
import org.w3c.dom.DOMException;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class FilterRepositoryConvertor
extends DOMConvertor
implements PropertyChangeListener {
    private static final String ATTR_ACTIVE = "active";
    private static final String ELEM_FILTER = "Filter";
    private static final String ELEM_FILTERS = "Filters";
    private Saver saver;

    private static Object create(FileObject fileObject) {
        return new FilterRepositoryConvertor();
    }

    public FilterRepositoryConvertor() {
        super("-//NetBeans org.netbeans.modules.tasklist//DTD Filters 1.0//EN", "http://tasklist.netbeans.org/dtd/filters-1_0.dtd", ELEM_FILTERS);
    }

    protected Object readElement(Element element) throws IOException, ClassNotFoundException {
        FilterRepository filterRepository = new FilterRepository();
        int n = Integer.parseInt(element.getAttribute(ATTR_ACTIVE));
        for (Node node = element.getFirstChild(); node != null; node = node.getNextSibling()) {
            if (node.getNodeType() != 1) continue;
            Filter filter = (Filter)FilterRepositoryConvertor.delegateRead((Element)((Element)node));
            filterRepository.add(filter);
        }
        if (n != -1) {
            filterRepository.setActive((Filter)filterRepository.get(n));
        }
        return filterRepository;
    }

    protected void writeElement(Document document, Element element, Object object) throws IOException, DOMException {
        FilterRepository filterRepository = (FilterRepository)object;
        element.setAttribute(ATTR_ACTIVE, Integer.toString(filterRepository.indexOf(filterRepository.getActive())));
        Iterator iterator = filterRepository.iterator();
        while (iterator.hasNext()) {
            Element element2 = FilterRepositoryConvertor.delegateWrite((Document)document, iterator.next());
            element.appendChild(element2);
        }
    }

    public void registerSaver(Object object, Saver saver) {
        this.saver = saver;
        ((FilterRepository)object).addPropertyChangeListener(this);
    }

    public void unregisterSaver(Object object, Saver saver) {
        if (saver == null || saver != this.saver) {
            ErrorManager.getDefault().notify(65536, (Throwable)new IllegalArgumentException("Wrong argument for unregisterSaver(Object=" + object + ", Saver=" + saver + ")"));
        }
        ((FilterRepository)object).removePropertyChangeListener(this);
        this.saver = null;
    }

    public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
        try {
            this.saver.requestSave();
        }
        catch (IOException iOException) {
            ErrorManager.getDefault().notify((Throwable)iOException);
        }
    }
}

