/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.tasklist.core.filter;

import java.io.IOException;
import javax.swing.JComponent;
import javax.swing.JTextField;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import org.netbeans.modules.tasklist.core.filter.OneOfFilterCondition;
import org.netbeans.modules.tasklist.core.filter.Util;
import org.w3c.dom.DOMException;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class StringFilterCondition
extends OneOfFilterCondition {
    public static final int EQUALS = 0;
    public static final int NOTEQUALS = 1;
    public static final int CONTAINS = 2;
    public static final int DOESNOTCONTAIN = 3;
    public static final int BEGINSWITH = 4;
    public static final int ENDSWITH = 5;
    public static final int CEQUALS = 6;
    public static final int CCONTAINS = 7;
    public static final int CDOESNOTCONTAIN = 8;
    public static final int CBEGINSWITH = 9;
    public static final int CENDSWITH = 10;
    private static String[] NAME_KEYS = new String[]{"Equals", "NotEquals", "Contains", "DoesNotContain", "BeginsWith", "EndsWith", "CEquals", "CContains", "CDoesNotContain", "CBeginsWith", "CEndsWith"};
    private String constant = "";

    public static StringFilterCondition[] createConditions() {
        return new StringFilterCondition[]{new StringFilterCondition(2), new StringFilterCondition(3), new StringFilterCondition(4), new StringFilterCondition(5), new StringFilterCondition(0), new StringFilterCondition(1), new StringFilterCondition(7), new StringFilterCondition(8), new StringFilterCondition(9), new StringFilterCondition(10), new StringFilterCondition(6)};
    }

    public StringFilterCondition(int n) {
        super(NAME_KEYS, n);
    }

    public StringFilterCondition(int n, String string) {
        this(n);
        this.constant = string;
    }

    public StringFilterCondition(StringFilterCondition stringFilterCondition) {
        super(stringFilterCondition);
        this.constant = stringFilterCondition.constant;
    }

    public Object clone() {
        return new StringFilterCondition(this);
    }

    private StringFilterCondition() {
        super(NAME_KEYS);
        this.constant = null;
    }

    public String getConstant() {
        return this.constant;
    }

    public JComponent createConstantComponent() {
        final JTextField jTextField = new JTextField();
        jTextField.setText(this.constant);
        jTextField.setToolTipText(Util.getString("string_desc"));
        jTextField.getDocument().addDocumentListener(new DocumentListener(){

            public void changedUpdate(DocumentEvent documentEvent) {
                Boolean bl = !"".equals(jTextField.getText());
                jTextField.putClientProperty("value-valid", bl);
            }

            public void insertUpdate(DocumentEvent documentEvent) {
                Boolean bl = !"".equals(jTextField.getText());
                jTextField.putClientProperty("value-valid", bl);
            }

            public void removeUpdate(DocumentEvent documentEvent) {
                Boolean bl = !"".equals(jTextField.getText());
                jTextField.putClientProperty("value-valid", bl);
            }
        });
        return jTextField;
    }

    public void getConstantFrom(JComponent jComponent) {
        JTextField jTextField = (JTextField)jComponent;
        this.constant = jTextField.getText();
    }

    public boolean isTrue(Object object) {
        String string = object == null ? "" : object.toString();
        switch (this.getId()) {
            case 0: {
                return string.equalsIgnoreCase(this.constant);
            }
            case 1: {
                return !string.equalsIgnoreCase(this.constant);
            }
            case 2: {
                return string.toLowerCase().indexOf(this.constant.toLowerCase()) >= 0;
            }
            case 3: {
                return string.toLowerCase().indexOf(this.constant.toLowerCase()) < 0;
            }
            case 4: {
                return string.toLowerCase().startsWith(this.constant.toLowerCase());
            }
            case 5: {
                return string.toLowerCase().endsWith(this.constant.toLowerCase());
            }
            case 6: {
                return string.equals(this.constant);
            }
            case 7: {
                return string.indexOf(this.constant) >= 0;
            }
            case 8: {
                return string.indexOf(this.constant) < 0;
            }
            case 9: {
                return string.startsWith(this.constant);
            }
            case 10: {
                return string.endsWith(this.constant);
            }
        }
        throw new InternalError("wrong id");
    }

    private static class Convertor
    extends OneOfFilterCondition.Convertor {
        private static final String ELEM_STRING_CONDITION = "StringCondition";
        private static final String ATTR_CONSTANT = "constant";

        public Convertor() {
            super(ELEM_STRING_CONDITION, NAME_KEYS);
        }

        public static Convertor create() {
            return new Convertor();
        }

        protected Object readElement(Element element) throws IOException, ClassNotFoundException {
            StringFilterCondition stringFilterCondition = new StringFilterCondition();
            super.readCondition(element, stringFilterCondition);
            stringFilterCondition.constant = element.getAttribute(ATTR_CONSTANT);
            return stringFilterCondition;
        }

        protected void writeElement(Document document, Element element, Object object) throws IOException, DOMException {
            StringFilterCondition stringFilterCondition = (StringFilterCondition)object;
            super.writeCondition(document, element, stringFilterCondition);
            element.setAttribute(ATTR_CONSTANT, stringFilterCondition.constant);
        }
    }
}

