/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.tasklist.core.table;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.border.EmptyBorder;
import javax.swing.table.TableColumn;
import javax.swing.table.TableColumnModel;
import javax.swing.table.TableModel;
import org.netbeans.modules.tasklist.core.checklist.CheckList;
import org.netbeans.modules.tasklist.core.checklist.CheckListModel;
import org.netbeans.modules.tasklist.core.checklist.DefaultCheckListModel;
import org.openide.DialogDescriptor;
import org.openide.DialogDisplayer;
import org.openide.NotifyDescriptor;
import org.openide.util.NbBundle;

public class ChooseColumnsPanel
extends JPanel {
    private static final long serialVersionUID = 1L;
    private CheckList columnsCheckList;
    private JLabel jLabel1;
    private JScrollPane jScrollPane1;

    private static int findColumn(TableColumnModel tableColumnModel, int n) {
        for (int i = 0; i < tableColumnModel.getColumnCount(); ++i) {
            if (tableColumnModel.getColumn(i).getModelIndex() != n) continue;
            return i;
        }
        return -1;
    }

    public static void installChooseColumnsButton(JScrollPane jScrollPane) {
        JTable jTable = (JTable)jScrollPane.getViewport().getView();
        JButton jButton = new JButton(new ImageIcon(ChooseColumnsPanel.class.getResource("columns.gif")));
        jButton.addActionListener(new ChooseColumnsActionListener(jTable));
        jScrollPane.setVerticalScrollBarPolicy(22);
        jScrollPane.setCorner("UPPER_RIGHT_CORNER", jButton);
    }

    public ChooseColumnsPanel(boolean[] blArray, String[] stringArray) {
        this.initComponents();
        this.columnsCheckList.setModel(new DefaultCheckListModel(blArray, stringArray));
    }

    public boolean[] getChecked() {
        CheckListModel checkListModel = (CheckListModel)this.columnsCheckList.getModel();
        boolean[] blArray = new boolean[checkListModel.getSize()];
        for (int i = 0; i < checkListModel.getSize(); ++i) {
            blArray[i] = checkListModel.isChecked(i);
        }
        return blArray;
    }

    private void initComponents() {
        this.jLabel1 = new JLabel();
        this.jScrollPane1 = new JScrollPane();
        this.columnsCheckList = new CheckList();
        this.setLayout(new GridBagLayout());
        this.setBorder(new EmptyBorder(new Insets(12, 12, 11, 11)));
        this.setPreferredSize(new Dimension(400, 300));
        this.jLabel1.setLabelFor(this.columnsCheckList);
        this.jLabel1.setText(NbBundle.getMessage(ChooseColumnsPanel.class, (String)"ChooseTheColumnsToDisplay"));
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(0, 0, 11, 0);
        this.add((Component)this.jLabel1, gridBagConstraints);
        this.jScrollPane1.setViewportView(this.columnsCheckList);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        this.add((Component)this.jScrollPane1, gridBagConstraints);
    }

    private static class ChooseColumnsActionListener
    implements ActionListener {
        private JTable table;

        public ChooseColumnsActionListener(JTable jTable) {
            this.table = jTable;
        }

        public void actionPerformed(ActionEvent actionEvent) {
            TableModel tableModel = this.table.getModel();
            int n = tableModel.getColumnCount();
            String[] stringArray = new String[n];
            for (int i = 0; i < n; ++i) {
                stringArray[i] = tableModel.getColumnName(i);
            }
            boolean[] blArray = new boolean[n];
            TableColumnModel tableColumnModel = this.table.getColumnModel();
            for (int i = 0; i < tableColumnModel.getColumnCount(); ++i) {
                blArray[tableColumnModel.getColumn((int)i).getModelIndex()] = true;
            }
            ChooseColumnsPanel chooseColumnsPanel = new ChooseColumnsPanel(blArray, stringArray);
            DialogDescriptor dialogDescriptor = new DialogDescriptor((Object)chooseColumnsPanel, NbBundle.getMessage(ChooseColumnsPanel.class, (String)"ChangeVisibleColumns"));
            Object object = DialogDisplayer.getDefault().notify((NotifyDescriptor)dialogDescriptor);
            if (object == NotifyDescriptor.OK_OPTION) {
                int n2;
                ArrayList<TableColumn> arrayList = new ArrayList<TableColumn>();
                for (n2 = 0; n2 < tableColumnModel.getColumnCount(); ++n2) {
                    arrayList.add(tableColumnModel.getColumn(n2));
                }
                this.table.createDefaultColumnsFromModel();
                for (n2 = 0; n2 < arrayList.size(); ++n2) {
                    tableColumnModel.addColumn((TableColumn)arrayList.get(n2));
                    tableColumnModel.moveColumn(tableColumnModel.getColumnCount() - 1, n2);
                }
                n2 = 0;
                while (n2 < tableColumnModel.getColumnCount()) {
                    TableColumn tableColumn = tableColumnModel.getColumn(n2);
                    int n3 = tableColumn.getModelIndex();
                    if (!blArray[n3]) {
                        tableColumnModel.removeColumn(tableColumnModel.getColumn(n2));
                        continue;
                    }
                    blArray[n3] = false;
                    ++n2;
                }
            }
        }
    }
}

