/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.tasklist.core.util;

import java.util.AbstractList;
import java.util.ArrayList;
import java.util.List;
import javax.swing.event.EventListenerList;
import org.netbeans.modules.tasklist.core.util.ObjectListEvent;
import org.netbeans.modules.tasklist.core.util.ObjectListListener;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ObjectList<E>
extends AbstractList<E> {
    private EventListenerList listeners = null;
    private List<E> objects = null;

    public ObjectList() {
    }

    public ObjectList(List<E> list) {
        this.objects = list;
    }

    @Override
    public int size() {
        int n = this.objects == null ? 0 : this.objects.size();
        return n;
    }

    @Override
    public E set(int n, E e) {
        if (this.objects == null) {
            this.objects = new ArrayList();
        }
        E e2 = this.objects.set(n, e);
        if (this.hasListeners()) {
            this.fireEvent(new ObjectListEvent(this, 0, new int[]{n}, new Object[]{e2}));
            this.fireEvent(new ObjectListEvent(this, 1, new int[]{n}, new Object[]{e}));
        }
        return e2;
    }

    public void addListener(ObjectListListener objectListListener) {
        if (this.listeners == null) {
            this.listeners = new EventListenerList();
        }
        this.listeners.add(ObjectListListener.class, objectListListener);
    }

    public void removeListener(ObjectListListener objectListListener) {
        if (this.listeners != null) {
            this.listeners.remove(ObjectListListener.class, objectListListener);
        }
        if (this.listeners.getListenerCount() == 0) {
            this.listeners = null;
        }
    }

    protected boolean hasListeners() {
        return this.listeners != null && this.listeners.getListenerCount() != 0;
    }

    protected void fireEvent(ObjectListEvent objectListEvent) {
        Object[] objectArray = this.listeners.getListenerList();
        for (int i = objectArray.length - 2; i >= 0; i -= 2) {
            ((ObjectListListener)objectArray[i + 1]).listChanged(objectListEvent);
        }
    }

    @Override
    public E get(int n) {
        if (this.objects == null) {
            throw new IndexOutOfBoundsException("Empty list");
        }
        return this.objects.get(n);
    }

    @Override
    public void add(int n, E e) {
        if (this.objects == null) {
            this.objects = new ArrayList();
        }
        this.objects.add(n, e);
        if (this.hasListeners() || e instanceof ObjectListListener) {
            ObjectListEvent objectListEvent = new ObjectListEvent(this, 1, new int[]{n}, new Object[]{e});
            if (this.hasListeners()) {
                this.fireEvent(objectListEvent);
            }
            if (e instanceof ObjectListListener) {
                ((ObjectListListener)e).listChanged(objectListEvent);
            }
        }
    }

    @Override
    public E remove(int n) {
        if (this.objects == null) {
            throw new IndexOutOfBoundsException("Empty list");
        }
        E e = this.objects.remove(n);
        if (this.hasListeners() || e instanceof ObjectListListener) {
            ObjectListEvent objectListEvent = new ObjectListEvent(this, 0, new int[]{n}, new Object[]{e});
            if (this.hasListeners()) {
                this.fireEvent(objectListEvent);
            }
            if (e instanceof ObjectListListener) {
                ((ObjectListListener)e).listChanged(objectListEvent);
            }
        }
        if (this.objects.size() == 0) {
            this.objects = null;
        }
        return e;
    }

    public void move(int n, int n2) {
        if (this.objects == null) {
            throw new IndexOutOfBoundsException("Empty list");
        }
        this.objects.add(n2, this.objects.remove(n));
        if (this.hasListeners()) {
            ObjectListEvent objectListEvent = new ObjectListEvent(this, 3, null, null);
            this.fireEvent(objectListEvent);
        }
    }
}

