/*
 * Decompiled with CFR 0.152.
 */
package org.openide.awt;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import org.openide.util.Lookup;

public abstract class StatusDisplayer {
    private static StatusDisplayer INSTANCE = null;

    protected StatusDisplayer() {
    }

    public static synchronized StatusDisplayer getDefault() {
        if (INSTANCE == null && (INSTANCE = (StatusDisplayer)Lookup.getDefault().lookup(StatusDisplayer.class)) == null) {
            INSTANCE = new Trivial();
        }
        return INSTANCE;
    }

    public abstract String getStatusText();

    public abstract void setStatusText(String var1);

    public abstract void addChangeListener(ChangeListener var1);

    public abstract void removeChangeListener(ChangeListener var1);

    private static final class Trivial
    extends StatusDisplayer {
        private List<ChangeListener> listeners = null;
        private String text = "";

        private Trivial() {
        }

        public synchronized String getStatusText() {
            return this.text;
        }

        public synchronized void setStatusText(String string) {
            if (string.equals(this.text)) {
                return;
            }
            this.text = string;
            if (string.length() > 0) {
                System.err.println("(" + string + ")");
            }
            this.fireChange();
        }

        public synchronized void addChangeListener(ChangeListener changeListener) {
            if (this.listeners == null) {
                this.listeners = new ArrayList<ChangeListener>();
            }
            this.listeners.add(changeListener);
        }

        public synchronized void removeChangeListener(ChangeListener changeListener) {
            if (this.listeners != null) {
                this.listeners.remove(changeListener);
            }
        }

        protected final void fireChange() {
            if (this.listeners != null && !this.listeners.isEmpty()) {
                ChangeEvent changeEvent = new ChangeEvent(this);
                Iterator<ChangeListener> iterator = this.listeners.iterator();
                while (iterator.hasNext()) {
                    iterator.next().stateChanged(changeEvent);
                }
            }
        }
    }
}

