/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.api.java.source;

import java.io.IOException;
import java.net.URL;
import java.util.Collections;
import java.util.EnumSet;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.logging.Logger;
import javax.lang.model.element.ElementKind;
import javax.lang.model.element.TypeElement;
import org.netbeans.api.java.classpath.ClassPath;
import org.netbeans.api.java.source.ElementHandle;
import org.netbeans.modules.java.source.classpath.GlobalSourcePath;
import org.netbeans.modules.java.source.usages.ClassIndexFactory;
import org.netbeans.modules.java.source.usages.ClassIndexImpl;
import org.netbeans.modules.java.source.usages.ClassIndexManager;
import org.netbeans.modules.java.source.usages.Index;
import org.netbeans.modules.java.source.usages.ResultConvertor;
import org.openide.filesystems.FileObject;
import org.openide.util.Exceptions;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class ClassIndex {
    private static final Logger LOGGER = Logger.getLogger(ClassIndex.class.getName());
    private final ClassPath bootPath;
    private final ClassPath classPath;
    private final ClassPath sourcePath;
    private Set<ClassIndexImpl> sourceIndeces;
    private Set<ClassIndexImpl> depsIndeces;

    ClassIndex(ClassPath classPath, ClassPath classPath2, ClassPath classPath3) {
        assert (classPath != null);
        assert (classPath2 != null);
        assert (classPath3 != null);
        this.bootPath = classPath;
        this.classPath = classPath2;
        this.sourcePath = classPath3;
    }

    public Set<ElementHandle<TypeElement>> getElements(ElementHandle<TypeElement> elementHandle, Set<SearchKind> set, Set<SearchScope> set2) {
        assert (elementHandle != null);
        assert (elementHandle.getSignature()[0] != null);
        assert (set != null);
        HashSet hashSet = new HashSet();
        Iterable<? extends ClassIndexImpl> iterable = this.getQueries(set2);
        Set<ClassIndexImpl.UsageType> set3 = ClassIndex.encodeSearchKind(elementHandle.getKind(), set);
        String string = elementHandle.getSignature()[0];
        ResultConvertor<ElementHandle<TypeElement>> resultConvertor = ResultConvertor.elementHandleConvertor();
        if (!set3.isEmpty()) {
            for (ClassIndexImpl classIndexImpl : iterable) {
                classIndexImpl.search(string, set3, resultConvertor, hashSet);
            }
        }
        return Collections.unmodifiableSet(hashSet);
    }

    public Set<FileObject> getResources(ElementHandle<TypeElement> elementHandle, Set<SearchKind> set, Set<SearchScope> set2) {
        assert (elementHandle != null);
        assert (elementHandle.getSignature()[0] != null);
        assert (set != null);
        HashSet hashSet = new HashSet();
        Iterable<? extends ClassIndexImpl> iterable = this.getQueries(set2);
        Set<ClassIndexImpl.UsageType> set3 = ClassIndex.encodeSearchKind(elementHandle.getKind(), set);
        String string = elementHandle.getSignature()[0];
        if (!set3.isEmpty()) {
            for (ClassIndexImpl classIndexImpl : iterable) {
                ResultConvertor<FileObject> resultConvertor = ResultConvertor.fileObjectConvertor(classIndexImpl.getSourceRoots());
                classIndexImpl.search(string, set3, resultConvertor, hashSet);
            }
        }
        return Collections.unmodifiableSet(hashSet);
    }

    public Set<ElementHandle<TypeElement>> getDeclaredTypes(String string, NameKind nameKind, Set<SearchScope> set) {
        assert (string != null);
        assert (nameKind != null);
        HashSet hashSet = new HashSet();
        Iterable<? extends ClassIndexImpl> iterable = this.getQueries(set);
        ResultConvertor<ElementHandle<TypeElement>> resultConvertor = ResultConvertor.elementHandleConvertor();
        for (ClassIndexImpl classIndexImpl : iterable) {
            classIndexImpl.getDeclaredTypes(string, nameKind, resultConvertor, hashSet);
        }
        LOGGER.fine(String.format("ClassIndex.getDeclaredTypes returned %d elements\n", hashSet.size()));
        return Collections.unmodifiableSet(hashSet);
    }

    public Set<String> getPackageNames(String string, boolean bl, Set<SearchScope> set) {
        assert (string != null);
        HashSet<String> hashSet = new HashSet<String>();
        Iterable<? extends ClassIndexImpl> iterable = this.getQueries(set);
        for (ClassIndexImpl classIndexImpl : iterable) {
            classIndexImpl.getPackageNames(string, bl, hashSet);
        }
        return Collections.unmodifiableSet(hashSet);
    }

    private synchronized Iterable<? extends ClassIndexImpl> getQueries(Set<SearchScope> set) {
        HashSet<ClassIndexImpl> hashSet;
        HashSet<ClassIndexImpl> hashSet2 = new HashSet<ClassIndexImpl>();
        if (set.contains((Object)SearchScope.SOURCE)) {
            if (this.sourceIndeces == null) {
                hashSet = new HashSet<ClassIndexImpl>();
                this.createQueriesForRoots(this.sourcePath, true, hashSet);
                this.sourceIndeces = hashSet;
            }
            hashSet2.addAll(this.sourceIndeces);
        }
        if (set.contains((Object)SearchScope.DEPENDENCIES)) {
            if (this.depsIndeces == null) {
                hashSet = new HashSet();
                this.createQueriesForRoots(this.bootPath, false, hashSet);
                this.createQueriesForRoots(this.classPath, false, hashSet);
                this.depsIndeces = hashSet;
            }
            hashSet2.addAll(this.depsIndeces);
        }
        LOGGER.fine(String.format("ClassIndex.queries[Scope=%s, sourcePath=%s, bootPath=%s, classPath=%s] => %s\n", set, this.sourcePath, this.bootPath, this.classPath, hashSet2));
        return hashSet2;
    }

    private void createQueriesForRoots(ClassPath classPath, boolean bl, Set<? super ClassIndexImpl> set) {
        GlobalSourcePath globalSourcePath = GlobalSourcePath.getDefault();
        List list = classPath.entries();
        for (ClassPath.Entry entry : list) {
            try {
                URL[] uRLArray;
                boolean bl2 = false;
                if (!bl) {
                    URL[] uRLArray2 = Index.getSourceRootForClassFolder(entry.getURL());
                    if (uRLArray2 != null) {
                        uRLArray = new URL[]{uRLArray2};
                    } else {
                        uRLArray = globalSourcePath.getSourceRootForBinaryRoot(entry.getURL(), classPath, true);
                        if (uRLArray == null) {
                            bl2 = true;
                            uRLArray = new URL[]{entry.getURL()};
                        }
                    }
                } else {
                    uRLArray = new URL[]{entry.getURL()};
                }
                for (URL uRL : uRLArray) {
                    ClassIndexImpl classIndexImpl = ClassIndexManager.getDefault().getUsagesQuery(uRL);
                    if (classIndexImpl == null) continue;
                    set.add(classIndexImpl);
                }
            }
            catch (IOException iOException) {
                Exceptions.printStackTrace((Throwable)iOException);
            }
        }
    }

    private static Set<ClassIndexImpl.UsageType> encodeSearchKind(ElementKind elementKind, Set<SearchKind> set) {
        assert (set != null);
        EnumSet<ClassIndexImpl.UsageType> enumSet = EnumSet.noneOf(ClassIndexImpl.UsageType.class);
        block12: for (SearchKind searchKind : set) {
            switch (searchKind) {
                case METHOD_REFERENCES: {
                    enumSet.add(ClassIndexImpl.UsageType.METHOD_REFERENCE);
                    continue block12;
                }
                case FIELD_REFERENCES: {
                    enumSet.add(ClassIndexImpl.UsageType.FIELD_REFERENCE);
                    continue block12;
                }
                case TYPE_REFERENCES: {
                    enumSet.add(ClassIndexImpl.UsageType.TYPE_REFERENCE);
                    continue block12;
                }
                case IMPLEMENTORS: {
                    switch (elementKind) {
                        case INTERFACE: 
                        case ANNOTATION_TYPE: {
                            enumSet.add(ClassIndexImpl.UsageType.SUPER_INTERFACE);
                            continue block12;
                        }
                        case CLASS: {
                            enumSet.add(ClassIndexImpl.UsageType.SUPER_CLASS);
                            continue block12;
                        }
                        case ENUM: {
                            continue block12;
                        }
                        case OTHER: {
                            enumSet.add(ClassIndexImpl.UsageType.SUPER_INTERFACE);
                            enumSet.add(ClassIndexImpl.UsageType.SUPER_CLASS);
                            continue block12;
                        }
                    }
                    throw new IllegalArgumentException();
                }
            }
            throw new IllegalArgumentException();
        }
        return enumSet;
    }

    static {
        ClassIndexImpl.FACTORY = new ClassIndexFactoryImpl();
    }

    private static class ClassIndexFactoryImpl
    implements ClassIndexFactory {
        private ClassIndexFactoryImpl() {
        }

        public ClassIndex create(ClassPath classPath, ClassPath classPath2, ClassPath classPath3) {
            return new ClassIndex(classPath, classPath2, classPath3);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum NameKind {
        SIMPLE_NAME,
        PREFIX,
        CASE_INSENSITIVE_PREFIX,
        CAMEL_CASE,
        REGEXP,
        CASE_INSENSITIVE_REGEXP;

    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum SearchKind {
        IMPLEMENTORS,
        METHOD_REFERENCES,
        FIELD_REFERENCES,
        TYPE_REFERENCES;

    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum SearchScope {
        SOURCE,
        DEPENDENCIES;

    }
}

