/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.api.java.source;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Reader;
import java.io.StringWriter;
import java.io.Writer;
import java.nio.charset.Charset;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.swing.text.BadLocationException;
import org.netbeans.api.java.source.JavaSource;
import org.netbeans.api.queries.FileEncodingQuery;
import org.netbeans.editor.BaseDocument;
import org.openide.cookies.EditorCookie;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.loaders.DataObject;
import org.openide.text.PositionRef;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class ModificationResult {
    private JavaSource js;
    Map<FileObject, List<Difference>> diffs = new HashMap<FileObject, List<Difference>>();

    ModificationResult(JavaSource javaSource) {
        this.js = javaSource;
    }

    public Set<? extends FileObject> getModifiedFileObjects() {
        return this.diffs.keySet();
    }

    public List<? extends Difference> getDifferences(FileObject fileObject) {
        return this.diffs.get(fileObject);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void commit() throws IOException {
        try {
            for (Map.Entry<FileObject, List<Difference>> entry : this.diffs.entrySet()) {
                this.commit(entry.getKey(), entry.getValue(), null);
            }
        }
        finally {
            if (this.js != null) {
                this.js.revalidate();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void commit(FileObject fileObject, List<Difference> list, Writer writer) throws IOException {
        Object object;
        EditorCookie editorCookie;
        DataObject dataObject = DataObject.find((FileObject)fileObject);
        EditorCookie editorCookie2 = editorCookie = dataObject != null ? (EditorCookie)dataObject.getCookie(EditorCookie.class) : null;
        if (editorCookie != null && writer == null && (object = editorCookie.getDocument()) != null) {
            if (object instanceof BaseDocument) {
                ((BaseDocument)object).atomicLock();
            }
            try {
                for (Difference difference : list) {
                    if (difference.isExcluded()) continue;
                    try {
                        switch (difference.getKind()) {
                            case INSERT: {
                                object.insertString(difference.getStartPosition().getOffset(), difference.getNewText(), null);
                                break;
                            }
                            case REMOVE: {
                                object.remove(difference.getStartPosition().getOffset(), difference.getEndPosition().getOffset() - difference.getStartPosition().getOffset());
                                break;
                            }
                            case CHANGE: {
                                object.remove(difference.getStartPosition().getOffset(), difference.getEndPosition().getOffset() - difference.getStartPosition().getOffset());
                                object.insertString(difference.getStartPosition().getOffset(), difference.getNewText(), null);
                            }
                        }
                    }
                    catch (BadLocationException badLocationException) {
                        IOException iOException = new IOException();
                        iOException.initCause(badLocationException);
                        throw iOException;
                        return;
                    }
                }
            }
            finally {
                if (object instanceof BaseDocument) {
                    ((BaseDocument)object).atomicUnlock();
                }
            }
        }
        object = null;
        ByteArrayOutputStream byteArrayOutputStream = null;
        Reader reader = null;
        try {
            int n;
            Charset charset = FileEncodingQuery.getEncoding((FileObject)fileObject);
            object = fileObject.getInputStream();
            byteArrayOutputStream = new ByteArrayOutputStream();
            FileUtil.copy((InputStream)object, (OutputStream)byteArrayOutputStream);
            ((InputStream)object).close();
            object = null;
            byte[] byArray = byteArrayOutputStream.toByteArray();
            byteArrayOutputStream.close();
            byteArrayOutputStream = null;
            reader = new InputStreamReader((InputStream)new ByteArrayInputStream(byArray), charset);
            if (writer == null) {
                writer = new OutputStreamWriter(fileObject.getOutputStream(), charset);
            }
            int n2 = 0;
            for (Difference difference : list) {
                int n3;
                if (difference.isExcluded()) continue;
                int n4 = difference.getStartPosition().getOffset();
                int n5 = n4 - n2;
                char[] cArray = new char[n5];
                int n6 = 0;
                while ((n3 = reader.read(cArray, 0, n5 - n6)) > 0 && n6 < n5) {
                    writer.write(cArray, 0, n3);
                    n6 += n3;
                    n2 += n3;
                }
                switch (difference.getKind()) {
                    case INSERT: {
                        writer.write(difference.getNewText());
                        break;
                    }
                    case REMOVE: {
                        int n7 = difference.getEndPosition().getOffset() - difference.getStartPosition().getOffset();
                        reader.skip(n7);
                        n2 += n7;
                        break;
                    }
                    case CHANGE: {
                        int n7 = difference.getEndPosition().getOffset() - difference.getStartPosition().getOffset();
                        reader.skip(n7);
                        n2 += n7;
                        writer.write(difference.getNewText());
                    }
                }
            }
            Object object2 = new char[1024];
            while ((n = reader.read((char[])object2)) > 0) {
                writer.write((char[])object2, 0, n);
            }
            return;
        }
        finally {
            if (object != null) {
                ((InputStream)object).close();
            }
            if (byteArrayOutputStream != null) {
                byteArrayOutputStream.close();
            }
            if (reader != null) {
                reader.close();
            }
            if (writer != null) {
                writer.close();
            }
        }
    }

    public String getResultingSource(FileObject fileObject) throws IOException {
        assert (fileObject != null) : "Provided fileObject is null";
        StringWriter stringWriter = new StringWriter();
        this.commit(fileObject, this.diffs.get(fileObject), stringWriter);
        return stringWriter.toString();
    }

    public static final class Difference {
        Kind kind;
        PositionRef startPos;
        PositionRef endPos;
        String oldText;
        String newText;
        String description;
        private boolean excluded;

        Difference(Kind kind, PositionRef positionRef, PositionRef positionRef2, String string, String string2, String string3) {
            this.kind = kind;
            this.startPos = positionRef;
            this.endPos = positionRef2;
            this.oldText = string;
            this.newText = string2;
            this.description = string3;
            this.excluded = false;
        }

        Difference(Kind kind, PositionRef positionRef, PositionRef positionRef2, String string, String string2) {
            this(kind, positionRef, positionRef2, string, string2, null);
        }

        public Kind getKind() {
            return this.kind;
        }

        public PositionRef getStartPosition() {
            return this.startPos;
        }

        public PositionRef getEndPosition() {
            return this.endPos;
        }

        public String getOldText() {
            return this.oldText;
        }

        public String getNewText() {
            return this.newText;
        }

        public boolean isExcluded() {
            return this.excluded;
        }

        public void exclude(boolean bl) {
            this.excluded = bl;
        }

        public String toString() {
            return (Object)((Object)this.kind) + "<" + this.startPos.getOffset() + ", " + this.endPos.getOffset() + ">: " + this.oldText + " -> " + this.newText;
        }

        public String getDescription() {
            return this.description;
        }

        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        public static enum Kind {
            INSERT,
            REMOVE,
            CHANGE;

        }
    }
}

