/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.api.java.source;

import com.sun.source.tree.CompilationUnitTree;
import com.sun.source.tree.ImportTree;
import com.sun.source.tree.MethodTree;
import com.sun.source.tree.Scope;
import com.sun.source.tree.Tree;
import com.sun.source.util.TreePath;
import com.sun.source.util.TreePathScanner;
import com.sun.tools.javac.api.JavacTrees;
import com.sun.tools.javac.code.Scope;
import com.sun.tools.javac.code.Symbol;
import com.sun.tools.javac.code.Symtab;
import com.sun.tools.javac.code.Type;
import com.sun.tools.javac.code.Types;
import com.sun.tools.javac.comp.Check;
import com.sun.tools.javac.model.JavacElements;
import com.sun.tools.javac.tree.JCTree;
import com.sun.tools.javac.util.Context;
import com.sun.tools.javac.util.List;
import com.sun.tools.javac.util.Name;
import java.io.File;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.EnumSet;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.Set;
import java.util.StringTokenizer;
import javax.lang.model.element.Element;
import javax.lang.model.element.ElementKind;
import javax.lang.model.element.ExecutableElement;
import javax.lang.model.element.Modifier;
import javax.lang.model.element.PackageElement;
import javax.lang.model.element.TypeElement;
import javax.lang.model.element.VariableElement;
import javax.lang.model.type.ArrayType;
import javax.lang.model.type.DeclaredType;
import javax.lang.model.type.TypeKind;
import javax.lang.model.type.TypeMirror;
import javax.lang.model.type.WildcardType;
import javax.lang.model.util.ElementFilter;
import javax.tools.JavaFileObject;
import org.netbeans.api.java.classpath.ClassPath;
import org.netbeans.api.java.queries.JavadocForBinaryQuery;
import org.netbeans.api.java.queries.SourceForBinaryQuery;
import org.netbeans.api.java.source.CancellableTask;
import org.netbeans.api.java.source.ClassIndex;
import org.netbeans.api.java.source.ClasspathInfo;
import org.netbeans.api.java.source.CompilationController;
import org.netbeans.api.java.source.CompilationInfo;
import org.netbeans.api.java.source.ElementHandle;
import org.netbeans.api.java.source.ElementUtilities;
import org.netbeans.api.java.source.JavaSource;
import org.netbeans.api.java.source.TreeMaker;
import org.netbeans.api.java.source.WorkingCopy;
import org.netbeans.modules.java.source.parsing.FileObjects;
import org.netbeans.modules.java.source.usages.Index;
import org.netbeans.modules.java.source.usages.RepositoryUpdater;
import org.netbeans.spi.java.classpath.support.ClassPathSupport;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileStateInvalidException;
import org.openide.filesystems.URLMapper;
import org.openide.util.Exceptions;
import org.openide.util.RequestProcessor;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SourceUtils {
    private static final String PACKAGE_SUMMARY = "package-summary";
    private static EnumSet JAVA_JFO_KIND = EnumSet.of(JavaFileObject.Kind.CLASS, JavaFileObject.Kind.SOURCE);

    private SourceUtils() {
    }

    public static Tree treeFor(CompilationInfo compilationInfo, Element element) {
        Element element2;
        Context context = SourceUtils.getSourceContextFor(compilationInfo.getClasspathInfo(), JavaSource.Phase.ELEMENTS_RESOLVED, element);
        if (context != null && (element2 = SourceUtils.getSourceElementFor(element, context)) != null) {
            return JavacElements.instance(context).getTree((Symbol)element2);
        }
        return null;
    }

    public static TreePath pathFor(CompilationInfo compilationInfo, Element element) {
        Element element2;
        Context context = SourceUtils.getSourceContextFor(compilationInfo.getClasspathInfo(), JavaSource.Phase.ELEMENTS_RESOLVED, element);
        if (context != null && (element2 = SourceUtils.getSourceElementFor(element, context)) != null) {
            return JavacTrees.instance(context).getPath(element2);
        }
        return null;
    }

    public static Element getImplementationOf(CompilationInfo compilationInfo, ExecutableElement executableElement, TypeElement typeElement) {
        Context context = compilationInfo.getJavacTask().getContext();
        return ((Symbol.MethodSymbol)executableElement).implementation((Symbol.TypeSymbol)((Object)typeElement), Types.instance(context), true);
    }

    public static boolean checkTypesAssignable(CompilationInfo compilationInfo, TypeMirror typeMirror, TypeMirror typeMirror2) {
        Context context = compilationInfo.getJavacTask().getContext();
        if (typeMirror.getKind() == TypeKind.DECLARED) {
            List<Type> list = List.nil();
            for (TypeMirror typeMirror3 : ((DeclaredType)typeMirror).getTypeArguments()) {
                if (typeMirror3.getKind() != TypeKind.TYPEVAR) continue;
                list = list.append((Type)typeMirror3);
            }
            if (!list.isEmpty()) {
                typeMirror = new Type.ForAll(list, (Type)typeMirror);
            }
        } else if (typeMirror.getKind() == TypeKind.WILDCARD) {
            typeMirror = Types.instance(context).upperBound((Type)typeMirror);
        }
        return Check.instance(context).checkType(null, (Type)typeMirror, (Type)typeMirror2).getKind() != TypeKind.ERROR;
    }

    public static TypeMirror getBound(WildcardType wildcardType) {
        Type.TypeVar typeVar = ((Type.WildcardType)wildcardType).bound;
        return typeVar != null ? typeVar.bound : null;
    }

    public static TypeElement getEnclosingTypeElement(Element element) throws IllegalArgumentException {
        if (element.getKind() == ElementKind.PACKAGE) {
            throw new IllegalArgumentException();
        }
        if (element.getEnclosingElement().getKind() == ElementKind.PACKAGE) {
            return null;
        }
        while (!element.getEnclosingElement().getKind().isClass() && !element.getEnclosingElement().getKind().isInterface()) {
            element = element.getEnclosingElement();
        }
        return (TypeElement)element.getEnclosingElement();
    }

    public static TypeElement getOutermostEnclosingTypeElement(Element element) {
        Element element2 = SourceUtils.getEnclosingTypeElement(element);
        if (element2 == null) {
            element2 = element;
        }
        while (element2.getEnclosingElement().getKind().isClass() || element2.getEnclosingElement().getKind().isInterface()) {
            element2 = element2.getEnclosingElement();
        }
        return (TypeElement)element2;
    }

    public static String resolveImport(final CompilationInfo compilationInfo, TreePath treePath, final String string) throws NullPointerException, IOException {
        if (compilationInfo == null) {
            throw new NullPointerException();
        }
        if (treePath == null) {
            throw new NullPointerException();
        }
        if (string == null) {
            throw new NullPointerException();
        }
        CompilationUnitTree compilationUnitTree = compilationInfo.getCompilationUnit();
        Scope scope = compilationInfo.getTrees().getScope(treePath);
        String string2 = string;
        StringBuilder stringBuilder = new StringBuilder();
        String string3 = null;
        boolean bl = false;
        ElementUtilities elementUtilities = compilationInfo.getElementUtilities();
        ElementUtilities.ElementAcceptor elementAcceptor = new ElementUtilities.ElementAcceptor(){

            public boolean accept(Element element, TypeMirror typeMirror) {
                return element.getKind().isClass() || element.getKind().isInterface();
            }
        };
        while (string2 != null && string2.length() > 0) {
            int n = string2.lastIndexOf(46);
            String string4 = string2.substring(n < 0 ? 0 : n + 1);
            if (string3 == null) {
                string3 = string4;
            } else {
                stringBuilder.insert(0, '.');
            }
            stringBuilder.insert(0, string4);
            if (compilationInfo.getElements().getTypeElement(string2) != null) {
                boolean bl2 = false;
                for (Element element : elementUtilities.getLocalMembersAndVars(scope, elementAcceptor)) {
                    if (!string4.contentEquals(element.getSimpleName())) continue;
                    if (string2.contentEquals(((TypeElement)element).getQualifiedName())) {
                        return stringBuilder.toString();
                    }
                    if (string == string2) {
                        bl = true;
                    }
                    bl2 = true;
                    break;
                }
                if (!bl2) {
                    for (TypeElement typeElement : elementUtilities.getGlobalTypes(elementAcceptor)) {
                        if (!string4.contentEquals(typeElement.getSimpleName())) continue;
                        if (string2.contentEquals(typeElement.getQualifiedName())) {
                            return stringBuilder.toString();
                        }
                        if (string != string2) break;
                        bl = true;
                        break;
                    }
                }
            }
            string2 = n < 0 ? null : string2.substring(0, n);
        }
        if (bl) {
            return string;
        }
        if (compilationInfo instanceof WorkingCopy) {
            CompilationUnitTree compilationUnitTree2 = (CompilationUnitTree)((WorkingCopy)compilationInfo).getChangeSet().getChange(compilationUnitTree);
            compilationUnitTree = compilationUnitTree2 != null ? compilationUnitTree2 : compilationUnitTree;
            ((WorkingCopy)compilationInfo).rewrite(compilationInfo.getCompilationUnit(), SourceUtils.addImports(compilationUnitTree, Collections.singletonList(string), ((WorkingCopy)compilationInfo).getTreeMaker()));
        } else {
            RequestProcessor.getDefault().post(new Runnable(){

                public void run() {
                    try {
                        compilationInfo.getJavaSource().runModificationTask(new CancellableTask<WorkingCopy>(){

                            @Override
                            public void cancel() {
                            }

                            @Override
                            public void run(WorkingCopy workingCopy) throws Exception {
                                workingCopy.toPhase(JavaSource.Phase.ELEMENTS_RESOLVED);
                                workingCopy.rewrite(workingCopy.getCompilationUnit(), SourceUtils.addImports(workingCopy.getCompilationUnit(), Collections.singletonList(string), workingCopy.getTreeMaker()));
                            }
                        }).commit();
                    }
                    catch (IOException iOException) {
                        Exceptions.printStackTrace((Throwable)iOException);
                    }
                }
            });
        }
        TypeElement typeElement = compilationInfo.getElements().getTypeElement(string);
        if (typeElement != null) {
            ((JCTree.JCCompilationUnit)compilationInfo.getCompilationUnit()).namedImportScope.enterIfAbsent((Symbol)((Object)typeElement));
        }
        return string3;
    }

    public static CompilationUnitTree addImports(CompilationUnitTree compilationUnitTree, java.util.List<String> list, TreeMaker treeMaker) throws IOException {
        String string;
        list = new ArrayList<String>(list);
        Collections.sort(list);
        ArrayList<? extends ImportTree> arrayList = new ArrayList<ImportTree>(compilationUnitTree.getImports());
        int n = list.size() - 1;
        int n2 = arrayList.size() - 1;
        while (n >= 0 && n2 >= 0) {
            string = list.get(n);
            while (n2 >= 0 && (((ImportTree)arrayList.get(n2)).isStatic() || ((ImportTree)arrayList.get(n2)).getQualifiedIdentifier().toString().compareTo(string) > 0)) {
                --n2;
            }
            if (n2 < 0) continue;
            arrayList.add(n2 + 1, treeMaker.Import(treeMaker.Identifier(string), false));
            --n;
        }
        while (n >= 0) {
            string = list.get(n);
            arrayList.add(0, treeMaker.Import(treeMaker.Identifier(string), false));
            --n;
        }
        return treeMaker.CompilationUnit(compilationUnitTree.getPackageName(), arrayList, compilationUnitTree.getTypeDecls(), compilationUnitTree.getSourceFile());
    }

    public static FileObject getFile(Element element) {
        URI uRI;
        if (element == null) {
            throw new IllegalArgumentException("Cannot pass null as an argument of the SourceUtils.getFile");
        }
        Element element2 = null;
        while (element.getKind() != ElementKind.PACKAGE) {
            element2 = element;
            element = element.getEnclosingElement();
        }
        if (element2 == null || !element2.getKind().isClass() && !element2.getKind().isInterface()) {
            return null;
        }
        Symbol.ClassSymbol classSymbol = (Symbol.ClassSymbol)element2;
        if (classSymbol.completer != null) {
            classSymbol.complete();
        }
        if (classSymbol.sourcefile != null && (uRI = classSymbol.sourcefile.toUri()) != null && uRI.isAbsolute()) {
            try {
                return URLMapper.findFileObject((URL)uRI.toURL());
            }
            catch (MalformedURLException malformedURLException) {
                malformedURLException.printStackTrace();
            }
        }
        return null;
    }

    public static FileObject getFile(Element element, ClasspathInfo classpathInfo) {
        try {
            URI uRI;
            if (element == null || classpathInfo == null) {
                throw new IllegalArgumentException("Cannot pass null as an argument of the SourceUtils.getFile");
            }
            Element element2 = null;
            while (element.getKind() != ElementKind.PACKAGE) {
                element2 = element;
                element = element.getEnclosingElement();
            }
            if (element2 == null || !element2.getKind().isClass() && !element2.getKind().isInterface()) {
                return null;
            }
            Symbol.ClassSymbol classSymbol = (Symbol.ClassSymbol)element2;
            if (classSymbol.completer != null) {
                classSymbol.complete();
            }
            if (classSymbol.sourcefile != null && (uRI = classSymbol.sourcefile.toUri()) != null && uRI.isAbsolute()) {
                return URLMapper.findFileObject((URL)uRI.toURL());
            }
            if (classSymbol.classfile == null) {
                return null;
            }
            uRI = classSymbol.classfile.toUri();
            if (uRI == null || !uRI.isAbsolute()) {
                return null;
            }
            FileObject fileObject = URLMapper.findFileObject((URL)uRI.toURL());
            if (fileObject == null) {
                return null;
            }
            ClassPath classPath = ClassPathSupport.createProxyClassPath((ClassPath[])new ClassPath[]{SourceUtils.createClassPath(classpathInfo, ClasspathInfo.PathKind.BOOT), SourceUtils.createClassPath(classpathInfo, ClasspathInfo.PathKind.OUTPUT), SourceUtils.createClassPath(classpathInfo, ClasspathInfo.PathKind.COMPILE)});
            FileObject fileObject2 = classPath.findOwnerRoot(fileObject);
            if (fileObject2 == null) {
                return null;
            }
            String string = classPath.getResourceName(fileObject.getParent(), '/', false);
            SourceForBinaryQuery.Result result = SourceForBinaryQuery.findSourceRoots((URL)fileObject2.getURL());
            FileObject[] fileObjectArray = result.getRoots();
            ClassPath classPath2 = ClassPathSupport.createClassPath((FileObject[])fileObjectArray);
            java.util.List list = classPath2.findAllResources(string);
            boolean bl = SourceUtils.isCaseSensitive();
            String string2 = SourceUtils.getSourceFileName(fileObject.getName());
            for (FileObject fileObject3 : list) {
                FileObject[] fileObjectArray2;
                for (FileObject fileObject4 : fileObjectArray2 = fileObject3.getChildren()) {
                    if ((!bl || !fileObject4.getName().equals(string2)) && (bl || !fileObject4.getName().equalsIgnoreCase(string2)) || !"java".equalsIgnoreCase(fileObject4.getExt())) continue;
                    return fileObject4;
                }
            }
        }
        catch (MalformedURLException malformedURLException) {
            Exceptions.printStackTrace((Throwable)malformedURLException);
        }
        catch (FileStateInvalidException fileStateInvalidException) {
            Exceptions.printStackTrace((Throwable)fileStateInvalidException);
        }
        return null;
    }

    public static FileObject getFile(ElementHandle<? extends Element> elementHandle, ClasspathInfo classpathInfo) {
        if (elementHandle == null || classpathInfo == null) {
            throw new IllegalArgumentException("Cannot pass null as an argument of the SourceUtils.getFile");
        }
        try {
            String string;
            boolean bl = elementHandle.getKind() == ElementKind.PACKAGE;
            String[] stringArray = elementHandle.getSignature();
            assert (stringArray.length >= 1);
            ClassPath classPath = ClassPathSupport.createProxyClassPath((ClassPath[])new ClassPath[]{SourceUtils.createClassPath(classpathInfo, ClasspathInfo.PathKind.BOOT), SourceUtils.createClassPath(classpathInfo, ClasspathInfo.PathKind.OUTPUT), SourceUtils.createClassPath(classpathInfo, ClasspathInfo.PathKind.COMPILE)});
            String string2 = null;
            if (bl) {
                string = FileObjects.convertPackage2Folder(stringArray[0]);
            } else {
                int n = stringArray[0].lastIndexOf(46);
                if (n < 0) {
                    string = "";
                    string2 = stringArray[0];
                } else {
                    string = FileObjects.convertPackage2Folder(stringArray[0].substring(0, n));
                    string2 = stringArray[0].substring(n + 1);
                }
            }
            java.util.List list = classPath.findAllResources(string);
            for (FileObject fileObject : list) {
                FileObject fileObject2 = classPath.findOwnerRoot(fileObject);
                assert (fileObject2 != null);
                FileObject[] fileObjectArray = SourceForBinaryQuery.findSourceRoots((URL)fileObject2.getURL()).getRoots();
                ClassPath classPath2 = ClassPathSupport.createClassPath((FileObject[])fileObjectArray);
                LinkedList<FileObject> linkedList = new LinkedList<FileObject>(classPath2.findAllResources(string));
                if (bl) {
                    return linkedList.isEmpty() ? fileObject : (FileObject)linkedList.get(0);
                }
                boolean bl2 = SourceUtils.isCaseSensitive();
                String string3 = SourceUtils.getSourceFileName(string2);
                linkedList.addFirst(fileObject);
                for (FileObject fileObject3 : linkedList) {
                    FileObject[] fileObjectArray2;
                    for (FileObject fileObject4 : fileObjectArray2 = fileObject3.getChildren()) {
                        if ((!bl2 || !fileObject4.getName().equals(string3)) && (bl2 || !fileObject4.getName().equalsIgnoreCase(string3)) || !fileObject4.isData() || !"java".equalsIgnoreCase(fileObject4.getExt())) continue;
                        return fileObject4;
                    }
                }
            }
        }
        catch (MalformedURLException malformedURLException) {
            Exceptions.printStackTrace((Throwable)malformedURLException);
        }
        catch (FileStateInvalidException fileStateInvalidException) {
            Exceptions.printStackTrace((Throwable)fileStateInvalidException);
        }
        return null;
    }

    public static URL getJavadoc(Element element, ClasspathInfo classpathInfo) {
        String string;
        String string2;
        Object object;
        Object object2;
        Object object3;
        if (element == null || classpathInfo == null) {
            throw new IllegalArgumentException("Cannot pass null as an argument of the SourceUtils.getJavadoc");
        }
        Symbol.ClassSymbol classSymbol = null;
        if (element.getKind() == ElementKind.PACKAGE) {
            object3 = element.getEnclosedElements();
            object2 = object3.iterator();
            while (object2.hasNext()) {
                object = object2.next();
                if (!object.getKind().isClass() && !object.getKind().isInterface()) continue;
                classSymbol = (Symbol.ClassSymbol)object;
                break;
            }
            if (classSymbol == null) {
                return null;
            }
            string2 = FileObjects.convertPackage2Folder(((PackageElement)element).getQualifiedName().toString());
            string = PACKAGE_SUMMARY;
        } else {
            object3 = null;
            while (element.getKind() != ElementKind.PACKAGE) {
                object3 = element;
                element = element.getEnclosingElement();
            }
            if (object3 == null || !object3.getKind().isClass() && !object3.getKind().isInterface()) {
                return null;
            }
            classSymbol = (Symbol.ClassSymbol)object3;
            string2 = FileObjects.convertPackage2Folder(((Symbol)classSymbol.getEnclosingElement()).getQualifiedName().toString());
            string = classSymbol.getSimpleName().toString();
        }
        if (classSymbol.completer != null) {
            classSymbol.complete();
        }
        object3 = null;
        object2 = new HashSet();
        try {
            Object object4;
            ClassPath classPath;
            Object object5;
            if (classSymbol.classfile != null) {
                URL uRL;
                object = URLMapper.findFileObject((URL)classSymbol.classfile.toUri().toURL());
                object5 = new StringTokenizer(string2, "/");
                for (int n = 0; object != null && n <= ((StringTokenizer)object5).countTokens(); object = object.getParent(), ++n) {
                }
                if (object != null && (object3 = Index.getSourceRootForClassFolder(uRL = object.getURL())) == null) {
                    object2.add(uRL);
                }
            }
            if (object3 == null && object2.isEmpty() && classSymbol.sourcefile != null) {
                object3 = classSymbol.sourcefile.toUri().toURL();
            }
            if (object3 != null && (object = URLMapper.findFileObject((URL)object3)) != null) {
                Object object622;
                object5 = ClassPath.getClassPath((FileObject)object, (String)"classpath/execute");
                ClassPath classPath2 = ClassPath.getClassPath((FileObject)object, (String)"classpath/compile");
                classPath = ClassPath.getClassPath((FileObject)object, (String)"classpath/source");
                if (object5 == null) {
                    object5 = classPath2;
                    classPath2 = null;
                }
                if (object5 == null || classPath == null) {
                    return null;
                }
                object4 = new HashSet();
                for (Object object622 : object5.entries()) {
                    object4.add(object622.getURL());
                }
                if (classPath2 != null) {
                    for (Object object622 : classPath2.entries()) {
                        object4.remove(object622.getURL());
                    }
                }
                java.util.List<FileObject> list = Arrays.asList(classPath.getRoots());
                object622 = object4.iterator();
                block8: while (object622.hasNext()) {
                    FileObject[] fileObjectArray;
                    URL uRL = (URL)object622.next();
                    for (FileObject fileObject : fileObjectArray = SourceForBinaryQuery.findSourceRoots((URL)uRL).getRoots()) {
                        if (!list.contains(fileObject)) continue;
                        object2.add(uRL);
                        continue block8;
                    }
                }
            }
            object = object2.iterator();
            while (object.hasNext()) {
                object5 = (URL)object.next();
                URL[] uRLArray = JavadocForBinaryQuery.findJavadoc((URL)object5).getRoots();
                classPath = ClassPathSupport.createClassPath((URL[])uRLArray);
                object4 = classPath.findResource(string2);
                if (object4 == null) continue;
                for (FileObject fileObject : object4.getChildren()) {
                    if (!string.equals(fileObject.getName()) || !"html".equalsIgnoreCase(fileObject.getExt())) continue;
                    return fileObject.getURL();
                }
            }
        }
        catch (MalformedURLException malformedURLException) {
            Exceptions.printStackTrace((Throwable)malformedURLException);
        }
        catch (FileStateInvalidException fileStateInvalidException) {
            Exceptions.printStackTrace((Throwable)fileStateInvalidException);
        }
        return null;
    }

    public static boolean isScanInProgress() {
        return RepositoryUpdater.getDefault().isScanInProgress();
    }

    public static void waitScanFinished() throws InterruptedException {
        RepositoryUpdater.getDefault().waitScanFinished();
    }

    public static Collection<ElementHandle<TypeElement>> getMainClasses(FileObject fileObject) {
        if (fileObject == null || !fileObject.isValid() || fileObject.isVirtual()) {
            throw new IllegalArgumentException();
        }
        JavaSource javaSource = JavaSource.forFileObject(fileObject);
        if (javaSource == null) {
            throw new IllegalArgumentException();
        }
        try {
            final LinkedList<ElementHandle<TypeElement>> linkedList = new LinkedList<ElementHandle<TypeElement>>();
            javaSource.runUserActionTask(new CancellableTask<CompilationController>(){

                @Override
                public void run(final CompilationController compilationController) throws Exception {
                    if (compilationController.toPhase(JavaSource.Phase.ELEMENTS_RESOLVED).compareTo(JavaSource.Phase.ELEMENTS_RESOLVED) >= 0) {
                        new TreePathScanner<Void, Void>(){

                            @Override
                            public Void visitMethod(MethodTree methodTree, Void void_) {
                                ExecutableElement executableElement = (ExecutableElement)compilationController.getTrees().getElement(this.getCurrentPath());
                                if (executableElement != null && SourceUtils.isMainMethod(executableElement) && this.isAccessible(executableElement.getEnclosingElement())) {
                                    linkedList.add(ElementHandle.create((TypeElement)executableElement.getEnclosingElement()));
                                }
                                return null;
                            }
                        }.scan(compilationController.getCompilationUnit(), null);
                    }
                }

                private boolean isAccessible(Element element) {
                    ElementKind elementKind = element.getKind();
                    while (elementKind != ElementKind.PACKAGE) {
                        if (!elementKind.isClass() && !elementKind.isInterface()) {
                            return false;
                        }
                        Set<Modifier> set = ((TypeElement)element).getModifiers();
                        if (!set.contains((Object)Modifier.PUBLIC)) {
                            return false;
                        }
                        Element element2 = element.getEnclosingElement();
                        if (element2.getKind() != ElementKind.PACKAGE && !set.contains((Object)Modifier.STATIC)) {
                            return false;
                        }
                        element = element2;
                        elementKind = element.getKind();
                    }
                    return true;
                }

                @Override
                public void cancel() {
                }
            }, true);
            return linkedList;
        }
        catch (IOException iOException) {
            Exceptions.printStackTrace((Throwable)iOException);
            return Collections.emptySet();
        }
    }

    public static boolean isMainClass(final String string, ClasspathInfo classpathInfo) {
        if (string == null || classpathInfo == null) {
            throw new IllegalArgumentException();
        }
        final boolean[] blArray = new boolean[]{false};
        JavaSource javaSource = JavaSource.create(classpathInfo, new FileObject[0]);
        try {
            javaSource.runUserActionTask(new CancellableTask<CompilationController>(){

                @Override
                public void run(CompilationController compilationController) throws Exception {
                    TypeElement typeElement = compilationController.getElements().getTypeElement(string);
                    if (typeElement == null) {
                        return;
                    }
                    java.util.List<ExecutableElement> list = ElementFilter.methodsIn(typeElement.getEnclosedElements());
                    for (ExecutableElement executableElement : list) {
                        if (!SourceUtils.isMainMethod(executableElement)) continue;
                        blArray[0] = true;
                        break;
                    }
                }

                @Override
                public void cancel() {
                }
            }, true);
        }
        catch (IOException iOException) {
            Exceptions.printStackTrace((Throwable)iOException);
        }
        return blArray[0];
    }

    public static boolean isMainMethod(ExecutableElement executableElement) {
        if (!"main".contentEquals(executableElement.getSimpleName())) {
            return false;
        }
        long l = ((Symbol.MethodSymbol)executableElement).flags();
        if ((l & 1L) == 0L || (l & 8L) == 0L) {
            return false;
        }
        if (executableElement.getReturnType().getKind() != TypeKind.VOID) {
            return false;
        }
        java.util.List<? extends VariableElement> list = executableElement.getParameters();
        if (list.size() != 1) {
            return false;
        }
        TypeMirror typeMirror = list.get(0).asType();
        if (typeMirror.getKind() != TypeKind.ARRAY) {
            return false;
        }
        ArrayType arrayType = (ArrayType)typeMirror;
        TypeMirror typeMirror2 = arrayType.getComponentType();
        if (typeMirror2.getKind() != TypeKind.DECLARED) {
            return false;
        }
        return "java.lang.String".contentEquals(((TypeElement)((DeclaredType)typeMirror2).asElement()).getQualifiedName());
    }

    public static Collection<ElementHandle<TypeElement>> getMainClasses(FileObject[] fileObjectArray) {
        final LinkedList<ElementHandle<TypeElement>> linkedList = new LinkedList<ElementHandle<TypeElement>>();
        for (FileObject fileObject : fileObjectArray) {
            try {
                ClassPath classPath = ClassPath.getClassPath((FileObject)fileObject, (String)"classpath/boot");
                ClassPath classPath2 = ClassPath.getClassPath((FileObject)fileObject, (String)"classpath/compile");
                ClassPath classPath3 = ClassPathSupport.createClassPath((FileObject[])new FileObject[]{fileObject});
                ClasspathInfo classpathInfo = ClasspathInfo.create(classPath, classPath2, classPath3);
                final Set<ElementHandle<TypeElement>> set = classpathInfo.getClassIndex().getDeclaredTypes("", ClassIndex.NameKind.PREFIX, EnumSet.of(ClassIndex.SearchScope.SOURCE));
                JavaSource javaSource = JavaSource.create(classpathInfo, new FileObject[0]);
                javaSource.runUserActionTask(new CancellableTask<CompilationController>(){

                    @Override
                    public void run(CompilationController compilationController) throws Exception {
                        for (ElementHandle elementHandle : set) {
                            TypeElement typeElement = (TypeElement)elementHandle.resolve(compilationController);
                            if (typeElement == null) continue;
                            java.util.List<ExecutableElement> list = ElementFilter.methodsIn(typeElement.getEnclosedElements());
                            for (ExecutableElement executableElement : list) {
                                if (!SourceUtils.isMainMethod(executableElement)) continue;
                                linkedList.add(elementHandle);
                            }
                        }
                    }

                    @Override
                    public void cancel() {
                    }
                }, false);
            }
            catch (IOException iOException) {
                Exceptions.printStackTrace((Throwable)iOException);
                return Collections.emptySet();
            }
        }
        return linkedList;
    }

    private static boolean isCaseSensitive() {
        return !new File("a").equals(new File("A"));
    }

    private static String getSourceFileName(String string) {
        int n = string.indexOf(36);
        return n == -1 ? string : string.substring(0, n);
    }

    private static ClassPath createClassPath(ClasspathInfo classpathInfo, ClasspathInfo.PathKind pathKind) throws MalformedURLException {
        return classpathInfo.getClassPath(pathKind);
    }

    private static Context getSourceContextFor(ClasspathInfo classpathInfo, final JavaSource.Phase phase, Element element) {
        try {
            JavaSource javaSource;
            FileObject fileObject = SourceUtils.getFile(element, classpathInfo);
            if (fileObject != null && (javaSource = JavaSource.forFileObject(fileObject)) != null) {
                final Context[] contextArray = new Context[1];
                javaSource.runUserActionTask(new CancellableTask<CompilationController>(){

                    @Override
                    public void cancel() {
                    }

                    @Override
                    public void run(CompilationController compilationController) throws Exception {
                        compilationController.toPhase(phase);
                        contextArray[0] = compilationController.getJavacTask().getContext();
                    }
                }, true);
                return contextArray[0];
            }
        }
        catch (IOException iOException) {
            Exceptions.printStackTrace((Throwable)iOException);
        }
        return null;
    }

    private static Element getSourceElementFor(Element element, Context context) {
        block10: {
            Symbol.ClassSymbol classSymbol;
            Symbol symbol;
            Name.Table table;
            Symbol symbol2;
            block9: {
                symbol2 = (Symbol)element;
                Symtab symtab = Symtab.instance(context);
                table = Name.Table.instance((Context)context);
                symbol = symbol2.owner;
                Symbol.ClassSymbol classSymbol2 = symbol2.enclClass();
                Name name = table.fromString(classSymbol2.flatname.toString());
                classSymbol = (Symbol.ClassSymbol)((Object)symtab.classes.get(name));
                if (classSymbol2 == symbol2) {
                    return classSymbol;
                }
                if (classSymbol == null || symbol != classSymbol2) break block9;
                Scope.Entry entry = classSymbol.members().lookup(table.fromString(symbol2.name.toString()));
                while (entry.scope != null) {
                    if (entry.sym.kind == symbol2.kind && (entry.sym.flags_field & 0x1000L) == 0L && entry.sym.type.toString().equals(symbol2.type.toString())) {
                        return entry.sym;
                    }
                    entry = entry.next();
                }
                break block10;
            }
            if (classSymbol == null || symbol.kind != 16 || symbol2.kind != 4) break block10;
            Scope.Entry entry = classSymbol.members().lookup(table.fromString(symbol.name.toString()));
            Symbol symbol3 = null;
            while (entry.scope != null) {
                if (entry.sym.kind == symbol.kind && (entry.sym.flags_field & 0x1000L) == 0L && entry.sym.type.toString().equals(symbol.type.toString())) {
                    symbol3 = entry.sym;
                    break;
                }
                entry = entry.next();
            }
            if (symbol3 != null && symbol3.kind == 16) {
                int n = 0;
                List<Symbol.VarSymbol> list = ((Symbol.MethodSymbol)symbol).params;
                while (list.nonEmpty()) {
                    ++n;
                    if (symbol2 == list.head) break;
                    list = list.tail;
                }
                list = ((Symbol.MethodSymbol)symbol3).params;
                while (list.nonEmpty()) {
                    if (--n == 0) {
                        return (Element)list.head;
                    }
                    list = list.tail;
                }
            }
        }
        return null;
    }
}

