/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.api.java.source;

import com.sun.source.tree.Tree;
import com.sun.source.util.TreePath;
import com.sun.tools.javac.tree.JCTree;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.logging.Logger;
import javax.lang.model.element.Element;
import javax.swing.text.Position;
import org.netbeans.api.java.source.CompilationInfo;
import org.netbeans.api.java.source.ElementHandle;
import org.openide.cookies.EditorCookie;
import org.openide.cookies.OpenCookie;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.filesystems.URLMapper;
import org.openide.loaders.DataObject;
import org.openide.loaders.DataObjectNotFoundException;
import org.openide.nodes.Node;
import org.openide.text.CloneableEditorSupport;
import org.openide.text.PositionRef;

public final class TreePathHandle {
    private PositionRef position;
    private KindPath kindPath;
    private FileObject file;
    private ElementHandle enclosingElement;
    private boolean enclElIsCorrespondingEl;

    public FileObject getFileObject() {
        return this.file;
    }

    public TreePath resolve(CompilationInfo compilationInfo) throws IllegalArgumentException {
        assert (compilationInfo != null);
        if (!compilationInfo.getFileObject().equals(this.getFileObject())) {
            throw new IllegalArgumentException("TreePathHandle [" + FileUtil.getFileDisplayName((FileObject)this.getFileObject()) + "] was not created from " + FileUtil.getFileDisplayName((FileObject)compilationInfo.getFileObject()));
        }
        Object t = this.enclosingElement.resolve(compilationInfo);
        TreePath treePath = null;
        if (t != null) {
            TreePath treePath2 = compilationInfo.getTrees().getPath((Element)t);
            if (treePath2 == null) {
                Logger.getLogger(TreePathHandle.class.getName()).fine("compilationInfo.getTrees().getPath(element) returned null for element %s " + t + "(" + this.file.getPath() + ")");
            } else {
                treePath = compilationInfo.getTreeUtilities().pathFor(treePath2, this.position.getOffset() + 1);
            }
        }
        if (treePath == null) {
            treePath = compilationInfo.getTreeUtilities().pathFor(this.position.getOffset() + 1);
        }
        if (new KindPath(treePath).equals(this.kindPath)) {
            return treePath;
        }
        return null;
    }

    public Element resolveElement(CompilationInfo compilationInfo) {
        TreePath treePath = null;
        IllegalStateException illegalStateException = null;
        try {
            if (compilationInfo.getFileObject().equals(this.file)) {
                treePath = this.resolve(compilationInfo);
            }
        }
        catch (IllegalStateException illegalStateException2) {
            illegalStateException = illegalStateException2;
        }
        if (treePath == null) {
            if (this.enclElIsCorrespondingEl) {
                return this.enclosingElement.resolve(compilationInfo);
            }
            if (illegalStateException == null) {
                return null;
            }
            throw illegalStateException;
        }
        Element element = compilationInfo.getTrees().getElement(treePath);
        if (element == null) {
            Logger.getLogger(TreePathHandle.class.toString()).fine("info.getTrees().getElement(tp) returned null for " + treePath);
            if (this.enclElIsCorrespondingEl) {
                return this.enclosingElement.resolve(compilationInfo);
            }
            return null;
        }
        return element;
    }

    public Tree.Kind getKind() {
        return (Tree.Kind)((Object)this.kindPath.kindPath.get(0));
    }

    private TreePathHandle(PositionRef positionRef, KindPath kindPath, FileObject fileObject, ElementHandle elementHandle, boolean bl) {
        this.kindPath = kindPath;
        this.position = positionRef;
        this.file = fileObject;
        this.enclosingElement = elementHandle;
        this.enclElIsCorrespondingEl = bl;
    }

    public static TreePathHandle create(TreePath treePath, CompilationInfo compilationInfo) throws IllegalArgumentException {
        Element element;
        FileObject fileObject;
        try {
            fileObject = URLMapper.findFileObject((URL)treePath.getCompilationUnit().getSourceFile().toUri().toURL());
        }
        catch (MalformedURLException malformedURLException) {
            throw (RuntimeException)new RuntimeException().initCause(malformedURLException);
        }
        int n = ((JCTree)treePath.getLeaf()).pos;
        CloneableEditorSupport cloneableEditorSupport = TreePathHandle.findCloneableEditorSupport(fileObject);
        PositionRef positionRef = cloneableEditorSupport.createPositionRef(n, Position.Bias.Forward);
        TreePath treePath2 = treePath;
        boolean bl = true;
        do {
            element = compilationInfo.getTrees().getElement(treePath2);
            treePath2 = treePath2.getParentPath();
            if (element == null || TreePathHandle.isSupported(element)) continue;
            bl = false;
        } while ((element == null || !TreePathHandle.isSupported(element)) && treePath2 != null);
        return new TreePathHandle(positionRef, new KindPath(treePath), fileObject, ElementHandle.create(element), bl);
    }

    private static boolean isSupported(Element element) {
        switch (element.getKind()) {
            case PACKAGE: 
            case CLASS: 
            case INTERFACE: 
            case ENUM: 
            case METHOD: 
            case CONSTRUCTOR: 
            case INSTANCE_INIT: 
            case STATIC_INIT: 
            case FIELD: 
            case ANNOTATION_TYPE: 
            case ENUM_CONSTANT: {
                return true;
            }
        }
        return false;
    }

    private static CloneableEditorSupport findCloneableEditorSupport(FileObject fileObject) {
        try {
            DataObject dataObject = DataObject.find((FileObject)fileObject);
            Node.Cookie cookie = dataObject.getCookie(OpenCookie.class);
            if (cookie instanceof CloneableEditorSupport) {
                return (CloneableEditorSupport)cookie;
            }
            cookie = dataObject.getCookie(EditorCookie.class);
            if (cookie instanceof CloneableEditorSupport) {
                return (CloneableEditorSupport)cookie;
            }
        }
        catch (DataObjectNotFoundException dataObjectNotFoundException) {
            dataObjectNotFoundException.printStackTrace();
        }
        return null;
    }

    private static class KindPath {
        private ArrayList<Tree.Kind> kindPath = new ArrayList();

        private KindPath(TreePath treePath) {
            while (treePath != null) {
                this.kindPath.add(treePath.getLeaf().getKind());
                treePath = treePath.getParentPath();
            }
        }

        public int hashCode() {
            return this.kindPath.hashCode();
        }

        public boolean equals(Object object) {
            if (object instanceof KindPath) {
                return this.kindPath.equals(((KindPath)object).kindPath);
            }
            return false;
        }
    }
}

