/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.api.java.source;

import com.sun.source.tree.BlockTree;
import com.sun.source.tree.CatchTree;
import com.sun.source.tree.ClassTree;
import com.sun.source.tree.CompilationUnitTree;
import com.sun.source.tree.EnhancedForLoopTree;
import com.sun.source.tree.ExpressionStatementTree;
import com.sun.source.tree.ExpressionTree;
import com.sun.source.tree.ForLoopTree;
import com.sun.source.tree.IdentifierTree;
import com.sun.source.tree.MethodInvocationTree;
import com.sun.source.tree.MethodTree;
import com.sun.source.tree.NewClassTree;
import com.sun.source.tree.Scope;
import com.sun.source.tree.StatementTree;
import com.sun.source.tree.ThrowTree;
import com.sun.source.tree.Tree;
import com.sun.source.tree.TryTree;
import com.sun.source.util.SourcePositions;
import com.sun.source.util.TreePath;
import com.sun.source.util.TreePathScanner;
import com.sun.tools.javac.api.JavacScope;
import com.sun.tools.javac.code.Symbol;
import com.sun.tools.javac.code.Type;
import com.sun.tools.javac.comp.Resolve;
import com.sun.tools.javac.tree.JCTree;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import javax.lang.model.element.Element;
import javax.lang.model.element.ElementKind;
import javax.lang.model.element.ExecutableElement;
import javax.lang.model.element.TypeElement;
import javax.lang.model.type.TypeKind;
import javax.lang.model.type.TypeMirror;
import org.netbeans.api.java.lexer.JavaTokenId;
import org.netbeans.api.java.source.Comment;
import org.netbeans.api.java.source.CompilationInfo;
import org.netbeans.api.java.source.query.CommentHandler;
import org.netbeans.api.java.source.query.CommentSet;
import org.netbeans.api.lexer.TokenSequence;
import org.netbeans.modules.java.source.builder.CommentHandlerService;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class TreeUtilities {
    private CompilationInfo info;
    private CommentHandler handler;

    TreeUtilities(CompilationInfo compilationInfo) {
        this.info = compilationInfo;
        this.handler = CommentHandlerService.instance(compilationInfo.getJavacTask().getContext());
    }

    public boolean isInterface(ClassTree classTree) {
        return (((JCTree.JCModifiers)classTree.getModifiers()).flags & 0x200L) != 0L;
    }

    public boolean isEnum(ClassTree classTree) {
        return (((JCTree.JCModifiers)classTree.getModifiers()).flags & 0x4000L) != 0L;
    }

    public boolean isAnnotation(ClassTree classTree) {
        return (((JCTree.JCModifiers)classTree.getModifiers()).flags & 0x2000L) != 0L;
    }

    public boolean isSynthetic(TreePath treePath) throws NullPointerException {
        IdentifierTree identifierTree;
        MethodInvocationTree methodInvocationTree;
        ExpressionStatementTree expressionStatementTree;
        Tree tree = treePath.getLeaf();
        JCTree jCTree = (JCTree)tree;
        if (jCTree.pos == -1) {
            return true;
        }
        if (tree.getKind() == Tree.Kind.METHOD) {
            return (((JCTree.JCMethodDecl)treePath.getLeaf()).mods.flags & 0x1000000000L) != 0L;
        }
        if (tree.getKind() == Tree.Kind.EXPRESSION_STATEMENT && (expressionStatementTree = (ExpressionStatementTree)tree).getExpression().getKind() == Tree.Kind.METHOD_INVOCATION && (methodInvocationTree = (MethodInvocationTree)expressionStatementTree.getExpression()).getMethodSelect().getKind() == Tree.Kind.IDENTIFIER && "super".equals((identifierTree = (IdentifierTree)methodInvocationTree.getMethodSelect()).getName().toString())) {
            SourcePositions sourcePositions = this.info.getTrees().getSourcePositions();
            return sourcePositions.getEndPosition(treePath.getCompilationUnit(), tree) == -1L;
        }
        return false;
    }

    public List<Comment> getComments(Tree tree, boolean bl) {
        CommentSet commentSet = this.handler.getComments(tree);
        if (commentSet == null) {
            return Collections.emptyList();
        }
        List<Comment> list = bl ? commentSet.getPrecedingComments() : commentSet.getTrailingComments();
        return Collections.unmodifiableList(list);
    }

    public TreePath pathFor(int n) {
        return this.pathFor(new TreePath(this.info.getCompilationUnit()), n);
    }

    public TreePath pathFor(TreePath treePath, int n) {
        return this.pathFor(treePath, n, this.info.getTrees().getSourcePositions());
    }

    public TreePath pathFor(TreePath treePath, int n, SourcePositions sourcePositions) {
        class Result
        extends Error {
            TreePath path;

            Result(TreePath treePath) {
                this.path = treePath;
            }
        }
        if (this.info == null || treePath == null || sourcePositions == null) {
            throw new IllegalArgumentException();
        }
        try {
            /*
             * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
             */
            class PathFinder
            extends TreePathScanner<Void, Void> {
                private int pos;
                private SourcePositions sourcePositions;

                PathFinder(int n, SourcePositions sourcePositions) {
                    this.pos = n;
                    this.sourcePositions = sourcePositions;
                }

                @Override
                public Void scan(Tree tree, Void void_) {
                    if (tree != null && this.sourcePositions.getStartPosition(this.getCurrentPath().getCompilationUnit(), tree) < (long)this.pos && this.sourcePositions.getEndPosition(this.getCurrentPath().getCompilationUnit(), tree) >= (long)this.pos) {
                        if (tree.getKind() == Tree.Kind.ERRONEOUS) {
                            tree.accept(this, void_);
                            throw new Result(this.getCurrentPath());
                        }
                        super.scan(tree, void_);
                        throw new Result(new TreePath(this.getCurrentPath(), tree));
                    }
                    return null;
                }
            }
            new PathFinder(n, sourcePositions).scan(treePath, null);
        }
        catch (Result result) {
            treePath = result.path;
        }
        if (treePath.getLeaf() == treePath.getCompilationUnit()) {
            return treePath;
        }
        TokenSequence<JavaTokenId> tokenSequence = this.tokensFor(treePath.getLeaf(), sourcePositions);
        tokenSequence.moveEnd();
        if (tokenSequence.movePrevious() && tokenSequence.offset() < n) {
            switch ((JavaTokenId)tokenSequence.token().id()) {
                case GTGTGT: 
                case GTGT: 
                case GT: {
                    if (treePath.getLeaf().getKind() == Tree.Kind.MEMBER_SELECT || treePath.getLeaf().getKind() == Tree.Kind.CLASS || treePath.getLeaf().getKind() == Tree.Kind.GREATER_THAN) break;
                }
                case RPAREN: {
                    if (treePath.getLeaf().getKind() == Tree.Kind.ENHANCED_FOR_LOOP || treePath.getLeaf().getKind() == Tree.Kind.FOR_LOOP || treePath.getLeaf().getKind() == Tree.Kind.IF || treePath.getLeaf().getKind() == Tree.Kind.WHILE_LOOP || treePath.getLeaf().getKind() == Tree.Kind.DO_WHILE_LOOP) break;
                }
                case SEMICOLON: {
                    if (treePath.getLeaf().getKind() == Tree.Kind.FOR_LOOP && (long)tokenSequence.offset() <= sourcePositions.getStartPosition(treePath.getCompilationUnit(), ((ForLoopTree)treePath.getLeaf()).getUpdate().get(0))) break;
                }
                case RBRACE: {
                    treePath = treePath.getParentPath();
                    switch (treePath.getLeaf().getKind()) {
                        case CATCH: {
                            treePath = treePath.getParentPath();
                        }
                        case METHOD: 
                        case TRY: {
                            treePath = treePath.getParentPath();
                        }
                    }
                }
            }
        }
        return treePath;
    }

    public TypeMirror parseType(String string, TypeElement typeElement) {
        return this.info.getJavacTask().parseType(string, typeElement);
    }

    public StatementTree parseStatement(String string, SourcePositions[] sourcePositionsArray) {
        return this.info.getJavacTask().parseStatement(string, sourcePositionsArray);
    }

    public ExpressionTree parseExpression(String string, SourcePositions[] sourcePositionsArray) {
        return this.info.getJavacTask().parseExpression(string, sourcePositionsArray);
    }

    public ExpressionTree parseVariableInitializer(String string, SourcePositions[] sourcePositionsArray) {
        return this.info.getJavacTask().parseVariableInitializer(string, sourcePositionsArray);
    }

    public BlockTree parseStaticBlock(String string, SourcePositions[] sourcePositionsArray) {
        return this.info.getJavacTask().parseStaticBlock(string, sourcePositionsArray);
    }

    public Scope scopeFor(int n) {
        List<? extends StatementTree> list = null;
        SourcePositions sourcePositions = this.info.getTrees().getSourcePositions();
        TreePath treePath = this.pathFor(n);
        CompilationUnitTree compilationUnitTree = treePath.getCompilationUnit();
        switch (treePath.getLeaf().getKind()) {
            case BLOCK: {
                list = ((BlockTree)treePath.getLeaf()).getStatements();
                break;
            }
            case FOR_LOOP: {
                list = ((ForLoopTree)treePath.getLeaf()).getInitializer();
                break;
            }
            case ENHANCED_FOR_LOOP: {
                list = Collections.singletonList(((EnhancedForLoopTree)treePath.getLeaf()).getStatement());
                break;
            }
            case METHOD: {
                list = ((MethodTree)treePath.getLeaf()).getParameters();
            }
        }
        if (list != null) {
            StatementTree statementTree = null;
            for (StatementTree statementTree2 : list) {
                if (sourcePositions.getStartPosition(compilationUnitTree, statementTree2) >= (long)n) continue;
                statementTree = statementTree2;
            }
            if (statementTree != null) {
                treePath = new TreePath(treePath, statementTree);
            }
        }
        return this.info.getTrees().getScope(treePath);
    }

    public TypeMirror attributeTree(Tree tree, Scope scope) {
        return this.info.getJavacTask().attributeTree((JCTree)tree, ((JavacScope)scope).getEnv());
    }

    public Scope attributeTreeTo(Tree tree, Scope scope, Tree tree2) {
        return this.info.getJavacTask().attributeTreeTo((JCTree)tree, ((JavacScope)scope).getEnv(), (JCTree)tree2);
    }

    public TokenSequence<JavaTokenId> tokensFor(Tree tree) {
        return this.tokensFor(tree, this.info.getTrees().getSourcePositions());
    }

    public TokenSequence<JavaTokenId> tokensFor(Tree tree, SourcePositions sourcePositions) {
        int n = (int)sourcePositions.getStartPosition(this.info.getCompilationUnit(), tree);
        int n2 = (int)sourcePositions.getEndPosition(this.info.getCompilationUnit(), tree);
        return this.info.getTokenHierarchy().tokenSequence(JavaTokenId.language()).subSequence(n, n2);
    }

    public boolean isAccessible(Scope scope, Element element, TypeMirror typeMirror) {
        if (scope instanceof JavacScope && element instanceof Symbol && typeMirror instanceof Type) {
            Resolve resolve = Resolve.instance(this.info.getJavacTask().getContext());
            return resolve.isAccessible(((JavacScope)scope).getEnv(), (Type)typeMirror, (Symbol)element);
        }
        return false;
    }

    public boolean isStaticContext(Scope scope) {
        Resolve.instance(this.info.getJavacTask().getContext());
        return Resolve.isStatic(((JavacScope)scope).getEnv());
    }

    public Set<TypeMirror> getUncaughtExceptions(TreePath treePath) {
        HashSet<TypeMirror> hashSet = new HashSet<TypeMirror>();
        new UncaughtExceptionsVisitor(this.info).scan(treePath, hashSet);
        return hashSet;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class UncaughtExceptionsVisitor
    extends TreePathScanner<Void, Set<TypeMirror>> {
        private CompilationInfo info;

        private UncaughtExceptionsVisitor(CompilationInfo compilationInfo) {
            this.info = compilationInfo;
        }

        @Override
        public Void visitMethodInvocation(MethodInvocationTree methodInvocationTree, Set<TypeMirror> set) {
            super.visitMethodInvocation(methodInvocationTree, set);
            Element element = this.info.getTrees().getElement(this.getCurrentPath());
            if (element != null && element.getKind() == ElementKind.METHOD) {
                set.addAll(((ExecutableElement)element).getThrownTypes());
            }
            return null;
        }

        @Override
        public Void visitNewClass(NewClassTree newClassTree, Set<TypeMirror> set) {
            super.visitNewClass(newClassTree, set);
            Element element = this.info.getTrees().getElement(this.getCurrentPath());
            if (element != null && element.getKind() == ElementKind.CONSTRUCTOR) {
                set.addAll(((ExecutableElement)element).getThrownTypes());
            }
            return null;
        }

        @Override
        public Void visitThrow(ThrowTree throwTree, Set<TypeMirror> set) {
            super.visitThrow(throwTree, set);
            TypeMirror typeMirror = this.info.getTrees().getTypeMirror(new TreePath(this.getCurrentPath(), throwTree.getExpression()));
            if (typeMirror != null && typeMirror.getKind() == TypeKind.DECLARED) {
                set.add(typeMirror);
            }
            return null;
        }

        @Override
        public Void visitTry(TryTree tryTree, Set<TypeMirror> set) {
            HashSet hashSet = new HashSet();
            this.scan(tryTree.getBlock(), hashSet);
            for (CatchTree catchTree : tryTree.getCatches()) {
                TypeMirror typeMirror = this.info.getTrees().getTypeMirror(new TreePath(this.getCurrentPath(), catchTree.getParameter().getType()));
                Iterator iterator = hashSet.iterator();
                while (iterator.hasNext()) {
                    if (!this.info.getTypes().isSubtype((TypeMirror)iterator.next(), typeMirror)) continue;
                    iterator.remove();
                }
            }
            set.addAll(hashSet);
            this.scan(tryTree.getCatches(), set);
            this.scan(tryTree.getFinallyBlock(), set);
            return null;
        }

        @Override
        public Void visitMethod(MethodTree methodTree, Set<TypeMirror> set) {
            HashSet hashSet = new HashSet();
            this.scan(methodTree.getBody(), hashSet);
            for (ExpressionTree expressionTree : methodTree.getThrows()) {
                TypeMirror typeMirror = this.info.getTrees().getTypeMirror(new TreePath(this.getCurrentPath(), expressionTree));
                Iterator iterator = hashSet.iterator();
                while (iterator.hasNext()) {
                    if (!this.info.getTypes().isSubtype((TypeMirror)iterator.next(), typeMirror)) continue;
                    iterator.remove();
                }
            }
            set.addAll(hashSet);
            return null;
        }
    }
}

