/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.api.java.source;

import com.sun.tools.javac.code.Symbol;
import com.sun.tools.javac.code.Type;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import javax.lang.model.element.Element;
import javax.lang.model.element.TypeElement;
import javax.lang.model.element.TypeParameterElement;
import javax.lang.model.type.ArrayType;
import javax.lang.model.type.DeclaredType;
import javax.lang.model.type.ErrorType;
import javax.lang.model.type.TypeKind;
import javax.lang.model.type.TypeMirror;
import javax.lang.model.type.TypeVariable;
import javax.lang.model.type.WildcardType;
import org.netbeans.api.java.source.CompilationInfo;
import org.netbeans.api.java.source.ElementHandle;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class TypeMirrorHandle<T extends TypeMirror> {
    private TypeKind kind;
    private ElementHandle<? extends Element> element;
    private List<TypeMirrorHandle<? extends TypeMirror>> typeMirrors;

    private TypeMirrorHandle(TypeKind typeKind, ElementHandle<? extends Element> elementHandle, List<TypeMirrorHandle<? extends TypeMirror>> list) {
        this.kind = typeKind;
        this.element = elementHandle;
        this.typeMirrors = list;
    }

    public static <T extends TypeMirror> TypeMirrorHandle<T> create(T t) {
        TypeKind typeKind = t.getKind();
        ElementHandle<Element> elementHandle = null;
        List<TypeMirrorHandle<? extends TypeMirror>> list = null;
        switch (typeKind) {
            case BOOLEAN: 
            case BYTE: 
            case CHAR: 
            case DOUBLE: 
            case FLOAT: 
            case INT: 
            case LONG: 
            case NONE: 
            case NULL: 
            case SHORT: 
            case VOID: {
                break;
            }
            case DECLARED: {
                TypeParameterElement annotatedConstruct2;
                Object object;
                List<? extends TypeMirror> list2;
                DeclaredType declaredType = (DeclaredType)t;
                TypeElement typeElement = (TypeElement)declaredType.asElement();
                elementHandle = ElementHandle.create(typeElement);
                if (typeElement.getTypeParameters().isEmpty() || !(list2 = declaredType.getTypeArguments()).isEmpty() && (object = list2.get(0)).getKind() == TypeKind.TYPEVAR && (annotatedConstruct2 = (TypeParameterElement)((TypeVariable)object).asElement()).getGenericElement() == declaredType.asElement()) break;
                list = new ArrayList<TypeMirrorHandle<? extends TypeMirror>>(list2.size());
                for (TypeMirror typeMirror : list2) {
                    list.add(TypeMirrorHandle.create(typeMirror));
                }
                break;
            }
            case ARRAY: {
                list = Collections.singletonList(TypeMirrorHandle.create(((ArrayType)t).getComponentType()));
                break;
            }
            case TYPEVAR: {
                TypeVariable typeVariable = (TypeVariable)t;
                elementHandle = ElementHandle.create(typeVariable.asElement());
                list = new ArrayList<TypeMirrorHandle<? extends TypeMirror>>();
                list.add(typeVariable.getLowerBound() != null ? TypeMirrorHandle.create(typeVariable.getLowerBound()) : null);
                list.add(typeVariable.getUpperBound() != null ? TypeMirrorHandle.create(typeVariable.getUpperBound()) : null);
                break;
            }
            case WILDCARD: {
                WildcardType wildcardType = (WildcardType)t;
                list = new ArrayList<TypeMirrorHandle<? extends TypeMirror>>();
                list.add(wildcardType.getExtendsBound() != null ? TypeMirrorHandle.create(wildcardType.getExtendsBound()) : null);
                list.add(wildcardType.getSuperBound() != null ? TypeMirrorHandle.create(wildcardType.getSuperBound()) : null);
                break;
            }
            case ERROR: {
                ErrorType errorType = (ErrorType)t;
                elementHandle = ElementHandle.create(errorType.asElement());
                break;
            }
            default: {
                throw new IllegalArgumentException("Currently unsupported TypeKind: " + (Object)((Object)t.getKind()));
            }
        }
        return new TypeMirrorHandle<T>(typeKind, elementHandle, list);
    }

    public T resolve(CompilationInfo compilationInfo) {
        switch (this.kind) {
            case BOOLEAN: 
            case BYTE: 
            case CHAR: 
            case DOUBLE: 
            case FLOAT: 
            case INT: 
            case LONG: 
            case SHORT: {
                return (T)compilationInfo.getTypes().getPrimitiveType(this.kind);
            }
            case NONE: 
            case VOID: {
                return (T)compilationInfo.getTypes().getNoType(this.kind);
            }
            case NULL: {
                return (T)compilationInfo.getTypes().getNullType();
            }
            case DECLARED: {
                TypeElement typeElement = (TypeElement)this.element.resolve(compilationInfo);
                if (typeElement == null) {
                    return null;
                }
                if (this.typeMirrors == null) {
                    return (T)typeElement.asType();
                }
                ArrayList<TypeMirror> arrayList = new ArrayList<TypeMirror>();
                for (TypeMirrorHandle<? extends TypeMirror> typeMirrorHandle : this.typeMirrors) {
                    TypeMirror typeMirror = typeMirrorHandle.resolve(compilationInfo);
                    if (typeMirror == null) {
                        return null;
                    }
                    arrayList.add(typeMirror);
                }
                return (T)compilationInfo.getTypes().getDeclaredType(typeElement, arrayList.toArray(new TypeMirror[arrayList.size()]));
            }
            case ARRAY: {
                TypeMirror typeMirror = this.typeMirrors.get(0).resolve(compilationInfo);
                if (typeMirror == null) {
                    return null;
                }
                return (T)compilationInfo.getTypes().getArrayType(typeMirror);
            }
            case TYPEVAR: {
                Element element = this.element.resolve(compilationInfo);
                if (!(element instanceof Symbol.TypeSymbol)) {
                    return null;
                }
                TypeMirrorHandle<? extends TypeMirror> typeMirrorHandle = this.typeMirrors.get(0);
                TypeMirror typeMirror = typeMirrorHandle != null ? typeMirrorHandle.resolve(compilationInfo) : null;
                TypeMirrorHandle<? extends TypeMirror> typeMirrorHandle2 = this.typeMirrors.get(1);
                TypeMirror typeMirror2 = typeMirrorHandle2 != null ? typeMirrorHandle2.resolve(compilationInfo) : null;
                return (T)new Type.TypeVar((Symbol.TypeSymbol)element, (Type)typeMirror, (Type)typeMirror2);
            }
            case WILDCARD: {
                TypeMirrorHandle<? extends TypeMirror> typeMirrorHandle = this.typeMirrors.get(0);
                TypeMirror typeMirror = typeMirrorHandle != null ? typeMirrorHandle.resolve(compilationInfo) : null;
                TypeMirrorHandle<? extends TypeMirror> typeMirrorHandle3 = this.typeMirrors.get(1);
                TypeMirror typeMirror3 = typeMirrorHandle3 != null ? typeMirrorHandle3.resolve(compilationInfo) : null;
                return (T)compilationInfo.getTypes().getWildcardType(typeMirror, typeMirror3);
            }
            case ERROR: {
                Element element = this.element.resolve(compilationInfo);
                if (!(element instanceof Symbol.ClassSymbol)) {
                    return null;
                }
                return (T)new Type.ErrorType((Symbol.ClassSymbol)element);
            }
        }
        throw new IllegalStateException("Internal error: unknown TypeHandle kind: " + (Object)((Object)this.kind));
    }

    public TypeKind getKind() {
        return this.kind;
    }
}

