/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.api.java.source.query;

import com.sun.source.tree.MethodInvocationTree;
import com.sun.source.tree.NewClassTree;
import com.sun.source.tree.Tree;
import com.sun.source.util.TreeScanner;
import java.util.BitSet;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Stack;
import javax.lang.model.element.Element;
import javax.lang.model.element.TypeElement;
import org.netbeans.api.java.source.query.QueryEnvironment;
import org.netbeans.modules.java.source.engine.ASTModel;
import org.netbeans.modules.java.source.engine.EngineEnvironment;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CallGraph {
    private Element rootMethod;
    private Node[] nodes;
    private int nnodes;
    private ASTModel model;
    private Map<Element, Tree> symbols;

    public CallGraph(Element element, QueryEnvironment queryEnvironment) {
        this.model = ((EngineEnvironment)queryEnvironment).getModel();
        this.nodes = new Node[1];
        this.rootMethod = element;
    }

    public Node find(Element element) {
        int n = this.findNode(element);
        return n != -1 ? this.nodes[n] : null;
    }

    public Node[] getNodes() {
        Node[] nodeArray = new Node[this.nnodes];
        System.arraycopy(this.nodes, 0, nodeArray, 0, this.nnodes);
        return nodeArray;
    }

    private int findNode(Element element) {
        for (int i = 0; i < this.nnodes; ++i) {
            if (!((Object)element).equals(this.nodes[i].sym)) continue;
            return i;
        }
        return -1;
    }

    public Node[] getPath(Element element) {
        int n = this.findNode(element);
        if (n == -1) {
            return new Node[0];
        }
        Stack stack = new Stack();
        BitSet bitSet = new BitSet(this.nnodes);
        this.getPath(0, n, stack, bitSet);
        Node[] nodeArray = new Node[stack.size()];
        stack.toArray(nodeArray);
        return nodeArray;
    }

    public String getPathString(Element element) {
        Node[] nodeArray = this.getPath(element);
        if (nodeArray.length == 0) {
            return "<no path>";
        }
        StringBuffer stringBuffer = new StringBuffer();
        Element element2 = element.getEnclosingElement();
        for (int i = 0; i < nodeArray.length; ++i) {
            Element element3 = nodeArray[i].sym;
            Element element4 = element3.getEnclosingElement();
            if (!((Object)element4).equals(element2)) {
                stringBuffer.append(element4.getSimpleName());
                stringBuffer.append('.');
            }
            stringBuffer.append(element3.getSimpleName());
            if (i >= nodeArray.length - 1) continue;
            stringBuffer.append("->");
        }
        return stringBuffer.toString();
    }

    private static String makeNodeName(Element element, TypeElement typeElement) {
        StringBuffer stringBuffer = new StringBuffer();
        TypeElement typeElement2 = (TypeElement)element.getEnclosingElement();
        if (!typeElement2.equals(typeElement)) {
            stringBuffer.append(typeElement2.getQualifiedName());
            stringBuffer.append('.');
        }
        stringBuffer.append(element.getSimpleName());
        return stringBuffer.toString();
    }

    private boolean getPath(int n, int n2, Stack stack, BitSet bitSet) {
        Node node = this.nodes[n];
        stack.push(node);
        bitSet.set(n);
        if (n == n2) {
            return false;
        }
        for (int i = 0; i < node.ncalls; ++i) {
            int n3 = node.calls[i];
            if (bitSet.get(n3) || this.getPath(n3, n2, stack, bitSet)) continue;
            return false;
        }
        stack.pop();
        return true;
    }

    private int addNode(Element element) {
        int n = this.findNode(element);
        if (n == -1) {
            if (this.nnodes == this.nodes.length) {
                Node[] nodeArray = new Node[this.nnodes * 2 + 1];
                System.arraycopy(this.nodes, 0, nodeArray, 0, this.nnodes);
                this.nodes = nodeArray;
            }
            n = this.nnodes++;
            this.nodes[n] = new Node(element);
        }
        return n;
    }

    public void buildGraph() {
        this.symbols = new HashMap<Element, Tree>();
        this.addTrees(this.symbols, this.model.getRoot());
        this.scanCalls(this.rootMethod, null);
        this.symbols = null;
    }

    private void addTrees(Map<Element, Tree> map, Tree tree) {
        Element element = this.model.getElement(tree);
        if (element != null) {
            map.put(element, tree);
            for (Tree tree2 : this.model.getChildren(tree)) {
                this.addTrees(map, tree2);
            }
        }
    }

    private void scanCalls(Element element, Node node) {
        boolean bl;
        int n = this.findNode(element);
        boolean bl2 = bl = n == -1;
        if (bl) {
            n = this.addNode(element);
        }
        if (node != null) {
            node.addCall(n);
        }
        if (!bl) {
            return;
        }
        final Node node2 = this.nodes[n];
        Tree tree = this.symbols.get(element);
        if (tree == null) {
            return;
        }
        tree.accept(new TreeScanner<Void, Object>(){

            @Override
            public Void visitMethodInvocation(MethodInvocationTree methodInvocationTree, Object object) {
                Element element = CallGraph.this.model.getElement(methodInvocationTree.getMethodSelect());
                if (element != null && CallGraph.this.acceptCall(element, methodInvocationTree)) {
                    CallGraph.this.scanCalls(element, node2);
                }
                super.visitMethodInvocation(methodInvocationTree, object);
                return null;
            }

            @Override
            public Void visitNewClass(NewClassTree newClassTree, Object object) {
                Element element = CallGraph.this.model.getElement(newClassTree);
                if (CallGraph.this.acceptCall(element, newClassTree)) {
                    CallGraph.this.scanCalls(element, node2);
                }
                super.visitNewClass(newClassTree, object);
                return null;
            }
        }, null);
    }

    public boolean acceptCall(Element element, Tree tree) {
        return true;
    }

    public void list() {
        this.list(this.find(this.rootMethod), 0, new HashSet());
    }

    private void list(Node node, int n, HashSet hashSet) {
        for (int i = 0; i < n; ++i) {
            System.out.print("  ");
        }
        if (hashSet.contains(node)) {
            System.out.println("<" + node.getElement() + ">");
        } else {
            hashSet.add(node);
            System.out.println(node.getElement());
            Node[] nodeArray = node.getCalls(this);
            for (int i = 0; i < nodeArray.length; ++i) {
                this.list(nodeArray[i], n + 1, hashSet);
            }
        }
    }

    public static class Node {
        Element sym;
        int[] calls = new int[0];
        int ncalls = 0;

        Node(Element element) {
            this.sym = element;
        }

        public Element getElement() {
            return this.sym;
        }

        Node[] getCalls(CallGraph callGraph) {
            Node[] nodeArray = new Node[this.ncalls];
            for (int i = 0; i < this.ncalls; ++i) {
                nodeArray[i] = callGraph.nodes[this.calls[i]];
            }
            return nodeArray;
        }

        void addCall(int n) {
            assert (this.ncalls <= this.calls.length);
            if (this.ncalls == this.calls.length) {
                int[] nArray = new int[this.ncalls * 2 + 1];
                System.arraycopy(this.calls, 0, nArray, 0, this.ncalls);
                this.calls = nArray;
            }
            this.calls[this.ncalls++] = n;
        }

        public String toString() {
            return this.sym.getSimpleName().toString();
        }
    }
}

