/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.api.java.source.query;

import com.sun.source.tree.AnnotationTree;
import com.sun.source.tree.ArrayAccessTree;
import com.sun.source.tree.AssignmentTree;
import com.sun.source.tree.BinaryTree;
import com.sun.source.tree.BlockTree;
import com.sun.source.tree.CompoundAssignmentTree;
import com.sun.source.tree.ConditionalExpressionTree;
import com.sun.source.tree.ExpressionTree;
import com.sun.source.tree.IdentifierTree;
import com.sun.source.tree.InstanceOfTree;
import com.sun.source.tree.LiteralTree;
import com.sun.source.tree.MemberSelectTree;
import com.sun.source.tree.MethodInvocationTree;
import com.sun.source.tree.ModifiersTree;
import com.sun.source.tree.ParenthesizedTree;
import com.sun.source.tree.StatementTree;
import com.sun.source.tree.ThrowTree;
import com.sun.source.tree.Tree;
import com.sun.source.tree.TypeCastTree;
import com.sun.source.tree.UnaryTree;
import com.sun.source.tree.VariableTree;
import com.sun.source.util.TreeScanner;
import com.sun.source.util.Trees;
import java.text.MessageFormat;
import java.util.List;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.lang.model.SourceVersion;
import javax.lang.model.element.Element;
import javax.lang.model.element.ExecutableElement;
import javax.lang.model.element.Modifier;
import javax.lang.model.element.Name;
import javax.lang.model.element.TypeElement;
import javax.lang.model.type.ExecutableType;
import javax.lang.model.type.NoType;
import javax.lang.model.type.NullType;
import javax.lang.model.type.PrimitiveType;
import javax.lang.model.type.TypeMirror;
import javax.lang.model.util.Types;
import org.netbeans.api.java.source.ElementUtilities;
import org.netbeans.api.java.source.query.Command;
import org.netbeans.api.java.source.query.NodeScanner;
import org.netbeans.api.java.source.query.QueryEnvironment;
import org.netbeans.api.java.source.query.QueryException;
import org.netbeans.api.java.source.query.ResultTableModel;
import org.netbeans.api.java.source.query.SearchEntry;
import org.netbeans.api.java.source.query.SearchResult;
import org.netbeans.api.java.source.query.TreeMatcher;
import org.netbeans.api.java.source.query.UseFinder;
import org.netbeans.api.java.source.transform.Transformer;
import org.netbeans.modules.java.source.engine.ElapsedTimer;
import org.openide.util.NbBundle;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class Query<R, P>
extends NodeScanner<R, P>
implements Command {
    protected ElementUtilities elements;
    protected Types types;
    protected Trees trees;
    protected SearchResult result = null;
    protected String queryDescription = null;
    protected SearchEntry lastAddition;
    private UseFinder useFinder;
    static final Logger logger = Logger.getLogger("org.netbeans.modules.java.source");
    public static final int NOPOS = -2;
    private AssignChecker assignChecker;
    private DeclarationChecker declareChecker;
    private TreeMatcher matcherObj;

    @Override
    public void init() {
        this.result = new SearchResult(this, this.getQueryDescription());
    }

    @Override
    public void attach(QueryEnvironment queryEnvironment) {
        super.attach(queryEnvironment);
        this.trees = queryEnvironment.getTrees();
        this.elements = queryEnvironment.getElementUtilities();
        this.types = queryEnvironment.getTypes();
        this.result.attach(queryEnvironment);
    }

    @Override
    public void release() {
        super.release();
        this.trees = null;
        this.elements = null;
        this.types = null;
    }

    @Override
    public void destroy() {
        super.destroy();
        this.result = null;
    }

    @Override
    public void apply() {
        this.logStart();
        ElapsedTimer elapsedTimer = new ElapsedTimer();
        this.apply(this.getRootNode());
        this.logStats(elapsedTimer.toString());
        this.show(this.result, this.getQueryDescription());
    }

    private void logStart() {
        String string = this instanceof Transformer ? "Transformer.running.transformer" : "Query.running.query";
        logger.log(Level.FINE, this.getString(string));
    }

    public void apply(Tree tree) {
        if (tree != null) {
            tree.accept(this, null);
        }
    }

    private void logStats(String string) {
        String string2 = this instanceof Transformer ? "Query.query.stats" : "Transformer.query.stats";
        String string3 = this.getString(string2);
        if (logger.isLoggable(Level.FINE)) {
            Runtime runtime = Runtime.getRuntime();
            System.gc();
            long l = (runtime.totalMemory() - runtime.freeMemory()) / 1024L;
            logger.log(Level.FINE, MessageFormat.format(string3, string, l));
        }
    }

    private void showNoResults() {
        String string = this.getString("Query.noResults");
        String string2 = MessageFormat.format(string, this.queryDescription);
        logger.log(Level.INFO, string2);
        this.env.setStatusMessage(string2);
    }

    private String getString(String string) {
        return NbBundle.getBundle(Query.class).getString(string);
    }

    public QueryEnvironment getEnvironment() {
        return this.env;
    }

    public final void error(Object object) {
        throw new QueryException(object.toString());
    }

    public final void error(QueryException queryException) {
        throw queryException;
    }

    public final void error(Throwable throwable) {
        throw new QueryException(throwable);
    }

    public final void note(String string) {
        this.env.setStatusMessage(string);
    }

    public final void show(SearchResult searchResult, String string) {
        if (this.result != null && this.result.size() > 0) {
            this.env.setResult(searchResult, string);
        } else {
            this.showNoResults();
        }
    }

    public final void show(ResultTableModel[] resultTableModelArray, String string) {
        if (resultTableModelArray != null && resultTableModelArray.length > 0) {
            this.env.setResult(resultTableModelArray, string);
        } else {
            this.showNoResults();
        }
    }

    protected void setResult(SearchResult searchResult) {
        this.result = searchResult;
        for (SearchEntry searchEntry : searchResult.getResults()) {
            logger.log(Level.FINE, this.asLogMessage(searchEntry));
        }
    }

    public final void addResult(Element element, String string) {
        this.addResult(element, null, string);
    }

    public final void addResult(Element element, Tree tree, String string) {
        this.lastAddition = new SearchEntry(this, element, tree, this.model.getPos(tree), string, 0);
        this.result.add(this.lastAddition);
    }

    public final void changeResult(Tree tree, Tree tree2) {
        if (this.lastAddition != null && this.lastAddition.tree == tree) {
            this.lastAddition.tree = tree2;
        }
    }

    public String getQueryDescription() {
        return this.queryDescription != null ? this.queryDescription : "Unnamed Query";
    }

    public void setQueryDescription(String string) {
        this.queryDescription = string;
    }

    public ResultTableModel getResult() {
        return this.result;
    }

    protected String asLogMessage(SearchEntry searchEntry) {
        return this.result.asLogMessage(searchEntry);
    }

    protected Tree getRootNode() {
        return this.env.getRootNode();
    }

    public SearchResult findUses(Element element) {
        if (this.useFinder == null) {
            this.useFinder = new UseFinder(this.env);
        }
        return this.useFinder.find(element, this.getRootNode());
    }

    public Tree getTree(Element element) {
        return this.trees.getTree(element);
    }

    public boolean isOverridden(ExecutableElement executableElement) {
        return false;
    }

    public boolean overrides(ExecutableElement executableElement) {
        return this.elements.overridesMethod(executableElement);
    }

    public boolean referenced(Tree tree) {
        return this.referenced(this.model.getElement(tree));
    }

    public boolean referenced(Element element) {
        return this.elements.referenced(element, this.getCurrentElement());
    }

    public boolean assigned(Element element) {
        return this.elements.assigned(element, this.getCurrentElement());
    }

    public boolean local(Element element) {
        return element == null || this.elements.isLocal(element);
    }

    public boolean local(Tree tree) {
        return tree instanceof IdentifierTree && this.local(this.model.getElement(tree));
    }

    public boolean parameter(Element element) {
        return this.elements.parameter(element, this.getCurrentElement());
    }

    public boolean parameter(Tree tree) {
        return this.parameter(this.model.getElement(tree));
    }

    public boolean assigned(Tree tree) {
        return this.assigned(this.model.getElement(tree));
    }

    public final boolean hasComment(Tree tree) {
        return tree != null && this.env.getCommentHandler().hasComments(tree);
    }

    protected boolean hasAnnotation(ModifiersTree modifiersTree, TypeMirror typeMirror) {
        List<? extends AnnotationTree> list = modifiersTree.getAnnotations();
        for (AnnotationTree annotationTree : list) {
            if (!((Object)this.model.getType(annotationTree)).equals(typeMirror)) continue;
            return true;
        }
        return false;
    }

    public boolean isConstant(Tree tree) {
        Element element = this.model.getElement(tree);
        if (element == null) {
            return false;
        }
        Set<Modifier> set = element.getModifiers();
        if (set.contains((Object)Modifier.FINAL)) {
            return false;
        }
        return element.asType() instanceof PrimitiveType || ((Object)element).equals(this.env.getElements().getTypeElement("java.lang.String"));
    }

    public boolean assignedIn(CharSequence charSequence, List<? extends Tree> list) {
        for (Tree tree : list) {
            if (!this.assignedIn(charSequence, tree)) continue;
            return true;
        }
        return false;
    }

    public boolean assignedIn(CharSequence charSequence, Tree tree) {
        if (this.assignChecker == null) {
            this.assignChecker = new AssignChecker();
        }
        return this.assignChecker.assignedIn(charSequence, tree);
    }

    public boolean declaredIn(CharSequence charSequence, List<? extends Tree> list) {
        for (Tree tree : list) {
            if (!this.declaredIn(charSequence, tree)) continue;
            return true;
        }
        return false;
    }

    public boolean declaredIn(CharSequence charSequence, Tree tree) {
        if (this.declareChecker == null) {
            this.declareChecker = new DeclarationChecker();
        }
        return this.declareChecker.declaredIn(charSequence, tree);
    }

    protected final boolean isInstance(Tree tree, Element element) {
        if (tree == null || element == null) {
            return false;
        }
        TypeMirror typeMirror = this.model.getType(tree);
        return typeMirror != null && this.isSubType(typeMirror, element.asType());
    }

    public boolean isSubType(TypeMirror typeMirror, TypeMirror typeMirror2) {
        if (typeMirror instanceof NoType || typeMirror2 instanceof NoType || typeMirror instanceof ExecutableType || typeMirror2 instanceof ExecutableType || typeMirror instanceof NullType || typeMirror2 instanceof NullType) {
            return false;
        }
        return this.types.isSubtype(typeMirror, typeMirror2);
    }

    public SourceVersion sourceVersion() {
        return this.model.sourceVersion();
    }

    public boolean sourceLevel(SourceVersion sourceVersion) {
        return this.model.sourceVersion().compareTo(sourceVersion) >= 0;
    }

    public final boolean matches(Tree tree, Tree tree2) {
        return this.matcher().matches(tree, tree2);
    }

    public boolean matches(List<? extends Tree> list, List<? extends Tree> list2) {
        return this.matcher().matches(list, list2);
    }

    public final boolean matches(CharSequence charSequence, Tree tree) {
        return tree instanceof IdentifierTree && ((Object)((IdentifierTree)tree).getName()).equals(charSequence);
    }

    public final boolean matches(CharSequence charSequence, CharSequence charSequence2) {
        return ((Object)charSequence).toString().equals(((Object)charSequence2).toString());
    }

    public final boolean matches(List<Tree> list, List<Tree> list2, int n) {
        return n <= 0 ? list.isEmpty() && list2.isEmpty() : (list.isEmpty() ? list2.isEmpty() : !list2.isEmpty() && this.matcher().matches((Tree)((Object)list), (Tree)((Object)list2)));
    }

    private final TreeMatcher matcher() {
        TreeMatcher treeMatcher = this.matcherObj;
        if (treeMatcher == null) {
            this.matcherObj = treeMatcher = new TreeMatcher(this.env);
        }
        return treeMatcher;
    }

    public static boolean isNull(Tree tree) {
        if (!(tree instanceof LiteralTree)) {
            return false;
        }
        return ((LiteralTree)tree).getValue() == null;
    }

    public static boolean isNullTree(Tree tree) {
        return tree == null;
    }

    public static boolean isTrue(Tree tree) {
        if (tree == null) {
            return false;
        }
        switch (tree.getKind()) {
            case IDENTIFIER: {
                Name name = ((IdentifierTree)tree).getName();
                return "true".contentEquals(name);
            }
            case BOOLEAN_LITERAL: {
                return ((LiteralTree)tree).getValue() == Boolean.TRUE;
            }
            case PARENTHESIZED: {
                return Query.isTrue(((ParenthesizedTree)tree).getExpression());
            }
        }
        return false;
    }

    public static boolean isFalse(Tree tree) {
        if (tree == null) {
            return false;
        }
        switch (tree.getKind()) {
            case IDENTIFIER: {
                Name name = ((IdentifierTree)tree).getName();
                return "false".contentEquals(name);
            }
            case BOOLEAN_LITERAL: {
                return ((LiteralTree)tree).getValue() == Boolean.FALSE;
            }
            case PARENTHESIZED: {
                return Query.isFalse(((ParenthesizedTree)tree).getExpression());
            }
        }
        return false;
    }

    public static boolean sideEffectFree(Tree tree) {
        if (tree == null) {
            return true;
        }
        if (tree instanceof LiteralTree || tree instanceof IdentifierTree) {
            return true;
        }
        if (tree instanceof BinaryTree) {
            BinaryTree binaryTree = (BinaryTree)tree;
            return Query.sideEffectFree(binaryTree.getLeftOperand()) && Query.sideEffectFree(binaryTree.getRightOperand());
        }
        Tree.Kind kind = tree.getKind();
        if (tree instanceof UnaryTree) {
            return (kind == Tree.Kind.PLUS || kind == Tree.Kind.MINUS || kind == Tree.Kind.LOGICAL_COMPLEMENT || kind == Tree.Kind.BITWISE_COMPLEMENT) && Query.sideEffectFree(((UnaryTree)tree).getExpression());
        }
        switch (kind) {
            default: {
                return false;
            }
            case PARENTHESIZED: {
                return Query.sideEffectFree(((ParenthesizedTree)tree).getExpression());
            }
            case MEMBER_SELECT: {
                return Query.sideEffectFree(((MemberSelectTree)tree).getExpression());
            }
            case TYPE_CAST: {
                return Query.sideEffectFree(((TypeCastTree)tree).getExpression());
            }
            case INSTANCE_OF: {
                return Query.sideEffectFree(((InstanceOfTree)tree).getExpression());
            }
            case ARRAY_ACCESS: {
                ArrayAccessTree arrayAccessTree = (ArrayAccessTree)tree;
                return Query.sideEffectFree(arrayAccessTree.getExpression()) && Query.sideEffectFree(arrayAccessTree.getIndex());
            }
            case CONDITIONAL_EXPRESSION: 
        }
        ConditionalExpressionTree conditionalExpressionTree = (ConditionalExpressionTree)tree;
        return Query.sideEffectFree(conditionalExpressionTree.getCondition()) && Query.sideEffectFree(conditionalExpressionTree.getTrueExpression()) && Query.sideEffectFree(conditionalExpressionTree.getFalseExpression());
    }

    public static boolean sideEffectFree(List<Tree> list) {
        for (Tree tree : list) {
            if (Query.sideEffectFree(tree)) continue;
            return false;
        }
        return true;
    }

    public Element getElement(Tree tree) {
        return this.model.getElement(tree);
    }

    public boolean alreadyDefinedIn(CharSequence charSequence, ExecutableType executableType, TypeElement typeElement) {
        return this.elements.alreadyDefinedIn(charSequence, executableType, typeElement);
    }

    public boolean isMemberOf(Element element, TypeElement typeElement) {
        return this.elements.isMemberOf(element, typeElement);
    }

    public boolean isDeprecated(Element element) {
        return this.env.getElements().isDeprecated(element);
    }

    public CharSequence getFullName(Element element) {
        return this.elements.getFullName(element);
    }

    public boolean couldThrow(Tree tree) {
        TreeScanner<Tree, Tree> treeScanner = new TreeScanner<Tree, Tree>(){

            @Override
            public Tree scan(Tree tree, Tree tree2) {
                return tree2 == null ? (Tree)super.scan(tree, tree2) : tree2;
            }

            @Override
            public Tree visitThrow(ThrowTree throwTree, Tree tree) {
                return throwTree;
            }

            @Override
            public Tree visitMethodInvocation(MethodInvocationTree methodInvocationTree, Tree tree) {
                if ((tree = (Tree)super.visitMethodInvocation(methodInvocationTree, tree)) == null) {
                    ExpressionTree expressionTree = methodInvocationTree.getMethodSelect();
                    ExecutableType executableType = (ExecutableType)Query.this.model.getType(expressionTree);
                    if (executableType == null) {
                        throw new QueryException("method not resolved: " + expressionTree);
                    }
                    if (!executableType.getThrownTypes().isEmpty()) {
                        tree = methodInvocationTree;
                    }
                }
                return tree;
            }
        };
        return treeScanner.scan(tree, null) != null;
    }

    public static boolean isEmpty(Tree tree) {
        if (tree == null) {
            return true;
        }
        switch (tree.getKind()) {
            default: {
                return false;
            }
            case BLOCK: {
                for (StatementTree statementTree : ((BlockTree)tree).getStatements()) {
                    if (Query.isEmpty(statementTree)) continue;
                    return false;
                }
                return true;
            }
            case EMPTY_STATEMENT: 
        }
        return true;
    }

    public boolean isClassIdentifier(Tree tree) {
        Element element;
        if (tree == null) {
            return false;
        }
        switch (tree.getKind()) {
            case IDENTIFIER: {
                element = this.model.getElement(tree);
                break;
            }
            case MEMBER_SELECT: {
                MemberSelectTree memberSelectTree = (MemberSelectTree)tree;
                if (!Query.sideEffectFree(memberSelectTree.getExpression())) {
                    return false;
                }
                element = this.model.getElement(tree);
                break;
            }
            default: {
                return false;
            }
        }
        return element instanceof TypeElement;
    }

    public TypeMirror getType(Tree tree) {
        return this.model.getType(tree);
    }

    public int getPos(Tree tree) {
        return this.model.getPos(tree);
    }

    public boolean isSynthetic(Tree tree) {
        return this.model.isSynthetic(tree);
    }

    public boolean hasVariableDeclarations(Tree tree) {
        if (tree instanceof VariableTree) {
            return true;
        }
        if (tree instanceof BlockTree) {
            for (StatementTree statementTree : ((BlockTree)tree).getStatements()) {
                if (statementTree == null || !(statementTree instanceof VariableTree)) continue;
                return true;
            }
        }
        return false;
    }

    public static boolean isStatement(Tree tree) {
        return tree instanceof StatementTree;
    }

    public boolean isStatic(Tree tree) {
        return this.model.isStatic(tree);
    }

    public int getInstanceReferenceCount(Tree tree) {
        return this.model.getInstanceReferenceCount(tree);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class AssignChecker
    extends TreeScanner<Void, Object> {
        String name;
        boolean assigned;

        private AssignChecker() {
        }

        public boolean assignedIn(CharSequence charSequence, Tree tree) {
            this.name = ((Object)charSequence).toString();
            this.assigned = false;
            this.scan(tree, (Object)null);
            return this.assigned;
        }

        @Override
        public Void scan(Tree tree, Object object) {
            if (!this.assigned) {
                super.scan(tree, object);
            }
            return null;
        }

        @Override
        public Void visitAssignment(AssignmentTree assignmentTree, Object object) {
            if (!this.checkTarget(assignmentTree.getVariable())) {
                super.visitAssignment(assignmentTree, object);
            }
            return null;
        }

        @Override
        public Void visitCompoundAssignment(CompoundAssignmentTree compoundAssignmentTree, Object object) {
            if (!this.checkTarget(compoundAssignmentTree.getVariable())) {
                super.visitCompoundAssignment(compoundAssignmentTree, object);
            }
            return null;
        }

        public boolean checkTarget(Tree tree) {
            if (tree instanceof IdentifierTree && ((IdentifierTree)tree).getName().toString().equals(this.name)) {
                this.assigned = true;
            }
            return this.assigned;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class DeclarationChecker
    extends TreeScanner<Void, Object> {
        String name;
        boolean declared;

        private DeclarationChecker() {
        }

        public boolean declaredIn(CharSequence charSequence, Tree tree) {
            this.name = ((Object)charSequence).toString();
            this.declared = false;
            this.scan(tree, (Object)null);
            return this.declared;
        }

        @Override
        public Void scan(Tree tree, Object object) {
            if (!this.declared) {
                super.scan(tree, object);
            }
            return null;
        }

        @Override
        public Void visitVariable(VariableTree variableTree, Object object) {
            if (!this.checkTarget(variableTree)) {
                super.visitVariable(variableTree, object);
            }
            return null;
        }

        public boolean checkTarget(VariableTree variableTree) {
            if (((Object)variableTree.getName()).equals(this.name)) {
                this.declared = true;
            }
            return this.declared;
        }
    }
}

