/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.api.java.source.query;

import com.sun.source.tree.Tree;
import javax.lang.model.element.Element;
import javax.lang.model.element.PackageElement;
import javax.lang.model.element.TypeElement;
import org.netbeans.api.java.source.query.Query;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SearchEntry
implements Comparable<SearchEntry> {
    public Query query;
    public Tree tree;
    private int pos;
    public Element sym;
    public String className;
    public String methName;
    public String symName;
    public String note;
    public int flags;

    public SearchEntry(Query query, Element element, Tree tree, int n) {
        this(query, element, tree, n, null);
    }

    public SearchEntry(Query query, Element element, Tree tree, int n, String string) {
        this(query, element, tree, n, string, 0);
    }

    public SearchEntry(Query query, Element element, Tree tree, int n, String string, int n2) {
        this.query = query;
        this.flags = n2;
        this.sym = element;
        this.tree = tree;
        this.pos = n;
        if (string != null && string.length() > 0) {
            this.note = string;
        }
        if (element == null) {
            this.className = "Unknown";
            this.methName = "Unknown";
        } else if (element instanceof TypeElement) {
            this.className = this.classSymbolName(this.sym);
        } else {
            while (element.getEnclosingElement() != null && !(element.getEnclosingElement() instanceof TypeElement)) {
                element = element.getEnclosingElement();
            }
            this.className = element.getEnclosingElement() == null ? "NULL PARENT" : this.classSymbolName(element);
            this.methName = element.getSimpleName().toString();
            if (element != this.sym) {
                this.symName = this.sym.getSimpleName().toString();
            }
        }
    }

    private String classSymbolName(Element element) {
        if (element == null || element instanceof PackageElement) {
            return "";
        }
        if (!(element instanceof TypeElement)) {
            return this.classSymbolName(element.getEnclosingElement());
        }
        String string = this.classSymbolName(element.getEnclosingElement());
        String string2 = element.getSimpleName().toString();
        if (string2.length() == 0) {
            string2 = ((Object)element.asType()).toString();
        }
        return string.length() > 0 ? string + '.' + string2 : string2;
    }

    @Override
    public int compareTo(SearchEntry searchEntry) {
        int n = this.className.compareTo(searchEntry.className);
        if (n == 0 && (this.methName == null || searchEntry.methName == null || (n = this.methName.compareTo(searchEntry.methName)) == 0) && this.tree != null) {
            n = this.pos - searchEntry.pos;
        }
        return n;
    }

    public String getSymName() {
        return this.symName == null ? "" : this.symName;
    }

    public String getNote() {
        return this.note == null ? "" : this.note;
    }

    public Element getElement() {
        return this.sym;
    }
}

