/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.api.java.source.query;

import com.sun.source.tree.AssignmentTree;
import com.sun.source.tree.CompoundAssignmentTree;
import com.sun.source.tree.ExpressionTree;
import com.sun.source.tree.IdentifierTree;
import com.sun.source.tree.MemberSelectTree;
import com.sun.source.tree.Tree;
import com.sun.source.tree.UnaryTree;
import com.sun.source.tree.VariableTree;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import javax.lang.model.element.Element;
import javax.lang.model.element.PackageElement;
import javax.lang.model.element.TypeElement;
import org.netbeans.api.java.source.query.NodeScanner;
import org.netbeans.api.java.source.query.QueryEnvironment;
import org.netbeans.api.java.source.query.SearchEntry;
import org.netbeans.api.java.source.query.SearchResult;
import org.netbeans.api.java.source.query.UseFinder;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SetUseFinder
extends NodeScanner<Void, Object> {
    private Map<Element, SearchInfo> target;

    public SetUseFinder(QueryEnvironment queryEnvironment) {
        this.attach(queryEnvironment);
    }

    private void findInfo(SearchResult searchResult, Tree tree, boolean bl) {
        if (searchResult == null) {
            return;
        }
        this.target = new HashMap<Element, SearchInfo>();
        Iterator<SearchEntry> iterator = searchResult.iterator();
        while (iterator.hasNext()) {
            Element element = iterator.next().sym;
            if (element == null) continue;
            this.target.put(element, new SearchInfo(this.env, element, bl));
        }
        if (tree != null) {
            tree.accept(this, null);
        }
    }

    public Map<Element, SearchResult> findAll(SearchResult searchResult, Tree tree) {
        if (searchResult == null) {
            return null;
        }
        this.findInfo(searchResult, tree, false);
        HashMap<Element, SearchResult> hashMap = new HashMap<Element, SearchResult>();
        for (SearchInfo searchInfo : this.target.values()) {
            hashMap.put(searchInfo.target, searchInfo.results);
        }
        return hashMap;
    }

    protected boolean acceptable(Element element, int n) {
        return true;
    }

    public void computeSummary(SearchResult searchResult, Tree tree) {
        if (searchResult == null) {
            return;
        }
        this.findInfo(searchResult, tree, true);
        Iterator<SearchEntry> iterator = searchResult.iterator();
        while (iterator.hasNext()) {
            SearchEntry searchEntry = iterator.next();
            Element element = searchEntry.sym;
            if (element == null) {
                iterator.remove();
                continue;
            }
            SearchInfo searchInfo = this.target.get(element);
            if (searchInfo != null && this.acceptable(element, searchInfo.flags)) {
                searchEntry.flags = searchInfo.flags;
                searchEntry.note = UseFinder.getMsg(searchInfo.flags);
                continue;
            }
            iterator.remove();
        }
    }

    private void add(Tree tree, SearchInfo searchInfo, int n) {
        Element element = this.currentSym;
        if (element == null) {
            if (searchInfo.results != null) {
                searchInfo.results.add(new SearchEntry(null, null, tree, this.model.getPos(tree), "No currentSym", 0));
            }
            return;
        }
        TypeElement typeElement = this.env.getElementUtilities().enclosingTypeElement(this.currentSym);
        PackageElement packageElement = this.env.getElementUtilities().packageElement(typeElement);
        int n2 = n << (typeElement == searchInfo.homeClass ? 4 : (packageElement == searchInfo.homePackage ? 2 : 0));
        searchInfo.flags |= n2;
        if (searchInfo.results != null) {
            searchInfo.results.add(new SearchEntry(null, element, tree, this.model.getPos(tree), UseFinder.getMsg(n2), n2));
        }
    }

    @Override
    public Void visitAssignment(AssignmentTree assignmentTree, Object object) {
        ExpressionTree expressionTree = assignmentTree.getVariable();
        ExpressionTree expressionTree2 = assignmentTree.getExpression();
        if (expressionTree instanceof MemberSelectTree) {
            MemberSelectTree memberSelectTree = (MemberSelectTree)expressionTree;
            this.scan(memberSelectTree.getExpression(), null);
            SearchInfo searchInfo = this.target.get(this.model.getElement(memberSelectTree));
            if (searchInfo != null) {
                this.add(assignmentTree, searchInfo, 1);
            }
        } else if (expressionTree instanceof IdentifierTree) {
            SearchInfo searchInfo = this.target.get(this.model.getElement(expressionTree));
            if (searchInfo != null) {
                this.add(assignmentTree, searchInfo, 1);
            }
        } else {
            this.scan(expressionTree, object);
        }
        this.scan(expressionTree2, object);
        return null;
    }

    @Override
    public Void visitCompoundAssignment(CompoundAssignmentTree compoundAssignmentTree, Object object) {
        ExpressionTree expressionTree = compoundAssignmentTree.getVariable();
        ExpressionTree expressionTree2 = compoundAssignmentTree.getExpression();
        if (expressionTree instanceof MemberSelectTree) {
            MemberSelectTree memberSelectTree = (MemberSelectTree)expressionTree;
            this.scan(memberSelectTree.getExpression(), null);
            SearchInfo searchInfo = this.target.get(this.model.getElement(memberSelectTree));
            if (searchInfo != null) {
                this.add(compoundAssignmentTree, searchInfo, 3);
            }
        } else if (expressionTree instanceof IdentifierTree) {
            SearchInfo searchInfo = this.target.get(this.model.getElement(expressionTree));
            if (searchInfo != null) {
                this.add(compoundAssignmentTree, searchInfo, 3);
            }
        } else {
            this.scan(expressionTree, object);
        }
        this.scan(expressionTree2, object);
        return null;
    }

    @Override
    public Void visitUnary(UnaryTree unaryTree, Object object) {
        switch (unaryTree.getKind()) {
            case PREFIX_INCREMENT: 
            case PREFIX_DECREMENT: 
            case POSTFIX_INCREMENT: 
            case POSTFIX_DECREMENT: {
                if (unaryTree.getExpression() instanceof MemberSelectTree) {
                    MemberSelectTree memberSelectTree = (MemberSelectTree)unaryTree.getExpression();
                    this.scan(memberSelectTree.getExpression(), object);
                    SearchInfo searchInfo = this.target.get(this.model.getElement(unaryTree));
                    if (searchInfo == null) break;
                    this.add(unaryTree, searchInfo, 3);
                    break;
                }
                if (unaryTree.getExpression() instanceof IdentifierTree) {
                    SearchInfo searchInfo = this.target.get(this.model.getElement(unaryTree.getExpression()));
                    if (searchInfo == null) break;
                    this.add(unaryTree, searchInfo, 3);
                    break;
                }
                this.scan(unaryTree.getExpression(), object);
                break;
            }
            default: {
                this.scan(unaryTree.getExpression(), object);
            }
        }
        return null;
    }

    @Override
    public Void visitIdentifier(IdentifierTree identifierTree, Object object) {
        super.visitIdentifier(identifierTree, object);
        SearchInfo searchInfo = this.target.get(this.model.getElement(identifierTree));
        if (searchInfo != null) {
            this.add(identifierTree, searchInfo, 2);
        }
        return null;
    }

    @Override
    public Void visitVariable(VariableTree variableTree, Object object) {
        this.scan(variableTree.getInitializer(), object);
        SearchInfo searchInfo = this.target.get(this.model.getElement(variableTree));
        if (searchInfo != null) {
            int n = 64;
            if (variableTree.getInitializer() != null) {
                n |= 0x10;
            }
            searchInfo.flags |= n;
            if (searchInfo.results != null) {
                searchInfo.results.add(new SearchEntry(null, this.currentSym, variableTree, this.model.getPos(variableTree), UseFinder.getMsg(n), n));
            }
        }
        return null;
    }

    @Override
    public Void visitMemberSelect(MemberSelectTree memberSelectTree, Object object) {
        super.visitMemberSelect(memberSelectTree, object);
        SearchInfo searchInfo = this.target.get(this.model.getElement(memberSelectTree));
        if (searchInfo != null) {
            this.add(memberSelectTree, searchInfo, 2);
        }
        return null;
    }

    private static class SearchInfo {
        Element target;
        SearchResult results;
        PackageElement homePackage;
        TypeElement homeClass;
        int flags;

        SearchInfo(QueryEnvironment queryEnvironment, Element element, boolean bl) {
            this.target = element;
            this.homePackage = queryEnvironment.getElementUtilities().packageElement(element);
            this.homeClass = queryEnvironment.getElementUtilities().enclosingTypeElement(element);
            if (!bl) {
                this.results = new SearchResult(null, "Uses of " + element);
                this.results.attach(queryEnvironment);
            }
        }
    }
}

