/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.api.java.source.support;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.swing.JEditorPane;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.text.JTextComponent;
import org.netbeans.editor.Registry;
import org.openide.filesystems.FileObject;
import org.openide.loaders.DataObject;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class OpenedEditors
implements ChangeListener,
PropertyChangeListener {
    private List<JTextComponent> visibleEditors = new ArrayList<JTextComponent>();
    private Map<JTextComponent, FileObject> visibleEditors2Files = new HashMap<JTextComponent, FileObject>();
    private List<ChangeListener> listeners = new ArrayList<ChangeListener>();
    private static OpenedEditors DEFAULT;

    private OpenedEditors() {
        Registry.addChangeListener((ChangeListener)this);
    }

    public static synchronized OpenedEditors getDefault() {
        if (DEFAULT == null) {
            DEFAULT = new OpenedEditors();
        }
        return DEFAULT;
    }

    public synchronized void addChangeListener(ChangeListener changeListener) {
        this.listeners.add(changeListener);
    }

    public synchronized void removeChangeListener(ChangeListener changeListener) {
        this.listeners.remove(changeListener);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void fireChangeEvent() {
        ChangeEvent changeEvent = new ChangeEvent(this);
        ArrayList<ChangeListener> arrayList = null;
        OpenedEditors openedEditors = this;
        synchronized (openedEditors) {
            arrayList = new ArrayList<ChangeListener>(this.listeners);
        }
        for (ChangeListener changeListener : arrayList) {
            changeListener.stateChanged(changeEvent);
        }
    }

    public synchronized List<JTextComponent> getVisibleEditors() {
        return Collections.unmodifiableList(this.visibleEditors);
    }

    public synchronized Collection<FileObject> getVisibleEditorsFiles() {
        return Collections.unmodifiableCollection(this.visibleEditors2Files.values());
    }

    @Override
    public synchronized void stateChanged(ChangeEvent changeEvent) {
        for (JTextComponent object : this.visibleEditors) {
            object.removePropertyChangeListener(this);
            this.visibleEditors2Files.remove(object);
        }
        this.visibleEditors.clear();
        JTextComponent jTextComponent = Registry.getMostActiveComponent();
        if (jTextComponent instanceof JEditorPane && "text/x-java".equals(((JEditorPane)jTextComponent).getContentType())) {
            this.visibleEditors.add(jTextComponent);
        }
        for (JTextComponent jTextComponent2 : this.visibleEditors) {
            jTextComponent2.addPropertyChangeListener(this);
            this.visibleEditors2Files.put(jTextComponent2, OpenedEditors.getFileObject(jTextComponent2));
        }
        this.fireChangeEvent();
    }

    @Override
    public synchronized void propertyChange(PropertyChangeEvent propertyChangeEvent) {
        FileObject fileObject;
        JTextComponent jTextComponent = (JTextComponent)propertyChangeEvent.getSource();
        FileObject fileObject2 = this.visibleEditors2Files.get(jTextComponent);
        if (fileObject2 != (fileObject = OpenedEditors.getFileObject(jTextComponent))) {
            this.visibleEditors2Files.put(jTextComponent, fileObject);
            this.fireChangeEvent();
        }
    }

    static FileObject getFileObject(JTextComponent jTextComponent) {
        DataObject dataObject = (DataObject)jTextComponent.getDocument().getProperty("stream");
        if (dataObject != null) {
            return dataObject.getPrimaryFile();
        }
        return null;
    }
}

