/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.api.java.source.transform;

import com.sun.source.tree.CompilationUnitTree;
import com.sun.source.tree.Tree;
import java.io.IOException;
import javax.lang.model.element.Element;
import org.netbeans.api.java.source.query.QueryException;
import org.netbeans.api.java.source.query.QueryResult;
import org.netbeans.api.java.source.query.SearchEntry;
import org.netbeans.api.java.source.query.SearchResult;
import org.netbeans.api.java.source.query.SourceSelection;
import org.netbeans.api.java.source.transform.Change;
import org.netbeans.api.java.source.transform.ChangeSet;
import org.netbeans.api.java.source.transform.Transformer;
import org.netbeans.api.java.source.transform.TransformerResult;
import org.netbeans.api.java.source.transform.UndoList;
import org.netbeans.modules.java.source.engine.DefaultSourceSelection;

public class TransformResult
extends SearchResult {
    ChangeSet changeSet;

    public TransformResult(Transformer transformer, String string, ChangeSet changeSet) {
        super(transformer, string);
        this.changeSet = changeSet;
    }

    public QueryResult getResult(int n) {
        SearchEntry searchEntry = this.getResults()[n];
        if (this.changeSet.hasOriginal(searchEntry.tree)) {
            return new TransformerResultImpl(searchEntry);
        }
        return super.getResult(n);
    }

    public ChangeSet getChangeSet() {
        return this.changeSet;
    }

    protected SourceSelection makeSelection(Element element, Tree tree, Tree tree2, final boolean bl) {
        final CompilationUnitTree compilationUnitTree = this.getTopLevel(element, tree, tree2);
        int n = this.model.getStartPos(tree);
        int n2 = this.model.getEndPos(tree, compilationUnitTree);
        String string = compilationUnitTree.getSourceFile().toUri().getPath();
        return new DefaultSourceSelection(element, n, this.model.getPos(tree), n2, string){

            public String getSource() {
                return bl ? TransformResult.this.fromSource(compilationUnitTree) : TransformResult.this.toSource(compilationUnitTree);
            }
        };
    }

    protected CompilationUnitTree getTopLevel(Element element, Tree tree, Tree tree2) {
        CompilationUnitTree compilationUnitTree = super.getTopLevel(element, tree, tree2);
        if (compilationUnitTree == null) {
            tree = this.env.getTrees().getTree(this.env.getElementUtilities().outermostTypeElement(element));
            compilationUnitTree = super.getTopLevel(element, tree, tree2);
        }
        return compilationUnitTree;
    }

    protected String toSource(CompilationUnitTree compilationUnitTree) {
        try {
            return this.env.toSource(compilationUnitTree);
        }
        catch (IOException iOException) {
            throw new QueryException(iOException);
        }
    }

    private class TransformerResultImpl
    implements TransformerResult {
        private SearchEntry se;

        TransformerResultImpl(SearchEntry searchEntry) {
            this.se = searchEntry;
        }

        public SourceSelection getSourceSelection() {
            Tree tree = TransformResult.this.env.getRootNode();
            return TransformResult.this.makeSelection(this.se.sym, this.se.tree, tree, false);
        }

        public String getNote() {
            return this.se.getNote();
        }

        public SourceSelection getOriginalSourceSelection() {
            UndoList undoList = TransformResult.this.env.getUndoList();
            Tree tree = TransformResult.this.env.getRootNode();
            Tree tree2 = undoList.getOld(tree);
            assert (tree2 != null);
            Tree tree3 = this.se.tree;
            Tree tree4 = TransformResult.this.changeSet.hasOriginal(tree3) ? TransformResult.this.changeSet.getOriginal(tree3) : tree3;
            return TransformResult.this.makeSelection(this.se.sym, tree4, tree2, true);
        }

        public boolean equals(Object object) {
            if (this == object) {
                return true;
            }
            return object instanceof TransformerResultImpl ? this.se.equals(((TransformerResultImpl)object).se) : false;
        }

        public int hashCode() {
            return this.se.hashCode();
        }

        public Change getChanges() {
            assert (this.se.tree != null);
            return TransformResult.this.changeSet.getResultChanges(this.se);
        }

        public String getRefactoringDescription() {
            return ((Transformer)this.se.query).getRefactoringDescription();
        }

        public String getQueryDescription() {
            return this.se.query.getQueryDescription();
        }
    }
}

