/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.api.java.source.transform;

import com.sun.source.tree.AnnotationTree;
import com.sun.source.tree.BinaryTree;
import com.sun.source.tree.BlockTree;
import com.sun.source.tree.ConditionalExpressionTree;
import com.sun.source.tree.ExpressionStatementTree;
import com.sun.source.tree.ExpressionTree;
import com.sun.source.tree.IdentifierTree;
import com.sun.source.tree.LiteralTree;
import com.sun.source.tree.MemberSelectTree;
import com.sun.source.tree.ModifiersTree;
import com.sun.source.tree.ParenthesizedTree;
import com.sun.source.tree.StatementTree;
import com.sun.source.tree.Tree;
import com.sun.source.tree.TreeVisitor;
import com.sun.source.tree.UnaryTree;
import com.sun.source.tree.VariableTree;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.EnumMap;
import java.util.List;
import java.util.Map;
import java.util.logging.Logger;
import javax.lang.model.element.Element;
import javax.lang.model.type.DeclaredType;
import javax.lang.model.type.TypeMirror;
import org.netbeans.api.java.source.Comment;
import org.netbeans.api.java.source.query.CommentHandler;
import org.netbeans.api.java.source.query.Query;
import org.netbeans.api.java.source.query.QueryEnvironment;
import org.netbeans.api.java.source.query.SearchEntry;
import org.netbeans.api.java.source.transform.ChangeSet;
import org.netbeans.api.java.source.transform.TransformResult;
import org.netbeans.modules.java.source.engine.ASTModel;
import org.netbeans.modules.java.source.engine.EngineEnvironment;
import org.netbeans.modules.java.source.engine.ReattributionException;
import org.netbeans.modules.java.source.engine.RootTree;
import org.netbeans.modules.java.source.engine.TreeMakerInt;
import org.openide.util.NbBundle;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class Transformer<R, P>
extends Query<R, P> {
    protected ASTModel model;
    public TreeMakerInt make;
    protected ChangeSet changes;
    protected String refactoringDescription;
    private String failureMessage;
    static final Logger logger = Logger.getLogger("org.netbeans.modules.java.source");
    private static final int COPY_REST = 99999;
    private static Map<Tree.Kind, Tree.Kind> relInvert = new EnumMap<Tree.Kind, Tree.Kind>(Tree.Kind.class);

    @Override
    public void init() {
        this.changes = new ChangeSet(this.getQueryDescription());
        this.result = new TransformResult(this, this.getRefactoringDescription(), this.changes);
    }

    @Override
    public void attach(QueryEnvironment queryEnvironment) {
        this.model = ((EngineEnvironment)queryEnvironment).getModel();
        this.make = queryEnvironment.getTreeMaker();
        this.changes.attach(queryEnvironment);
        this.result.attach(queryEnvironment);
        super.attach(queryEnvironment);
    }

    @Override
    public void release() {
        super.release();
        this.make = null;
        this.types = null;
    }

    @Override
    public void destroy() {
        super.destroy();
        this.changes = null;
        this.result = null;
    }

    public String getRefactoringDescription() {
        return this.refactoringDescription != null ? this.refactoringDescription : "Unnamed Refactoring";
    }

    public void setRefactoringDescription(String string) {
        this.refactoringDescription = string;
    }

    @Override
    public void apply(Tree tree) {
        try {
            tree.accept(this.getTranslator(), null);
            RootTree rootTree = this.commit((RootTree)this.model.getRoot());
            if (!this.translationSuccessful()) {
                this.result.clear();
                String string = this.queryDescription != null ? this.queryDescription : this.getString("Transformer.failure");
                this.env.setErrorMessage(this.failureMessage, string);
            } else if (this.changes.hasChanges()) {
                this.model.setRoot(rootTree);
            }
        }
        catch (ReattributionException reattributionException) {
            this.error(reattributionException);
        }
    }

    String getString(String string) {
        return NbBundle.getBundle(Transformer.class).getString(string);
    }

    protected TransformResult makePreviewResult() {
        TransformResult transformResult = new TransformResult(this, this.queryDescription, this.changes);
        for (SearchEntry searchEntry : this.result.getResults()) {
            if (!this.changes.hasOriginal(searchEntry.tree)) continue;
            transformResult.add(searchEntry);
        }
        return transformResult;
    }

    protected TreeVisitor getTranslator() {
        return this;
    }

    public ChangeSet getChanges() {
        return this.changes;
    }

    public void setChanges(ChangeSet changeSet) {
        this.changes = changeSet;
    }

    public RootTree commit(RootTree rootTree) {
        return this.changes.commit(rootTree);
    }

    public final void addResult(Tree tree) {
        this.addResult(tree, null);
    }

    public final void addResult(Tree tree, String string) {
        if (tree != null) {
            Element element = this.getCurrentElement();
            this.lastAddition = new SearchEntry(this, element, tree, this.model.getPos(tree), string, 0);
            this.result.add(this.lastAddition);
        }
    }

    protected void translationFailure(String string) {
        logger.severe(string);
        this.failureMessage = this.failureMessage != null ? this.failureMessage + "\n" + string : string;
    }

    protected String getFailureMessage() {
        return this.failureMessage;
    }

    protected boolean translationSuccessful() {
        return this.failureMessage == null;
    }

    public IdentifierTree ident(Element element) {
        IdentifierTree identifierTree = this.make.Identifier(element.getSimpleName());
        this.model.setElement(identifierTree, element);
        this.model.setType(identifierTree, element.asType());
        return identifierTree;
    }

    public MemberSelectTree select(ExpressionTree expressionTree, Element element) {
        MemberSelectTree memberSelectTree = this.make.MemberSelect(expressionTree, element.getSimpleName());
        this.model.setElement(memberSelectTree, element);
        this.model.setType(memberSelectTree, element.asType());
        return memberSelectTree;
    }

    public ExpressionTree rwSymbol(Tree tree, Element element) {
        if (tree instanceof IdentifierTree) {
            return this.ident(element);
        }
        if (tree instanceof MemberSelectTree) {
            return this.select(((MemberSelectTree)tree).getExpression(), element);
        }
        this.error("Var ref expected " + tree);
        return this.ident(element);
    }

    public static <T extends Tree> List<T> sublist(List<T> list, int n, int n2) {
        if (list.isEmpty()) {
            return list;
        }
        if (n2 == 0 || n >= list.size()) {
            return Collections.emptyList();
        }
        int n3 = Math.min(n + n2, list.size());
        return list.subList(n, n3);
    }

    public StatementTree sublist(StatementTree statementTree, int n) {
        return this.sublist(statementTree, n, 99999);
    }

    public StatementTree sublist(StatementTree statementTree, int n, int n2) {
        StatementTree statementTree2;
        if (statementTree == null || n2 <= 1 || !(statementTree instanceof BlockTree)) {
            statementTree2 = n2 <= 0 ? null : this.getStatement(n, statementTree);
        } else {
            BlockTree blockTree = (BlockTree)statementTree;
            List<? extends StatementTree> list = blockTree.getStatements();
            List<? extends StatementTree> list2 = Transformer.sublist(list, n, n2);
            StatementTree statementTree3 = statementTree2 = list2 == list ? statementTree : this.make.Block(list2, false);
        }
        if (n == 0) {
            this.copyCommentTo(statementTree, statementTree2);
        }
        return statementTree2;
    }

    public final void attach(Tree tree, Comment comment) {
        this.env.getCommentHandler().addComment(tree, comment);
    }

    public final void attach(Tree tree, String string) {
        if (tree != null && string != null) {
            this.env.getCommentHandler().addComment(tree, Comment.create(string));
        }
    }

    public final void copyCommentTo(Tree tree, Tree tree2, Tree tree3) {
        this.copyCommentTo(tree, tree3);
        if (tree != tree2) {
            this.copyCommentTo(tree2, tree3);
        }
    }

    public final void copyCommentTo(Tree tree, Tree tree2) {
        if (tree != null && tree2 != null) {
            CommentHandler commentHandler = this.env.getCommentHandler();
            commentHandler.copyComments(tree, tree2);
        }
    }

    public ExpressionTree Conditional(ExpressionTree expressionTree, ExpressionStatementTree expressionStatementTree, ExpressionStatementTree expressionStatementTree2) {
        if (Transformer.isTrue(expressionTree)) {
            return expressionStatementTree.getExpression();
        }
        if (Transformer.isFalse(expressionTree)) {
            return expressionStatementTree2.getExpression();
        }
        return this.make.ConditionalExpression(expressionTree, expressionStatementTree.getExpression(), expressionStatementTree2.getExpression());
    }

    public StatementTree If(ExpressionTree expressionTree, StatementTree statementTree, StatementTree statementTree2) {
        if (Transformer.isEmpty(statementTree)) {
            if (Transformer.isEmpty(statementTree2)) {
                if (Transformer.sideEffectFree(expressionTree)) {
                    return this.make.EmptyStatement();
                }
                if (statementTree == null) {
                    statementTree = this.make.EmptyStatement();
                }
            } else {
                expressionTree = this.not(expressionTree);
                statementTree = statementTree2;
                statementTree2 = null;
            }
        }
        if (Transformer.isTrue(expressionTree)) {
            return statementTree;
        }
        if (Transformer.isFalse(expressionTree)) {
            return statementTree2;
        }
        return this.make.If(expressionTree, statementTree, statementTree2);
    }

    public StatementTree If(ExpressionTree expressionTree, StatementTree statementTree) {
        return this.If(expressionTree, statementTree, null);
    }

    public StatementTree statement(Tree tree) {
        if (tree == null) {
            return null;
        }
        if (tree instanceof ConditionalExpressionTree) {
            ConditionalExpressionTree conditionalExpressionTree = (ConditionalExpressionTree)tree;
            tree = this.If(conditionalExpressionTree.getCondition(), this.statement(conditionalExpressionTree.getTrueExpression()), this.statement(conditionalExpressionTree.getFalseExpression()));
        } else if (tree instanceof ExpressionTree) {
            tree = this.make.ExpressionStatement((ExpressionTree)tree);
        }
        return (StatementTree)tree;
    }

    public StatementTree block(StatementTree statementTree, StatementTree statementTree2) {
        statementTree = this.statement(statementTree);
        statementTree2 = this.statement(statementTree2);
        if (Transformer.isEmpty(statementTree)) {
            return statementTree2;
        }
        if (Transformer.isEmpty(statementTree2)) {
            return statementTree;
        }
        List<StatementTree> list = new ArrayList<StatementTree>();
        if (statementTree instanceof BlockTree) {
            list.addAll(((BlockTree)statementTree).getStatements());
            if (statementTree2 instanceof BlockTree) {
                list.addAll(((BlockTree)statementTree2).getStatements());
            } else {
                list.add(statementTree2);
            }
        } else {
            list.add(statementTree);
            if (statementTree2 instanceof BlockTree) {
                list.addAll(((BlockTree)statementTree2).getStatements());
            } else {
                list.add(statementTree2);
            }
        }
        list = this.chopUnreachable(list);
        return this.make.Block(list, false);
    }

    public BlockTree block(List<StatementTree> list, boolean bl) {
        return this.make.Block(this.flatten(list), bl);
    }

    private List<StatementTree> flatten(List<StatementTree> list) {
        if (list == null || list.isEmpty()) {
            return Collections.emptyList();
        }
        ArrayList<StatementTree> arrayList = new ArrayList<StatementTree>();
        for (StatementTree statementTree : list) {
            if (Transformer.isEmpty(statementTree)) continue;
            if (statementTree instanceof BlockTree) {
                List<StatementTree> list2 = Transformer.convert(StatementTree.class, ((BlockTree)statementTree).getStatements());
                list2 = this.flatten(list2);
                boolean bl = false;
                for (StatementTree statementTree2 : list2) {
                    if (!(statementTree2 instanceof VariableTree)) continue;
                    bl = true;
                    break;
                }
                if (bl) {
                    arrayList.add(statementTree);
                    continue;
                }
                arrayList.addAll(list2);
                continue;
            }
            arrayList.add(statementTree);
        }
        return arrayList;
    }

    private static <T> List<T> convert(Class<T> clazz, List<?> list) {
        if (list == null) {
            return null;
        }
        for (Object obj : list) {
            clazz.cast(obj);
        }
        return list;
    }

    public BlockTree block(StatementTree statementTree) {
        if (statementTree instanceof BlockTree) {
            return (BlockTree)statementTree;
        }
        if (statementTree == null) {
            return null;
        }
        return this.make.Block(Arrays.asList(this.statement(statementTree)), false);
    }

    public int blockLength(Tree tree) {
        if (tree == null) {
            return 0;
        }
        if (!(tree instanceof BlockTree)) {
            return 1;
        }
        return ((BlockTree)tree).getStatements().size();
    }

    public StatementTree getStatement(int n, StatementTree statementTree) {
        if (statementTree != null) {
            if (statementTree instanceof BlockTree) {
                List<? extends StatementTree> list = ((BlockTree)statementTree).getStatements();
                return n < list.size() ? list.get(n) : null;
            }
            return n != 0 ? null : statementTree;
        }
        return null;
    }

    public StatementTree lastStatement(StatementTree statementTree) {
        if (statementTree instanceof BlockTree) {
            List<? extends StatementTree> list = ((BlockTree)statementTree).getStatements();
            int n = list.size();
            return n > 0 ? list.get(n - 1) : statementTree;
        }
        return statementTree;
    }

    public <T extends Tree> List<T> chopUnreachable(List<T> list) {
        ArrayList<Tree> arrayList = new ArrayList<Tree>();
        boolean bl = false;
        for (Tree tree : list) {
            switch (tree.getKind()) {
                case BREAK: 
                case CONTINUE: 
                case THROW: 
                case RETURN: {
                    bl = true;
                    break;
                }
                default: {
                    if (!bl) break;
                    return arrayList;
                }
            }
            arrayList.add(tree);
        }
        return list;
    }

    public ExpressionTree and(ExpressionTree expressionTree, ExpressionTree expressionTree2) {
        Object object = this.eval(expressionTree);
        if (object == Boolean.TRUE) {
            return expressionTree2;
        }
        if (object == Boolean.FALSE) {
            return expressionTree;
        }
        Object object2 = this.eval(expressionTree2);
        if (object2 == Boolean.TRUE) {
            return expressionTree;
        }
        if (object2 == Boolean.FALSE && Transformer.sideEffectFree(expressionTree)) {
            return expressionTree2;
        }
        return this.make.Binary(Tree.Kind.CONDITIONAL_AND, expressionTree, expressionTree2);
    }

    public ExpressionTree or(ExpressionTree expressionTree, ExpressionTree expressionTree2) {
        Object object = this.eval(expressionTree);
        if (object == Boolean.TRUE) {
            return expressionTree;
        }
        if (object == Boolean.FALSE) {
            return expressionTree2;
        }
        Object object2 = this.eval(expressionTree2);
        if (object2 == Boolean.TRUE && Transformer.sideEffectFree(expressionTree)) {
            return expressionTree2;
        }
        if (object2 == Boolean.FALSE) {
            return expressionTree;
        }
        return this.make.Binary(Tree.Kind.CONDITIONAL_OR, expressionTree, expressionTree2);
    }

    public ExpressionTree not(ExpressionTree expressionTree) {
        Object object;
        if (expressionTree == null) {
            return null;
        }
        if (expressionTree instanceof LiteralTree && (object = ((LiteralTree)expressionTree).getValue()) instanceof Boolean) {
            return this.make.Literal((boolean)((Boolean)object));
        }
        object = expressionTree.getKind();
        if (object == Tree.Kind.LOGICAL_COMPLEMENT) {
            return ((UnaryTree)expressionTree).getExpression();
        }
        Tree.Kind kind = relInvert.get(object);
        if (kind != null) {
            BinaryTree binaryTree = (BinaryTree)expressionTree;
            return this.make.Binary(kind, this.not(binaryTree.getLeftOperand()), this.not(binaryTree.getRightOperand()));
        }
        return this.make.Unary(Tree.Kind.LOGICAL_COMPLEMENT, expressionTree);
    }

    public Object eval(ExpressionTree expressionTree) {
        if (expressionTree == null) {
            return expressionTree;
        }
        expressionTree = (ExpressionTree)Transformer.deblock(expressionTree);
        try {
            if (expressionTree instanceof BinaryTree) {
                BinaryTree binaryTree = (BinaryTree)expressionTree;
                Object object = this.eval(binaryTree.getLeftOperand());
                if (object == null) {
                    return null;
                }
                switch (binaryTree.getKind()) {
                    case OR: {
                        if (object != Boolean.TRUE) break;
                        return object;
                    }
                    case AND: {
                        if (object != Boolean.FALSE) break;
                        return object;
                    }
                }
                Object object2 = this.eval(binaryTree.getRightOperand());
                if (object2 == null) {
                    return null;
                }
                switch (binaryTree.getKind()) {
                    case CONDITIONAL_OR: {
                        return object2;
                    }
                    case CONDITIONAL_AND: {
                        return object2;
                    }
                    case EQUAL_TO: {
                        return this.compare(object, object2) == 0;
                    }
                    case NOT_EQUAL_TO: {
                        return this.compare(object, object2) != 0;
                    }
                    case LESS_THAN: {
                        return this.compare(object, object2) < 0;
                    }
                    case LESS_THAN_EQUAL: {
                        return this.compare(object, object2) <= 0;
                    }
                    case GREATER_THAN: {
                        return this.compare(object, object2) > 0;
                    }
                    case GREATER_THAN_EQUAL: {
                        return this.compare(object, object2) >= 0;
                    }
                }
                if (object instanceof Integer && object2 instanceof Integer) {
                    int n;
                    int n2 = (Integer)object;
                    int n3 = (Integer)object2;
                    switch (binaryTree.getKind()) {
                        default: {
                            return null;
                        }
                        case OR: {
                            n = n2 | n3;
                            break;
                        }
                        case AND: {
                            n = n2 & n3;
                            break;
                        }
                        case XOR: {
                            n = n2 ^ n3;
                            break;
                        }
                        case LEFT_SHIFT: {
                            n = n2 << n3;
                            break;
                        }
                        case RIGHT_SHIFT: {
                            n = n2 >> n3;
                            break;
                        }
                        case UNSIGNED_RIGHT_SHIFT: {
                            n = n2 >>> n3;
                            break;
                        }
                        case PLUS: {
                            n = n2 + n3;
                            break;
                        }
                        case MINUS: {
                            n = n2 - n3;
                            break;
                        }
                        case MULTIPLY: {
                            n = n2 * n3;
                            break;
                        }
                        case DIVIDE: {
                            n = n2 / n3;
                            break;
                        }
                        case REMAINDER: {
                            n = n2 % n3;
                        }
                    }
                    return new Integer(n);
                }
            } else if (expressionTree instanceof UnaryTree) {
                Object object = this.eval(((UnaryTree)expressionTree).getExpression());
                if (object instanceof Integer) {
                    int n;
                    int n4 = (Integer)object;
                    switch (expressionTree.getKind()) {
                        case UNARY_PLUS: {
                            return object;
                        }
                        case UNARY_MINUS: {
                            n = -n4;
                            break;
                        }
                        case LOGICAL_COMPLEMENT: 
                        case BITWISE_COMPLEMENT: {
                            n = ~n4;
                            break;
                        }
                        default: {
                            return null;
                        }
                    }
                    return new Integer(n);
                }
                if (object instanceof Float) {
                    float f;
                    float f2 = ((Float)object).floatValue();
                    switch (expressionTree.getKind()) {
                        case UNARY_PLUS: {
                            return object;
                        }
                        case UNARY_MINUS: {
                            f = -f2;
                            break;
                        }
                        default: {
                            return null;
                        }
                    }
                    return new Float(f);
                }
                if (object instanceof Double) {
                    double d;
                    double d2 = (Double)object;
                    switch (expressionTree.getKind()) {
                        case UNARY_PLUS: {
                            return object;
                        }
                        case UNARY_MINUS: {
                            d = -d2;
                            break;
                        }
                        default: {
                            return null;
                        }
                    }
                    return new Double(d);
                }
            } else if (expressionTree instanceof LiteralTree) {
                return ((LiteralTree)expressionTree).getValue();
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        return null;
    }

    public int compare(Object object, Object object2) {
        if (object == object2) {
            return 0;
        }
        if (object == null) {
            return -1;
        }
        if (object2 == null) {
            return 1;
        }
        try {
            long l;
            if (object.getClass() == object2.getClass()) {
                return ((Comparable)object).compareTo(object2);
            }
            if (object instanceof Double || object2 instanceof Double || object instanceof Float || object2 instanceof Float) {
                double d;
                double d2 = ((Number)object).doubleValue();
                return d2 < (d = ((Number)object2).doubleValue()) ? -1 : (d2 > d ? 1 : 0);
            }
            long l2 = (Long)object;
            return l2 < (l = ((Long)object2).longValue()) ? -1 : (l2 > l ? 1 : 0);
        }
        catch (Throwable throwable) {
            return -2;
        }
    }

    protected ModifiersTree addAnnotation(ModifiersTree modifiersTree, DeclaredType declaredType) {
        Element element = declaredType.asElement();
        AnnotationTree annotationTree = this.make.Annotation(this.make.QualIdent(element), new ArrayList());
        this.model.setType(annotationTree, declaredType);
        return this.addAnnotation(modifiersTree, annotationTree);
    }

    protected ModifiersTree addAnnotation(ModifiersTree modifiersTree, AnnotationTree annotationTree) {
        ArrayList<? extends AnnotationTree> arrayList = new ArrayList<AnnotationTree>();
        arrayList.addAll(modifiersTree.getAnnotations());
        arrayList.add(annotationTree);
        ModifiersTree modifiersTree2 = this.make.Modifiers(modifiersTree, arrayList);
        this.copyCommentTo(modifiersTree, modifiersTree2);
        return modifiersTree2;
    }

    public static Tree deblock(Tree tree) {
        block4: while (tree != null) {
            switch (tree.getKind()) {
                case BLOCK: {
                    BlockTree blockTree = (BlockTree)tree;
                    if (blockTree.isStatic()) {
                        return tree;
                    }
                    List<? extends StatementTree> list = blockTree.getStatements();
                    if (list.size() == 1) {
                        tree = list.get(0);
                        continue block4;
                    }
                    return tree;
                }
                case PARENTHESIZED: {
                    tree = ((ParenthesizedTree)tree).getExpression();
                    continue block4;
                }
            }
            return tree;
        }
        return null;
    }

    public void setElement(Tree tree, Element element) {
        this.model.setElement(tree, element);
    }

    public void setType(Tree tree, TypeMirror typeMirror) {
        this.model.setType(tree, typeMirror);
    }

    static {
        relInvert.put(Tree.Kind.CONDITIONAL_AND, Tree.Kind.CONDITIONAL_OR);
        relInvert.put(Tree.Kind.CONDITIONAL_OR, Tree.Kind.CONDITIONAL_AND);
        relInvert.put(Tree.Kind.EQUAL_TO, Tree.Kind.NOT_EQUAL_TO);
        relInvert.put(Tree.Kind.NOT_EQUAL_TO, Tree.Kind.EQUAL_TO);
        relInvert.put(Tree.Kind.GREATER_THAN, Tree.Kind.LESS_THAN);
        relInvert.put(Tree.Kind.LESS_THAN, Tree.Kind.GREATER_THAN);
        relInvert.put(Tree.Kind.GREATER_THAN_EQUAL, Tree.Kind.LESS_THAN_EQUAL);
        relInvert.put(Tree.Kind.LESS_THAN_EQUAL, Tree.Kind.GREATER_THAN_EQUAL);
    }
}

