/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.jackpot.test;

import java.io.ByteArrayInputStream;
import java.io.EOFException;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URL;
import java.util.zip.GZIPInputStream;
import org.netbeans.api.java.source.query.ResultTableModel;
import org.netbeans.jackpot.test.TransformationException;
import org.netbeans.modules.java.source.engine.BuildErrorsException;
import org.netbeans.modules.java.source.engine.DefaultApplicationContext;
import org.netbeans.modules.java.source.engine.EngineFactory;
import org.netbeans.modules.java.source.engine.JackpotEngine;
import org.openide.filesystems.FileUtil;

public final class TestUtilities {
    private static File tempDirectory;

    private TestUtilities() {
        try {
            File file = File.createTempFile("foo", "bar");
            tempDirectory = file.getParentFile();
        }
        catch (IOException iOException) {
            tempDirectory = new File("/tmp");
        }
    }

    public static void assertTransform(String string, String string2, String string3) throws TransformationException, Exception {
        File file = TestUtilities.copyStringToFile(TestUtilities.getClassName(string), string);
        File file2 = TestUtilities.copyStringToFile("test.rules", string3);
        TestUtilities.apply(tempDirectory, file2.getPath(), true, true, false);
        String string4 = TestUtilities.copyFileToString(file);
        if (!string4.equals(string2)) {
            throw new TransformationException("expected: \"" + string2 + "\" got: \"" + string4 + "\"");
        }
    }

    public static void assertTransform(String string, String string2, Class clazz) throws TransformationException, Exception {
        File file = TestUtilities.copyStringToFile(TestUtilities.getClassName(string), string);
        String string3 = clazz.getName();
        TestUtilities.apply(tempDirectory, string3, false, true, false);
        String string4 = TestUtilities.copyFileToString(file);
        if (!string4.equals(string2)) {
            throw new TransformationException("expected: \"" + string2 + "\" got: \"" + string4 + "\"");
        }
    }

    private static String getClassName(String string) {
        return null;
    }

    public static int applyRules(File file, URL uRL) throws BuildErrorsException, Exception {
        return TestUtilities.applyRules(file, uRL, false);
    }

    public static int applyRules(File file, URL uRL, boolean bl) throws BuildErrorsException, Exception {
        File file2 = TestUtilities.copyResourceToFile(uRL);
        return TestUtilities.apply(file, file2.getPath(), true, true, bl).getResultCount();
    }

    public static ResultTableModel applyQuery(File file, String string) throws BuildErrorsException, Exception {
        return TestUtilities.apply(file, string, false, true, false);
    }

    public static int applyTransformer(File file, String string) throws BuildErrorsException, Exception {
        return TestUtilities.apply(file, string, false, true, false).getResultCount();
    }

    private static ResultTableModel apply(File file, String string, boolean bl, boolean bl2, boolean bl3) throws BuildErrorsException, Exception {
        ResultTableModel resultTableModel;
        DefaultApplicationContext defaultApplicationContext = new DefaultApplicationContext();
        JackpotEngine jackpotEngine = EngineFactory.createEngine(defaultApplicationContext);
        int n = jackpotEngine.initialize(file.getPath(), System.getProperty("java.class.path"), "1.5");
        if (n > 0 && !bl3) {
            throw new BuildErrorsException(Integer.toString(n) + " build errors");
        }
        ResultTableModel resultTableModel2 = resultTableModel = bl ? jackpotEngine.runScript("q", "t", string) : jackpotEngine.runCommand("q", "t", string);
        if (bl2 && !jackpotEngine.commit()) {
            throw new AssertionError((Object)"commit canceled");
        }
        return resultTableModel;
    }

    public static final String copyFileToString(File file) throws IOException {
        int n = (int)file.length();
        byte[] byArray = new byte[n];
        int n2 = new FileInputStream(file).read(byArray);
        if (n2 != n) {
            throw new EOFException("truncated file");
        }
        return new String(byArray);
    }

    public static final String copyGZipFileToString(File file) throws IOException {
        int n;
        GZIPInputStream gZIPInputStream = new GZIPInputStream(new FileInputStream(file));
        byte[] byArray = new byte[65536];
        int n2 = 0;
        while (n2 + (n = gZIPInputStream.read(byArray, n2, byArray.length - n2)) >= byArray.length) {
        }
        return new String(byArray, 0, n2 + n);
    }

    public static final File copyStringToFile(File file, String string) throws Exception {
        FileOutputStream fileOutputStream = new FileOutputStream(file);
        ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(string.getBytes("UTF-8"));
        FileUtil.copy((InputStream)byteArrayInputStream, (OutputStream)fileOutputStream);
        fileOutputStream.close();
        return file;
    }

    private static final File copyStringToFile(String string, String string2) throws Exception {
        File file = new File(tempDirectory, string);
        file.deleteOnExit();
        return TestUtilities.copyStringToFile(file, string2);
    }

    private static final File copyResourceToFile(URL uRL) throws Exception {
        File file = File.createTempFile("res", ".xml");
        file.deleteOnExit();
        FileOutputStream fileOutputStream = new FileOutputStream(file);
        InputStream inputStream = uRL.openStream();
        FileUtil.copy((InputStream)inputStream, (OutputStream)fileOutputStream);
        fileOutputStream.close();
        return file;
    }
}

