/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.java;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Reader;
import java.io.UnsupportedEncodingException;
import java.io.Writer;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.LinkedList;
import javax.swing.text.BadLocationException;
import javax.swing.text.Document;
import javax.swing.text.StyledDocument;
import org.netbeans.modules.java.JavaDataObject;
import org.openide.ErrorManager;
import org.openide.cookies.EditorCookie;
import org.openide.cookies.SaveCookie;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.loaders.DataObject;
import org.openide.text.IndentEngine;
import org.openide.util.NbBundle;

public final class Util {
    static final String MAGIC_PREFIX = "//GEN-";
    private static ErrorManager errorManager;
    static final String ATTR_FILE_ENCODING = "Content-Encoding";

    static String getString(String string) {
        return NbBundle.getMessage(Util.class, (String)string);
    }

    static ErrorManager getErrorManager() {
        if (errorManager != null) {
            return errorManager;
        }
        ErrorManager errorManager = ErrorManager.getDefault();
        if (errorManager == null) {
            System.err.println("WARNING: can't lookup error manager");
            return null;
        }
        Util.errorManager = errorManager;
        return Util.errorManager;
    }

    static void annotateThrowable(Throwable throwable, Throwable throwable2) {
        Util.getErrorManager().annotate(throwable, throwable2);
    }

    static void annotateThrowable(Throwable throwable, String string, boolean bl) {
        if (bl) {
            Util.getErrorManager().annotate(throwable, 256, null, string, null, null);
        } else {
            Util.getErrorManager().annotate(throwable, 4096, null, string, null, null);
        }
    }

    static FileObject findBrother(FileObject fileObject, String string) {
        return FileUtil.findBrother((FileObject)fileObject, (String)string);
    }

    private static FileObject findSibling(FileObject fileObject, String string, Enumeration enumeration) {
        while (enumeration.hasMoreElements()) {
            FileObject fileObject2;
            String string2 = (String)enumeration.nextElement();
            if (string2 == null || (fileObject2 = fileObject.getFileObject(string, string2)) == null) continue;
            return fileObject2;
        }
        return null;
    }

    private static void notifyException(Throwable throwable, String string) {
        Util.getErrorManager().notify(throwable);
    }

    static Writer findIndentWriter(Document document, int n, Writer writer) {
        IndentEngine indentEngine = IndentEngine.find((Document)document);
        return indentEngine.createWriter(document, n, writer);
    }

    public static String getFileEncoding0(FileObject fileObject) {
        return (String)fileObject.getAttribute(ATTR_FILE_ENCODING);
    }

    public static String getFileEncoding(FileObject fileObject) {
        String string = Util.getFileEncoding0(fileObject);
        if (string == null) {
            string = null;
        }
        if ("".equals(string)) {
            return null;
        }
        return string;
    }

    public static void setFileEncoding(FileObject fileObject, String string) throws IOException {
        fileObject.setAttribute(ATTR_FILE_ENCODING, (Object)string);
    }

    public static char[] readContents(Reader reader) throws IOException {
        char[] cArray;
        int n = 0;
        int n2 = 0;
        LinkedList<char[]> linkedList = new LinkedList<char[]>();
        do {
            int n3;
            cArray = new char[2048];
            for (n3 = 0; n3 < cArray.length && (n = reader.read(cArray, n3, cArray.length - n3)) != -1; n3 += n) {
            }
            if (n3 > 0) {
                linkedList.add(cArray);
            }
            n2 += n3;
        } while (n >= 0);
        reader.close();
        cArray = new char[n2];
        Iterator iterator = linkedList.iterator();
        int n4 = 0;
        while (iterator.hasNext()) {
            char[] cArray2 = (char[])iterator.next();
            int n5 = iterator.hasNext() ? cArray2.length : n2 - n4;
            System.arraycopy(cArray2, 0, cArray, n4, n5);
            n4 += n5;
        }
        return cArray;
    }

    private static String getDocumentText(FileObject fileObject, boolean bl) throws IOException {
        StyledDocument styledDocument;
        DataObject dataObject = DataObject.find((FileObject)fileObject);
        EditorCookie editorCookie = null;
        if (dataObject instanceof JavaDataObject) {
            editorCookie = ((JavaDataObject)dataObject).getCookie(EditorCookie.class);
        }
        if (editorCookie != null && (styledDocument = editorCookie.getDocument()) != null) {
            SaveCookie saveCookie;
            final String[] stringArray = new String[1];
            Runnable runnable = new Runnable(){

                public void run() {
                    try {
                        stringArray[0] = styledDocument.getText(0, styledDocument.getLength());
                    }
                    catch (BadLocationException badLocationException) {
                        // empty catch block
                    }
                }
            };
            if (bl && (saveCookie = (SaveCookie)dataObject.getCookie(SaveCookie.class)) != null) {
                saveCookie.save();
            }
            styledDocument.render(runnable);
            return stringArray[0];
        }
        return null;
    }

    static class ParserInputStream
    extends InputStream {
        private InputStream stream;
        private String text;
        private StringBuffer buffer;
        private boolean mode;
        private int counter;
        private int[] lines = new int[200];
        int lineCounter = 2;
        int currentLineLength = 0;

        ParserInputStream(String string) {
            this(string, null);
        }

        ParserInputStream(String string, String string2) {
            this.text = string;
            this.counter = 0;
            this.mode = false;
            ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream(string.length());
            Writer writer = null;
            if (string2 != null) {
                try {
                    writer = new OutputStreamWriter((OutputStream)byteArrayOutputStream, string2);
                }
                catch (UnsupportedEncodingException unsupportedEncodingException) {
                    // empty catch block
                }
            }
            if (writer == null) {
                writer = new OutputStreamWriter(byteArrayOutputStream);
            }
            try {
                writer.write(string);
                writer.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
            this.stream = new ByteArrayInputStream(byteArrayOutputStream.toByteArray());
        }

        ParserInputStream(InputStream inputStream) {
            this.stream = inputStream;
            this.buffer = new StringBuffer();
            this.mode = true;
        }

        public String getString(int n, int n2) {
            return this.mode ? this.buffer.substring(n, n2) : this.text.substring(n, n2);
        }

        public String getString(int n) {
            if (this.mode) {
                return this.buffer.substring(n);
            }
            int n2 = Math.min(this.counter - 1, this.text.length());
            return this.text.substring(n, n2);
        }

        public int read() throws IOException {
            int n = this.stream.read();
            if (this.mode && n != -1) {
                this.buffer.append((char)n);
                ++this.counter;
            }
            if (n == 10) {
                if (this.lineCounter == this.lines.length - 1) {
                    int[] nArray = new int[this.lineCounter + this.lineCounter];
                    System.arraycopy(this.lines, 0, nArray, 0, this.lines.length);
                    this.lines = nArray;
                }
                this.lines[this.lineCounter] = this.lines[this.lineCounter - 1] + this.currentLineLength + 1;
                ++this.lineCounter;
                this.currentLineLength = 0;
            } else {
                ++this.currentLineLength;
            }
            return n;
        }

        public void close() throws IOException {
            this.stream.close();
        }

        int getOffset(int n, int n2) {
            return this.lines[n] + n2 - 1;
        }
    }
}

