/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.java.source.builder;

import com.sun.source.tree.CompilationUnitTree;
import com.sun.tools.javac.api.JavacTaskImpl;
import com.sun.tools.javac.code.Symbol;
import com.sun.tools.javac.comp.Attr;
import com.sun.tools.javac.comp.Env;
import com.sun.tools.javac.comp.Todo;
import com.sun.tools.javac.jvm.ClassReader;
import com.sun.tools.javac.parser.EndPosParser;
import com.sun.tools.javac.parser.Lexer;
import com.sun.tools.javac.parser.Parser;
import com.sun.tools.javac.tree.JCTree;
import com.sun.tools.javac.tree.TreeMaker;
import com.sun.tools.javac.util.Abort;
import com.sun.tools.javac.util.Context;
import com.sun.tools.javac.util.List;
import com.sun.tools.javac.util.ListBuffer;
import com.sun.tools.javac.util.Log;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.PrintStream;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Map;
import java.util.logging.Logger;
import javax.tools.JavaCompiler;
import javax.tools.JavaFileManager;
import javax.tools.JavaFileObject;
import javax.tools.StandardJavaFileManager;
import javax.tools.ToolProvider;
import org.netbeans.api.java.source.ClasspathInfo;
import org.netbeans.api.java.source.query.CommentHandler;
import org.netbeans.modules.java.source.builder.ASTService;
import org.netbeans.modules.java.source.builder.BufferRunQueue;
import org.netbeans.modules.java.source.builder.CommentHandlerService;
import org.netbeans.modules.java.source.builder.DefaultSourceFileFilter;
import org.netbeans.modules.java.source.builder.DumpAST;
import org.netbeans.modules.java.source.builder.Enter;
import org.netbeans.modules.java.source.builder.Scanner;
import org.netbeans.modules.java.source.builder.SourceFileFilter;
import org.netbeans.modules.java.source.builder.SourceFileList;
import org.netbeans.modules.java.source.engine.BuildProgress;
import org.netbeans.modules.java.source.engine.ElapsedTimer;
import org.netbeans.modules.java.source.engine.ReattributionException;
import org.netbeans.modules.java.source.engine.RootTree;
import org.netbeans.modules.java.source.save.SourceBuffer;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class Builder
implements ClassReader.SourceCompleter {
    private Log log;
    private Context context;
    private Enter enter;
    private TreeMaker make;
    private CommentHandlerService comments;
    private Parser.Factory parserFactory;
    private Scanner.Factory scannerFactory;
    private ASTService trees;
    private String encoding;
    private String[] sourcePaths;
    private BuildProgress progressMonitor;
    private int nfiles;
    private JavaFileManager fileManager;
    static final Logger logger = Logger.getLogger("org.netbeans.modules.java.source");
    static boolean dumpAST = Boolean.getBoolean("jackpot.dump.ast");
    private boolean hasBeenUsed = false;
    public static final SourceFileFilter sourceFileFilter = new DefaultSourceFileFilter(){

        public boolean acceptFile(String string) {
            return super.acceptFile(string) && string.endsWith(".java");
        }

        public boolean acceptDirectory(String string) {
            return super.acceptDirectory(string) && !string.equals("junk");
        }
    };

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int build() throws Exception {
        ElapsedTimer elapsedTimer = new ElapsedTimer();
        try {
            this.progressMonitor.buildStarted();
            this.progressMonitor.sourceExpansionStarting();
            String[] stringArray = SourceFileList.findFiles(this.sourcePaths, sourceFileFilter);
            this.nfiles = stringArray.length;
            this.progressMonitor.sourceExpansionFinished();
            if (this.nfiles == 0) {
                int n = 0;
                return n;
            }
            this.compile(List.from(stringArray));
        }
        finally {
            this.close();
            elapsedTimer.stop();
            this.progressMonitor.buildFinished(this.errorCount(), this.warningCount(), elapsedTimer.getElapsedMilliseconds());
            this.progressMonitor = null;
        }
        return this.errorCount();
    }

    Builder(JavacTaskImpl javacTaskImpl, String[] stringArray, BuildProgress buildProgress) {
        this.context = javacTaskImpl.getContext();
        this.sourcePaths = stringArray;
        this.progressMonitor = buildProgress;
        this.log = Log.instance(this.context);
        this.enter = (Enter)Enter.instance(this.context);
        this.enter.setBuildProgress(buildProgress);
        this.make = TreeMaker.instance(this.context);
        this.comments = CommentHandlerService.instance(this.context);
        this.parserFactory = ParserFactory.instance(this.context);
        this.scannerFactory = (Scanner.Factory)Scanner.Factory.instance(this.context);
        this.trees = ASTService.instance(this.context);
        this.fileManager = this.context.get(JavaFileManager.class);
        assert (this.fileManager instanceof StandardJavaFileManager);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static JavacTaskImpl createJavacTask(String string, String string2, String string3, String string4, String string5) {
        ArrayList<String> arrayList = new ArrayList<String>();
        arrayList.add("-XDbackgroundCompilation");
        arrayList.add("-XDcompilePolicy=attr");
        arrayList.add("-source");
        if (string4 == null) {
            string4 = "1.5";
        }
        arrayList.add(string4);
        arrayList.add("-classpath");
        arrayList.add(string2);
        if (string3 != null) {
            arrayList.add("-bootclasspath");
            arrayList.add(string3);
        }
        if (string5 != null && string5.length() > 0) {
            arrayList.add("-encoding");
            arrayList.add(string5);
        }
        String string6 = Integer.toString(Integer.MAX_VALUE);
        arrayList.add("-Xmaxerrs");
        arrayList.add(string6);
        ClassLoader classLoader = Thread.currentThread().getContextClassLoader();
        try {
            Thread.currentThread().setContextClassLoader(ClasspathInfo.class.getClassLoader());
            JavaCompiler javaCompiler = ToolProvider.getSystemJavaCompiler();
            JavacTaskImpl javacTaskImpl = (JavacTaskImpl)javaCompiler.getTask(null, null, null, arrayList, null, Collections.emptySet());
            Enter.register(javacTaskImpl.getContext());
            JavacTaskImpl javacTaskImpl2 = javacTaskImpl;
            return javacTaskImpl2;
        }
        finally {
            Thread.currentThread().setContextClassLoader(classLoader);
        }
    }

    public int errorCount() {
        return this.log.nerrors;
    }

    public int warningCount() {
        return this.log.nwarnings;
    }

    public int sourcefileCount() {
        return this.nfiles;
    }

    protected List<Symbol.ClassSymbol> compile(List<String> list) throws Exception {
        assert (!this.hasBeenUsed) : "attempt to reuse Builder";
        this.hasBeenUsed = true;
        ListBuffer listBuffer = new ListBuffer();
        try {
            this.progressMonitor.setTotalSourceFiles(list.size());
            ListBuffer<JCTree.JCCompilationUnit> listBuffer2 = new ListBuffer<JCTree.JCCompilationUnit>();
            for (JavaFileObject javaFileObject : ((StandardJavaFileManager)this.fileManager).getJavaFileObjectsFromStrings(list)) {
                listBuffer2.append(this.parse(javaFileObject));
                this.progressMonitor.fileParsed();
            }
            this.progressMonitor.parsingFinished();
            List list2 = listBuffer2.toList();
            if (dumpAST) {
                Builder.dumpTrees(list2, this.comments, "parse");
            }
            if (this.errorCount() == 0) {
                Builder.attributeTrees(this.context, list2, this.progressMonitor);
            }
            if (dumpAST) {
                Builder.dumpTrees(list2, this.comments, "attr");
            }
        }
        catch (Abort abort) {
            // empty catch block
        }
        return listBuffer.toList();
    }

    static void attributeTrees(Context context, java.util.List<CompilationUnitTree> list, BuildProgress buildProgress) throws ReattributionException {
        Log log = Log.instance(context);
        Enter enter = (Enter)Enter.instance(context);
        Todo todo = Todo.instance(context);
        ASTService aSTService = ASTService.instance(context);
        aSTService.setRoot(new RootTree(list));
        buildProgress.setTotalTrees(list.size());
        ListBuffer<JCTree.JCCompilationUnit> listBuffer = new ListBuffer<JCTree.JCCompilationUnit>();
        for (CompilationUnitTree object : list) {
            listBuffer.append((JCTree.JCCompilationUnit)object);
        }
        try {
            enter.main(listBuffer.toList());
        }
        catch (IllegalArgumentException illegalArgumentException) {
            log.error(illegalArgumentException.getLocalizedMessage(), new Object[0]);
        }
        buildProgress.enterFinished();
        if (log.nerrors == 0) {
            buildProgress.setTotalClasses(todo.length());
            Attr attr = Attr.instance(context);
            while (todo.nonEmpty()) {
                Env env = (Env)todo.next();
                JavaFileObject javaFileObject = env.enclClass.sym.sourcefile;
                log.useSource(javaFileObject);
                try {
                    attr.attribClass(env.tree.pos(), env.enclClass.sym);
                }
                catch (AssertionError assertionError) {
                    System.err.println("Problem attributing " + env.toplevel.sourcefile);
                }
                buildProgress.classAttributed();
            }
            buildProgress.attributionFinished();
        }
    }

    protected void close() {
    }

    protected JCTree.JCCompilationUnit parse(JavaFileObject javaFileObject) {
        try {
            return this.parse(javaFileObject, javaFileObject.openInputStream());
        }
        catch (IOException iOException) {
            this.log.error(-1, "error.reading.file", javaFileObject, iOException);
            return this.make.TopLevel(List.nil(), null, List.nil());
        }
    }

    protected JCTree.JCCompilationUnit parse(JavaFileObject javaFileObject, InputStream inputStream) {
        JavaFileObject javaFileObject2 = this.log.useSource(javaFileObject);
        JCTree.JCCompilationUnit jCCompilationUnit = this.make.TopLevel(List.nil(), null, List.nil());
        jCCompilationUnit.sourcefile = javaFileObject;
        if (inputStream != null) {
            try {
                SourceBuffer sourceBuffer = this.encoding != null ? new SourceBuffer(inputStream, this.encoding) : new SourceBuffer(inputStream);
                inputStream.close();
                BufferRunQueue bufferRunQueue = new BufferRunQueue();
                Scanner scanner = (Scanner)((Object)this.scannerFactory.newScanner(sourceBuffer, bufferRunQueue));
                Parser parser = this.parserFactory.newParser((Lexer)((Object)scanner), false, true);
                jCCompilationUnit = parser.compilationUnit();
                jCCompilationUnit.sourcefile = javaFileObject;
                if (jCCompilationUnit.endPositions != null) {
                    this.trees.setEndPosTable(javaFileObject, (Map<JCTree, Integer>)((Object)jCCompilationUnit.endPositions));
                }
                jCCompilationUnit.lineMap = scanner.getLineMap();
                this.comments.mapComments(jCCompilationUnit, sourceBuffer, bufferRunQueue);
            }
            catch (IOException iOException) {
                this.log.error(-1, "error.reading.file", javaFileObject, iOException);
            }
        }
        this.log.useSource(javaFileObject2);
        return jCCompilationUnit;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void complete(Symbol.ClassSymbol classSymbol) throws Symbol.CompletionFailure {
        JCTree.JCCompilationUnit jCCompilationUnit;
        JavaFileObject javaFileObject = classSymbol.classfile;
        JavaFileObject javaFileObject2 = this.log.useSource(javaFileObject);
        try {
            jCCompilationUnit = this.parse(javaFileObject);
        }
        finally {
            this.log.useSource(javaFileObject2);
        }
        this.enter.complete(List.of(jCCompilationUnit), classSymbol);
        if (this.enter.getEnv(classSymbol) == null) {
            String string = Log.getLocalizedString("file.doesnt.contain.class", classSymbol.fullname);
            throw new ClassReader.BadClassFile(classSymbol, (Object)javaFileObject, (Object)string);
        }
    }

    private void reportErrors() {
        int n = this.errorCount();
        String string = "count." + (n == 1 ? "error" : "error.plural");
        Log.printLines((PrintWriter)this.log.errWriter, (String)Log.getLocalizedString(string, Integer.toString(n)));
        String string2 = "count." + (n == 1 ? "warn" : "warn.plural");
        Log.printLines((PrintWriter)this.log.errWriter, (String)Log.getLocalizedString(string2, Integer.toString(n)));
        this.log.errWriter.flush();
    }

    static void dumpTrees(java.util.List<CompilationUnitTree> list, CommentHandler commentHandler, String string) {
        logger.fine("dumping trees");
        File file = Builder.makeDumpDirectory(string);
        for (CompilationUnitTree compilationUnitTree : list) {
            File file2 = new File(compilationUnitTree.getSourceFile().toUri().getPath());
            File file3 = new File(file, file2.getName());
            try {
                FileOutputStream fileOutputStream = new FileOutputStream(file3);
                PrintStream printStream = new PrintStream(new BufferedOutputStream(fileOutputStream));
                DumpAST.dump(compilationUnitTree, commentHandler, printStream);
                printStream.flush();
                fileOutputStream.close();
            }
            catch (IOException iOException) {
                System.err.println("failed writing " + file3.getPath() + ": " + iOException);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static File makeDumpDirectory(String string) {
        File file;
        File file2 = null;
        try {
            file2 = File.createTempFile("HOHO", null);
            file = new File(file2.getParentFile(), "jackpot-" + string);
        }
        catch (IOException iOException) {
            file = new File("/tmp/jackpot-" + string);
        }
        finally {
            if (file2 != null) {
                file2.delete();
            }
        }
        file.mkdirs();
        return file;
    }

    public static class ParserFactory
    extends Parser.Factory {
        public static Parser.Factory instance(Context context) {
            Parser.Factory factory = (Parser.Factory)context.get(parserFactoryKey);
            if (factory == null) {
                factory = new ParserFactory(context);
            }
            return factory;
        }

        protected ParserFactory(Context context) {
            super(context);
        }

        public Parser newParser(Scanner scanner, boolean bl, boolean bl2) {
            return new EndPosParser(this, (Lexer)((Object)scanner), bl){

                protected StringBuffer foldStrings(JCTree jCTree) {
                    return null;
                }
            };
        }
    }
}

