/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.java.source.builder;

import com.sun.source.tree.CompilationUnitTree;
import com.sun.source.tree.Tree;
import com.sun.tools.javac.parser.Token;
import com.sun.tools.javac.tree.JCTree;
import com.sun.tools.javac.tree.TreeScanner;
import com.sun.tools.javac.util.Context;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.SortedMap;
import java.util.TreeMap;
import java.util.WeakHashMap;
import org.netbeans.api.java.source.Comment;
import org.netbeans.api.java.source.query.CommentHandler;
import org.netbeans.api.java.source.query.CommentSet;
import org.netbeans.modules.java.source.builder.ASTService;
import org.netbeans.modules.java.source.builder.BufferRun;
import org.netbeans.modules.java.source.builder.BufferRunQueue;
import org.netbeans.modules.java.source.builder.CommentRun;
import org.netbeans.modules.java.source.builder.CommentSetImpl;
import org.netbeans.modules.java.source.builder.TokenRun;
import org.netbeans.modules.java.source.engine.ASTModel;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CommentHandlerService
implements CommentHandler {
    private static final Context.Key<CommentHandlerService> commentHandlerKey = new Context.Key();
    private Map<Tree, CommentSetImpl> map = new WeakHashMap<Tree, CommentSetImpl>();
    protected ASTModel model;

    public static CommentHandlerService instance(Context context) {
        CommentHandlerService commentHandlerService = context.get(commentHandlerKey);
        if (commentHandlerService == null) {
            commentHandlerService = new CommentHandlerService(context);
            CommentHandlerService.setCommentHandler(context, commentHandlerService);
        }
        return commentHandlerService;
    }

    public static void setCommentHandler(Context context, CommentHandlerService commentHandlerService) {
        assert (context.get(commentHandlerKey) == null);
        context.put(commentHandlerKey, commentHandlerService);
    }

    private CommentHandlerService(Context context) {
        this.model = ASTService.instance(context);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean hasComments(Tree tree) {
        Map<Tree, CommentSetImpl> map = this.map;
        synchronized (map) {
            return this.map.containsKey(tree);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public CommentSet getComments(Tree tree) {
        Map<Tree, CommentSetImpl> map = this.map;
        synchronized (map) {
            CommentSetImpl commentSetImpl = this.map.get(tree);
            if (commentSetImpl == null) {
                commentSetImpl = new CommentSetImpl();
                this.map.put(tree, commentSetImpl);
            }
            return commentSetImpl;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void copyComments(Tree tree, Tree tree2) {
        Map<Tree, CommentSetImpl> map = this.map;
        synchronized (map) {
            CommentSetImpl commentSetImpl = this.map.get(tree);
            if (commentSetImpl != null) {
                CommentSetImpl commentSetImpl2 = this.map.get(tree2);
                if (commentSetImpl2 == null) {
                    commentSetImpl2 = (CommentSetImpl)commentSetImpl.clone();
                    commentSetImpl2.setTree(tree2);
                    this.map.put(tree2, commentSetImpl2);
                } else {
                    commentSetImpl2.addPrecedingComments(commentSetImpl.getPrecedingComments());
                    commentSetImpl2.addTrailingComments(commentSetImpl.getTrailingComments());
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void addComment(Tree tree, Comment comment) {
        Map<Tree, CommentSetImpl> map = this.map;
        synchronized (map) {
            CommentSetImpl commentSetImpl = this.map.get(tree);
            if (commentSetImpl == null) {
                commentSetImpl = new CommentSetImpl();
                this.map.put(tree, commentSetImpl);
            }
            commentSetImpl.addPrecedingComment(comment);
        }
    }

    public void mapComments(CompilationUnitTree compilationUnitTree, CharSequence charSequence, BufferRunQueue bufferRunQueue) {
        Object object;
        final JCTree.JCCompilationUnit jCCompilationUnit = (JCTree.JCCompilationUnit)compilationUnitTree;
        SortedMap<Integer, JCTree> sortedMap = this.getPositions(jCCompilationUnit);
        if (sortedMap.size() == 0) {
            return;
        }
        Object object2 = null;
        LineColMapper lineColMapper = new LineColMapper(){

            public int getColumn(int n) {
                return jCCompilationUnit.lineMap.getColumnNumber(n);
            }

            public int getLine(int n) {
                return jCCompilationUnit.lineMap.getLineNumber(n);
            }
        };
        CommentSetImpl commentSetImpl = (CommentSetImpl)this.getComments(jCCompilationUnit);
        for (BufferRun bufferRun : bufferRunQueue) {
            if (bufferRun.getKind() == BufferRun.Kind.TOKEN) break;
            if (bufferRun.getKind() != BufferRun.Kind.COMMENT) continue;
            object = (CommentRun)bufferRun;
            if (((CommentRun)object).getStyle() == Comment.Style.JAVADOC) break;
            Comment comment = ((CommentRun)object).toComment(((BufferRun)object).getString(charSequence), lineColMapper.getColumn(((BufferRun)object).getStart()));
            commentSetImpl.addPrecedingComment(comment);
        }
        Iterator<Object> iterator = sortedMap.keySet().iterator();
        while (iterator.hasNext()) {
            int n = (Integer)iterator.next();
            object = (JCTree)sortedMap.get(n);
            int n2 = bufferRunQueue.findRunStartingAt(this.model.getStartPos((Tree)object));
            if (n2 == -1) continue;
            this.mapComments(n2, (JCTree)object, (JCTree)object2, charSequence, bufferRunQueue, lineColMapper);
            int n3 = this.model.getEndPos((Tree)object, jCCompilationUnit);
            int n4 = bufferRunQueue.findRunEndingWith(n3);
            if (n4 == -1) continue;
            BufferRun bufferRun = bufferRunQueue.get(n4);
            if (bufferRun.getKind() == BufferRun.Kind.TOKEN && ((TokenRun)bufferRun).getToken() == Token.RBRACE) {
                this.mapTrailingBlockComments(n2, n4, (JCTree)object, this.getComments((Tree)object), charSequence, bufferRunQueue, lineColMapper);
            }
            object2 = object;
        }
        for (int i = bufferRunQueue.findRunEndingWith(this.model.getEndPos(jCCompilationUnit, jCCompilationUnit)) + 1; i < bufferRunQueue.size(); ++i) {
            BufferRun bufferRun;
            if (bufferRunQueue.get(i).getKind() != BufferRun.Kind.COMMENT) continue;
            bufferRun = (CommentRun)bufferRunQueue.get(i);
            object = ((CommentRun)bufferRun).toComment(bufferRun.getString(charSequence), lineColMapper.getColumn(bufferRun.getStart()));
            commentSetImpl.addTrailingComment((Comment)object);
        }
    }

    private void mapTrailingBlockComments(int n, int n2, JCTree jCTree, CommentSet commentSet, CharSequence charSequence, BufferRunQueue bufferRunQueue, LineColMapper lineColMapper) {
        while (--n2 > n && bufferRunQueue.get(n2).getKind() != BufferRun.Kind.TOKEN) {
            BufferRun bufferRun = bufferRunQueue.get(n2);
            if (bufferRun.getKind() != BufferRun.Kind.COMMENT) continue;
            CommentRun commentRun = (CommentRun)bufferRun;
            Comment comment = commentRun.toComment(commentRun.getString(charSequence), lineColMapper.getColumn(commentRun.getStart()));
            commentSet.addTrailingComment(comment);
        }
    }

    private void mapComments(int n, JCTree jCTree, JCTree jCTree2, CharSequence charSequence, BufferRunQueue bufferRunQueue, LineColMapper lineColMapper) {
        int n2;
        assert (n != -1);
        int n3 = -1;
        for (n2 = n - 1; n2 >= 0 && bufferRunQueue.get(n2).getKind() != BufferRun.Kind.TOKEN; --n2) {
            if (bufferRunQueue.get(n2).getKind() != BufferRun.Kind.LINE_ENDING) continue;
            n3 = lineColMapper.getLine(bufferRunQueue.get(n2).getStart());
        }
        while (++n2 < n) {
            if (bufferRunQueue.get(n2).getKind() != BufferRun.Kind.COMMENT) continue;
            CommentRun commentRun = (CommentRun)bufferRunQueue.get(n2);
            Comment comment = commentRun.toComment(commentRun.getString(charSequence), lineColMapper.getColumn(commentRun.getStart()));
            if (jCTree2 != null && lineColMapper.getLine(commentRun.getEnd()) == n3) {
                CommentSetImpl commentSetImpl = (CommentSetImpl)this.getComments(jCTree2);
                commentSetImpl.addTrailingComment(comment);
                continue;
            }
            this.addComment(jCTree, comment);
        }
    }

    private CommentSetImpl flushTrailingComments(CommentSetImpl commentSetImpl, CommentSetImpl commentSetImpl2) {
        List<Comment> list = commentSetImpl.getPrecedingComments();
        if (list.isEmpty()) {
            return commentSetImpl;
        }
        for (Comment comment : list) {
            commentSetImpl2.addTrailingComment(comment);
        }
        return new CommentSetImpl();
    }

    private SortedMap<Integer, JCTree> getPositions(JCTree.JCCompilationUnit jCCompilationUnit) {
        final TreeMap<Integer, JCTree> treeMap = new TreeMap<Integer, JCTree>();
        jCCompilationUnit.accept(new TreeScanner(){

            public void scan(JCTree jCTree) {
                if (jCTree != null) {
                    jCTree.accept(this);
                    int n = CommentHandlerService.this.model.getStartPos(jCTree);
                    if (n != -1) {
                        treeMap.put(n, jCTree);
                    }
                }
            }

            public void visitTypeIdent(JCTree.JCPrimitiveTypeTree jCPrimitiveTypeTree) {
                super.visitTypeIdent(jCPrimitiveTypeTree);
            }

            public void visitMethodDef(JCTree.JCMethodDecl jCMethodDecl) {
                super.visitMethodDef(jCMethodDecl);
            }
        });
        return treeMap;
    }

    private static interface LineColMapper {
        public int getColumn(int var1);

        public int getLine(int var1);
    }
}

