/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.java.source.builder;

import com.sun.source.tree.AnnotationTree;
import com.sun.source.tree.ArrayAccessTree;
import com.sun.source.tree.ArrayTypeTree;
import com.sun.source.tree.AssertTree;
import com.sun.source.tree.AssignmentTree;
import com.sun.source.tree.BinaryTree;
import com.sun.source.tree.BlockTree;
import com.sun.source.tree.BreakTree;
import com.sun.source.tree.CaseTree;
import com.sun.source.tree.CatchTree;
import com.sun.source.tree.ClassTree;
import com.sun.source.tree.CompilationUnitTree;
import com.sun.source.tree.CompoundAssignmentTree;
import com.sun.source.tree.ConditionalExpressionTree;
import com.sun.source.tree.ContinueTree;
import com.sun.source.tree.DoWhileLoopTree;
import com.sun.source.tree.EmptyStatementTree;
import com.sun.source.tree.EnhancedForLoopTree;
import com.sun.source.tree.ErroneousTree;
import com.sun.source.tree.ExpressionStatementTree;
import com.sun.source.tree.ForLoopTree;
import com.sun.source.tree.IdentifierTree;
import com.sun.source.tree.IfTree;
import com.sun.source.tree.ImportTree;
import com.sun.source.tree.InstanceOfTree;
import com.sun.source.tree.LabeledStatementTree;
import com.sun.source.tree.LiteralTree;
import com.sun.source.tree.MemberSelectTree;
import com.sun.source.tree.MethodInvocationTree;
import com.sun.source.tree.MethodTree;
import com.sun.source.tree.ModifiersTree;
import com.sun.source.tree.NewArrayTree;
import com.sun.source.tree.NewClassTree;
import com.sun.source.tree.ParameterizedTypeTree;
import com.sun.source.tree.ParenthesizedTree;
import com.sun.source.tree.PrimitiveTypeTree;
import com.sun.source.tree.ReturnTree;
import com.sun.source.tree.SwitchTree;
import com.sun.source.tree.SynchronizedTree;
import com.sun.source.tree.ThrowTree;
import com.sun.source.tree.Tree;
import com.sun.source.tree.TryTree;
import com.sun.source.tree.TypeCastTree;
import com.sun.source.tree.TypeParameterTree;
import com.sun.source.tree.UnaryTree;
import com.sun.source.tree.VariableTree;
import com.sun.source.tree.WhileLoopTree;
import com.sun.source.tree.WildcardTree;
import com.sun.source.util.TreeScanner;
import com.sun.tools.javac.tree.JCTree;
import java.io.PrintStream;
import java.util.List;
import java.util.Set;
import javax.lang.model.element.Modifier;
import org.netbeans.api.java.source.query.CommentHandler;
import org.netbeans.api.java.source.query.CommentSet;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class DumpAST
extends TreeScanner<Object, Object> {
    CommentHandler comments;
    PrintStream out;
    int indent;

    public static void dump(Tree tree, CommentHandler commentHandler, PrintStream printStream) {
        tree.accept(new DumpAST(printStream, commentHandler), null);
    }

    DumpAST(PrintStream printStream, CommentHandler commentHandler) {
        this.out = printStream;
        this.comments = commentHandler;
        this.indent = 0;
    }

    private void indent() {
        for (int i = 0; i < this.indent; ++i) {
            this.out.print(". ");
        }
    }

    private void dump(String string, Tree tree) {
        ++this.indent;
        this.indent();
        this.out.print(string + ": ");
        if (tree != null) {
            this.out.println();
            ++this.indent;
            this.scan(tree, null);
            --this.indent;
        } else {
            this.out.println("null");
        }
        --this.indent;
    }

    private void dump(String string, List<? extends Tree> list) {
        ++this.indent;
        this.indent();
        this.out.print(string);
        if (list == null) {
            this.out.println(": null");
        } else if (list.isEmpty()) {
            this.out.println(" {}");
        } else {
            this.out.println(" {");
            ++this.indent;
            for (Tree tree : list) {
                this.scan(tree, null);
            }
            --this.indent;
            this.indent();
            this.out.println("}");
        }
        --this.indent;
    }

    private void dumpField(String string, Object object) {
        ++this.indent;
        this.indent();
        this.out.println(string + ": " + (object != null ? object.toString() : "null"));
        --this.indent;
    }

    private void dumpFlags(Set<Modifier> set) {
        StringBuffer stringBuffer = new StringBuffer();
        for (Modifier modifier : set) {
            stringBuffer.append(modifier.name());
            stringBuffer.append(' ');
        }
        this.dumpField("flags", stringBuffer.toString().trim());
    }

    private void header(String string, Tree tree) {
        this.indent();
        this.out.println(string);
        this.dumpField("pos", Integer.toString(((JCTree)tree).pos));
        if (this.comments.hasComments((JCTree)tree)) {
            CommentSet commentSet = this.comments.getComments((JCTree)tree);
            this.dumpField("comments", commentSet.toString());
        }
    }

    @Override
    public Object visitCompilationUnit(CompilationUnitTree compilationUnitTree, Object object) {
        this.header("CompilationUnit", compilationUnitTree);
        this.dump("packageAnnotations", compilationUnitTree.getPackageAnnotations());
        this.dump("pid", compilationUnitTree.getPackageName());
        this.dumpField("sourcefile", compilationUnitTree.getSourceFile());
        this.dumpField("namedImportScope", compilationUnitTree.getImports());
        this.dump("defs", compilationUnitTree.getTypeDecls());
        return object;
    }

    @Override
    public Object visitImport(ImportTree importTree, Object object) {
        this.header("Import", importTree);
        this.dumpField("staticImport", Boolean.toString(importTree.isStatic()));
        this.dump("qualid", importTree.getQualifiedIdentifier());
        return object;
    }

    @Override
    public Object visitClass(ClassTree classTree, Object object) {
        this.header("Class", classTree);
        this.dumpField("name", classTree.getSimpleName());
        this.dump("mods", classTree.getModifiers());
        this.dump("typarams", classTree.getTypeParameters());
        this.dump("extending", classTree.getExtendsClause());
        this.dump("implementing", classTree.getImplementsClause());
        this.dump("defs", classTree.getMembers());
        return object;
    }

    @Override
    public Object visitMethod(MethodTree methodTree, Object object) {
        this.header("Method", methodTree);
        this.dumpField("name", methodTree.getName());
        this.dump("mods", methodTree.getModifiers());
        this.dump("restype", methodTree.getReturnType());
        this.dump("typarams", methodTree.getTypeParameters());
        this.dump("params", methodTree.getParameters());
        this.dump("thrown", methodTree.getThrows());
        this.dump("defaultValue", methodTree.getDefaultValue());
        this.dump("body", methodTree.getBody());
        return object;
    }

    @Override
    public Object visitVariable(VariableTree variableTree, Object object) {
        this.header("Variable", variableTree);
        this.dumpField("name", variableTree.getName());
        this.dump("mods", variableTree.getModifiers());
        this.dump("vartype", variableTree.getType());
        this.dump("init", variableTree.getInitializer());
        return object;
    }

    @Override
    public Object visitEmptyStatement(EmptyStatementTree emptyStatementTree, Object object) {
        this.header("EmptyStatement", emptyStatementTree);
        return object;
    }

    @Override
    public Object visitBlock(BlockTree blockTree, Object object) {
        this.header("Block", blockTree);
        this.dumpField("(flags & Static)", blockTree.isStatic());
        this.dump("stats", blockTree.getStatements());
        return object;
    }

    @Override
    public Object visitDoWhileLoop(DoWhileLoopTree doWhileLoopTree, Object object) {
        this.header("DoWhileLoop", doWhileLoopTree);
        this.dump("body", doWhileLoopTree.getStatement());
        this.dump("cond", doWhileLoopTree.getCondition());
        return object;
    }

    @Override
    public Object visitWhileLoop(WhileLoopTree whileLoopTree, Object object) {
        this.header("WhileLoop", whileLoopTree);
        this.dump("cond", whileLoopTree.getCondition());
        this.dump("body", whileLoopTree.getStatement());
        return object;
    }

    @Override
    public Object visitForLoop(ForLoopTree forLoopTree, Object object) {
        this.header("ForLoop", forLoopTree);
        this.dump("init", forLoopTree.getInitializer());
        this.dump("cond", forLoopTree.getCondition());
        this.dump("step", forLoopTree.getUpdate());
        this.dump("body", forLoopTree.getStatement());
        return object;
    }

    @Override
    public Object visitEnhancedForLoop(EnhancedForLoopTree enhancedForLoopTree, Object object) {
        this.header("EnhancedForLoop", enhancedForLoopTree);
        this.dump("var", enhancedForLoopTree.getVariable());
        this.dump("expr", enhancedForLoopTree.getExpression());
        this.dump("body", enhancedForLoopTree.getStatement());
        return object;
    }

    @Override
    public Object visitLabeledStatement(LabeledStatementTree labeledStatementTree, Object object) {
        this.header("LabeledStatement", labeledStatementTree);
        this.dumpField("label", labeledStatementTree.getLabel());
        this.dump("body", labeledStatementTree.getStatement());
        return object;
    }

    @Override
    public Object visitSwitch(SwitchTree switchTree, Object object) {
        this.header("Switch", switchTree);
        this.dump("selector", switchTree.getExpression());
        this.dump("cases", switchTree.getCases());
        return object;
    }

    @Override
    public Object visitCase(CaseTree caseTree, Object object) {
        this.header("Case", caseTree);
        this.dump("pat", caseTree.getExpression());
        this.dump("stats", caseTree.getStatements());
        return object;
    }

    @Override
    public Object visitSynchronized(SynchronizedTree synchronizedTree, Object object) {
        this.header("Synchronized", synchronizedTree);
        this.dump("lock", synchronizedTree.getExpression());
        this.dump("body", synchronizedTree.getBlock());
        return object;
    }

    @Override
    public Object visitTry(TryTree tryTree, Object object) {
        this.header("Try", tryTree);
        this.dump("body", tryTree.getBlock());
        this.dump("catchers", tryTree.getCatches());
        this.dump("finalizer", tryTree.getFinallyBlock());
        return object;
    }

    @Override
    public Object visitCatch(CatchTree catchTree, Object object) {
        this.header("Catch", catchTree);
        this.dump("param", catchTree.getParameter());
        this.dump("body", catchTree.getBlock());
        return object;
    }

    @Override
    public Object visitConditionalExpression(ConditionalExpressionTree conditionalExpressionTree, Object object) {
        this.header("ConditionalExpression", conditionalExpressionTree);
        this.dump("cond", conditionalExpressionTree.getCondition());
        this.dump("truepart", conditionalExpressionTree.getTrueExpression());
        this.dump("falsepart", conditionalExpressionTree.getFalseExpression());
        return object;
    }

    @Override
    public Object visitIf(IfTree ifTree, Object object) {
        this.header("If", ifTree);
        this.dump("cond", ifTree.getCondition());
        this.dump("thenpart", ifTree.getThenStatement());
        this.dump("elsepart", ifTree.getElseStatement());
        return object;
    }

    @Override
    public Object visitExpressionStatement(ExpressionStatementTree expressionStatementTree, Object object) {
        this.header("ExpressionStatement", expressionStatementTree);
        this.dump("expr", expressionStatementTree.getExpression());
        return object;
    }

    @Override
    public Object visitBreak(BreakTree breakTree, Object object) {
        this.header("Break", breakTree);
        this.dumpField("label", breakTree.getLabel());
        return object;
    }

    @Override
    public Object visitContinue(ContinueTree continueTree, Object object) {
        this.header("Continue", continueTree);
        this.dumpField("label", continueTree.getLabel());
        return object;
    }

    @Override
    public Object visitReturn(ReturnTree returnTree, Object object) {
        this.header("Return", returnTree);
        this.dump("expr", returnTree.getExpression());
        return object;
    }

    @Override
    public Object visitThrow(ThrowTree throwTree, Object object) {
        this.header("Throw", throwTree);
        this.dump("expr", throwTree.getExpression());
        return object;
    }

    @Override
    public Object visitAssert(AssertTree assertTree, Object object) {
        this.header("Assert", assertTree);
        this.dump("cond", assertTree.getCondition());
        this.dump("detail", assertTree.getDetail());
        return object;
    }

    @Override
    public Object visitMethodInvocation(MethodInvocationTree methodInvocationTree, Object object) {
        this.header("MethodInvocation", methodInvocationTree);
        this.dump("typeargs", methodInvocationTree.getTypeArguments());
        this.dump("meth", methodInvocationTree.getMethodSelect());
        this.dump("args", methodInvocationTree.getArguments());
        return object;
    }

    @Override
    public Object visitNewClass(NewClassTree newClassTree, Object object) {
        this.header("NewClass", newClassTree);
        this.dump("encl", newClassTree.getEnclosingExpression());
        this.dump("typeargs", newClassTree.getTypeArguments());
        this.dump("clazz", newClassTree.getIdentifier());
        this.dump("args", newClassTree.getArguments());
        this.dump("def", newClassTree.getClassBody());
        return object;
    }

    @Override
    public Object visitNewArray(NewArrayTree newArrayTree, Object object) {
        this.header("NewArray", newArrayTree);
        this.dump("elemtype", newArrayTree.getType());
        this.dump("dims", newArrayTree.getDimensions());
        this.dump("elems", newArrayTree.getInitializers());
        return object;
    }

    @Override
    public Object visitParenthesized(ParenthesizedTree parenthesizedTree, Object object) {
        this.header("Parenthesized", parenthesizedTree);
        this.dump("expr", parenthesizedTree.getExpression());
        return object;
    }

    @Override
    public Object visitAssignment(AssignmentTree assignmentTree, Object object) {
        this.header("Assignment", assignmentTree);
        this.dump("lhs", assignmentTree.getVariable());
        this.dump("rhs", assignmentTree.getExpression());
        return object;
    }

    @Override
    public Object visitCompoundAssignment(CompoundAssignmentTree compoundAssignmentTree, Object object) {
        this.header("CompoundAssignment", compoundAssignmentTree);
        this.dump("lhs", compoundAssignmentTree.getVariable());
        this.dump("rhs", compoundAssignmentTree.getExpression());
        return object;
    }

    @Override
    public Object visitUnary(UnaryTree unaryTree, Object object) {
        this.header("Unary", unaryTree);
        this.dump("arg", unaryTree.getExpression());
        return object;
    }

    @Override
    public Object visitBinary(BinaryTree binaryTree, Object object) {
        this.header("Binary", binaryTree);
        this.dump("lhs", binaryTree.getLeftOperand());
        this.dump("rhs", binaryTree.getRightOperand());
        return object;
    }

    @Override
    public Object visitTypeCast(TypeCastTree typeCastTree, Object object) {
        this.header("TypeCast", typeCastTree);
        this.dump("clazz", typeCastTree.getType());
        this.dump("expr", typeCastTree.getExpression());
        return object;
    }

    @Override
    public Object visitInstanceOf(InstanceOfTree instanceOfTree, Object object) {
        this.header("InstanceOf", instanceOfTree);
        this.dump("expr", instanceOfTree.getExpression());
        this.dump("clazz", instanceOfTree.getType());
        return object;
    }

    @Override
    public Object visitArrayAccess(ArrayAccessTree arrayAccessTree, Object object) {
        this.header("ArrayAccess", arrayAccessTree);
        this.dump("indexed", arrayAccessTree.getExpression());
        this.dump("index", arrayAccessTree.getIndex());
        return object;
    }

    @Override
    public Object visitMemberSelect(MemberSelectTree memberSelectTree, Object object) {
        this.header("MemberSelect", memberSelectTree);
        this.dumpField("name", memberSelectTree.getIdentifier());
        this.dump("selected", memberSelectTree.getExpression());
        return object;
    }

    @Override
    public Object visitIdentifier(IdentifierTree identifierTree, Object object) {
        this.header("Identifier", identifierTree);
        this.dumpField("name", identifierTree.getName());
        return object;
    }

    @Override
    public Object visitLiteral(LiteralTree literalTree, Object object) {
        this.header("Literal", literalTree);
        this.dumpField("typetag", (Object)literalTree.getKind());
        this.dumpField("value", literalTree.getValue());
        return object;
    }

    @Override
    public Object visitPrimitiveType(PrimitiveTypeTree primitiveTypeTree, Object object) {
        this.header("PrimitiveType", primitiveTypeTree);
        this.dumpField("typetag", (Object)primitiveTypeTree.getKind());
        return object;
    }

    @Override
    public Object visitArrayType(ArrayTypeTree arrayTypeTree, Object object) {
        this.header("ArrayType", arrayTypeTree);
        this.dump("elemtype", arrayTypeTree.getType());
        return object;
    }

    @Override
    public Object visitParameterizedType(ParameterizedTypeTree parameterizedTypeTree, Object object) {
        this.header("ParameterizedType", parameterizedTypeTree);
        this.dump("clazz", parameterizedTypeTree.getType());
        this.dump("arguments", parameterizedTypeTree.getTypeArguments());
        return object;
    }

    @Override
    public Object visitTypeParameter(TypeParameterTree typeParameterTree, Object object) {
        this.header("TypeParameter", typeParameterTree);
        this.dumpField("name", typeParameterTree.getName());
        this.dump("bounds", typeParameterTree.getBounds());
        return object;
    }

    @Override
    public Object visitWildcard(WildcardTree wildcardTree, Object object) {
        this.header("Wildcard", wildcardTree);
        this.dumpField("kind", (Object)wildcardTree.getKind());
        this.dump("inner", wildcardTree.getBound());
        return object;
    }

    @Override
    public Object visitModifiers(ModifiersTree modifiersTree, Object object) {
        this.header("Modifiers", modifiersTree);
        this.dumpFlags(modifiersTree.getFlags());
        this.dump("annotations", modifiersTree.getAnnotations());
        return object;
    }

    @Override
    public Object visitAnnotation(AnnotationTree annotationTree, Object object) {
        this.header("Annotation", annotationTree);
        this.dump("annotationType", annotationTree.getAnnotationType());
        this.dump("args", annotationTree.getArguments());
        return object;
    }

    @Override
    public Object visitErroneous(ErroneousTree erroneousTree, Object object) {
        this.header("Erroneous", erroneousTree);
        return object;
    }

    @Override
    public Object visitOther(Tree tree, Object object) {
        assert (false);
        return object;
    }
}

