/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.java.source.builder;

import com.sun.tools.javac.tree.JCTree;
import com.sun.tools.javac.tree.TreeInfo;
import com.sun.tools.javac.tree.TreeScanner;
import java.io.PrintWriter;
import org.netbeans.modules.java.source.builder.BufferRun;
import org.netbeans.modules.java.source.builder.BufferRunQueue;
import org.netbeans.modules.java.source.builder.CommentRun;

public class DumpScanner
extends TreeScanner {
    BufferRunQueue runs;
    JCTree.JCCompilationUnit toplevel;
    PrintWriter out;
    int level = -1;
    static final String BLANK = "                                                                                                                        ";
    private static final String[] TYPE_NAMES = new String[]{null, "byte", "char", "short", "int", "long", "float", "double", "boolean", "void", "<class>", "<array>", "<method>", "<package>"};

    public static void dump(BufferRunQueue bufferRunQueue, JCTree.JCCompilationUnit jCCompilationUnit, PrintWriter printWriter) {
        new DumpScanner(bufferRunQueue, jCCompilationUnit, printWriter).scan(jCCompilationUnit);
    }

    DumpScanner(BufferRunQueue bufferRunQueue, JCTree.JCCompilationUnit jCCompilationUnit, PrintWriter printWriter) {
        this.runs = bufferRunQueue;
        this.toplevel = jCCompilationUnit;
        this.out = printWriter;
    }

    public void scan(JCTree jCTree) {
        ++this.level;
        super.scan(jCTree);
        --this.level;
    }

    private static void appendTypeTag(StringBuffer stringBuffer, int n) {
        if (n > 0 && n < TYPE_NAMES.length) {
            stringBuffer.append(TYPE_NAMES[n]);
        } else {
            stringBuffer.append("<BadTypeTag:" + n + ">");
        }
    }

    public void dumpHead(JCTree jCTree) {
        if (jCTree != null) {
            int n;
            Object object;
            while ((object = this.runs.getNextBefore(jCTree.pos)) instanceof CommentRun) {
                n = ((BufferRun)object).getStart();
                int n2 = ((BufferRun)object).getEnd();
                this.out.print(BLANK.substring(0, this.level * 4));
                this.out.println("Comment @ " + n + "-" + n2 + ": " + ((BufferRun)object).toString());
            }
            this.out.print(BLANK.substring(0, this.level * 4));
            object = jCTree.getClass().getName();
            n = ((String)object).indexOf(36);
            object = ((String)object).substring(n + 1);
            this.out.print((String)object);
            this.out.print(" @ " + jCTree.pos);
            if (this.toplevel.endPositions != null) {
                Integer n3 = (Integer)this.toplevel.endPositions.get(jCTree);
                if (n3 != null) {
                    int n4 = n3;
                    this.out.print("-" + n4);
                } else {
                    int n5 = TreeInfo.endPos(jCTree);
                    this.out.print("-(" + n5 + ")");
                }
            }
            this.out.print("  ");
        }
    }

    public void visitTopLevel(JCTree.JCCompilationUnit jCCompilationUnit) {
        this.dumpHead(jCCompilationUnit);
        if (jCCompilationUnit.sourcefile != null) {
            this.out.print(" file:" + jCCompilationUnit.sourcefile.toString());
        }
        if (jCCompilationUnit.packge != null) {
            this.out.print(" pkg:" + jCCompilationUnit.packge.toString());
        }
        this.out.println();
        super.visitTopLevel(jCCompilationUnit);
    }

    public void visitImport(JCTree.JCImport jCImport) {
        this.dumpHead(jCImport);
        this.out.println();
        super.visitImport(jCImport);
    }

    public void visitClassDef(JCTree.JCClassDecl jCClassDecl) {
        this.dumpHead(jCClassDecl);
        this.out.println("\"" + jCClassDecl.name + "\"");
        super.visitClassDef(jCClassDecl);
    }

    public void visitMethodDef(JCTree.JCMethodDecl jCMethodDecl) {
        this.dumpHead(jCMethodDecl);
        this.out.println("\"" + jCMethodDecl.name + "\"");
        super.visitMethodDef(jCMethodDecl);
    }

    public void visitVarDef(JCTree.JCVariableDecl jCVariableDecl) {
        this.dumpHead(jCVariableDecl);
        this.out.println("\"" + jCVariableDecl.name + "\"");
        super.visitVarDef(jCVariableDecl);
    }

    public void visitSkip(JCTree.JCSkip jCSkip) {
        this.dumpHead(jCSkip);
        this.out.println();
        super.visitSkip(jCSkip);
    }

    public void visitBlock(JCTree.JCBlock jCBlock) {
        this.dumpHead(jCBlock);
        this.out.println("flags:" + jCBlock.flags + " endPos:" + jCBlock.endpos);
        super.visitBlock(jCBlock);
    }

    public void visitDoLoop(JCTree.JCDoWhileLoop jCDoWhileLoop) {
        this.dumpHead(jCDoWhileLoop);
        this.out.println();
        super.visitDoLoop(jCDoWhileLoop);
    }

    public void visitWhileLoop(JCTree.JCWhileLoop jCWhileLoop) {
        this.dumpHead(jCWhileLoop);
        this.out.println();
        super.visitWhileLoop(jCWhileLoop);
    }

    public void visitForLoop(JCTree.JCForLoop jCForLoop) {
        this.dumpHead(jCForLoop);
        this.out.println();
        super.visitForLoop(jCForLoop);
    }

    public void visitForeachLoop(JCTree.JCEnhancedForLoop jCEnhancedForLoop) {
        this.dumpHead(jCEnhancedForLoop);
        this.out.println();
        super.visitForeachLoop(jCEnhancedForLoop);
    }

    public void visitLabelled(JCTree.JCLabeledStatement jCLabeledStatement) {
        this.dumpHead(jCLabeledStatement);
        this.out.println();
        super.visitLabelled(jCLabeledStatement);
    }

    public void visitSwitch(JCTree.JCSwitch jCSwitch) {
        this.dumpHead(jCSwitch);
        this.out.println();
        super.visitSwitch(jCSwitch);
    }

    public void visitCase(JCTree.JCCase jCCase) {
        this.dumpHead(jCCase);
        this.out.println();
        super.visitCase(jCCase);
    }

    public void visitSynchronized(JCTree.JCSynchronized jCSynchronized) {
        this.dumpHead(jCSynchronized);
        this.out.println();
        super.visitSynchronized(jCSynchronized);
    }

    public void visitTry(JCTree.JCTry jCTry) {
        this.dumpHead(jCTry);
        this.out.println();
        super.visitTry(jCTry);
    }

    public void visitCatch(JCTree.JCCatch jCCatch) {
        this.dumpHead(jCCatch);
        this.out.println();
        super.visitCatch(jCCatch);
    }

    public void visitConditional(JCTree.JCConditional jCConditional) {
        this.dumpHead(jCConditional);
        this.out.println();
        super.visitConditional(jCConditional);
    }

    public void visitIf(JCTree.JCIf jCIf) {
        this.dumpHead(jCIf);
        this.out.println();
        super.visitIf(jCIf);
    }

    public void visitExec(JCTree.JCExpressionStatement jCExpressionStatement) {
        this.dumpHead(jCExpressionStatement);
        this.out.println();
        super.visitExec(jCExpressionStatement);
    }

    public void visitBreak(JCTree.JCBreak jCBreak) {
        this.dumpHead(jCBreak);
        this.out.println();
        super.visitBreak(jCBreak);
    }

    public void visitContinue(JCTree.JCContinue jCContinue) {
        this.dumpHead(jCContinue);
        this.out.println();
        super.visitContinue(jCContinue);
    }

    public void visitReturn(JCTree.JCReturn jCReturn) {
        this.dumpHead(jCReturn);
        this.out.println();
        super.visitReturn(jCReturn);
    }

    public void visitThrow(JCTree.JCThrow jCThrow) {
        this.dumpHead(jCThrow);
        this.out.println();
        super.visitThrow(jCThrow);
    }

    public void visitAssert(JCTree.JCAssert jCAssert) {
        this.dumpHead(jCAssert);
        this.out.println();
        super.visitAssert(jCAssert);
    }

    public void visitApply(JCTree.JCMethodInvocation jCMethodInvocation) {
        this.dumpHead(jCMethodInvocation);
        this.out.println();
        super.visitApply(jCMethodInvocation);
    }

    public void visitNewClass(JCTree.JCNewClass jCNewClass) {
        this.dumpHead(jCNewClass);
        this.out.println();
        super.visitNewClass(jCNewClass);
    }

    public void visitNewArray(JCTree.JCNewArray jCNewArray) {
        this.dumpHead(jCNewArray);
        this.out.println();
        super.visitNewArray(jCNewArray);
    }

    public void visitParens(JCTree.JCParens jCParens) {
        this.dumpHead(jCParens);
        this.out.println();
        super.visitParens(jCParens);
    }

    public void visitAssign(JCTree.JCAssign jCAssign) {
        this.dumpHead(jCAssign);
        this.out.println();
        super.visitAssign(jCAssign);
    }

    public void visitAssignop(JCTree.JCAssignOp jCAssignOp) {
        this.dumpHead(jCAssignOp);
        this.out.println(jCAssignOp.operator);
        super.visitAssignop(jCAssignOp);
    }

    public void visitUnary(JCTree.JCUnary jCUnary) {
        this.dumpHead(jCUnary);
        this.out.println(jCUnary.operator);
        super.visitUnary(jCUnary);
    }

    public void visitBinary(JCTree.JCBinary jCBinary) {
        this.dumpHead(jCBinary);
        this.out.println(jCBinary.operator);
        super.visitBinary(jCBinary);
    }

    public void visitTypeCast(JCTree.JCTypeCast jCTypeCast) {
        this.dumpHead(jCTypeCast);
        this.out.println();
        super.visitTypeCast(jCTypeCast);
    }

    public void visitTypeTest(JCTree.JCInstanceOf jCInstanceOf) {
        this.dumpHead(jCInstanceOf);
        this.out.println();
        super.visitTypeTest(jCInstanceOf);
    }

    public void visitIndexed(JCTree.JCArrayAccess jCArrayAccess) {
        this.dumpHead(jCArrayAccess);
        this.out.println();
        super.visitIndexed(jCArrayAccess);
    }

    public void visitSelect(JCTree.JCFieldAccess jCFieldAccess) {
        this.dumpHead(jCFieldAccess);
        this.out.println("\"" + jCFieldAccess.name + "\"");
        super.visitSelect(jCFieldAccess);
    }

    public void visitIdent(JCTree.JCIdent jCIdent) {
        this.dumpHead(jCIdent);
        this.out.println("\"" + jCIdent.name + "\"");
        super.visitIdent(jCIdent);
    }

    public void visitLiteral(JCTree.JCLiteral jCLiteral) {
        this.dumpHead(jCLiteral);
        this.out.println(jCLiteral.value);
        super.visitLiteral(jCLiteral);
    }

    public void visitTypeIdent(JCTree.JCPrimitiveTypeTree jCPrimitiveTypeTree) {
        this.dumpHead(jCPrimitiveTypeTree);
        StringBuffer stringBuffer = new StringBuffer();
        DumpScanner.appendTypeTag(stringBuffer, (int)jCPrimitiveTypeTree.typetag);
        this.out.println(stringBuffer + " (" + (int)jCPrimitiveTypeTree.typetag + ")");
        super.visitTypeIdent(jCPrimitiveTypeTree);
    }

    public void visitTypeArray(JCTree.JCArrayTypeTree jCArrayTypeTree) {
        this.dumpHead(jCArrayTypeTree);
        this.out.println();
        super.visitTypeArray(jCArrayTypeTree);
    }

    public void visitTypeApply(JCTree.JCTypeApply jCTypeApply) {
        this.dumpHead(jCTypeApply);
        this.out.println();
        super.visitTypeApply(jCTypeApply);
    }

    public void visitTypeParameter(JCTree.JCTypeParameter jCTypeParameter) {
        this.dumpHead(jCTypeParameter);
        this.out.println();
        super.visitTypeParameter(jCTypeParameter);
    }

    public void visitWildcard(JCTree.JCWildcard jCWildcard) {
        this.dumpHead(jCWildcard);
        this.out.println();
        super.visitWildcard(jCWildcard);
    }

    public void visitAnnotation(JCTree.JCAnnotation jCAnnotation) {
        this.dumpHead(jCAnnotation);
        this.out.println();
        super.visitAnnotation(jCAnnotation);
    }

    public void visitModifiers(JCTree.JCModifiers jCModifiers) {
        this.dumpHead(jCModifiers);
        this.out.println();
        super.visitModifiers(jCModifiers);
    }

    public void visitErroneous(JCTree.JCErroneous jCErroneous) {
        this.dumpHead(jCErroneous);
        this.out.println();
        super.visitErroneous(jCErroneous);
    }
}

