/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.java.source.builder;

import com.sun.tools.javac.util.Context;
import org.netbeans.api.java.source.transform.UndoEntry;
import org.netbeans.api.java.source.transform.UndoList;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class UndoListService
implements UndoList {
    protected static final Context.Key<UndoListService> undolistKey = new Context.Key();
    static final UndoEntry nullUndo = new UndoEntry(){
        {
            this.endCommand = true;
        }

        public void undo() {
            throw new Error("Not Undoable");
        }

        public void redo() {
            throw new Error("Not Redoable");
        }
    };
    UndoEntry undoList = nullUndo;

    public static synchronized UndoListService instance(Context context) {
        UndoListService undoListService = context.get(undolistKey);
        if (undoListService == null) {
            undoListService = new UndoListService();
            UndoListService.setInstance(context, undoListService);
        }
        return undoListService;
    }

    public static void setInstance(Context context, UndoListService undoListService) {
        context.put(undolistKey, undoListService);
    }

    @Override
    public final void add(UndoEntry undoEntry) {
        if (undoEntry == null) {
            return;
        }
        undoEntry.addAfter(this.undoList);
        this.undoList = undoEntry;
    }

    @Override
    public final void addAndApply(UndoEntry undoEntry) {
        this.add(undoEntry);
        undoEntry.redo();
    }

    @Override
    public final void undo() {
        if (this.canUndo()) {
            do {
                this.undoList.undo();
                this.undoList = this.undoList.prev;
            } while (!this.undoList.isEndCommand());
        }
    }

    @Override
    public final void redo() {
        if (this.canRedo()) {
            do {
                this.undoList = this.undoList.next;
                this.undoList.redo();
            } while (this.canRedo() && !this.undoList.isEndCommand());
        }
    }

    @Override
    public final boolean canUndo() {
        return this.undoList != nullUndo;
    }

    @Override
    public final boolean canRedo() {
        return this.undoList.next != null;
    }

    @Override
    public final void setEndCommand(boolean bl) {
        this.undoList.setEndCommand(bl);
    }

    @Override
    public final void clearRedo() {
        this.undoList.next = null;
    }

    @Override
    public final void reset() {
        this.undoList = nullUndo;
        this.undoList.prev = null;
        this.undoList.next = null;
    }

    @Override
    public final boolean atEndCommand() {
        return this.undoList.isEndCommand();
    }

    @Override
    public final <T> T getOld(T t) {
        UndoEntry undoEntry = this.undoList;
        while (undoEntry.prev != null) {
            undoEntry = undoEntry.prev;
        }
        while (undoEntry != null) {
            T t2 = undoEntry.getOld(t);
            if (t2 != null) {
                return t2;
            }
            undoEntry = undoEntry.next;
        }
        return null;
    }
}

