/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.java.source.classpath;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.io.File;
import java.io.IOException;
import java.net.URL;
import java.util.LinkedList;
import java.util.List;
import org.netbeans.api.java.classpath.ClassPath;
import org.netbeans.api.java.platform.JavaPlatform;
import org.netbeans.api.java.platform.JavaPlatformManager;
import org.netbeans.modules.java.source.classpath.GlobalSourcePath;
import org.netbeans.modules.java.source.usages.Index;
import org.netbeans.spi.java.classpath.ClassPathFactory;
import org.netbeans.spi.java.classpath.ClassPathImplementation;
import org.netbeans.spi.java.classpath.PathResourceImplementation;
import org.netbeans.spi.java.classpath.support.ClassPathSupport;
import org.openide.ErrorManager;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.filesystems.URLMapper;
import org.openide.util.WeakListeners;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CacheClassPath
implements ClassPathImplementation,
PropertyChangeListener {
    private final ClassPath cp;
    private final boolean translate;
    private final boolean isBoot;
    private PropertyChangeSupport listeners = new PropertyChangeSupport(this);
    private List<PathResourceImplementation> cache;

    private CacheClassPath(ClassPath classPath, boolean bl, boolean bl2) {
        this.cp = classPath;
        this.translate = bl;
        this.isBoot = bl2;
        this.cp.addPropertyChangeListener(WeakListeners.propertyChange((PropertyChangeListener)this, (Object)classPath));
    }

    public void removePropertyChangeListener(PropertyChangeListener propertyChangeListener) {
        this.listeners.removePropertyChangeListener(propertyChangeListener);
    }

    public void addPropertyChangeListener(PropertyChangeListener propertyChangeListener) {
        this.listeners.addPropertyChangeListener(propertyChangeListener);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
        if ("entries".equals(propertyChangeEvent.getPropertyName())) {
            CacheClassPath cacheClassPath = this;
            synchronized (cacheClassPath) {
                this.cache = null;
            }
            this.listeners.firePropertyChange("resources", null, null);
        }
    }

    public synchronized List<? extends PathResourceImplementation> getResources() {
        block15: {
            if (this.cache != null) break block15;
            List list = this.cp.entries();
            this.cache = new LinkedList<PathResourceImplementation>();
            if (this.isBoot && list.size() == 0) {
                JavaPlatform javaPlatform = JavaPlatformManager.getDefault().getDefaultPlatform();
                assert (javaPlatform != null);
                list = javaPlatform.getBootstrapLibraries().entries();
                assert (list.size() > 0);
                for (ClassPath.Entry entry : list) {
                    this.cache.add(ClassPathSupport.createResource((URL)entry.getURL()));
                }
            } else {
                GlobalSourcePath globalSourcePath = GlobalSourcePath.getDefault();
                for (ClassPath.Entry entry : list) {
                    URL uRL;
                    Object object;
                    URL uRL2 = entry.getURL();
                    URL[] uRLArray = this.translate ? globalSourcePath.getSourceRootForBinaryRoot(uRL2, this.cp, true) : new URL[]{uRL2};
                    if (uRLArray != null) {
                        object = uRLArray;
                        int n = ((URL[])object).length;
                        for (int i = 0; i < n; ++i) {
                            Object object2 = object[i];
                            try {
                                File file = Index.getClassFolder((URL)object2);
                                URL uRL3 = file.toURI().toURL();
                                if (!file.exists()) {
                                    uRL3 = new URL(uRL3.toExternalForm() + "/");
                                }
                                this.cache.add(ClassPathSupport.createResource((URL)uRL3));
                                continue;
                            }
                            catch (IOException iOException) {
                                ErrorManager.getDefault().notify((Throwable)iOException);
                            }
                        }
                        continue;
                    }
                    if ("jar".equals(uRL2.getProtocol())) {
                        FileObject fileObject;
                        object = FileUtil.getArchiveFile((URL)uRL2);
                        if (!"file".equals(((URL)object).getProtocol()) && (fileObject = URLMapper.findFileObject((URL)object)) != null && "file".equals(((URL)(object = URLMapper.findURL((FileObject)fileObject, (int)1))).getProtocol())) {
                            uRL2 = FileUtil.getArchiveRoot((URL)object);
                        }
                    } else if (!"file".equals(uRL2.getProtocol()) && (object = URLMapper.findFileObject((URL)uRL2)) != null && "file".equals((uRL = URLMapper.findURL((FileObject)object, (int)1)).getProtocol())) {
                        uRL2 = uRL;
                    }
                    this.cache.add(ClassPathSupport.createResource((URL)uRL2));
                }
            }
        }
        return this.cache;
    }

    public static ClassPath forClassPath(ClassPath classPath) {
        assert (classPath != null);
        return ClassPathFactory.createClassPath((ClassPathImplementation)new CacheClassPath(classPath, true, false));
    }

    public static ClassPath forBootPath(ClassPath classPath) {
        assert (classPath != null);
        return ClassPathFactory.createClassPath((ClassPathImplementation)new CacheClassPath(classPath, true, true));
    }

    public static ClassPath forSourcePath(ClassPath classPath) {
        assert (classPath != null);
        return ClassPathFactory.createClassPath((ClassPathImplementation)new CacheClassPath(classPath, false, false));
    }
}

