/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.java.source.parsing;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Reader;
import java.io.Writer;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URL;
import java.nio.CharBuffer;
import java.util.Comparator;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import javax.lang.model.element.Modifier;
import javax.lang.model.element.NestingKind;
import javax.tools.JavaFileObject;
import org.netbeans.modules.java.preprocessorbridge.spi.JavaFileFilterImplementation;
import org.netbeans.modules.java.source.parsing.SourceFileObject;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.util.NbBundle;
import org.openide.util.Utilities;

public class FileObjects {
    public static final Comparator<String> SIMPLE_NAME_STRING_COMPARATOR = new SimpleNameStringComparator();
    public static final Comparator<JavaFileObject> SIMPLE_NAME_FILEOBJECT_COMPARATOR = new SimpleNameFileObjectComparator();
    public static final String JAVA = "java";
    public static final String CLASS = "class";
    public static final String JAR = "jar";
    public static final String FILE = "file";
    public static final String ZIP = "zip";
    public static final String HTML = "html";
    public static final String SIG = "sig";
    public static final String RS = "rs";
    static final String encodingName = new OutputStreamWriter(new ByteArrayOutputStream()).getEncoding();

    private FileObjects() {
    }

    public static JavaFileObject zipFileObject(File file, String string, String string2, long l) {
        assert (file != null);
        return new ZipFileObject(file, string, string2, l);
    }

    public static JavaFileObject zipFileObject(ZipFile zipFile, String string, String string2, long l) {
        assert (zipFile != null);
        return new CachedZipFileObject(zipFile, string, string2, l);
    }

    public static JavaFileObject fileFileObject(File file, File file2, JavaFileFilterImplementation javaFileFilterImplementation) {
        assert (file != null);
        assert (file2 != null);
        String[] stringArray = FileObjects.getFolderAndBaseName(FileObjects.getRelativePath(file2, file), File.separatorChar);
        return new RegularFileObject(file, FileObjects.convertFolder2Package(stringArray[0], File.separatorChar), stringArray[1], javaFileFilterImplementation);
    }

    public static JavaFileObject nbFileObject(FileObject fileObject) throws IOException {
        return FileObjects.nbFileObject(fileObject, null, false);
    }

    public static JavaFileObject nbFileObject(FileObject fileObject, JavaFileFilterImplementation javaFileFilterImplementation, boolean bl) throws IOException {
        assert (fileObject != null);
        if (!fileObject.isValid() || fileObject.isVirtual()) {
            throw new InvalidFileException(fileObject);
        }
        return new SourceFileObject(fileObject, javaFileFilterImplementation, bl);
    }

    public static JavaFileObject memoryFileObject(CharSequence charSequence, CharSequence charSequence2) {
        String string = ((Object)charSequence2).toString();
        if (!string.equals(FileObjects.getBaseName(string))) {
            throw new IllegalArgumentException("Memory is flat");
        }
        int n = charSequence.length();
        if (n != 0 && Character.isWhitespace(charSequence.charAt(n - 1))) {
            return new MemoryFileObject(string, CharBuffer.wrap(charSequence));
        }
        return new MemoryFileObject(string, (CharBuffer)CharBuffer.allocate(n + 1).append(charSequence).append(' ').flip());
    }

    public static String stripExtension(String string) {
        int n = string.lastIndexOf(".");
        return n == -1 ? string : string.substring(0, n);
    }

    public static String getName(JavaFileObject javaFileObject, boolean bl) {
        assert (javaFileObject != null);
        if (javaFileObject instanceof Base) {
            Base base = (Base)javaFileObject;
            if (bl) {
                return base.getName();
            }
            StringBuilder stringBuilder = new StringBuilder();
            stringBuilder.append(base.getName());
            stringBuilder.append('.');
            stringBuilder.append(base.getExt());
            return stringBuilder.toString();
        }
        try {
            int n;
            URL uRL = javaFileObject.toUri().toURL();
            String string = uRL.getPath();
            int n2 = string.lastIndexOf(47);
            int n3 = bl ? ((n = string.lastIndexOf(46)) > n2 ? n : string.length()) : string.length();
            string = string.substring(n2 + 1, n3);
            return string;
        }
        catch (MalformedURLException malformedURLException) {
            return null;
        }
    }

    public static String getBaseName(String string) {
        return FileObjects.getBaseName(string, File.separatorChar);
    }

    public static String getBaseName(String string, char c) {
        return FileObjects.getFolderAndBaseName(string, c)[1];
    }

    public static String[] getFolderAndBaseName(String string, char c) {
        int n = string.lastIndexOf(c);
        if (n == -1) {
            return new String[]{"", string};
        }
        return new String[]{string.substring(0, n), string.substring(n + 1)};
    }

    public static String getBinaryName(File file, File file2) {
        assert (file != null && file2 != null);
        String string = FileObjects.getRelativePath(file2, file);
        int n = string.lastIndexOf(46);
        if (n > 0) {
            string = string.substring(0, n);
        }
        return string.replace(File.separatorChar, '.');
    }

    public static String getSimpleName(JavaFileObject javaFileObject) {
        String string = FileObjects.getName(javaFileObject, true);
        int n = string.lastIndexOf(36);
        if (n == -1) {
            return string;
        }
        return string.substring(n + 1);
    }

    public static String getSimpleName(String string) {
        String string2 = FileObjects.getBaseName(string);
        int n = string2.lastIndexOf(36);
        if (n == -1) {
            return string2;
        }
        return string2.substring(n + 1);
    }

    public static String convertPackage2Folder(String string) {
        return string.replace('.', '/');
    }

    public static String convertFolder2Package(String string) {
        return FileObjects.convertFolder2Package(string, '/');
    }

    public static String convertFolder2Package(String string, char c) {
        return string.replace(c, '.');
    }

    public static String getRelativePath(String string, String string2) {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append(string.replace('.', '/'));
        stringBuilder.append(string2);
        return stringBuilder.toString();
    }

    public static String[] getParentRelativePathAndName(String string) {
        if (string.charAt(string.length() - 1) == '.') {
            return null;
        }
        int n = string.lastIndexOf(46);
        if (n < 0) {
            return new String[]{"", string};
        }
        return new String[]{string.substring(0, n).replace('.', '/'), string.substring(n + 1)};
    }

    public static String getRelativePath(File file, File file2) {
        int n;
        String string = file.getAbsolutePath();
        String string2 = file2.getAbsolutePath();
        assert (string2.startsWith(string));
        int n2 = string.length();
        if (string.charAt(n2 - 1) != File.separatorChar) {
            ++n2;
        }
        if ((n = string2.length()) <= n2) {
            return "";
        }
        return string2.substring(n2);
    }

    public static abstract class Base
    implements JavaFileObject {
        protected final JavaFileObject.Kind kind;
        protected final String pkgName;
        protected final String nameWithoutExt;
        protected final String ext;

        protected Base(String string, String string2) {
            assert (string != null);
            assert (string2 != null);
            this.pkgName = string;
            String[] stringArray = Base.getNameExtPair(string2);
            this.nameWithoutExt = stringArray[0];
            this.ext = stringArray[1];
            this.kind = FileObjects.JAVA.equalsIgnoreCase(this.ext) ? JavaFileObject.Kind.SOURCE : (FileObjects.CLASS.equalsIgnoreCase(this.ext) || FileObjects.SIG.equals(this.ext) ? JavaFileObject.Kind.CLASS : (FileObjects.HTML.equalsIgnoreCase(this.ext) ? JavaFileObject.Kind.HTML : JavaFileObject.Kind.OTHER));
        }

        public JavaFileObject.Kind getKind() {
            return this.kind;
        }

        public boolean isNameCompatible(String string, JavaFileObject.Kind kind) {
            if (this.kind != kind) {
                return false;
            }
            return this.nameWithoutExt.equals(string);
        }

        public NestingKind getNestingKind() {
            return null;
        }

        public Modifier getAccessLevel() {
            return null;
        }

        public String toString() {
            return this.toUri().toString();
        }

        public String getPackage() {
            return this.pkgName;
        }

        public String getNameWithoutExtension() {
            return this.nameWithoutExt;
        }

        public String getName() {
            return this.nameWithoutExt + '.' + this.ext;
        }

        public String getExt() {
            return this.ext;
        }

        private static String[] getNameExtPair(String string) {
            String string2;
            String string3;
            int n = string.lastIndexOf(46);
            if (n <= 0) {
                string3 = string;
                string2 = "";
            } else {
                string3 = string.substring(0, n);
                string2 = n == string.length() - 1 ? "" : string.substring(n + 1);
            }
            return new String[]{string3, string2};
        }
    }

    private static class CachedZipFileObject
    extends ZipFileBase {
        private ZipFile zipFile;

        CachedZipFileObject(ZipFile zipFile, String string, String string2, long l) {
            super(string, string2, l);
            assert (zipFile != null) : "archiveFile == null";
            this.zipFile = zipFile;
        }

        public InputStream openInputStream() throws IOException {
            return this.zipFile.getInputStream(new ZipEntry(this.resName));
        }

        public URI getArchiveURI() {
            return new File(this.zipFile.getName()).toURI();
        }

        protected long getSize() throws IOException {
            ZipEntry zipEntry = this.zipFile.getEntry(this.resName);
            return zipEntry == null ? 0L : zipEntry.getSize();
        }
    }

    public static abstract class FileBase
    extends Base {
        protected final File f;

        protected FileBase(File file, String string, String string2) {
            super(string, string2);
            assert (file != null);
            assert (file.equals(FileUtil.normalizeFile((File)file)));
            this.f = file;
        }

        public File getFile() {
            return this.f;
        }
    }

    public static class InvalidFileException
    extends IOException {
        public InvalidFileException() {
        }

        public InvalidFileException(FileObject fileObject) {
            super(NbBundle.getMessage(FileObjects.class, (String)"FMT_InvalidFile", (Object)FileUtil.getFileDisplayName((FileObject)fileObject)));
        }
    }

    private static class MemoryFileObject
    extends Base {
        private String fileName;
        private CharBuffer cb;

        public MemoryFileObject(String string, CharBuffer charBuffer) {
            super("", string);
            this.cb = charBuffer;
            this.fileName = string;
        }

        public CharBuffer getCharContent(boolean bl) throws IOException {
            return this.cb;
        }

        public boolean delete() {
            return false;
        }

        public URI toUri() {
            return URI.create(this.nameWithoutExt);
        }

        public long getLastModified() {
            return System.currentTimeMillis();
        }

        public InputStream openInputStream() throws IOException {
            return new ByteArrayInputStream(this.cb.toString().getBytes("UTF-8"));
        }

        public OutputStream openOutputStream() throws IOException {
            throw new UnsupportedOperationException();
        }

        public Reader openReader(boolean bl) throws IOException {
            throw new UnsupportedOperationException();
        }

        public Writer openWriter() throws IOException {
            throw new UnsupportedOperationException();
        }
    }

    private static class RegularFileObject
    extends FileBase {
        private URI uriCache;
        private final JavaFileFilterImplementation filter;

        public RegularFileObject(File file, String string, String string2, JavaFileFilterImplementation javaFileFilterImplementation) {
            super(file, string, string2);
            this.filter = javaFileFilterImplementation;
        }

        public InputStream openInputStream() throws IOException {
            return new FileInputStream(this.f);
        }

        public Reader openReader(boolean bl) throws IOException {
            throw new UnsupportedOperationException();
        }

        public OutputStream openOutputStream() throws IOException {
            return new FileOutputStream(this.f);
        }

        public Writer openWriter() throws IOException {
            return new OutputStreamWriter(new FileOutputStream(this.f));
        }

        public boolean isNameCompatible(String string, JavaFileObject.Kind kind) {
            boolean bl = super.isNameCompatible(string, kind);
            if (bl) {
                return bl;
            }
            if (Utilities.isWindows()) {
                return this.nameWithoutExt.equalsIgnoreCase(string);
            }
            return false;
        }

        public URI toUri() {
            if (this.uriCache == null) {
                this.uriCache = this.f.toURI();
            }
            return this.uriCache;
        }

        public long getLastModified() {
            return this.f.lastModified();
        }

        public boolean delete() {
            return this.f.delete();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public CharSequence getCharContent(boolean bl) throws IOException {
            char[] cArray;
            InputStreamReader inputStreamReader = new InputStreamReader((InputStream)new FileInputStream(this.f), encodingName);
            try {
                int n;
                int n2 = (int)this.f.length();
                cArray = new char[n2 + 1];
                int n3 = 0;
                while ((n = inputStreamReader.read(cArray, n3, n2 - n3)) > 0 && (n3 += n) < n2) {
                }
            }
            finally {
                inputStreamReader.close();
            }
            cArray[cArray.length - 1] = 10;
            CharSequence charSequence = CharBuffer.wrap(cArray);
            if (this.filter != null) {
                charSequence = this.filter.filterCharSequence(charSequence);
            }
            return charSequence;
        }

        public boolean equals(Object object) {
            if (!(object instanceof RegularFileObject)) {
                return false;
            }
            RegularFileObject regularFileObject = (RegularFileObject)object;
            return this.f.equals(regularFileObject.f);
        }

        public int hashCode() {
            return this.f.hashCode();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class SimpleNameFileObjectComparator
    implements Comparator<JavaFileObject> {
        private SimpleNameFileObjectComparator() {
        }

        @Override
        public int compare(JavaFileObject javaFileObject, JavaFileObject javaFileObject2) {
            String string = FileObjects.getSimpleName(javaFileObject);
            String string2 = FileObjects.getSimpleName(javaFileObject2);
            return string.compareTo(string2);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class SimpleNameStringComparator
    implements Comparator<String> {
        private SimpleNameStringComparator() {
        }

        @Override
        public int compare(String string, String string2) {
            return FileObjects.getSimpleName(string).compareTo(FileObjects.getSimpleName(string2));
        }
    }

    public static abstract class ZipFileBase
    extends Base {
        protected final long mtime;
        protected final String resName;

        public ZipFileBase(String string, String string2, long l) {
            super(FileObjects.convertFolder2Package(string), string2);
            this.mtime = l;
            if (string.length() == 0) {
                this.resName = string2;
            } else {
                StringBuilder stringBuilder = new StringBuilder(string);
                stringBuilder.append('/');
                stringBuilder.append(string2);
                this.resName = stringBuilder.toString();
            }
        }

        public OutputStream openOutputStream() throws IOException {
            throw new UnsupportedOperationException();
        }

        public Reader openReader(boolean bl) throws IOException {
            if (this.getKind() == JavaFileObject.Kind.CLASS) {
                throw new UnsupportedOperationException();
            }
            return new InputStreamReader(this.openInputStream(), encodingName);
        }

        public Writer openWriter() throws IOException {
            throw new UnsupportedOperationException();
        }

        public long getLastModified() {
            return this.mtime;
        }

        public boolean delete() {
            throw new UnsupportedOperationException();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public CharBuffer getCharContent(boolean bl) throws IOException {
            Reader reader = this.openReader(bl);
            try {
                int n;
                int n2 = 0;
                int n3 = (int)this.getSize();
                char[] cArray = new char[n3 + 1];
                while ((n = reader.read(cArray, n2, n3 - n2)) > 0 && (n2 += n) < n3) {
                }
                int n4 = 0;
                for (int i = 0; i < n2; ++i) {
                    if (cArray[i] == '\r') {
                        if (i + 1 < n2 && cArray[i + 1] == '\n') continue;
                        cArray[n4++] = 10;
                        continue;
                    }
                    cArray[n4++] = cArray[i];
                }
                cArray[n4] = 10;
                CharBuffer charBuffer = CharBuffer.wrap(cArray, 0, n4);
                return charBuffer;
            }
            finally {
                reader.close();
            }
        }

        public final URI toUri() {
            URI uRI = this.getArchiveURI();
            return URI.create("jar:" + uRI.toString() + "!/" + this.resName);
        }

        public int hashCode() {
            return this.resName.hashCode();
        }

        public boolean equals(Object object) {
            if (!(object instanceof ZipFileBase)) {
                return false;
            }
            ZipFileBase zipFileBase = (ZipFileBase)object;
            return this.getArchiveURI().equals(zipFileBase.getArchiveURI()) && this.resName.equals(zipFileBase.resName);
        }

        protected abstract URI getArchiveURI();

        protected abstract long getSize() throws IOException;
    }

    private static class ZipFileObject
    extends ZipFileBase {
        private final File archiveFile;

        ZipFileObject(File file, String string, String string2, long l) {
            super(string, string2, l);
            assert (file != null) : "archiveFile == null";
            this.archiveFile = file;
        }

        public InputStream openInputStream() throws IOException {
            ZipFile zipFile = new ZipFile(this.archiveFile);
            class ZipInputStream
            extends InputStream {
                private ZipFile zipfile;
                private InputStream delegate;

                public ZipInputStream(ZipFile zipFile) throws IOException {
                    this.zipfile = zipFile;
                    this.delegate = zipFile.getInputStream(new ZipEntry(ZipFileObject.this.resName));
                }

                public int read() throws IOException {
                    throw new UnsupportedOperationException("Not supported yet.");
                }

                public int read(byte[] byArray, int n, int n2) throws IOException {
                    return this.delegate.read(byArray, n, n2);
                }

                public int available() throws IOException {
                    return this.delegate.available();
                }

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                public void close() throws IOException {
                    try {
                        this.delegate.close();
                    }
                    finally {
                        this.zipfile.close();
                    }
                }
            }
            return new ZipInputStream(zipFile);
        }

        public URI getArchiveURI() {
            return this.archiveFile.toURI();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        protected long getSize() throws IOException {
            ZipFile zipFile = new ZipFile(this.archiveFile);
            try {
                ZipEntry zipEntry = zipFile.getEntry(this.resName);
                long l = zipEntry == null ? 0L : zipEntry.getSize();
                return l;
            }
            finally {
                zipFile.close();
            }
        }
    }
}

