/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.java.source.pretty;

import com.sun.source.tree.ClassTree;
import com.sun.source.tree.MethodTree;
import com.sun.source.tree.Tree;
import com.sun.source.tree.VariableTree;
import com.sun.tools.javac.code.BoundKind;
import com.sun.tools.javac.code.Symbol;
import com.sun.tools.javac.code.Symtab;
import com.sun.tools.javac.code.Type;
import com.sun.tools.javac.code.Types;
import com.sun.tools.javac.tree.JCTree;
import com.sun.tools.javac.tree.TreeInfo;
import com.sun.tools.javac.util.Context;
import com.sun.tools.javac.util.Convert;
import com.sun.tools.javac.util.List;
import com.sun.tools.javac.util.Name;
import java.io.IOException;
import java.io.Writer;
import java.util.Set;
import org.netbeans.api.java.source.Comment;
import org.netbeans.api.java.source.query.CommentHandler;
import org.netbeans.api.java.source.query.CommentSet;
import org.netbeans.modules.java.source.builder.CommentHandlerService;
import org.netbeans.modules.java.source.engine.JavaFormatOptions;
import org.netbeans.modules.java.source.pretty.CharBuffer;
import org.netbeans.modules.java.source.pretty.DanglingElseChecker;
import org.netbeans.modules.java.source.pretty.ImportAnalysis;
import org.netbeans.modules.java.source.pretty.WidthEstimator;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class VeryPretty
extends JCTree.Visitor {
    public JavaFormatOptions options;
    private CharBuffer out;
    boolean cuddleElse;
    private final Name.Table names;
    private CommentHandler commentHandler;
    private final Symtab symbols;
    private final Types types;
    private final TreeInfo treeinfo;
    private boolean packagePrinted;
    private boolean importsPrinted;
    private JCTree selection;
    private int selectionPos;
    private int selectionEndPos;
    public Name enclClassName;
    private static char[] hex = "0123456789ABCDEF".toCharArray();
    private ImportAnalysis imports;
    int prec;
    private final WidthEstimator widthEstimator;
    private Comment pendingAppendComment = null;
    private JCTree lastCommentCheck = null;
    private String body;
    private static final String REPLACEMENT = "%[a-z]*%";
    private final DanglingElseChecker danglingElseChecker = new DanglingElseChecker();

    public VeryPretty(Context context) {
        this(context, JavaFormatOptions.getDefault());
    }

    public VeryPretty(Context context, JavaFormatOptions javaFormatOptions) {
        this.options = javaFormatOptions;
        this.out = new CharBuffer(javaFormatOptions.rightMargin);
        this.cuddleElse = javaFormatOptions.cuddleElse && !javaFormatOptions.cuddleCloseBrace;
        this.names = Name.Table.instance((Context)context);
        this.enclClassName = this.names.empty;
        this.commentHandler = CommentHandlerService.instance(context);
        this.symbols = Symtab.instance(context);
        this.types = Types.instance(context);
        this.treeinfo = TreeInfo.instance((Context)context);
        this.prec = -1;
        this.widthEstimator = new WidthEstimator(context);
        this.selectionPos = -1;
        this.selectionEndPos = -1;
    }

    public String toString() {
        return this.out.toString();
    }

    public void writeTo(Writer writer) throws IOException {
        this.out.writeTo(writer);
    }

    protected void toLeftMargin() {
        this.out.toLeftMargin();
    }

    public void reset(int n) {
        this.out.setLength(0);
        this.out.leftMargin = n;
    }

    public int indent() {
        int n = this.out.leftMargin;
        this.out.leftMargin = n + this.options.indentSize;
        return n;
    }

    public void undent(int n) {
        this.out.leftMargin = n;
    }

    public void setPrec(int n) {
        this.prec = n;
    }

    public void setSelection(JCTree jCTree) {
        this.selection = jCTree;
    }

    public int getSelectionPos() {
        return this.selectionPos;
    }

    public int getSelectionEndPos() {
        return this.selectionEndPos;
    }

    void open(int n, int n2) {
        block5: {
            block4: {
                block2: {
                    block3: {
                        if (!this.options.excessParensAroundConditionals) break block2;
                        if (n2 == 10) break block3;
                        if (n2 != 9) break block2;
                    }
                    if (n > 3) break block4;
                }
                if (n2 >= n) break block5;
            }
            this.print('(');
        }
    }

    void close(int n, int n2) {
        block5: {
            block4: {
                block2: {
                    block3: {
                        if (!this.options.excessParensAroundConditionals) break block2;
                        if (n2 == 10) break block3;
                        if (n2 != 9) break block2;
                    }
                    if (n > 3) break block4;
                }
                if (n2 >= n) break block5;
            }
            this.print(')');
        }
    }

    public void print(String string) {
        if (string == null) {
            return;
        }
        this.out.append(string);
    }

    public final void print(char c) {
        this.out.append(c);
    }

    public final void needSpace() {
        this.out.needSpace();
    }

    public final void print(Name name) {
        this.out.appendUtf8((byte[])name.table.names, name.index, name.len);
    }

    public void printQualified(Symbol symbol) {
        if (!(symbol.owner == null || symbol.owner.name.len <= 0 || symbol.type instanceof Type.TypeVar || this.imports != null && this.imports.imported(symbol) || symbol.owner instanceof Symbol.MethodSymbol)) {
            if (symbol.owner instanceof Symbol.PackageSymbol) {
                this.printAllQualified(symbol.owner);
            } else {
                this.printQualified(symbol.owner);
            }
            this.print('.');
        }
        this.print(symbol.name);
    }

    public void printAllQualified(Symbol symbol) {
        if (symbol.owner != null && symbol.owner.name.len > 0) {
            this.printAllQualified(symbol.owner);
            this.print('.');
        }
        this.print(symbol.name);
    }

    public void printImports() {
        this.printImports(true);
    }

    public void printImports(boolean bl) {
        if (this.imports == null) {
            return;
        }
        this.imports.decideImports();
        int n = 0;
        if (bl && this.imports.containingPackage != null && this.imports.containingPackage != this.symbols.unnamedPackage) {
            this.print("package ");
            this.printAllQualified(this.imports.containingPackage);
            this.print(";\n\n");
            this.packagePrinted = true;
        }
        ImportAnalysis.SymRefStats symRefStats = this.imports.usedClassOwners;
        while (symRefStats != null) {
            if (symRefStats.imported && !symRefStats.implicitlyImported()) {
                this.printImport(symRefStats.clazz, true);
                ++n;
            }
            symRefStats = symRefStats.next;
        }
        symRefStats = this.imports.usedClasses;
        while (symRefStats != null) {
            if (symRefStats.imported && !symRefStats.implicitlyImported() && !this.imports.starred(symRefStats.clazz.owner)) {
                this.printImport(symRefStats.clazz, false);
                ++n;
            }
            symRefStats = symRefStats.next;
        }
        if (n > 0 || bl) {
            this.blankline();
        }
        this.importsPrinted = true;
    }

    public void printImports(Set<Symbol> set) {
        for (Symbol symbol : set) {
            this.printImport(symbol, false);
        }
    }

    private void printImport(Symbol symbol, boolean bl) {
        this.print("import ");
        this.printAllQualified(symbol);
        if (bl) {
            this.print(".*");
        }
        this.print(";\n");
    }

    public void setImports(ImportAnalysis importAnalysis) {
        this.imports = importAnalysis;
        this.widthEstimator.setImports(importAnalysis);
    }

    public ImportAnalysis getImports() {
        return this.imports;
    }

    public void print(JCTree jCTree, Type type) {
        if (type == null || type == Type.noType) {
            this.print(jCTree);
        } else {
            List<Type> list;
            int n = 0;
            while (type instanceof Type.ArrayType) {
                type = ((Type.ArrayType)type).elemtype;
                ++n;
            }
            this.printQualified(type.tsym);
            if (type instanceof Type.ClassType && (list = ((Type.ClassType)type).typarams_field) != null && list.nonEmpty()) {
                int n2 = 60;
                while (list.nonEmpty()) {
                    this.print((char)n2);
                    n2 = 44;
                    this.print(null, (Type)list.head);
                    list = list.tail;
                }
                this.print('>');
            }
            while (--n >= 0) {
                this.print("[]");
            }
        }
    }

    public void print(JCTree jCTree) {
        CommentSet commentSet = this.commentHandler.getComments(jCTree);
        this.printPrecedingComments(commentSet);
        if (jCTree == this.selection) {
            this.selectionPos = this.out.used;
        }
        jCTree.accept(this);
        if (jCTree == this.selection) {
            this.selectionEndPos = this.out.used;
        }
        this.printTrailingComments(commentSet);
    }

    public void printExpr(JCTree jCTree, int n) {
        if (jCTree == null) {
            this.print("/*missing*/");
        } else {
            int n2 = this.prec;
            this.prec = n;
            if (jCTree == this.selection) {
                this.selectionPos = this.out.used;
            }
            jCTree.accept(this);
            if (jCTree == this.selection) {
                this.selectionEndPos = this.out.used;
            }
            this.prec = n2;
        }
    }

    public void printExpr(JCTree jCTree) {
        this.printExpr(jCTree, 0);
    }

    public void printNoParenExpr(JCTree jCTree) {
        while (jCTree instanceof JCTree.JCParens) {
            jCTree = ((JCTree.JCParens)jCTree).expr;
        }
        this.printExpr(jCTree, 0);
    }

    public void printStat(JCTree jCTree) {
        if (jCTree == null) {
            this.print(';');
        } else {
            CommentSet commentSet = this.commentHandler.getComments(jCTree);
            this.printPrecedingComments(commentSet);
            this.printExpr(jCTree, -1);
            int n = jCTree.tag;
            if (26 <= n && n <= 90) {
                this.print(';');
            }
            this.printTrailingComments(commentSet);
        }
    }

    public void printIndentedStat(JCTree jCTree) {
        switch (this.options.redundantBraces.value) {
            case 0: {
                break;
            }
            case 1: {
                List<JCTree.JCStatement> list;
                while (jCTree instanceof JCTree.JCBlock && !(list = ((JCTree.JCBlock)jCTree).stats).isEmpty() && list.tail.isEmpty() && !(list.head instanceof JCTree.JCVariableDecl)) {
                    this.printPrecedingComments(jCTree);
                    jCTree = (JCTree)list.head;
                }
                break;
            }
            case 2: 
            case 3: {
                this.printBlock(jCTree);
                return;
            }
        }
        int n = this.out.leftMargin;
        if (!(jCTree instanceof JCTree.JCBlock)) {
            this.indent();
        }
        if (this.options.sameLineIfFit) {
            int n2 = this.out.harden();
            int n3 = this.out.col;
            int n4 = this.out.used;
            int n5 = this.out.leftMargin;
            try {
                this.needSpace();
                this.printStat(jCTree);
                this.undent(n);
                this.out.restore(n2);
                return;
            }
            catch (Throwable throwable) {
                this.out.restore(n2);
                this.out.col = n3;
                this.out.used = n4;
                this.out.leftMargin = n5;
            }
        }
        if (this.out.hasMargin() || jCTree instanceof JCTree.JCBlock && this.options.cuddleOpenBrace) {
            this.needSpace();
        } else {
            if (this.out.col > 0) {
                this.newline();
            }
            this.out.toLeftMargin();
        }
        this.printStat(jCTree);
        this.undent(n);
    }

    public <T extends JCTree> void printExprs(List<T> list, String string) {
        if (list.nonEmpty()) {
            this.printNoParenExpr((JCTree)list.head);
            List list2 = list.tail;
            while (list2.nonEmpty()) {
                this.print(string);
                this.printNoParenExpr((JCTree)list2.head);
                list2 = list2.tail;
            }
        }
    }

    public <T extends JCTree> void printExprs(List<T> list) {
        this.printExprs(list, ", ");
    }

    public <T extends JCTree> void wrapExprs(List<T> list, String string, int n) {
        if (list.nonEmpty()) {
            boolean bl = true;
            int n2 = this.out.leftMargin;
            this.out.leftMargin = n;
            int n3 = this.options.rightMargin;
            List<Object> list2 = list;
            while (list2.nonEmpty()) {
                if (!bl) {
                    this.print(string);
                    int n4 = this.out.col;
                    if (n4 + this.widthEstimator.estimateWidth((JCTree)list2.head, n3 - n4 + 1) > n3) {
                        this.toColExactly(n);
                    }
                }
                bl = false;
                this.printNoParenExpr((JCTree)list2.head);
                list2 = list2.tail;
            }
            this.out.leftMargin = n2;
        }
    }

    public <T extends JCTree> void wrapExprs(List<T> list, String string) {
        this.wrapExprs(list, string, this.out.leftMargin + this.options.continuationIndent);
    }

    public <T extends JCTree> void wrapExprs(List<T> list) {
        this.wrapExprs(list, ", ");
    }

    public <T extends JCTree> void wrapExprs(List<T> list, int n) {
        this.wrapExprs(list, ", ", n);
    }

    public <T extends JCTree> void printStats(List<T> list) {
        this.printStats(list, -2);
    }

    public <T extends JCTree> void printStats(List<T> list, int n) {
        boolean bl = false;
        boolean bl2 = true;
        List<Object> list2 = list;
        while (list2.nonEmpty()) {
            JCTree jCTree = (JCTree)list2.head;
            if (!VeryPretty.isSynthetic(jCTree, n)) {
                boolean bl3;
                boolean bl4 = bl3 = jCTree instanceof JCTree.JCVariableDecl || jCTree instanceof JCTree.JCMethodDecl || jCTree instanceof JCTree.JCClassDecl;
                if (!bl2 && (this.options.blankLineBeforeInlineDeclarations && bl3 && !bl || this.options.blankLineAfterDeclarations && !bl3 && bl)) {
                    this.blankline();
                }
                this.toColExactly(this.out.leftMargin);
                this.printStat(jCTree);
                bl2 = false;
                bl = bl3;
            }
            list2 = list2.tail;
        }
    }

    private static boolean isSynthetic(JCTree jCTree, int n) {
        return Tree.Kind.METHOD == jCTree.getKind() && (((JCTree.JCMethodDecl)jCTree).mods.flags & 0x1000000000L) != 0L;
    }

    public void printAnnotations(List<JCTree.JCAnnotation> list) {
        while (!list.isEmpty()) {
            this.printNoParenExpr((JCTree)list.head);
            if (list.tail != null) {
                this.newline();
                this.toColExactly(this.out.leftMargin);
            } else {
                this.needSpace();
            }
            list = list.tail;
        }
    }

    public void printFlags(long l) {
        this.print(TreeInfo.flagNames(l));
        if ((l & 0xFFFL) != 0L) {
            this.needSpace();
        }
    }

    protected void printPrecedingComments(CommentSet commentSet) {
        if (!commentSet.hasComments()) {
            return;
        }
        for (Comment comment : commentSet.getPrecedingComments()) {
            this.printComment(comment, false, this.options.moveAppendedComments);
        }
    }

    protected void printTrailingComments(CommentSet commentSet) {
        if (!commentSet.hasComments()) {
            return;
        }
        for (Comment comment : commentSet.getTrailingComments()) {
            this.printComment(comment, true, false);
        }
    }

    public void printPrecedingComments(JCTree jCTree) {
        if (jCTree == this.lastCommentCheck) {
            return;
        }
        this.lastCommentCheck = jCTree;
        if (this.pendingAppendComment != null) {
            this.printComment(this.pendingAppendComment, true, false);
            this.pendingAppendComment = null;
        }
        if (this.commentHandler != null) {
            CommentSet commentSet = this.commentHandler.getComments(jCTree);
            this.printPrecedingComments(commentSet);
        }
    }

    public void newline() {
        if (this.pendingAppendComment != null) {
            this.printComment(this.pendingAppendComment, true, false);
            this.pendingAppendComment = null;
        }
        this.out.nlTerm();
    }

    public void blankline() {
        this.newline();
        this.out.blankline();
    }

    public void toColExactly(int n) {
        if (n < this.out.col) {
            this.newline();
        }
        this.out.toCol(n);
    }

    public void printComment(Comment comment, boolean bl, boolean bl2) {
        boolean bl3;
        int n;
        int n2;
        this.body = comment.getText();
        int n3 = comment.indent();
        int n4 = -1;
        int n5 = 0;
        CommentLine commentLine = null;
        CommentLine commentLine2 = null;
        int n6 = this.body.length();
        block11: for (n2 = 0; n2 < n6; ++n2) {
            char c = this.body.charAt(n2);
            switch (c) {
                default: {
                    if (n4 < 0) {
                        n4 = n2;
                    }
                    n5 = n2 + 1;
                    continue block11;
                }
                case '\t': {
                    if (n4 >= 0) continue block11;
                    n3 = n3 + 8 & 0xFFFFFFF8;
                    continue block11;
                }
                case ' ': 
                case '*': 
                case '/': {
                    if (n4 >= 0) continue block11;
                    ++n3;
                    continue block11;
                }
                case '\n': {
                    int n7 = n = n4 < 0 ? 0 : n2 - n4;
                    if (n > 0 || commentLine != null) {
                        CommentLine commentLine3 = new CommentLine(n3, n4, n);
                        if (commentLine2 == null) {
                            commentLine = commentLine3;
                        } else {
                            commentLine2.next = commentLine3;
                        }
                        commentLine2 = commentLine3;
                    }
                    n4 = -1;
                    n3 = 0;
                }
            }
        }
        if (n4 >= 0 && n4 < n6) {
            CommentLine commentLine4 = new CommentLine(n3, n4, n5 - n4);
            if (commentLine2 == null) {
                commentLine = commentLine4;
            } else {
                commentLine2.next = commentLine4;
            }
        }
        if (commentLine == null) {
            return;
        }
        n2 = 99999;
        CommentLine commentLine5 = commentLine;
        while (commentLine5 != null) {
            if (commentLine5.length > 0 && commentLine5.startColumn < n2) {
                n2 = commentLine5.startColumn;
            }
            commentLine5 = commentLine5.next;
        }
        commentLine5 = commentLine;
        while (commentLine5 != null) {
            if (commentLine5.length > 0) {
                commentLine5.startColumn -= n2;
            }
            commentLine5 = commentLine5.next;
        }
        n = ((bl3 = comment.isDocComment()) ? this.options.docCommentStyle : (commentLine.next == null ? this.options.smallCommentStyle : this.options.blockCommentStyle)).value;
        int n8 = this.out.col;
        boolean bl4 = true;
        int n9 = this.out.leftMargin;
        if (bl) {
            return;
        }
        if (this.options.blankLineBeforeAllComments || this.options.blankLineBeforeDocComments && bl3) {
            this.out.blankline();
        }
        if (!bl3) {
            n9 -= this.options.unindentDisplace;
        }
        switch (n) {
            case 0: {
                CommentLine commentLine6 = commentLine;
                while (commentLine6 != null) {
                    this.out.toColExactly(n9);
                    this.out.append(bl4 ? (bl3 ? "/**" : "/*") : " *");
                    bl4 = false;
                    commentLine6.print(n9 + 3);
                    if (commentLine6.next == null) {
                        this.out.append(" */");
                    }
                    this.out.nlTerm();
                    commentLine6 = commentLine6.next;
                }
                break;
            }
            case 1: {
                this.out.toColExactly(n9);
                this.out.append(bl3 ? "/**" : "/*");
                CommentLine commentLine7 = commentLine;
                while (commentLine7 != null) {
                    this.out.toColExactly(n9 + 1);
                    this.out.append("*");
                    commentLine7.print(n9 + 3);
                    this.out.nlTerm();
                    commentLine7 = commentLine7.next;
                }
                this.out.toColExactly(n9 + 1);
                this.out.append("*/");
                this.out.nlTerm();
                break;
            }
            case 2: {
                int n10 = 0;
                CommentLine commentLine8 = commentLine;
                while (commentLine8 != null) {
                    int n11 = commentLine8.length + commentLine8.startColumn;
                    if (n11 > n10) {
                        n10 = n11;
                    }
                    commentLine8 = commentLine8.next;
                }
                this.out.toColExactly(n9);
                this.out.append(bl3 ? "/**" : "/* ");
                int n12 = n10 + 2;
                while (--n12 >= 0) {
                    this.out.append('*');
                }
                this.out.nlTerm();
                CommentLine commentLine9 = commentLine;
                while (commentLine9 != null) {
                    this.out.toColExactly(n9);
                    this.out.append(" *");
                    commentLine9.print(n9 + 3);
                    this.out.toCol(n9 + n10 + 4);
                    this.out.append('*');
                    this.out.nlTerm();
                    commentLine9 = commentLine9.next;
                }
                this.out.toColExactly(n9 + 1);
                int n13 = n10 + 4;
                while (--n13 >= 0) {
                    this.out.append('*');
                }
                this.out.append('/');
                this.out.nlTerm();
                break;
            }
            case 3: {
                CommentLine commentLine10 = commentLine;
                while (commentLine10 != null) {
                    this.out.toColExactly(n9);
                    this.out.append(bl4 && bl3 ? "//*" : "//");
                    bl4 = false;
                    commentLine10.print(n9 + 3);
                    this.out.nlTerm();
                    commentLine10 = commentLine10.next;
                }
                break;
            }
        }
        this.out.nlTerm();
        this.out.toLeftMargin();
    }

    public void printTypeParameters(List<JCTree.JCTypeParameter> list) {
        if (list.nonEmpty()) {
            this.print('<');
            this.printExprs(list);
            this.print('>');
        }
    }

    public void printBlock(List<? extends JCTree> list) {
        this.printBlock(list, -2);
    }

    public void printBlock(List<? extends JCTree> list, int n) {
        int n2;
        int n3 = n2 = this.indent();
        if (this.options.indBracesHalfway) {
            n3 += this.options.indentSize >> 1;
        } else if (this.options.indBracesInner) {
            n3 = this.out.leftMargin;
        }
        this.out.toCol(n3);
        this.needSpace();
        this.print('{');
        if (!list.isEmpty()) {
            this.newline();
        }
        this.printStats(list, n);
        this.undent(n2);
        if (this.options.cuddleCloseBrace) {
            this.print(" }");
        } else {
            this.toColExactly(n3);
            this.print('}');
        }
    }

    public void printBlock(JCTree jCTree) {
        List<JCTree> list = jCTree instanceof JCTree.JCBlock ? ((JCTree.JCBlock)jCTree).stats : List.of(jCTree);
        this.printBlock(list);
    }

    public void printUnit(JCTree.JCCompilationUnit jCCompilationUnit) {
        if (!this.packagePrinted) {
            this.printPrecedingComments(jCCompilationUnit);
            if (jCCompilationUnit.pid != null) {
                this.print("package ");
                this.printExpr(jCCompilationUnit.pid);
                this.print(';');
                this.newline();
            }
            this.packagePrinted = true;
        }
        List<JCTree> list = jCCompilationUnit.defs;
        while (list.nonEmpty() && ((JCTree)list.head).tag == 2) {
            if (!this.importsPrinted) {
                this.printStat((JCTree)list.head);
                this.newline();
            }
            list = list.tail;
        }
        this.importsPrinted = true;
        while (list.nonEmpty()) {
            this.printStat((JCTree)list.head);
            this.newline();
            list = list.tail;
        }
    }

    private Name fullName(JCTree jCTree) {
        switch (jCTree.tag) {
            case 35: {
                return ((JCTree.JCIdent)jCTree).name;
            }
            case 34: {
                JCTree.JCFieldAccess jCFieldAccess = (JCTree.JCFieldAccess)jCTree;
                Name name = this.fullName(jCFieldAccess.selected);
                return name != null && name.len > 0 ? name.append('.', jCFieldAccess.name) : jCFieldAccess.name;
            }
        }
        return null;
    }

    @Override
    public void visitTopLevel(JCTree.JCCompilationUnit jCCompilationUnit) {
        this.printUnit(jCCompilationUnit);
    }

    @Override
    public void visitImport(JCTree.JCImport jCImport) {
        if (!this.importsPrinted) {
            this.print("import ");
            if (jCImport.staticImport) {
                this.print("static ");
            }
            this.print(this.fullName(jCImport.qualid));
            this.print(';');
        }
    }

    @Override
    public void visitClassDef(JCTree.JCClassDecl jCClassDecl) {
        this.out.toLeftMargin();
        Name name = this.enclClassName;
        this.enclClassName = jCClassDecl.name;
        this.printClassHeader(jCClassDecl);
        this.needSpace();
        this.printClassBody(jCClassDecl);
        this.enclClassName = name;
    }

    protected void printClassHeader(JCTree.JCClassDecl jCClassDecl) {
        long l;
        this.printAnnotations(jCClassDecl.mods.annotations);
        long l2 = l = jCClassDecl.sym != null ? jCClassDecl.sym.flags() : jCClassDecl.mods.flags;
        if ((l & 0x4000L) != 0L) {
            this.printFlags(l & 0xFFFFFFFFFFFFFDE7L);
        } else {
            this.printFlags(l & 0xFFFFFFFFFFFFF9FFL);
        }
        if ((l & 0x200L) != 0L || (l & 0x2000L) != 0L) {
            if ((l & 0x2000L) != 0L) {
                this.print('@');
            }
            this.print("interface ");
            this.print(jCClassDecl.name);
            this.printTypeParameters(jCClassDecl.typarams);
            if (jCClassDecl.implementing.nonEmpty()) {
                this.print(" extends ");
                this.wrapExprs(jCClassDecl.implementing);
            }
        } else {
            if ((l & 0x4000L) != 0L) {
                this.print("enum ");
            } else {
                if ((l & 0x400L) != 0L) {
                    this.print("abstract ");
                }
                this.print("class ");
            }
            this.print(jCClassDecl.name);
            this.printTypeParameters(jCClassDecl.typarams);
            if (jCClassDecl.extending != null) {
                this.print(" extends ");
                this.print(jCClassDecl.extending, jCClassDecl.sym != null ? this.types.supertype(jCClassDecl.sym.type) : null);
            }
            if (jCClassDecl.implementing.nonEmpty()) {
                this.print(" implements ");
                this.wrapExprs(jCClassDecl.implementing, this.out.col);
            }
        }
    }

    protected void printClassBody(JCTree.JCClassDecl jCClassDecl) {
        if ((jCClassDecl.mods.flags & 0x4000L) != 0L) {
            this.printEnumBody(jCClassDecl.defs, jCClassDecl.pos);
        } else {
            this.printBlock(jCClassDecl.defs, jCClassDecl.pos);
        }
    }

    public void printEnumBody(List<JCTree> list, int n) {
        int n2;
        int n3 = n2 = this.indent();
        if (this.options.indBracesHalfway) {
            n3 += this.options.indentSize >> 1;
        } else if (this.options.indBracesInner) {
            n3 = this.out.leftMargin;
        }
        this.out.toCol(n3);
        this.needSpace();
        this.print("{");
        if (!list.isEmpty()) {
            this.newline();
        }
        boolean bl = true;
        boolean bl2 = false;
        List<JCTree> list2 = list;
        while (list2.nonEmpty()) {
            if (this.isEnumerator((JCTree)list2.head)) {
                if (!bl) {
                    this.print(", ");
                    if (this.options.blankLineBeforeInlineDeclarations || this.options.blankLineAfterDeclarations) {
                        this.blankline();
                    }
                }
                this.toColExactly(this.out.leftMargin);
                this.printStat((JCTree)list2.head);
                bl = false;
            } else if (!VeryPretty.isSynthetic((JCTree)list2.head, n)) {
                bl2 = true;
            }
            list2 = list2.tail;
        }
        if (bl2) {
            this.print(";");
            this.newline();
        }
        list2 = list;
        while (list2.nonEmpty()) {
            JCTree jCTree = (JCTree)list2.head;
            if (!this.isEnumerator(jCTree) && !VeryPretty.isSynthetic(jCTree, n)) {
                this.toColExactly(this.out.leftMargin);
                this.printStat(jCTree);
                this.newline();
            }
            list2 = list2.tail;
        }
        this.undent(n2);
        if (this.options.cuddleCloseBrace) {
            this.print(" }");
        } else {
            this.toColExactly(n3);
            this.print('}');
        }
    }

    protected boolean isEnumerator(JCTree jCTree) {
        return jCTree.tag == 5 && (((JCTree.JCVariableDecl)jCTree).mods.flags & 0x4000L) != 0L;
    }

    protected final boolean isMethodPrintable(JCTree.JCMethodDecl jCMethodDecl) {
        return (jCMethodDecl.mods.flags & 0x1000L) == 0L && jCMethodDecl.name != this.names.init || this.enclClassName != null;
    }

    @Override
    public void visitMethodDef(JCTree.JCMethodDecl jCMethodDecl) {
        if (this.isMethodPrintable(jCMethodDecl)) {
            if (this.options.blankLineBeforeMethods) {
                this.blankline();
            }
            this.out.toLeftMargin();
            this.printMethodHeader(jCMethodDecl);
            this.needSpace();
            this.printMethodBody(jCMethodDecl);
        }
    }

    private String replace(String string, String string2) {
        string = string.replace(string2, this.out.toString());
        this.out.clear();
        return string;
    }

    public String getMethodHeader(MethodTree methodTree, String string) {
        JCTree.JCMethodDecl jCMethodDecl = (JCTree.JCMethodDecl)methodTree;
        this.printAnnotations(jCMethodDecl.mods.annotations);
        string = this.replace(string, "%annotations");
        this.printFlags(jCMethodDecl.mods.flags);
        string = this.replace(string, "%flags%");
        if (jCMethodDecl.name == this.names.init) {
            this.print(this.enclClassName);
            string = this.replace(string, "%name%");
        } else {
            if (jCMethodDecl.typarams != null) {
                this.printTypeParameters(jCMethodDecl.typarams);
                this.needSpace();
                string = this.replace(string, "%typeparameters%");
            }
            this.print(jCMethodDecl.restype, jCMethodDecl.sym != null && jCMethodDecl.sym.type != null ? jCMethodDecl.sym.type.getReturnType() : null);
            string = this.replace(string, "%type%");
            if (this.options.methodNamesStartLine) {
                this.newline();
                this.out.toLeftMargin();
            } else {
                this.needSpace();
            }
            this.out.clear();
            this.print(jCMethodDecl.name);
            string = this.replace(string, "%name%");
        }
        this.print('(');
        this.wrapExprs(jCMethodDecl.params, this.out.col);
        this.print(')');
        string = this.replace(string, "%parameters%");
        if (jCMethodDecl.thrown.nonEmpty()) {
            this.print(" throws ");
            this.wrapExprs(jCMethodDecl.thrown, this.out.col);
            string = this.replace(string, "%throws%");
        }
        return string.replaceAll(REPLACEMENT, "");
    }

    public String getClassHeader(ClassTree classTree, String string) {
        long l;
        JCTree.JCClassDecl jCClassDecl = (JCTree.JCClassDecl)classTree;
        this.printAnnotations(jCClassDecl.mods.annotations);
        string = this.replace(string, "%annotations");
        long l2 = l = jCClassDecl.sym != null ? jCClassDecl.sym.flags() : jCClassDecl.mods.flags;
        if ((l & 0x4000L) != 0L) {
            this.printFlags(l & 0xFFFFFFFFFFFFFDE7L);
        } else {
            this.printFlags(l & 0xFFFFFFFFFFFFF9FFL);
        }
        string = this.replace(string, "%flags%");
        if ((l & 0x200L) != 0L) {
            this.print("interface ");
            this.print(jCClassDecl.name);
            string = this.replace(string, "%name%");
            this.printTypeParameters(jCClassDecl.typarams);
            string = this.replace(string, "%typeparameters%");
            if (jCClassDecl.implementing.nonEmpty()) {
                this.print(" extends ");
                this.wrapExprs(jCClassDecl.implementing);
                string = this.replace(string, "%extends%");
            }
        } else {
            if ((l & 0x4000L) != 0L) {
                this.print("enum ");
            } else {
                if ((l & 0x400L) != 0L) {
                    this.print("abstract ");
                }
                this.print("class ");
            }
            this.print(jCClassDecl.name);
            string = this.replace(string, "%name%");
            this.printTypeParameters(jCClassDecl.typarams);
            string = this.replace(string, "%typeparameters%");
            if (jCClassDecl.extending != null) {
                this.print(" extends ");
                this.print(jCClassDecl.extending, jCClassDecl.sym != null ? this.types.supertype(jCClassDecl.sym.type) : null);
                string = this.replace(string, "%extends%");
            }
            if (jCClassDecl.implementing.nonEmpty()) {
                this.print(" implements ");
                this.wrapExprs(jCClassDecl.implementing, this.out.col);
                string = this.replace(string, "%implements%");
            }
        }
        return string.replaceAll(REPLACEMENT, "");
    }

    public String getVariableHeader(VariableTree variableTree, String string) {
        JCTree.JCVariableDecl jCVariableDecl = (JCTree.JCVariableDecl)variableTree;
        this.printAnnotations(jCVariableDecl.mods.annotations);
        string = this.replace(string, "%annotations");
        this.printFlags(jCVariableDecl.mods.flags);
        string = this.replace(string, "%flags%");
        Type type = jCVariableDecl.type != null ? jCVariableDecl.type : jCVariableDecl.vartype.type;
        this.print(jCVariableDecl.vartype, type);
        string = this.replace(string, "%type%");
        this.needSpace();
        this.print(jCVariableDecl.name);
        string = this.replace(string, "%name%");
        return string.replaceAll(REPLACEMENT, "");
    }

    protected void printMethodHeader(JCTree.JCMethodDecl jCMethodDecl) {
        this.printAnnotations(jCMethodDecl.mods.annotations);
        this.printFlags(jCMethodDecl.mods.flags);
        if (jCMethodDecl.name == this.names.init) {
            this.print(this.enclClassName);
        } else {
            if (jCMethodDecl.typarams != null) {
                this.printTypeParameters(jCMethodDecl.typarams);
                this.needSpace();
            }
            this.print(jCMethodDecl.restype, jCMethodDecl.sym != null && jCMethodDecl.sym.type != null ? jCMethodDecl.sym.type.getReturnType() : null);
            if (this.options.methodNamesStartLine) {
                this.newline();
                this.out.toLeftMargin();
            } else {
                this.needSpace();
            }
            this.print(jCMethodDecl.name);
        }
        this.print('(');
        this.wrapExprs(jCMethodDecl.params, this.out.col);
        this.print(')');
        if (jCMethodDecl.thrown.nonEmpty()) {
            this.print(" throws ");
            this.wrapExprs(jCMethodDecl.thrown, this.out.col);
        }
    }

    protected void printMethodBody(JCTree.JCMethodDecl jCMethodDecl) {
        if (jCMethodDecl.body != null) {
            boolean bl = jCMethodDecl.name == this.names.init;
            List<JCTree.JCStatement> list = jCMethodDecl.body.stats;
            JCTree jCTree = (JCTree)list.head;
            if (jCTree instanceof JCTree.JCExpressionStatement) {
                jCTree = ((JCTree.JCExpressionStatement)jCTree).expr;
            }
            if (bl && jCTree instanceof JCTree.JCMethodInvocation) {
                JCTree.JCMethodInvocation jCMethodInvocation = (JCTree.JCMethodInvocation)jCTree;
                if (jCMethodInvocation.args.isEmpty() && jCMethodInvocation.meth instanceof JCTree.JCIdent) {
                    Name name;
                    JCTree.JCIdent jCIdent = (JCTree.JCIdent)jCMethodInvocation.meth;
                    Name name2 = name = jCIdent.sym == null ? jCIdent.name : jCIdent.sym.name;
                    if (name == this.names.init) {
                        list = list.tail;
                    }
                }
            }
            this.printBlock(list);
        } else {
            this.print(';');
        }
    }

    @Override
    public void visitVarDef(JCTree.JCVariableDecl jCVariableDecl) {
        if (this.commentHandler != null && this.commentHandler.hasComments(jCVariableDecl) && this.prec == -1) {
            this.newline();
            this.out.toLeftMargin();
        }
        if ((jCVariableDecl.mods.flags & 0x4000L) != 0L) {
            this.print(jCVariableDecl.name);
        } else {
            this.printVarHeader(jCVariableDecl);
            this.printVarBody(jCVariableDecl);
        }
    }

    protected void printVarHeader(JCTree.JCVariableDecl jCVariableDecl) {
        Type type;
        this.printAnnotations(jCVariableDecl.mods.annotations);
        this.printFlags(jCVariableDecl.mods.flags);
        Type type2 = type = jCVariableDecl.type != null ? jCVariableDecl.type : jCVariableDecl.vartype.type;
        if ((jCVariableDecl.mods.flags & 0x400000000L) != 0L) {
            this.printExpr(((JCTree.JCArrayTypeTree)jCVariableDecl.vartype).elemtype);
            this.print("...");
        } else {
            this.print(jCVariableDecl.vartype, type);
        }
        this.needSpace();
        this.print(jCVariableDecl.name);
    }

    protected void printVarBody(JCTree.JCVariableDecl jCVariableDecl) {
        if (jCVariableDecl.init != null) {
            this.print(" = ");
            this.printNoParenExpr(jCVariableDecl.init);
        }
        if (this.prec == -1) {
            this.print(';');
        }
    }

    @Override
    public void visitSkip(JCTree.JCSkip jCSkip) {
        this.print(';');
    }

    @Override
    public void visitBlock(JCTree.JCBlock jCBlock) {
        this.printFlags(jCBlock.flags);
        this.printBlock(jCBlock.stats);
    }

    @Override
    public void visitDoLoop(JCTree.JCDoWhileLoop jCDoWhileLoop) {
        this.print("do ");
        this.printIndentedStat(jCDoWhileLoop.body);
        this.out.toLeftMargin();
        this.needSpace();
        this.print("while (");
        this.printNoParenExpr(jCDoWhileLoop.cond);
        this.print(");");
    }

    @Override
    public void visitWhileLoop(JCTree.JCWhileLoop jCWhileLoop) {
        this.print("while (");
        this.printNoParenExpr(jCWhileLoop.cond);
        this.print(") ");
        this.printIndentedStat(jCWhileLoop.body);
    }

    @Override
    public void visitForLoop(JCTree.JCForLoop jCForLoop) {
        this.print("for (");
        if (jCForLoop.init.nonEmpty()) {
            if (((JCTree.JCStatement)jCForLoop.init.head).tag == 5) {
                this.printNoParenExpr((JCTree)jCForLoop.init.head);
                List list = jCForLoop.init.tail;
                while (list.nonEmpty()) {
                    JCTree.JCVariableDecl jCVariableDecl = (JCTree.JCVariableDecl)list.head;
                    this.print(", " + jCVariableDecl.name + " = ");
                    this.printNoParenExpr(jCVariableDecl.init);
                    list = list.tail;
                }
            } else {
                this.printExprs(jCForLoop.init);
            }
        }
        this.print(';');
        if (jCForLoop.cond != null) {
            this.print(' ');
            this.printNoParenExpr(jCForLoop.cond);
        }
        this.print(';');
        if (jCForLoop.step.nonEmpty()) {
            this.print(' ');
            this.printExprs(jCForLoop.step);
        }
        this.print(") ");
        this.printIndentedStat(jCForLoop.body);
    }

    @Override
    public void visitLabelled(JCTree.JCLabeledStatement jCLabeledStatement) {
        this.print(jCLabeledStatement.label);
        this.print(": ");
        this.printIndentedStat(jCLabeledStatement.body);
    }

    @Override
    public void visitSwitch(JCTree.JCSwitch jCSwitch) {
        this.print("switch (");
        this.printNoParenExpr(jCSwitch.selector);
        this.print(") {\n");
        this.printStats(jCSwitch.cases);
        this.toColExactly(this.out.leftMargin);
        this.print('}');
    }

    @Override
    public void visitCase(JCTree.JCCase jCCase) {
        this.toColExactly(this.out.leftMargin + this.options.caseInd);
        if (jCCase.pat == null) {
            this.print("default");
        } else {
            this.print("case ");
            this.printNoParenExpr(jCCase.pat);
        }
        this.print(':');
        this.newline();
        int n = this.indent();
        this.printStats(jCCase.stats);
        this.undent(n);
    }

    @Override
    public void visitSynchronized(JCTree.JCSynchronized jCSynchronized) {
        this.print("synchronized (");
        this.printNoParenExpr(jCSynchronized.lock);
        this.print(") ");
        this.printBlock(jCSynchronized.body);
    }

    @Override
    public void visitTry(JCTree.JCTry jCTry) {
        this.print("try ");
        this.printBlock(jCTry.body);
        List<JCTree.JCCatch> list = jCTry.catchers;
        while (list.nonEmpty()) {
            this.printStat((JCTree)list.head);
            list = list.tail;
        }
        if (jCTry.finalizer != null) {
            this.toColExactly(this.out.leftMargin);
            this.print("finally ");
            this.printBlock(jCTry.finalizer);
        }
    }

    @Override
    public void visitCatch(JCTree.JCCatch jCCatch) {
        this.toColExactly(this.out.leftMargin);
        this.print("catch (");
        this.printNoParenExpr(jCCatch.param);
        this.print(") ");
        this.printBlock(jCCatch.body);
    }

    @Override
    public void visitConditional(JCTree.JCConditional jCConditional) {
        block6: {
            block5: {
                int n = 0;
                if (this.options.forceCondExprWrap) {
                    JCTree.JCConditional jCConditional2 = jCConditional;
                    while (true) {
                        int n2;
                        if ((n2 = this.widthEstimator.estimateWidth(jCConditional2.cond, 40)) > n) {
                            n = n2;
                        }
                        if (!(jCConditional2.falsepart instanceof JCTree.JCConditional)) break;
                        jCConditional2 = (JCTree.JCConditional)jCConditional2.falsepart;
                    }
                    if (n >= 40) {
                        n = this.options.continuationIndent;
                    }
                }
                this.open(this.prec, 3);
                int n3 = this.out.col;
                while (true) {
                    this.printExpr(jCConditional.cond, 3 - 1);
                    this.out.toColExactly(n3 + n + 1);
                    this.print("? ");
                    this.printExpr(jCConditional.truepart, 3);
                    if (!this.options.forceCondExprWrap) break block5;
                    if (!(jCConditional.falsepart instanceof JCTree.JCConditional)) break;
                    jCConditional = (JCTree.JCConditional)jCConditional.falsepart;
                    this.toColExactly(n3 - 3);
                    this.print(" : ");
                }
                this.toColExactly(n3 + n + 1);
                break block6;
            }
            this.needSpace();
        }
        this.print(": ");
        this.printExpr(jCConditional.falsepart, 3);
        this.close(this.prec, 3);
    }

    @Override
    public void visitIf(JCTree.JCIf jCIf) {
        boolean bl;
        this.print("if (");
        this.printNoParenExpr(jCIf.cond);
        this.print(")");
        boolean bl2 = bl = jCIf.thenpart instanceof JCTree.JCBlock || this.options.redundantBraces.value >= 2;
        if (jCIf.elsepart != null && this.danglingElseChecker.hasDanglingElse(jCIf.thenpart)) {
            this.printBlock(jCIf.thenpart);
            bl = true;
        } else {
            this.printIndentedStat(jCIf.thenpart);
        }
        if (jCIf.elsepart != null) {
            if (bl && this.cuddleElse) {
                this.needSpace();
            } else {
                this.toColExactly(this.out.leftMargin);
            }
            this.needSpace();
            this.print("else");
            if (jCIf.elsepart instanceof JCTree.JCIf && this.options.cuddleElseIf) {
                this.needSpace();
                this.printStat(jCIf.elsepart);
            } else {
                this.printIndentedStat(jCIf.elsepart);
            }
        }
    }

    @Override
    public void visitExec(JCTree.JCExpressionStatement jCExpressionStatement) {
        this.printNoParenExpr(jCExpressionStatement.expr);
        if (this.prec == -1) {
            this.print(';');
        }
    }

    @Override
    public void visitBreak(JCTree.JCBreak jCBreak) {
        this.print("break");
        if (jCBreak.label != null) {
            this.needSpace();
            this.print(jCBreak.label);
        }
        this.print(';');
    }

    @Override
    public void visitContinue(JCTree.JCContinue jCContinue) {
        this.print("continue");
        if (jCContinue.label != null) {
            this.needSpace();
            this.print(jCContinue.label);
        }
        this.print(';');
    }

    @Override
    public void visitReturn(JCTree.JCReturn jCReturn) {
        this.print("return");
        if (jCReturn.expr != null) {
            this.needSpace();
            this.printNoParenExpr(jCReturn.expr);
        }
        this.print(';');
    }

    @Override
    public void visitThrow(JCTree.JCThrow jCThrow) {
        this.print("throw ");
        this.printNoParenExpr(jCThrow.expr);
        this.print(';');
    }

    @Override
    public void visitAssert(JCTree.JCAssert jCAssert) {
        this.print("assert ");
        this.printExpr(jCAssert.cond);
        if (jCAssert.detail != null) {
            this.print(" : ");
            this.printExpr(jCAssert.detail);
        }
        this.print(';');
    }

    private void printTypeArguments(List<? extends JCTree.JCExpression> list) {
        if (list.size() > 0) {
            this.print('<');
            this.printExprs(list);
            this.print('>');
        }
    }

    @Override
    public void visitApply(JCTree.JCMethodInvocation jCMethodInvocation) {
        if (!jCMethodInvocation.typeargs.isEmpty()) {
            int n = this.prec;
            this.prec = 15;
            if (jCMethodInvocation.meth.tag == 34) {
                JCTree.JCFieldAccess jCFieldAccess = (JCTree.JCFieldAccess)jCMethodInvocation.meth;
                this.printExpr(jCFieldAccess.selected);
                this.print('.');
                this.printTypeArguments(jCMethodInvocation.typeargs);
                this.print(jCFieldAccess.name.toString());
            } else {
                this.printTypeArguments(jCMethodInvocation.typeargs);
                this.printExpr(jCMethodInvocation.meth);
            }
            this.prec = n;
        } else {
            this.printExpr(jCMethodInvocation.meth, 15);
        }
        this.print('(');
        this.wrapExprs(jCMethodInvocation.args, this.out.col);
        this.print(')');
    }

    @Override
    public void visitNewClass(JCTree.JCNewClass jCNewClass) {
        if (jCNewClass.encl != null) {
            this.printExpr(jCNewClass.encl);
            this.print('.');
        }
        this.print("new ");
        if (!jCNewClass.typeargs.isEmpty()) {
            this.print("<");
            this.printExprs(jCNewClass.typeargs);
            this.print(">");
        }
        if (jCNewClass.encl == null) {
            this.print(jCNewClass.clazz, jCNewClass.clazz.type);
        } else if (jCNewClass.clazz.type != null) {
            this.print(jCNewClass.clazz.type.tsym.name);
        } else {
            this.print(jCNewClass.clazz);
        }
        this.print('(');
        this.wrapExprs(jCNewClass.args, this.out.col);
        this.print(')');
        if (jCNewClass.def != null) {
            Name name = this.enclClassName;
            this.enclClassName = null;
            this.printBlock(jCNewClass.def.defs);
            this.enclClassName = name;
        }
    }

    @Override
    public void visitNewArray(JCTree.JCNewArray jCNewArray) {
        if (jCNewArray.elemtype != null) {
            this.print("new ");
            int n = jCNewArray.elems != null ? 1 : 0;
            JCTree.JCExpression jCExpression = jCNewArray.elemtype;
            while (jCExpression.tag == 38) {
                ++n;
                jCExpression = ((JCTree.JCArrayTypeTree)jCExpression).elemtype;
            }
            this.printExpr(jCExpression);
            List<JCTree.JCExpression> list = jCNewArray.dims;
            while (list.nonEmpty()) {
                this.print('[');
                this.printNoParenExpr((JCTree)list.head);
                this.print(']');
                --n;
                list = list.tail;
            }
            while (--n >= 0) {
                this.print("[]");
            }
        }
        if (jCNewArray.elems != null) {
            this.print("{");
            this.wrapExprs(jCNewArray.elems);
            this.print('}');
        }
    }

    @Override
    public void visitParens(JCTree.JCParens jCParens) {
        this.print('(');
        this.printExpr(jCParens.expr);
        this.print(')');
    }

    @Override
    public void visitAssign(JCTree.JCAssign jCAssign) {
        this.open(this.prec, 1);
        this.printExpr(jCAssign.lhs, 1 + 1);
        this.print(" = ");
        this.printExpr(jCAssign.rhs, 1);
        this.close(this.prec, 1);
    }

    @Override
    public void visitAssignop(JCTree.JCAssignOp jCAssignOp) {
        this.open(this.prec, 2);
        this.printExpr(jCAssignOp.lhs, 2 + 1);
        this.print(" ");
        this.print(this.treeinfo.operatorName(jCAssignOp.tag - 17));
        this.print("= ");
        this.printExpr(jCAssignOp.rhs, 2);
        this.close(this.prec, 2);
    }

    @Override
    public void visitUnary(JCTree.JCUnary jCUnary) {
        int n = TreeInfo.opPrec((int)jCUnary.tag);
        Name name = this.treeinfo.operatorName(jCUnary.tag);
        this.open(this.prec, n);
        if (jCUnary.tag <= 51) {
            this.print(name);
            this.printExpr(jCUnary.arg, n);
        } else {
            this.printExpr(jCUnary.arg, n);
            this.print(name);
        }
        this.close(this.prec, n);
    }

    @Override
    public void visitBinary(JCTree.JCBinary jCBinary) {
        int n;
        int n2 = TreeInfo.opPrec((int)jCBinary.tag);
        Name name = this.treeinfo.operatorName(jCBinary.tag);
        this.open(this.prec, n2);
        int n3 = this.out.col;
        this.printExpr(jCBinary.lhs, n2);
        int n4 = this.options.spaceOperatorsBelow.value;
        if (n2 <= n4) {
            this.needSpace();
        }
        this.print(name);
        if (n2 <= n4) {
            this.needSpace();
        }
        if (this.out.col + this.widthEstimator.estimateWidth(jCBinary.rhs, (n = this.options.rightMargin) - this.out.col) > n) {
            this.out.toColExactly(n3);
        }
        this.printExpr(jCBinary.rhs, n2 + 1);
        this.close(this.prec, n2);
    }

    @Override
    public void visitTypeCast(JCTree.JCTypeCast jCTypeCast) {
        this.open(this.prec, 14);
        this.print('(');
        this.print(jCTypeCast.clazz, jCTypeCast.clazz.type);
        this.print(") ");
        this.printExpr(jCTypeCast.expr, 14);
        this.close(this.prec, 14);
    }

    @Override
    public void visitTypeTest(JCTree.JCInstanceOf jCInstanceOf) {
        this.open(this.prec, 10);
        this.printExpr(jCInstanceOf.expr, 10);
        this.print(" instanceof ");
        this.print(jCInstanceOf.clazz, jCInstanceOf.clazz.type);
        this.close(this.prec, 10);
    }

    @Override
    public void visitIndexed(JCTree.JCArrayAccess jCArrayAccess) {
        this.printExpr(jCArrayAccess.indexed, 15);
        this.print('[');
        this.printExpr(jCArrayAccess.index);
        this.print(']');
    }

    @Override
    public void visitSelect(JCTree.JCFieldAccess jCFieldAccess) {
        if (jCFieldAccess.sym instanceof Symbol.ClassSymbol) {
            this.print(null, jCFieldAccess.type);
        } else {
            this.printExpr(jCFieldAccess.selected, 15);
            this.print('.');
            this.print(jCFieldAccess.sym == null ? jCFieldAccess.name : jCFieldAccess.sym.name);
        }
    }

    @Override
    public void visitIdent(JCTree.JCIdent jCIdent) {
        if (jCIdent.sym instanceof Symbol.ClassSymbol) {
            this.print(null, jCIdent.type);
        } else {
            Name name;
            Name name2 = name = jCIdent.sym == null ? jCIdent.name : jCIdent.sym.name;
            if (name == this.names.init) {
                this.print(jCIdent.name);
            } else {
                this.print(name);
            }
        }
    }

    @Override
    public void visitLiteral(JCTree.JCLiteral jCLiteral) {
        switch (jCLiteral.typetag) {
            case 4: {
                this.print(jCLiteral.value.toString());
                break;
            }
            case 5: {
                this.print(jCLiteral.value.toString() + "L");
                break;
            }
            case 6: {
                this.print(jCLiteral.value.toString() + "F");
                break;
            }
            case 7: {
                this.print(jCLiteral.value.toString());
                break;
            }
            case 2: {
                this.print("'" + Convert.quote(String.valueOf((char)((Number)jCLiteral.value).intValue())) + "'");
                break;
            }
            case 10: {
                this.print("\"" + Convert.quote((String)jCLiteral.value) + "\"");
                break;
            }
            case 8: {
                this.print(jCLiteral.getValue().toString());
                break;
            }
            case 17: {
                this.print("null");
                break;
            }
            default: {
                this.print(jCLiteral.value.toString());
            }
        }
    }

    @Override
    public void visitTypeIdent(JCTree.JCPrimitiveTypeTree jCPrimitiveTypeTree) {
        this.print(this.symbols.typeOfTag[jCPrimitiveTypeTree.typetag].tsym.name);
    }

    @Override
    public void visitTypeArray(JCTree.JCArrayTypeTree jCArrayTypeTree) {
        this.printExpr(jCArrayTypeTree.elemtype);
        this.print("[]");
    }

    @Override
    public void visitTypeApply(JCTree.JCTypeApply jCTypeApply) {
        this.printExpr(jCTypeApply.clazz);
        this.print('<');
        this.printExprs(jCTypeApply.arguments);
        this.print('>');
    }

    @Override
    public void visitTypeParameter(JCTree.JCTypeParameter jCTypeParameter) {
        this.print(jCTypeParameter.name);
        if (jCTypeParameter.bounds.nonEmpty()) {
            this.print(" extends ");
            this.printExprs(jCTypeParameter.bounds, " & ");
        }
    }

    @Override
    public void visitWildcard(JCTree.JCWildcard jCWildcard) {
        this.print("" + jCWildcard.kind);
        if (jCWildcard.kind != BoundKind.UNBOUND) {
            this.printExpr(jCWildcard.inner);
        }
    }

    @Override
    public void visitModifiers(JCTree.JCModifiers jCModifiers) {
        this.printAnnotations(jCModifiers.annotations);
        this.printFlags(jCModifiers.flags);
    }

    @Override
    public void visitAnnotation(JCTree.JCAnnotation jCAnnotation) {
        this.print("@");
        this.printExpr(jCAnnotation.annotationType);
        if (jCAnnotation.args.nonEmpty()) {
            this.print("(");
            this.printExprs(jCAnnotation.args);
            this.print(")");
        }
    }

    @Override
    public void visitForeachLoop(JCTree.JCEnhancedForLoop jCEnhancedForLoop) {
        this.print("for (");
        this.printExpr(jCEnhancedForLoop.getVariable());
        this.print(" : ");
        this.printExpr(jCEnhancedForLoop.getExpression());
        this.print(") ");
        this.printIndentedStat(jCEnhancedForLoop.getStatement());
    }

    @Override
    public void visitLetExpr(JCTree.LetExpr letExpr) {
        this.print("(let " + letExpr.defs + " in " + letExpr.expr + ")");
    }

    @Override
    public void visitErroneous(JCTree.JCErroneous jCErroneous) {
        this.print("(ERROR)");
    }

    @Override
    public void visitTree(JCTree jCTree) {
        this.print("(UNKNOWN: " + jCTree + ")");
        this.newline();
    }

    class CommentLine {
        int startColumn;
        int startPos;
        int length;
        CommentLine next;

        CommentLine(int n, int n2, int n3) {
            this.length = n3;
            if (this.length == 0) {
                this.startColumn = 0;
                this.startPos = 0;
            } else {
                this.startColumn = n;
                this.startPos = n2;
            }
        }

        public void print(int n) {
            if (this.length > 0) {
                VeryPretty.this.out.toCol(n);
                int n2 = this.startPos + this.length;
                for (int i = this.startPos; i < n2; ++i) {
                    VeryPretty.this.out.append(VeryPretty.this.body.charAt(i));
                }
            }
        }
    }
}

