/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.java.source.save;

import com.sun.source.tree.CompilationUnitTree;
import com.sun.source.tree.Tree;
import com.sun.tools.javac.code.Symbol;
import com.sun.tools.javac.code.Symtab;
import com.sun.tools.javac.code.Types;
import com.sun.tools.javac.tree.JCTree;
import com.sun.tools.javac.tree.TreeInfo;
import com.sun.tools.javac.util.Context;
import com.sun.tools.javac.util.List;
import com.sun.tools.javac.util.Name;
import com.sun.tools.javac.util.Options;
import java.io.BufferedReader;
import java.io.CharArrayReader;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.StringReader;
import java.io.StringWriter;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.Set;
import java.util.TreeSet;
import java.util.logging.Logger;
import java.util.prefs.Preferences;
import javax.swing.text.BadLocationException;
import org.netbeans.api.java.lexer.JavaTokenId;
import org.netbeans.api.java.source.WorkingCopy;
import org.netbeans.api.java.source.query.Query;
import org.netbeans.api.java.source.query.QueryEnvironment;
import org.netbeans.api.lexer.TokenSequence;
import org.netbeans.modules.java.source.engine.ASTModel;
import org.netbeans.modules.java.source.engine.EngineEnvironment;
import org.netbeans.modules.java.source.engine.ExternalModificationException;
import org.netbeans.modules.java.source.engine.PropertySheetInfo;
import org.netbeans.modules.java.source.engine.ReadOnlyFilesException;
import org.netbeans.modules.java.source.engine.RootTree;
import org.netbeans.modules.java.source.engine.SourceReader;
import org.netbeans.modules.java.source.engine.SourceRewriter;
import org.netbeans.modules.java.source.pretty.ImportAnalysis;
import org.netbeans.modules.java.source.pretty.VeryPretty;
import org.netbeans.modules.java.source.save.CasualDiff;
import org.netbeans.modules.java.source.save.SourceBuffer;
import org.netbeans.modules.java.source.save.TokenList;
import org.netbeans.modules.java.source.save.TokenUtilities;
import org.netbeans.modules.java.source.save.TreeDiff;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Commit
extends Query<Void, Object> {
    boolean displayedError = false;
    Context context;
    ASTModel model;
    Symtab symtab;
    Types types;
    int lastMargin;
    private EngineEnvironment ee;
    private boolean fixImports;
    private boolean forceReformat;
    private static final int POSITION_OFFSET = 1;
    private ArrayList<String> readOnlyFiles = new ArrayList();
    private static final Logger logger = Logger.getLogger("org.netbeans.modules.java.source");
    private WorkingCopy workingCopy;
    private TokenSequence<JavaTokenId> tokenSequence;

    public Commit() {
        Preferences preferences = Preferences.userRoot().node(this.getClass().getName().replace('.', '/'));
        this.fixImports = preferences.getBoolean("fixImports", false);
        this.forceReformat = preferences.getBoolean("forceReformat", false);
    }

    public Commit(WorkingCopy workingCopy) {
        this();
        this.workingCopy = workingCopy;
        this.tokenSequence = workingCopy.getTokenHierarchy().tokenSequence();
    }

    public boolean isEnabled(QueryEnvironment queryEnvironment) {
        return queryEnvironment.getUndoList().getOld(queryEnvironment.getRootNode()) != null;
    }

    @Override
    public void attach(QueryEnvironment queryEnvironment) {
        super.attach(queryEnvironment);
        this.ee = (EngineEnvironment)queryEnvironment;
        this.context = this.ee.getContext();
        this.symtab = this.ee.getSymbolTable();
        this.types = Types.instance(this.context);
        this.model = ((EngineEnvironment)queryEnvironment).getModel();
    }

    @Override
    public void apply() {
        throw new AssertionError((Object)"use commit() instead");
    }

    public void commit() throws IOException {
        if (this.getOriginalRoot() != this.getRootNode()) {
            PropertySheetInfo.find(Commit.class).loadValues(this);
            Options options = Options.instance(this.context);
            this.apply(this.getRootNode());
            if (this.readOnlyFiles.size() > 0) {
                this.throwReadOnlyFilesException();
            }
        }
    }

    private void throwReadOnlyFilesException() throws IOException {
        StringBuffer stringBuffer = new StringBuffer();
        for (String string : this.readOnlyFiles) {
            stringBuffer.append(string);
            stringBuffer.append('\n');
        }
        throw new ReadOnlyFilesException(stringBuffer.toString());
    }

    private RootTree getOriginalRoot() {
        RootTree rootTree;
        RootTree rootTree2 = (RootTree)this.getRootNode();
        while ((rootTree = this.env.getUndoList().getOld(rootTree2)) != null) {
            rootTree2 = rootTree;
        }
        return rootTree2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Void visitCompilationUnit(CompilationUnitTree compilationUnitTree, Object object) {
        JCTree.JCCompilationUnit jCCompilationUnit = (JCTree.JCCompilationUnit)compilationUnitTree;
        if (!this.isModified(jCCompilationUnit)) {
            return null;
        }
        SourceRewriter sourceRewriter = null;
        String string = jCCompilationUnit.sourcefile.toString();
        boolean bl = this.forceReformat;
        bl = false;
        boolean bl2 = true;
        try {
            sourceRewriter = ((EngineEnvironment)this.env).getSourceRewriter(compilationUnitTree.getSourceFile());
        }
        catch (FileNotFoundException fileNotFoundException) {
            logger.warning("couldn't open original file: " + string);
            bl = true;
        }
        catch (ExternalModificationException externalModificationException) {
            this.note("source file modified, reformatting: " + string);
            bl = true;
        }
        catch (IOException iOException) {
            logger.warning("couldn't write to original file: " + string);
            this.readOnlyFiles.add(string);
            return null;
        }
        logger.fine("original file: " + string);
        try {
            if (bl) {
                this.reformat(jCCompilationUnit, sourceRewriter);
            } else {
                this.commit(jCCompilationUnit, sourceRewriter);
            }
            logger.info("Saved " + string);
        }
        catch (IOException iOException) {
            this.logError(iOException, jCCompilationUnit);
            this.displayedError = true;
            bl2 = false;
        }
        catch (Throwable throwable) {
            this.error(throwable);
        }
        finally {
            block24: {
                if (sourceRewriter != null) {
                    try {
                        sourceRewriter.close(bl2);
                    }
                    catch (IOException iOException) {
                        if (this.displayedError) break block24;
                        this.logError(iOException, jCCompilationUnit);
                    }
                }
            }
        }
        return null;
    }

    private void logError(IOException iOException, JCTree.JCCompilationUnit jCCompilationUnit) {
        Throwable throwable = iOException.getCause() == null ? iOException : iOException.getCause();
        throwable.printStackTrace();
        String string = "Error writing " + Commit.getSourceFileName(jCCompilationUnit) + ": " + throwable;
        try {
            logger.severe(string);
            string = null;
        }
        catch (Throwable throwable2) {
            // empty catch block
        }
        if (string != null) {
            this.error(string);
        }
    }

    public void reformat(JCTree.JCCompilationUnit jCCompilationUnit, SourceRewriter sourceRewriter) throws IOException, BadLocationException {
        PrettyPrinter prettyPrinter = new PrettyPrinter(this.context);
        ImportAnalysis importAnalysis = new ImportAnalysis(prettyPrinter.options.starThreshold, prettyPrinter.options.useThreshold, jCCompilationUnit, this.symtab, this.types);
        importAnalysis.decideImports();
        prettyPrinter.setImports(importAnalysis);
        if (importAnalysis.containingClass != null) {
            prettyPrinter.enclClassName = importAnalysis.containingClass.name;
        }
        prettyPrinter.printUnit(jCCompilationUnit);
        sourceRewriter.writeTo(prettyPrinter.toString());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void commit(CompilationUnitTree compilationUnitTree, SourceRewriter sourceRewriter) throws IOException, BadLocationException {
        JCTree.JCCompilationUnit jCCompilationUnit = (JCTree.JCCompilationUnit)compilationUnitTree;
        CharArrayReader charArrayReader = null;
        try {
            TreeDiff.Diff diff;
            String string = jCCompilationUnit.sourcefile.toString();
            SourceBuffer sourceBuffer = new SourceBuffer(jCCompilationUnit.sourcefile);
            charArrayReader = new SourceReader(sourceBuffer.getChars());
            JCTree.JCCompilationUnit jCCompilationUnit2 = (JCTree.JCCompilationUnit)this.getOriginalTree(jCCompilationUnit);
            List<TreeDiff.Diff> list = "jackpot-orig".equals(System.getProperty("generatorType")) ? TreeDiff.diff(this.context, this.workingCopy, jCCompilationUnit2, jCCompilationUnit) : CasualDiff.diff(this.context, this.workingCopy, jCCompilationUnit2, jCCompilationUnit);
            TokenList tokenList = TokenList.scan(this.context, string, sourceBuffer);
            PrettyPrinter prettyPrinter = new PrettyPrinter(this.context);
            List<JCTree> list2 = jCCompilationUnit2.defs;
            while (list.nonEmpty() && (list2.head == null || ((TreeDiff.Diff)list.head).pos < ((JCTree)list2.head).pos || ((TreeDiff.Diff)list.head).oldTree instanceof JCTree.JCCompilationUnit)) {
                diff = (TreeDiff.Diff)list.head;
                if (diff.type != TreeDiff.DiffTypes.INSERT_COMMENT && diff.type != TreeDiff.DiffTypes.MODIFY_COMMENT && diff.type != TreeDiff.DiffTypes.DELETE_COMMENT) break;
                this.applyCommentDiff(diff, (SourceReader)charArrayReader, sourceRewriter, prettyPrinter, jCCompilationUnit2, sourceBuffer);
                list = list.tail;
            }
            while (list.nonEmpty()) {
                prettyPrinter.reset(0);
                diff = (TreeDiff.Diff)list.head;
                if (this.shouldApplyDiff(diff)) {
                    switch (diff.type) {
                        case INSERT: {
                            sourceRewriter.copyTo((SourceReader)charArrayReader, diff.getPos());
                            this.insertNewTree(diff, (SourceReader)charArrayReader, sourceRewriter, prettyPrinter, diff.pos, sourceBuffer);
                            break;
                        }
                        case MODIFY: {
                            this.applyModifyDiff(diff, (SourceReader)charArrayReader, sourceRewriter, prettyPrinter, jCCompilationUnit2, sourceBuffer);
                            break;
                        }
                        case DELETE: {
                            this.removeOldTree(diff, (SourceReader)charArrayReader, sourceRewriter, jCCompilationUnit2, sourceBuffer);
                            break;
                        }
                        case NAME: {
                            Commit.changeName((TreeDiff.NameDiff)diff, (SourceReader)charArrayReader, sourceRewriter);
                            break;
                        }
                        case FLAGS: {
                            this.changeFlags((TreeDiff.FlagsDiff)diff, (SourceReader)charArrayReader, sourceRewriter, tokenList);
                            break;
                        }
                        case INSERT_OFFSET: {
                            TreeDiff.OffsetDiff offsetDiff = (TreeDiff.OffsetDiff)diff;
                            sourceRewriter.copyTo((SourceReader)charArrayReader, offsetDiff.getStartOffset());
                            if (offsetDiff.getHead() != null) {
                                sourceRewriter.writeTo(offsetDiff.getHead());
                            }
                            if (diff.getNew() != null) {
                                this.insertNewTree(diff, (SourceReader)charArrayReader, sourceRewriter, prettyPrinter, diff.pos, sourceBuffer);
                            }
                            if (offsetDiff.getTail() == null) break;
                            sourceRewriter.writeTo(offsetDiff.getTail());
                            break;
                        }
                        case DELETE_OFFSET: {
                            TreeDiff.OffsetDiff offsetDiff = (TreeDiff.OffsetDiff)diff;
                            sourceRewriter.copyTo((SourceReader)charArrayReader, offsetDiff.getStartOffset());
                            sourceRewriter.skipThrough((SourceReader)charArrayReader, offsetDiff.getEndOffset());
                            break;
                        }
                        case INSERT_TOKEN: {
                            sourceRewriter.copyTo((SourceReader)charArrayReader, diff.getPos());
                            TreeDiff.TokenDiff tokenDiff = (TreeDiff.TokenDiff)diff;
                            if (tokenDiff.getPreceding() != null) {
                                sourceRewriter.writeTo(tokenDiff.getPreceding());
                            }
                            if (TreeDiff.ListType.PARAMETER == tokenDiff.getItemType()) {
                                prettyPrinter.printExpr(diff.getNew(), 0);
                                sourceRewriter.writeTo(prettyPrinter.toString());
                            } else {
                                this.insertNewTree(diff, (SourceReader)charArrayReader, sourceRewriter, prettyPrinter, diff.pos, sourceBuffer);
                            }
                            if (tokenDiff.getTail() == null) break;
                            sourceRewriter.writeTo(tokenDiff.getTail());
                            break;
                        }
                        case DELETE_TOKEN: {
                            int n;
                            int n2 = diff.getOld().getStartPosition();
                            int n3 = this.getOldEndPos(diff.getOld(), jCCompilationUnit2, sourceBuffer);
                            TreeDiff.TokenDiff tokenDiff = (TreeDiff.TokenDiff)diff;
                            if (tokenDiff.getPreceding() != null && (n = TokenUtilities.moveBackToToken(this.tokenSequence, n2, tokenDiff.getPreceding())) > 0) {
                                n2 = n;
                            }
                            if (tokenDiff.getTail() != null && (n = TokenUtilities.moveFwdToToken(this.tokenSequence, n3, tokenDiff.getTail())) > 0) {
                                n3 = n + this.tokenSequence.token().length();
                            }
                            if (((SourceReader)charArrayReader).getPos() < n2) {
                                sourceRewriter.copyTo((SourceReader)charArrayReader, n2);
                            }
                            sourceRewriter.skipThrough((SourceReader)charArrayReader, n3);
                            break;
                        }
                        case MODIFY_TOKEN: {
                            if (diff.getNew() != null && diff.getOld() != null) {
                                int n = this.removeOldTree(diff, (SourceReader)charArrayReader, sourceRewriter, jCCompilationUnit2, sourceBuffer);
                                if (TreeDiff.ListType.PARAMETER == ((TreeDiff.TokenDiff)diff).getItemType()) {
                                    prettyPrinter.printExpr(diff.getNew(), 0);
                                    sourceRewriter.writeTo(prettyPrinter.toString());
                                    break;
                                }
                                this.insertNewTree(diff, (SourceReader)charArrayReader, sourceRewriter, prettyPrinter, n, sourceBuffer);
                                break;
                            }
                            TreeDiff.TokenDiff tokenDiff = (TreeDiff.TokenDiff)diff;
                            if (tokenDiff.getNew() == null && tokenDiff.getOld() != null) {
                                if (tokenDiff.getPreceding() != null) {
                                    TokenUtilities.movePrevious(this.tokenSequence, tokenDiff.getOld().getStartPosition());
                                }
                                sourceRewriter.copyTo((SourceReader)charArrayReader, this.tokenSequence.offset());
                                if (tokenDiff.getTail() != null) {
                                    TokenUtilities.moveNext(this.tokenSequence, diff.getPos());
                                    this.tokenSequence.moveNext();
                                    this.tokenSequence.movePrevious();
                                }
                                sourceRewriter.skipThrough((SourceReader)charArrayReader, this.tokenSequence.offset() + this.tokenSequence.token().length());
                                break;
                            }
                            sourceRewriter.copyTo((SourceReader)charArrayReader, diff.getPos());
                            prettyPrinter.print(tokenDiff.getPreceding());
                            prettyPrinter.print(tokenDiff.getNew());
                            prettyPrinter.print(";\n\n");
                            sourceRewriter.writeTo(prettyPrinter.toString());
                            break;
                        }
                        case INSERT_COMMENT: 
                        case MODIFY_COMMENT: 
                        case DELETE_COMMENT: {
                            this.applyCommentDiff(diff, (SourceReader)charArrayReader, sourceRewriter, prettyPrinter, jCCompilationUnit2, sourceBuffer);
                            break;
                        }
                        default: {
                            throw new AssertionError((Object)("unknown TreeDiff type: " + (Object)((Object)diff.type)));
                        }
                    }
                }
                list = list.tail;
            }
            sourceRewriter.copyRest((SourceReader)charArrayReader);
        }
        finally {
            if (charArrayReader != null) {
                charArrayReader.close();
            }
        }
    }

    private void applyModifyDiff(TreeDiff.Diff diff, SourceReader sourceReader, SourceRewriter sourceRewriter, PrettyPrinter prettyPrinter, JCTree.JCCompilationUnit jCCompilationUnit, SourceBuffer sourceBuffer) throws IOException, BadLocationException {
        if (diff.oldTree.getKind() == Tree.Kind.IF && diff.newTree.getKind() == Tree.Kind.IF) {
            JCTree.JCIf jCIf = (JCTree.JCIf)diff.oldTree;
            JCTree.JCIf jCIf2 = (JCTree.JCIf)diff.newTree;
            if (jCIf.elsepart == null && jCIf2.elsepart != null) {
                int n = this.getOldEndPos(jCIf, jCCompilationUnit, sourceBuffer);
                sourceRewriter.copyTo(sourceReader, n);
                this.setIndent(prettyPrinter, n, sourceBuffer);
                if (jCIf2.elsepart.getKind() == Tree.Kind.BLOCK && prettyPrinter.options.cuddleElse) {
                    prettyPrinter.print(' ');
                } else {
                    prettyPrinter.blankline();
                    prettyPrinter.toLeftMargin();
                }
                prettyPrinter.print("else ");
                jCIf2.elsepart.accept(prettyPrinter);
                sourceRewriter.writeTo(prettyPrinter.toString());
                return;
            }
            if (jCIf.elsepart != null && jCIf2.elsepart == null) {
                int n = this.getOldEndPos(jCIf.thenpart, jCCompilationUnit, sourceBuffer);
                sourceRewriter.copyTo(sourceReader, n);
                sourceRewriter.skipThrough(sourceReader, this.getOldEndPos(jCIf, jCCompilationUnit, sourceBuffer));
                return;
            }
        }
        int n = this.removeOldTree(diff, sourceReader, sourceRewriter, jCCompilationUnit, sourceBuffer);
        this.insertNewTree(diff, sourceReader, sourceRewriter, prettyPrinter, n, sourceBuffer);
    }

    private void applyCommentDiff(TreeDiff.Diff diff, SourceReader sourceReader, SourceRewriter sourceRewriter, PrettyPrinter prettyPrinter, JCTree.JCCompilationUnit jCCompilationUnit, SourceBuffer sourceBuffer) throws IOException, BadLocationException {
        int n = diff.oldComment != null ? diff.oldComment.pos() : this.getOldPos(diff.oldTree);
        int n2 = diff.oldComment != null ? diff.oldComment.endPos() : this.getOldEndPos(diff.oldTree, jCCompilationUnit, sourceBuffer);
        sourceRewriter.copyTo(sourceReader, n);
        if (diff.type == TreeDiff.DiffTypes.INSERT_COMMENT) {
            sourceRewriter.writeTo(diff.newComment.getText());
        } else if (diff.type == TreeDiff.DiffTypes.MODIFY_COMMENT) {
            sourceRewriter.skipThrough(sourceReader, n2);
            sourceRewriter.writeTo(diff.newComment.getText());
        } else if (diff.type == TreeDiff.DiffTypes.DELETE_COMMENT) {
            sourceRewriter.skipThrough(sourceReader, n2);
        }
        if (diff.newLine == TreeDiff.LineInsertionType.BEFORE) {
            this.setIndent(prettyPrinter, n, sourceBuffer);
            prettyPrinter.blankline();
            prettyPrinter.toLeftMargin();
            sourceRewriter.writeTo(prettyPrinter.toString());
        }
    }

    private boolean shouldApplyDiff(TreeDiff.Diff diff) {
        JCTree jCTree = diff.getOld();
        if (jCTree == null) {
            jCTree = diff.getNew();
        }
        return !this.fixImports || diff.type == TreeDiff.DiffTypes.FLAGS || jCTree.tag != 2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void insertNewTree(TreeDiff.Diff diff, SourceReader sourceReader, SourceRewriter sourceRewriter, PrettyPrinter prettyPrinter, int n, SourceBuffer sourceBuffer) throws IOException, BadLocationException {
        boolean bl = diff.type != TreeDiff.DiffTypes.NAME && diff.type != TreeDiff.DiffTypes.FLAGS;
        prettyPrinter.setPrintBody(bl);
        this.setIndent(prettyPrinter, n, sourceBuffer);
        if (diff.newLine == TreeDiff.LineInsertionType.BEFORE) {
            prettyPrinter.blankline();
            prettyPrinter.toLeftMargin();
        }
        Name name = prettyPrinter.enclClassName;
        try {
            if (diff.owningClassName != null) {
                prettyPrinter.enclClassName = diff.owningClassName;
            }
            diff.getNew().accept(prettyPrinter);
        }
        finally {
            prettyPrinter.enclClassName = name;
        }
        if (diff.newLine == TreeDiff.LineInsertionType.AFTER) {
            prettyPrinter.newline();
            prettyPrinter.toLeftMargin();
        }
        sourceRewriter.writeTo(prettyPrinter.toString());
    }

    private int removeOldTree(TreeDiff.Diff diff, SourceReader sourceReader, SourceRewriter sourceRewriter, JCTree.JCCompilationUnit jCCompilationUnit, SourceBuffer sourceBuffer) throws IOException, BadLocationException {
        JCTree jCTree = diff.getOld();
        int n = this.getOldPos(jCTree);
        sourceRewriter.copyTo(sourceReader, n);
        sourceRewriter.skipThrough(sourceReader, this.getOldEndPos(jCTree, jCCompilationUnit, sourceBuffer));
        return n;
    }

    private static void changeName(TreeDiff.NameDiff nameDiff, SourceReader sourceReader, SourceRewriter sourceRewriter) throws IOException, BadLocationException {
        sourceRewriter.copyTo(sourceReader, nameDiff.getPos());
        sourceRewriter.skipThrough(sourceReader, nameDiff.getPos() + nameDiff.getOldName().length());
        sourceRewriter.writeTo(nameDiff.getNewName());
    }

    private void changeFlags(TreeDiff.FlagsDiff flagsDiff, SourceReader sourceReader, SourceRewriter sourceRewriter, TokenList tokenList) throws IOException, BadLocationException {
        String string;
        boolean bl;
        int n = flagsDiff.getPos();
        sourceRewriter.copyTo(sourceReader, n);
        boolean bl2 = bl = flagsDiff.getOldEndPos() - n > 0;
        if (bl) {
            int n2 = tokenList.indexOf(n);
            int n3 = tokenList.indexOfEndPos(flagsDiff.getOldEndPos());
            assert (n2 != -1 && n3 != -1);
            boolean bl3 = false;
            for (int i = n2; i <= n3; ++i) {
                TokenList.Token token = tokenList.get(i);
                if (token.isFlag()) {
                    if (bl3) {
                        int n4;
                        StringBuilder stringBuilder = new StringBuilder();
                        while ((n4 = sourceReader.read()) != -1 && Character.isWhitespace(n4)) {
                            stringBuilder.append((char)n4);
                        }
                        if (stringBuilder.length() > 0) {
                            sourceRewriter.writeTo(stringBuilder.toString());
                        }
                    }
                    sourceRewriter.skipThrough(sourceReader, token.getEndPos());
                } else {
                    sourceRewriter.copyTo(sourceReader, token.getEndPos());
                }
                bl3 = token.isIdentifier();
            }
            sourceRewriter.skipThrough(sourceReader, tokenList.get(n3 + 1).getPos());
        }
        if ((string = TreeInfo.flagNames(flagsDiff.getNewFlags())).length() > 0) {
            sourceRewriter.writeTo(string);
            sourceRewriter.writeTo(" ");
        }
    }

    static String getSourceFileName(JCTree.JCCompilationUnit jCCompilationUnit) {
        JCTree.JCClassDecl jCClassDecl = Commit.getMainClassDef(jCCompilationUnit);
        return jCClassDecl.sym.fullname.toString().replace('.', File.separatorChar) + ".java";
    }

    static JCTree.JCClassDecl getMainClassDef(JCTree.JCCompilationUnit jCCompilationUnit) {
        List<JCTree> list = jCCompilationUnit.defs;
        JCTree.JCClassDecl jCClassDecl = null;
        while (list.nonEmpty()) {
            if (((JCTree)list.head).tag == 3) {
                JCTree.JCClassDecl jCClassDecl2 = (JCTree.JCClassDecl)list.head;
                if ((jCClassDecl2.mods.flags & 1L) != 0L) {
                    return jCClassDecl2;
                }
                jCClassDecl = jCClassDecl2;
            }
            list = list.tail;
        }
        return jCClassDecl;
    }

    int getOldEndPos(JCTree jCTree, JCTree.JCCompilationUnit jCCompilationUnit, SourceBuffer sourceBuffer) {
        if (jCTree == null || jCCompilationUnit == null) {
            return -2;
        }
        int n = this.model.getEndPos(jCTree, jCCompilationUnit);
        assert (n != -2);
        if (jCTree.tag == 5 && sourceBuffer.src[n - 1] == ';') {
            --n;
        }
        return n;
    }

    void setIndent(PrettyPrinter prettyPrinter, int n, SourceBuffer sourceBuffer) {
        if (n != -2) {
            int n2 = sourceBuffer.getLineNumber(n);
            char[] cArray = sourceBuffer.getLine(n2);
            this.lastMargin = this.getMargin(cArray);
        }
        prettyPrinter.reset(this.lastMargin);
    }

    CompilationUnitTree getOriginalTree(CompilationUnitTree compilationUnitTree) {
        RootTree rootTree = this.getOriginalRoot();
        for (CompilationUnitTree compilationUnitTree2 : rootTree.getCompilationUnits()) {
            if (compilationUnitTree2.getSourceFile() != compilationUnitTree.getSourceFile()) continue;
            return compilationUnitTree2;
        }
        return compilationUnitTree;
    }

    private int getOldPos(JCTree jCTree) {
        return TreeDiff.getOldPos(jCTree, this.model, this.env.getUndoList());
    }

    private static boolean isDefaultConstructor(JCTree.JCMethodDecl jCMethodDecl) {
        return jCMethodDecl.sym.isConstructor() && jCMethodDecl.params.isEmpty();
    }

    protected void printSortedImports(boolean bl, PrettyPrinter prettyPrinter, Set<Symbol> set, SourceRewriter sourceRewriter) throws IOException, BadLocationException {
        String string;
        if (bl) {
            prettyPrinter.printImports(false);
        } else {
            prettyPrinter.printImports(set);
        }
        StringWriter stringWriter = new StringWriter();
        prettyPrinter.writeTo(stringWriter);
        String string2 = stringWriter.toString();
        BufferedReader bufferedReader = new BufferedReader(new StringReader(string2));
        TreeSet<String> treeSet = new TreeSet<String>();
        while ((string = bufferedReader.readLine()) != null && string.length() > 0) {
            treeSet.add(string);
        }
        Iterator iterator = treeSet.iterator();
        while (iterator.hasNext()) {
            sourceRewriter.writeTo((String)iterator.next() + '\n');
        }
    }

    private int getMargin(char[] cArray) {
        char c;
        int n = 0;
        for (int i = 0; i < cArray.length && ((c = cArray[i]) == ' ' || c == '\t'); ++i) {
            n = this.calculateColumn(n, c);
        }
        return n;
    }

    private int calculateColumn(int n, char c) {
        if (c == '\f' || c == '\n') {
            return 1;
        }
        if (c == '\t') {
            return (n - 1) / 8 * 8 + 8 + 1;
        }
        return n + 1;
    }

    public boolean isModified(JCTree.JCCompilationUnit jCCompilationUnit) {
        return this.getOriginalTree(jCCompilationUnit) != jCCompilationUnit;
    }

    static class PrettyPrinter
    extends VeryPretty {
        boolean printBody = true;

        PrettyPrinter(Context context) {
            super(context);
        }

        public void toLeftMargin() {
            super.toLeftMargin();
        }

        void setPrintBody(boolean bl) {
            this.printBody = bl;
        }

        protected void printClassBody(JCTree.JCClassDecl jCClassDecl) {
            if (this.printBody) {
                super.printClassBody(jCClassDecl);
            }
        }

        protected void printMethodBody(JCTree.JCMethodDecl jCMethodDecl) {
            if (this.printBody) {
                super.printMethodBody(jCMethodDecl);
            }
        }

        protected void printVarBody(JCTree.JCVariableDecl jCVariableDecl) {
            if (this.printBody) {
                super.printVarBody(jCVariableDecl);
            }
        }
    }
}

