/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.java.source.save;

import com.sun.source.tree.CompilationUnitTree;
import com.sun.tools.javac.tree.JCTree;
import com.sun.tools.javac.util.Context;
import com.sun.tools.javac.util.List;
import com.sun.tools.javac.util.Options;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.PrintWriter;
import org.netbeans.api.java.source.query.Query;
import org.netbeans.api.java.source.query.QueryEnvironment;
import org.netbeans.modules.java.source.engine.EngineEnvironment;
import org.netbeans.modules.java.source.pretty.ImportAnalysis;
import org.netbeans.modules.java.source.pretty.VeryPretty;
import org.netbeans.modules.java.source.save.Commit;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Reformat
extends Query<Void, Object> {
    public String destinationDirectory;
    boolean displayedError = false;
    Context context;
    PrintWriter log;
    int nWritten;
    private EngineEnvironment ee;

    @Override
    public void attach(QueryEnvironment queryEnvironment) {
        super.attach(queryEnvironment);
        this.ee = (EngineEnvironment)queryEnvironment;
        this.context = this.ee.getContext();
        Options options = Options.instance(this.context);
        String string = options.get("-save_directory");
        if (string != null) {
            this.destinationDirectory = string;
        }
    }

    @Override
    public void release() {
        super.release();
        this.ee = null;
        this.context = null;
        this.log = null;
    }

    @Override
    public void apply() {
        this.nWritten = 0;
        this.log = this.env.getOutputWriter("Formatting Files");
        super.apply();
        this.log.println("Wrote " + this.nWritten + " files");
        this.log.close();
        this.log = null;
    }

    @Override
    public Void visitCompilationUnit(CompilationUnitTree compilationUnitTree, Object object) {
        PrintWriter printWriter;
        JCTree.JCCompilationUnit jCCompilationUnit = (JCTree.JCCompilationUnit)compilationUnitTree;
        String string = Commit.getSourceFileName(jCCompilationUnit);
        File file = new File(this.destinationDirectory, string);
        this.log.println("Formatting " + file);
        try {
            printWriter = new PrintWriter(new BufferedWriter(new FileWriter(file)));
        }
        catch (IOException iOException) {
            if (!file.getParentFile().mkdirs()) {
                if (!this.displayedError) {
                    this.error("Couldn't create directory:\n" + file.getParent() + "\n" + iOException.getMessage());
                }
                this.displayedError = true;
                return null;
            }
            try {
                printWriter = new PrintWriter(new BufferedWriter(new FileWriter(file)));
            }
            catch (IOException iOException2) {
                if (!this.displayedError) {
                    this.error("Couldn't create file:\n" + file + "\n" + iOException2.getMessage());
                }
                this.displayedError = true;
                return null;
            }
        }
        try {
            VeryPretty veryPretty = new VeryPretty(this.context);
            ImportAnalysis importAnalysis = new ImportAnalysis(veryPretty.options.starThreshold, veryPretty.options.useThreshold, jCCompilationUnit, this.ee.getSymbolTable(), this.ee.getJavacTypes());
            veryPretty.setImports(importAnalysis);
            if (importAnalysis.containingClass != null) {
                veryPretty.enclClassName = importAnalysis.containingClass.name;
            }
            veryPretty.printImports();
            List<JCTree> list = jCCompilationUnit.defs;
            while (list.tail != null) {
                ((JCTree)list.head).accept(veryPretty);
                if (list.tail != null) {
                    veryPretty.print('\n');
                }
                list = list.tail;
            }
            veryPretty.writeTo(printWriter);
            printWriter.close();
            ++this.nWritten;
        }
        catch (Throwable throwable) {
            String string2 = "Error writing " + string + ": " + throwable;
            try {
                this.log.println(string2);
                string2 = null;
            }
            catch (Throwable throwable2) {
                // empty catch block
            }
            if (string2 != null) {
                this.error(string2);
            }
            this.displayedError = true;
        }
        return null;
    }
}

