/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.java.source.save;

import java.io.CharArrayWriter;
import java.io.FileReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.util.BitSet;
import javax.tools.JavaFileObject;

public class SourceBuffer
implements CharSequence {
    public char[] src;
    LineMap lineMap;
    int maxLines;

    public SourceBuffer(char[] cArray, int n) {
        this.src = cArray;
        this.lineMap = new LineMap(cArray, cArray.length);
        this.maxLines = this.lineMap.getLineNumber(cArray.length - 1);
    }

    public SourceBuffer(String string) throws IOException {
        this(new FileReader(string));
    }

    public SourceBuffer(InputStream inputStream) throws IOException {
        this(new InputStreamReader(inputStream));
    }

    public SourceBuffer(InputStream inputStream, String string) throws IOException {
        this(new InputStreamReader(inputStream, string));
    }

    public SourceBuffer(Reader reader) throws IOException {
        this.src = SourceBuffer.readInFile(reader);
        this.lineMap = new LineMap(this.src, this.src.length);
        this.maxLines = this.lineMap.getLineNumber(this.src.length - 1);
    }

    public SourceBuffer(JavaFileObject javaFileObject) throws IOException {
        String string = ((Object)javaFileObject.getCharContent(true)).toString();
        this.src = string.toCharArray();
        this.lineMap = new LineMap(this.src, this.src.length);
        this.maxLines = this.lineMap.getLineNumber(this.src.length - 1);
    }

    private static char[] readInFile(Reader reader) throws IOException {
        int n;
        CharArrayWriter charArrayWriter = new CharArrayWriter(4096);
        char[] cArray = new char[4096];
        while ((n = reader.read(cArray)) > 0) {
            charArrayWriter.write(cArray, 0, n);
        }
        reader.close();
        charArrayWriter.write(0);
        return charArrayWriter.toCharArray();
    }

    public char[] getChars() {
        char[] cArray = new char[this.src.length];
        System.arraycopy(this.src, 0, cArray, 0, this.src.length);
        return cArray;
    }

    public char[] getChars(int n, int n2) {
        int n3 = n2 - n;
        char[] cArray = new char[n3];
        System.arraycopy(this.src, n, cArray, 0, n3);
        return cArray;
    }

    public String getString(int n, int n2) {
        return new String(this.src, n, n2 - n);
    }

    public char[] getLine(int n) {
        if (n <= 0 || n > this.maxLines) {
            throw new IndexOutOfBoundsException("line out of range: " + n);
        }
        int n2 = this.lineMap.getStartPosition(n);
        int n3 = (n + 1 >= this.maxLines ? this.src.length : this.lineMap.getStartPosition(n + 1)) - 1;
        if (this.src[n3] == '\n') {
            --n3;
        }
        if (this.src[n3] == '\r') {
            --n3;
        }
        return this.getChars(n2, n3 + 1);
    }

    public int getLineNumber(int n) {
        return this.lineMap.getLineNumber(n);
    }

    public int getColumnNumber(int n) {
        return this.lineMap.getColumnNumber(n);
    }

    public int getPosition(int n, int n2) {
        return this.lineMap.getPosition(n, n2);
    }

    public int getStartPosition(int n) {
        return this.lineMap.getStartPosition(n);
    }

    public int length() {
        return this.src.length - 1;
    }

    public char charAt(int n) {
        return this.src[n];
    }

    public CharSequence subSequence(int n, int n2) {
        return this.getString(n, n2);
    }

    public String toString() {
        return new String(this.src, 0, this.length());
    }

    static class LineMap {
        private int[] startPosition;
        private BitSet tabMap;
        public static final int FIRSTLINE = 1;
        public static final int FIRSTCOLUMN = 1;
        public static final int TabInc = 8;
        private static final char SCANNER_SENTINEL = '\u0000';
        private int lastPosition = 0;
        private int lastLine = 1;

        protected LineMap(char[] cArray, int n) {
            if (cArray[n - 1] == '\u0000') {
                --n;
            }
            this.tabMap = new BitSet(n);
            int n2 = 0;
            int n3 = 0;
            int[] nArray = new int[n];
            block0: while (n3 < n) {
                nArray[n2++] = n3;
                do {
                    char c;
                    if ((c = cArray[n3]) == '\r' || c == '\n') {
                        if (c == '\r' && n3 + 1 < n && cArray[n3 + 1] == '\n') {
                            n3 += 2;
                            continue block0;
                        }
                        ++n3;
                        continue block0;
                    }
                    if (c != '\t') continue;
                    this.setTabPosition(n3);
                } while (++n3 < n);
            }
            this.startPosition = new int[n2];
            System.arraycopy(nArray, 0, this.startPosition, 0, n2);
        }

        public int getStartPosition(int n) {
            return this.startPosition[n - 1];
        }

        public int getPosition(int n, int n2) {
            int n3 = this.startPosition[n - 1];
            --n2;
            int n4 = 0;
            while (n4 < n2) {
                if (this.tabMap.get(++n3)) {
                    n4 = n4 / 8 * 8 + 8;
                    continue;
                }
                ++n4;
            }
            return n3;
        }

        public int getLineNumber(int n) {
            if (n == this.lastPosition) {
                return this.lastLine;
            }
            this.lastPosition = n;
            int n2 = 0;
            int n3 = this.startPosition.length - 1;
            while (n2 <= n3) {
                int n4 = n2 + n3 >> 1;
                int n5 = this.startPosition[n4];
                if (n5 < n) {
                    n2 = n4 + 1;
                    continue;
                }
                if (n5 > n) {
                    n3 = n4 - 1;
                    continue;
                }
                this.lastLine = n4 + 1;
                return this.lastLine;
            }
            this.lastLine = n2;
            return this.lastLine;
        }

        public int getColumnNumber(int n) {
            int n2 = this.startPosition[this.getLineNumber(n) - 1];
            int n3 = 0;
            for (int i = n2; i < n; ++i) {
                if (this.tabMap.get(i)) {
                    n3 = n3 / 8 * 8 + 8;
                    continue;
                }
                ++n3;
            }
            return n3 + 1;
        }

        protected void setTabPosition(int n) {
            this.tabMap.set(n);
        }
    }
}

