/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.java.source.save;

import com.sun.source.tree.MethodTree;
import com.sun.source.tree.Tree;
import com.sun.tools.javac.code.BoundKind;
import com.sun.tools.javac.tree.JCTree;
import com.sun.tools.javac.tree.Pretty;
import com.sun.tools.javac.tree.TreeInfo;
import com.sun.tools.javac.util.Context;
import com.sun.tools.javac.util.List;
import com.sun.tools.javac.util.ListBuffer;
import com.sun.tools.javac.util.Name;
import java.util.ArrayList;
import java.util.Iterator;
import org.netbeans.api.java.lexer.JavaTokenId;
import org.netbeans.api.java.source.Comment;
import org.netbeans.api.java.source.WorkingCopy;
import org.netbeans.api.java.source.query.CommentHandler;
import org.netbeans.api.java.source.query.CommentSet;
import org.netbeans.api.java.source.transform.UndoList;
import org.netbeans.api.lexer.TokenSequence;
import org.netbeans.modules.java.source.builder.ASTService;
import org.netbeans.modules.java.source.builder.CommentHandlerService;
import org.netbeans.modules.java.source.builder.UndoListService;
import org.netbeans.modules.java.source.engine.ASTModel;
import org.netbeans.modules.java.source.save.EstimatorFactory;
import org.netbeans.modules.java.source.save.ListMatcher;
import org.netbeans.modules.java.source.save.Measure;
import org.netbeans.modules.java.source.save.PositionEstimator;
import org.netbeans.modules.java.source.save.TokenUtilities;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 * Duplicate member names - consider using --renamedupmembers true
 */
public class TreeDiff {
    protected ListBuffer<Diff> diffs = new ListBuffer();
    protected CommentHandler comments;
    protected ASTModel model;
    protected UndoList undo;
    protected JCTree oldParent;
    protected JCTree newParent;
    protected JCTree.JCCompilationUnit oldTopLevel;
    private WorkingCopy workingCopy;
    private TokenSequence<JavaTokenId> tokenSequence;
    private Name origClassName = null;

    public static List<Diff> diff(Context context, JCTree jCTree, JCTree jCTree2) {
        return TreeDiff.diff(context, null, jCTree, jCTree2);
    }

    public static List<Diff> diff(Context context, WorkingCopy workingCopy, JCTree jCTree, JCTree jCTree2) {
        TreeDiff treeDiff = new TreeDiff(context, workingCopy);
        treeDiff.diffTree(jCTree, jCTree2);
        return treeDiff.getDiffs();
    }

    protected TreeDiff(Context context, WorkingCopy workingCopy) {
        this.comments = CommentHandlerService.instance(context);
        this.model = ASTService.instance(context);
        this.undo = UndoListService.instance(context);
        this.workingCopy = workingCopy;
        this.tokenSequence = workingCopy.getTokenHierarchy().tokenSequence();
    }

    protected List<Diff> getDiffs() {
        return this.diffs.toList();
    }

    private void append(Diff diff) {
        for (Diff diff2 : this.diffs) {
            if (!diff2.equals(diff)) continue;
            return;
        }
        this.diffs.append(diff);
    }

    private int endPos(JCTree jCTree) {
        return this.model.getEndPos(jCTree, this.oldTopLevel);
    }

    protected void diffTopLevel(JCTree.JCCompilationUnit jCCompilationUnit, JCTree.JCCompilationUnit jCCompilationUnit2) {
        this.oldTopLevel = jCCompilationUnit;
        this.diffList(jCCompilationUnit.packageAnnotations, jCCompilationUnit2.packageAnnotations, LineInsertionType.NONE, 0);
        int n = jCCompilationUnit.pid == null ? (((List)jCCompilationUnit.getImports()).head != null ? ((JCTree.JCImport)((List)jCCompilationUnit.getImports()).head).getStartPosition() : (((List)jCCompilationUnit.getTypeDecls()).head != null ? ((JCTree)((List)jCCompilationUnit.getTypeDecls()).head).getStartPosition() : 1)) : this.endPos(jCCompilationUnit.pid);
        this.diffTreeToken("package ", n, jCCompilationUnit.pid, jCCompilationUnit2.pid, ";");
        if (((List)jCCompilationUnit.getImports()).isEmpty()) {
            if (jCCompilationUnit.pid != null) {
                n = TokenUtilities.moveFwdToToken(this.tokenSequence, n, JavaTokenId.SEMICOLON);
                n += JavaTokenId.SEMICOLON.fixedText().length();
            }
        } else {
            n = ((JCTree.JCImport)((List)jCCompilationUnit.getImports()).head).pos;
        }
        this.diffList(jCCompilationUnit.getTypeDecls(), jCCompilationUnit2.getTypeDecls(), LineInsertionType.BEFORE, -1);
    }

    protected void diffImport(JCTree.JCImport jCImport, JCTree.JCImport jCImport2) {
        if (TreeInfo.fullName(jCImport.qualid) != TreeInfo.fullName(jCImport2.qualid)) {
            this.append(Diff.modify(jCImport, this.getOldPos(jCImport), jCImport2));
        } else if (jCImport.staticImport != jCImport2.staticImport) {
            this.append(Diff.flags(jCImport.pos, this.endPos(jCImport), jCImport.staticImport ? 8L : 0L, jCImport2.staticImport ? 8L : 0L));
        }
    }

    protected void diffClassDef(JCTree.JCClassDecl jCClassDecl, JCTree.JCClassDecl jCClassDecl2) {
        Object object;
        JCTree jCTree = this.oldParent;
        this.oldParent = jCClassDecl;
        JCTree jCTree2 = this.newParent;
        this.newParent = jCClassDecl2;
        this.tokenSequence.move(jCClassDecl.pos);
        this.tokenSequence.moveNext();
        int n = TokenUtilities.moveNext(this.tokenSequence, this.tokenSequence.offset());
        if (this.nameChanged(jCClassDecl.name, jCClassDecl2.name)) {
            this.origClassName = jCClassDecl.name;
            this.append(Diff.name(n, jCClassDecl.name, jCClassDecl2.name));
        }
        n += jCClassDecl.name.length();
        this.diffModifiers(jCClassDecl.mods, jCClassDecl2.mods, jCClassDecl);
        this.diffParameterList(jCClassDecl.typarams, jCClassDecl2.typarams);
        if (jCClassDecl.typarams.nonEmpty()) {
            n = this.endPos(jCClassDecl.typarams.last());
            TokenUtilities.moveFwdToToken(this.tokenSequence, n, JavaTokenId.GT);
            n = this.tokenSequence.offset() + JavaTokenId.GT.fixedText().length();
        }
        this.diffTree(jCClassDecl.extending, jCClassDecl2.extending, n, " extends ");
        if (jCClassDecl.implementing.isEmpty()) {
            if (jCClassDecl.extending != null) {
                n = this.endPos(jCClassDecl.extending);
            }
        } else {
            n = jCClassDecl.implementing.iterator().next().getStartPosition();
        }
        long l = jCClassDecl.sym != null ? jCClassDecl.sym.flags() : jCClassDecl.mods.flags;
        PositionEstimator positionEstimator = (l & 0x200L) == 0L ? EstimatorFactory.implementz(jCClassDecl.getImplementsClause(), jCClassDecl2.getImplementsClause(), this.workingCopy) : EstimatorFactory.extendz(jCClassDecl.getImplementsClause(), jCClassDecl2.getImplementsClause(), this.workingCopy);
        this.diffList2(jCClassDecl.implementing, jCClassDecl2.implementing, n, positionEstimator);
        n = this.endPos(jCClassDecl) - 1;
        if (jCClassDecl.defs.isEmpty()) {
            n = this.endPos(jCClassDecl) - 1;
        } else {
            Object object2 = object = ((JCTree)jCClassDecl.defs.head).pos == jCClassDecl.pos ? (JCTree)jCClassDecl.defs.tail.head : (JCTree)jCClassDecl.defs.head;
            if (object != null) {
                n = ((JCTree)object).getStartPosition();
            }
        }
        object = EstimatorFactory.deprecated(this.filterHidden(jCClassDecl.defs), this.filterHidden(jCClassDecl2.defs), this.workingCopy);
        this.diffList(this.filterHidden(jCClassDecl.defs), this.filterHidden(jCClassDecl2.defs), n, (PositionEstimator)object, Measure.MEMBER, jCClassDecl2.name);
        this.oldParent = jCTree;
        this.newParent = jCTree2;
        this.origClassName = null;
    }

    protected void diffMethodDef(JCTree.JCMethodDecl jCMethodDecl, JCTree.JCMethodDecl jCMethodDecl2) {
        this.diffModifiers(jCMethodDecl.mods, jCMethodDecl2.mods, jCMethodDecl);
        this.diffTree(jCMethodDecl.restype, jCMethodDecl2.restype);
        int n = jCMethodDecl.typarams.isEmpty() ? (jCMethodDecl.restype != null ? jCMethodDecl.restype.getStartPosition() : jCMethodDecl.getStartPosition()) : jCMethodDecl.typarams.iterator().next().getStartPosition();
        if ((!jCMethodDecl.sym.isConstructor() || this.origClassName != null) && this.nameChanged(jCMethodDecl.name, jCMethodDecl2.name)) {
            if (jCMethodDecl.sym.isConstructor() && this.origClassName != null) {
                this.append(Diff.name(jCMethodDecl.pos, this.origClassName, jCMethodDecl2.name));
            } else {
                this.append(Diff.name(jCMethodDecl.pos, jCMethodDecl.name, jCMethodDecl2.name));
            }
        }
        this.diffParameterList(jCMethodDecl.typarams, jCMethodDecl2.typarams, n, ListType.TYPE_PARAMETER);
        if (jCMethodDecl.params.isEmpty()) {
            int n2 = jCMethodDecl.restype != null ? jCMethodDecl.restype.getStartPosition() : jCMethodDecl.getStartPosition();
            this.tokenSequence.move(n2);
            TokenUtilities.moveFwdToToken(this.tokenSequence, n2, JavaTokenId.RPAREN);
            n = this.tokenSequence.offset();
        } else {
            n = jCMethodDecl.params.iterator().next().getStartPosition();
        }
        this.diffParameterList(jCMethodDecl.params, jCMethodDecl2.params, n, ListType.PARAMETER);
        if (jCMethodDecl.thrown.isEmpty()) {
            n = (jCMethodDecl.body == null ? this.endPos(jCMethodDecl) : jCMethodDecl.body.pos) - 1;
            this.tokenSequence.move(n);
            if (this.tokenSequence.token().id() != JavaTokenId.WHITESPACE) {
                ++n;
            }
        } else {
            n = jCMethodDecl.thrown.iterator().next().getStartPosition();
        }
        PositionEstimator positionEstimator = EstimatorFactory.throwz(jCMethodDecl.getThrows(), jCMethodDecl2.getThrows(), this.workingCopy);
        this.diffList2(jCMethodDecl.thrown, jCMethodDecl2.thrown, n, positionEstimator);
        this.diffTree(jCMethodDecl.body, jCMethodDecl2.body);
        this.diffTree(jCMethodDecl.defaultValue, jCMethodDecl2.defaultValue);
    }

    protected void diffVarDef(JCTree.JCVariableDecl jCVariableDecl, JCTree.JCVariableDecl jCVariableDecl2) {
        if (this.nameChanged(jCVariableDecl.name, jCVariableDecl2.name)) {
            this.append(Diff.name(jCVariableDecl.pos, jCVariableDecl.name, jCVariableDecl2.name));
        }
        this.diffModifiers(jCVariableDecl.mods, jCVariableDecl2.mods, jCVariableDecl);
        this.diffTree(jCVariableDecl.vartype, jCVariableDecl2.vartype);
        if (jCVariableDecl2.init != null && jCVariableDecl.init != null) {
            this.diffTree(jCVariableDecl.init, jCVariableDecl2.init);
        } else {
            this.diffTreeToken("=", this.endPos(jCVariableDecl.init), jCVariableDecl.init, jCVariableDecl2.init, "");
        }
    }

    protected void diffBlock(JCTree.JCBlock jCBlock, JCTree.JCBlock jCBlock2) {
        if (jCBlock.flags != jCBlock2.flags) {
            this.append(Diff.flags(jCBlock.pos, this.endPos(jCBlock), jCBlock.flags, jCBlock2.flags));
        }
        this.diffList(jCBlock.stats, jCBlock2.stats, LineInsertionType.BEFORE, jCBlock.pos + 1);
    }

    protected void diffDoLoop(JCTree.JCDoWhileLoop jCDoWhileLoop, JCTree.JCDoWhileLoop jCDoWhileLoop2) {
        this.diffTree(jCDoWhileLoop.body, jCDoWhileLoop2.body);
        this.diffTree(jCDoWhileLoop.cond, jCDoWhileLoop2.cond);
    }

    protected void diffWhileLoop(JCTree.JCWhileLoop jCWhileLoop, JCTree.JCWhileLoop jCWhileLoop2) {
        this.diffTree(jCWhileLoop.cond, jCWhileLoop2.cond);
        this.diffTree(jCWhileLoop.body, jCWhileLoop2.body);
    }

    protected void diffForLoop(JCTree.JCForLoop jCForLoop, JCTree.JCForLoop jCForLoop2) {
        int n = jCForLoop.cond != null ? jCForLoop.cond.pos - 1 : -2;
        int n2 = jCForLoop.cond != null ? this.endPos(jCForLoop.cond) + 1 : -2;
        this.diffList(jCForLoop.init, jCForLoop2.init, LineInsertionType.NONE, n);
        this.diffTree(jCForLoop.cond, jCForLoop2.cond);
        this.diffList(jCForLoop.step, jCForLoop2.step, LineInsertionType.NONE, n2);
        this.diffTree(jCForLoop.body, jCForLoop2.body);
    }

    protected void diffForeachLoop(JCTree.JCEnhancedForLoop jCEnhancedForLoop, JCTree.JCEnhancedForLoop jCEnhancedForLoop2) {
        this.diffTree(jCEnhancedForLoop.var, jCEnhancedForLoop2.var);
        this.diffTree(jCEnhancedForLoop.expr, jCEnhancedForLoop2.expr);
        this.diffTree(jCEnhancedForLoop.body, jCEnhancedForLoop2.body);
    }

    protected void diffLabelled(JCTree.JCLabeledStatement jCLabeledStatement, JCTree.JCLabeledStatement jCLabeledStatement2) {
        if (this.nameChanged(jCLabeledStatement.label, jCLabeledStatement2.label)) {
            this.append(Diff.name(jCLabeledStatement.pos, jCLabeledStatement.label, jCLabeledStatement2.label));
        }
        this.diffTree(jCLabeledStatement.body, jCLabeledStatement2.body);
    }

    protected void diffSwitch(JCTree.JCSwitch jCSwitch, JCTree.JCSwitch jCSwitch2) {
        this.diffTree(jCSwitch.selector, jCSwitch2.selector);
        int n = jCSwitch.cases.size() > 0 ? ((JCTree.JCCase)jCSwitch.cases.head).pos : -2;
        this.diffList(jCSwitch.cases, jCSwitch2.cases, LineInsertionType.BEFORE, n);
    }

    protected void diffCase(JCTree.JCCase jCCase, JCTree.JCCase jCCase2) {
        this.diffTree(jCCase.pat, jCCase2.pat);
        this.diffList(jCCase.stats, jCCase2.stats, LineInsertionType.BEFORE, this.endPos(jCCase) + 1);
    }

    protected void diffSynchronized(JCTree.JCSynchronized jCSynchronized, JCTree.JCSynchronized jCSynchronized2) {
        this.diffTree(jCSynchronized.lock, jCSynchronized2.lock);
        this.diffTree(jCSynchronized.body, jCSynchronized2.body);
    }

    protected void diffTry(JCTree.JCTry jCTry, JCTree.JCTry jCTry2) {
        this.diffTree(jCTry.body, jCTry2.body);
        this.diffList(jCTry.catchers, jCTry2.catchers, LineInsertionType.BEFORE, jCTry.body.endpos + 1);
        this.diffTree(jCTry.finalizer, jCTry2.finalizer);
    }

    protected void diffCatch(JCTree.JCCatch jCCatch, JCTree.JCCatch jCCatch2) {
        this.diffTree(jCCatch.param, jCCatch2.param);
        this.diffTree(jCCatch.body, jCCatch2.body);
    }

    protected void diffConditional(JCTree.JCConditional jCConditional, JCTree.JCConditional jCConditional2) {
        this.diffTree(jCConditional.cond, jCConditional2.cond);
        this.diffTree(jCConditional.truepart, jCConditional2.truepart);
        this.diffTree(jCConditional.falsepart, jCConditional2.falsepart);
    }

    protected void diffIf(JCTree.JCIf jCIf, JCTree.JCIf jCIf2) {
        if (jCIf.elsepart == null && jCIf2.elsepart != null || jCIf.elsepart != null && jCIf2.elsepart == null) {
            this.append(Diff.modify(jCIf, this.getOldPos(jCIf), jCIf2));
        } else {
            this.diffTree(jCIf.cond, jCIf2.cond);
            this.diffTree(jCIf.thenpart, jCIf2.thenpart);
            this.diffTree(jCIf.elsepart, jCIf2.elsepart);
        }
    }

    protected void diffExec(JCTree.JCExpressionStatement jCExpressionStatement, JCTree.JCExpressionStatement jCExpressionStatement2) {
        this.diffTree(jCExpressionStatement.expr, jCExpressionStatement2.expr);
    }

    protected void diffBreak(JCTree.JCBreak jCBreak, JCTree.JCBreak jCBreak2) {
        if (this.nameChanged(jCBreak.label, jCBreak2.label)) {
            this.append(Diff.name(jCBreak.pos, jCBreak.label, jCBreak2.label));
        }
        this.diffTree(jCBreak.target, jCBreak2.target);
    }

    protected void diffContinue(JCTree.JCContinue jCContinue, JCTree.JCContinue jCContinue2) {
        if (this.nameChanged(jCContinue.label, jCContinue2.label)) {
            this.append(Diff.name(jCContinue.pos, jCContinue.label, jCContinue2.label));
        }
        this.diffTree(jCContinue.target, jCContinue2.target);
    }

    protected void diffReturn(JCTree.JCReturn jCReturn, JCTree.JCReturn jCReturn2) {
        this.diffTree(jCReturn.expr, jCReturn2.expr);
    }

    protected void diffThrow(JCTree.JCThrow jCThrow, JCTree.JCThrow jCThrow2) {
        this.diffTree(jCThrow.expr, jCThrow2.expr);
    }

    protected void diffAssert(JCTree.JCAssert jCAssert, JCTree.JCAssert jCAssert2) {
        this.diffTree(jCAssert.cond, jCAssert2.cond);
        this.diffTree(jCAssert.detail, jCAssert2.detail);
    }

    protected void diffApply(JCTree.JCMethodInvocation jCMethodInvocation, JCTree.JCMethodInvocation jCMethodInvocation2) {
        this.diffParameterList(jCMethodInvocation.typeargs, jCMethodInvocation2.typeargs);
        this.diffTree(jCMethodInvocation.meth, jCMethodInvocation2.meth);
        this.diffParameterList(jCMethodInvocation.args, jCMethodInvocation2.args);
    }

    protected void diffNewClass(JCTree.JCNewClass jCNewClass, JCTree.JCNewClass jCNewClass2) {
        this.diffTree(jCNewClass.encl, jCNewClass2.encl);
        this.diffParameterList(jCNewClass.typeargs, jCNewClass2.typeargs);
        this.diffTree(jCNewClass.clazz, jCNewClass2.clazz);
        this.diffParameterList(jCNewClass.args, jCNewClass2.args);
        this.diffTree(jCNewClass.def, jCNewClass2.def);
        if (jCNewClass.constructor != jCNewClass2.constructor) {
            this.append(Diff.name(jCNewClass.pos, jCNewClass.constructor.name, jCNewClass2.constructor.name));
        }
    }

    protected void diffNewArray(JCTree.JCNewArray jCNewArray, JCTree.JCNewArray jCNewArray2) {
        this.diffTree(jCNewArray.elemtype, jCNewArray2.elemtype);
        this.diffParameterList(jCNewArray.dims, jCNewArray2.dims);
        this.diffList(jCNewArray.elems, jCNewArray2.elems, LineInsertionType.NONE, -2);
    }

    protected void diffParens(JCTree.JCParens jCParens, JCTree.JCParens jCParens2) {
        this.diffTree(jCParens.expr, jCParens2.expr);
    }

    protected void diffAssign(JCTree.JCAssign jCAssign, JCTree.JCAssign jCAssign2) {
        this.diffTree(jCAssign.lhs, jCAssign2.lhs);
        this.diffTree(jCAssign.rhs, jCAssign2.rhs);
    }

    protected void diffAssignop(JCTree.JCAssignOp jCAssignOp, JCTree.JCAssignOp jCAssignOp2) {
        this.diffTree(jCAssignOp.lhs, jCAssignOp2.lhs);
        this.diffTree(jCAssignOp.rhs, jCAssignOp2.rhs);
        if (jCAssignOp.tag != jCAssignOp2.tag) {
            this.append(Diff.name(jCAssignOp.pos, this.operatorName(jCAssignOp.tag), this.operatorName(jCAssignOp2.tag)));
        }
    }

    protected void diffUnary(JCTree.JCUnary jCUnary, JCTree.JCUnary jCUnary2) {
        this.diffTree(jCUnary.arg, jCUnary2.arg);
        if (jCUnary.tag != jCUnary2.tag) {
            this.append(Diff.name(jCUnary.pos, this.operatorName(jCUnary.tag), this.operatorName(jCUnary2.tag)));
        }
    }

    protected void diffBinary(JCTree.JCBinary jCBinary, JCTree.JCBinary jCBinary2) {
        this.diffTree(jCBinary.lhs, jCBinary2.lhs);
        this.diffTree(jCBinary.rhs, jCBinary2.rhs);
        if (jCBinary.tag != jCBinary2.tag) {
            this.append(Diff.name(jCBinary.pos, this.operatorName(jCBinary.tag), this.operatorName(jCBinary2.tag)));
        }
    }

    private String operatorName(int n) {
        return new Pretty(null, false).operatorName(n);
    }

    protected void diffTypeCast(JCTree.JCTypeCast jCTypeCast, JCTree.JCTypeCast jCTypeCast2) {
        this.diffTree(jCTypeCast.clazz, jCTypeCast2.clazz);
        this.diffTree(jCTypeCast.expr, jCTypeCast2.expr);
    }

    protected void diffTypeTest(JCTree.JCInstanceOf jCInstanceOf, JCTree.JCInstanceOf jCInstanceOf2) {
        this.diffTree(jCInstanceOf.expr, jCInstanceOf2.expr);
        this.diffTree(jCInstanceOf.clazz, jCInstanceOf2.clazz);
    }

    protected void diffIndexed(JCTree.JCArrayAccess jCArrayAccess, JCTree.JCArrayAccess jCArrayAccess2) {
        this.diffTree(jCArrayAccess.indexed, jCArrayAccess2.indexed);
        this.diffTree(jCArrayAccess.index, jCArrayAccess2.index);
    }

    protected void diffSelect(JCTree.JCFieldAccess jCFieldAccess, JCTree.JCFieldAccess jCFieldAccess2) {
        this.diffTree(jCFieldAccess.selected, jCFieldAccess2.selected);
        if (this.nameChanged(jCFieldAccess.name, jCFieldAccess2.name)) {
            this.append(Diff.name(jCFieldAccess.pos, jCFieldAccess.name, jCFieldAccess2.name));
        }
    }

    protected void diffIdent(JCTree.JCIdent jCIdent, JCTree.JCIdent jCIdent2) {
        if (this.nameChanged(jCIdent.name, jCIdent2.name)) {
            this.append(Diff.name(jCIdent.pos, jCIdent.name, jCIdent2.name));
        }
    }

    protected void diffLiteral(JCTree.JCLiteral jCLiteral, JCTree.JCLiteral jCLiteral2) {
        if (jCLiteral.typetag != jCLiteral2.typetag || !jCLiteral.value.equals(jCLiteral2.value)) {
            this.append(Diff.modify(jCLiteral, this.getOldPos(jCLiteral), jCLiteral2));
        }
    }

    protected void diffTypeIdent(JCTree.JCPrimitiveTypeTree jCPrimitiveTypeTree, JCTree.JCPrimitiveTypeTree jCPrimitiveTypeTree2) {
        if (jCPrimitiveTypeTree.typetag != jCPrimitiveTypeTree2.typetag) {
            this.append(Diff.modify(jCPrimitiveTypeTree, this.getOldPos(jCPrimitiveTypeTree), jCPrimitiveTypeTree2));
        }
    }

    protected void diffTypeArray(JCTree.JCArrayTypeTree jCArrayTypeTree, JCTree.JCArrayTypeTree jCArrayTypeTree2) {
        this.diffTree(jCArrayTypeTree.elemtype, jCArrayTypeTree2.elemtype);
    }

    protected void diffTypeApply(JCTree.JCTypeApply jCTypeApply, JCTree.JCTypeApply jCTypeApply2) {
        this.diffTree(jCTypeApply.clazz, jCTypeApply2.clazz);
        this.diffParameterList(jCTypeApply.arguments, jCTypeApply2.arguments);
    }

    protected void diffTypeParameter(JCTree.JCTypeParameter jCTypeParameter, JCTree.JCTypeParameter jCTypeParameter2) {
        if (this.nameChanged(jCTypeParameter.name, jCTypeParameter2.name)) {
            this.append(Diff.name(jCTypeParameter.pos, jCTypeParameter.name, jCTypeParameter2.name));
        }
        this.diffParameterList(jCTypeParameter.bounds, jCTypeParameter2.bounds);
    }

    protected void diffWildcard(JCTree.JCWildcard jCWildcard, JCTree.JCWildcard jCWildcard2) {
        if (jCWildcard.kind != jCWildcard2.kind) {
            this.append(Diff.name(jCWildcard.pos, ((BoundKind)((Object)jCWildcard.kind)).toString(), ((BoundKind)((Object)jCWildcard2.kind)).toString()));
        }
        this.diffTree(jCWildcard.inner, jCWildcard2.inner);
    }

    protected void diffTypeBoundKind(JCTree.TypeBoundKind typeBoundKind, JCTree.TypeBoundKind typeBoundKind2) {
        if (typeBoundKind.kind != typeBoundKind2.kind) {
            this.append(Diff.name(typeBoundKind.pos, typeBoundKind.kind.toString(), typeBoundKind2.kind.toString()));
        }
    }

    protected void diffAnnotation(JCTree.JCAnnotation jCAnnotation, JCTree.JCAnnotation jCAnnotation2) {
        this.diffTree(jCAnnotation.annotationType, jCAnnotation2.annotationType);
        this.diffParameterList(jCAnnotation.args, jCAnnotation2.args);
    }

    protected void diffModifiers(JCTree.JCModifiers jCModifiers, JCTree.JCModifiers jCModifiers2, JCTree jCTree) {
        int n;
        int n2 = n = jCModifiers.pos != -1 ? this.getOldPos(jCModifiers) : this.getOldPos(jCTree);
        if (jCModifiers.flags != jCModifiers2.flags) {
            this.append(Diff.flags(n, n == jCModifiers.pos ? this.endPos(jCModifiers) : n, jCModifiers.flags, jCModifiers2.flags));
        }
        LineInsertionType lineInsertionType = jCModifiers.annotations.nonEmpty() ? LineInsertionType.BEFORE : LineInsertionType.AFTER;
        this.diffList(jCModifiers.annotations, jCModifiers2.annotations, lineInsertionType, n);
    }

    protected void diffLetExpr(JCTree.LetExpr letExpr, JCTree.LetExpr letExpr2) {
        this.diffList(letExpr.defs, letExpr2.defs, LineInsertionType.NONE, -2);
        this.diffTree(letExpr.expr, letExpr2.expr);
    }

    protected void diffErroneous(JCTree.JCErroneous jCErroneous, JCTree.JCErroneous jCErroneous2) {
        this.diffList(jCErroneous.errs, jCErroneous2.errs, LineInsertionType.BEFORE, -2);
    }

    protected boolean listContains(java.util.List<? extends JCTree> list, JCTree jCTree) {
        for (JCTree jCTree2 : list) {
            if (!this.treesMatch(jCTree2, jCTree)) continue;
            return true;
        }
        return false;
    }

    protected boolean treesMatch(JCTree jCTree, JCTree jCTree2) {
        return this.treesMatch(jCTree, jCTree2, true);
    }

    public boolean treesMatch(JCTree jCTree, JCTree jCTree2, boolean bl) {
        if (jCTree == jCTree2) {
            return true;
        }
        if (jCTree == null || jCTree2 == null) {
            return false;
        }
        if (jCTree.tag != jCTree2.tag) {
            return false;
        }
        if (!bl) {
            return true;
        }
        switch (jCTree.tag) {
            case 1: {
                return ((JCTree.JCCompilationUnit)jCTree).sourcefile.equals(((JCTree.JCCompilationUnit)jCTree2).sourcefile);
            }
            case 2: {
                return this.matchImport((JCTree.JCImport)jCTree, (JCTree.JCImport)jCTree2);
            }
            case 3: {
                return ((JCTree.JCClassDecl)jCTree).sym == ((JCTree.JCClassDecl)jCTree2).sym;
            }
            case 4: {
                return ((JCTree.JCMethodDecl)jCTree).sym == ((JCTree.JCMethodDecl)jCTree2).sym;
            }
            case 5: {
                return ((JCTree.JCVariableDecl)jCTree).sym == ((JCTree.JCVariableDecl)jCTree2).sym;
            }
            case 6: {
                return true;
            }
            case 7: {
                return this.matchBlock((JCTree.JCBlock)jCTree, (JCTree.JCBlock)jCTree2);
            }
            case 8: {
                return this.matchDoLoop((JCTree.JCDoWhileLoop)jCTree, (JCTree.JCDoWhileLoop)jCTree2);
            }
            case 9: {
                return this.matchWhileLoop((JCTree.JCWhileLoop)jCTree, (JCTree.JCWhileLoop)jCTree2);
            }
            case 10: {
                return this.matchForLoop((JCTree.JCForLoop)jCTree, (JCTree.JCForLoop)jCTree2);
            }
            case 11: {
                return this.matchForeachLoop((JCTree.JCEnhancedForLoop)jCTree, (JCTree.JCEnhancedForLoop)jCTree2);
            }
            case 12: {
                return this.matchLabelled((JCTree.JCLabeledStatement)jCTree, (JCTree.JCLabeledStatement)jCTree2);
            }
            case 13: {
                return this.matchSwitch((JCTree.JCSwitch)jCTree, (JCTree.JCSwitch)jCTree2);
            }
            case 14: {
                return this.matchCase((JCTree.JCCase)jCTree, (JCTree.JCCase)jCTree2);
            }
            case 15: {
                return this.matchSynchronized((JCTree.JCSynchronized)jCTree, (JCTree.JCSynchronized)jCTree2);
            }
            case 16: {
                return this.matchTry((JCTree.JCTry)jCTree, (JCTree.JCTry)jCTree2);
            }
            case 17: {
                return this.matchCatch((JCTree.JCCatch)jCTree, (JCTree.JCCatch)jCTree2);
            }
            case 18: {
                return this.matchConditional((JCTree.JCConditional)jCTree, (JCTree.JCConditional)jCTree2);
            }
            case 19: {
                return this.matchIf((JCTree.JCIf)jCTree, (JCTree.JCIf)jCTree2);
            }
            case 20: {
                return this.treesMatch(((JCTree.JCExpressionStatement)jCTree).expr, ((JCTree.JCExpressionStatement)jCTree2).expr);
            }
            case 21: {
                return this.matchBreak((JCTree.JCBreak)jCTree, (JCTree.JCBreak)jCTree2);
            }
            case 22: {
                return this.matchContinue((JCTree.JCContinue)jCTree, (JCTree.JCContinue)jCTree2);
            }
            case 23: {
                return this.treesMatch(((JCTree.JCReturn)jCTree).expr, ((JCTree.JCReturn)jCTree2).expr);
            }
            case 24: {
                return this.treesMatch(((JCTree.JCThrow)jCTree).expr, ((JCTree.JCThrow)jCTree2).expr);
            }
            case 25: {
                return this.matchAssert((JCTree.JCAssert)jCTree, (JCTree.JCAssert)jCTree2);
            }
            case 26: {
                return this.matchApply((JCTree.JCMethodInvocation)jCTree, (JCTree.JCMethodInvocation)jCTree2);
            }
            case 27: {
                return this.matchNewClass((JCTree.JCNewClass)jCTree, (JCTree.JCNewClass)jCTree2);
            }
            case 28: {
                return this.matchNewArray((JCTree.JCNewArray)jCTree, (JCTree.JCNewArray)jCTree2);
            }
            case 29: {
                return this.treesMatch(((JCTree.JCParens)jCTree).expr, ((JCTree.JCParens)jCTree2).expr);
            }
            case 30: {
                return this.matchAssign((JCTree.JCAssign)jCTree, (JCTree.JCAssign)jCTree2);
            }
            case 31: {
                return this.matchTypeCast((JCTree.JCTypeCast)jCTree, (JCTree.JCTypeCast)jCTree2);
            }
            case 32: {
                return this.matchTypeTest((JCTree.JCInstanceOf)jCTree, (JCTree.JCInstanceOf)jCTree2);
            }
            case 33: {
                return this.matchIndexed((JCTree.JCArrayAccess)jCTree, (JCTree.JCArrayAccess)jCTree2);
            }
            case 34: {
                return ((JCTree.JCFieldAccess)jCTree).sym == ((JCTree.JCFieldAccess)jCTree2).sym;
            }
            case 35: {
                return ((JCTree.JCIdent)jCTree).sym == ((JCTree.JCIdent)jCTree2).sym;
            }
            case 36: {
                return this.matchLiteral((JCTree.JCLiteral)jCTree, (JCTree.JCLiteral)jCTree2);
            }
            case 37: {
                return ((JCTree.JCPrimitiveTypeTree)jCTree).typetag == ((JCTree.JCPrimitiveTypeTree)jCTree2).typetag;
            }
            case 38: {
                return this.treesMatch(((JCTree.JCArrayTypeTree)jCTree).elemtype, ((JCTree.JCArrayTypeTree)jCTree2).elemtype);
            }
            case 39: {
                return this.matchTypeApply((JCTree.JCTypeApply)jCTree, (JCTree.JCTypeApply)jCTree2);
            }
            case 40: {
                return this.matchTypeParameter((JCTree.JCTypeParameter)jCTree, (JCTree.JCTypeParameter)jCTree2);
            }
            case 41: {
                return this.matchWildcard((JCTree.JCWildcard)jCTree, (JCTree.JCWildcard)jCTree2);
            }
            case 42: {
                return ((JCTree.TypeBoundKind)jCTree).kind == ((JCTree.TypeBoundKind)jCTree2).kind;
            }
            case 43: {
                return this.matchAnnotation((JCTree.JCAnnotation)jCTree, (JCTree.JCAnnotation)jCTree2);
            }
            case 91: {
                return this.matchLetExpr((JCTree.LetExpr)jCTree, (JCTree.LetExpr)jCTree2);
            }
            case 46: 
            case 47: 
            case 48: 
            case 49: 
            case 50: 
            case 51: 
            case 52: 
            case 53: 
            case 54: {
                return this.matchUnary((JCTree.JCUnary)jCTree, (JCTree.JCUnary)jCTree2);
            }
            case 55: 
            case 56: 
            case 57: 
            case 58: 
            case 59: 
            case 60: 
            case 61: 
            case 62: 
            case 63: 
            case 64: 
            case 65: 
            case 66: 
            case 67: 
            case 68: 
            case 69: 
            case 70: 
            case 71: 
            case 72: 
            case 73: {
                return this.matchBinary((JCTree.JCBinary)jCTree, (JCTree.JCBinary)jCTree2);
            }
            case 74: 
            case 75: 
            case 76: 
            case 83: 
            case 84: 
            case 85: 
            case 86: 
            case 87: 
            case 88: 
            case 89: 
            case 90: {
                return this.matchAssignop((JCTree.JCAssignOp)jCTree, (JCTree.JCAssignOp)jCTree2);
            }
        }
        String string = jCTree.getKind().toString() + " " + jCTree.getClass().getName();
        throw new AssertionError((Object)string);
    }

    protected boolean nameChanged(Name name, Name name2) {
        byte[] byArray;
        if (name == name2) {
            return false;
        }
        byte[] byArray2 = name.toUtf();
        int n = byArray2.length;
        if (n != (byArray = name2.toUtf()).length) {
            return true;
        }
        for (int i = 0; i < n; ++i) {
            if (byArray2[i] == byArray[i]) continue;
            return true;
        }
        return false;
    }

    protected void diffList(java.util.List<? extends JCTree> list, java.util.List<? extends JCTree> list2, LineInsertionType lineInsertionType, int n) {
        this.diffList(list, list2, lineInsertionType, n, null);
    }

    protected void diffList(java.util.List<? extends JCTree> list, java.util.List<? extends JCTree> list2, LineInsertionType lineInsertionType, int n, Name name) {
        if (list == list2) {
            return;
        }
        assert (list != null && list2 != null);
        int n2 = n;
        Iterator<? extends JCTree> iterator = list.iterator();
        Iterator<? extends JCTree> iterator2 = list2.iterator();
        JCTree jCTree = this.safeNext(iterator);
        JCTree jCTree2 = this.safeNext(iterator2);
        while (jCTree != null && jCTree2 != null) {
            int n3;
            if (this.oldTopLevel != null && (n3 = this.model.getEndPos(jCTree, this.oldTopLevel)) != -1) {
                n2 = n3;
            }
            if (this.treesMatch(jCTree, jCTree2, false)) {
                this.diffTree(jCTree, jCTree2);
                jCTree = this.safeNext(iterator);
                jCTree2 = this.safeNext(iterator2);
                continue;
            }
            if (!this.listContains(list2, jCTree) && !this.listContains(list, jCTree2)) {
                this.append(Diff.modify(jCTree, this.getOldPos(jCTree), jCTree2));
                jCTree = this.safeNext(iterator);
                jCTree2 = this.safeNext(iterator2);
                continue;
            }
            if (!this.listContains(list2, jCTree)) {
                if (!this.isHidden(jCTree, this.oldParent)) {
                    this.append(Diff.delete(jCTree, this.getOldPos(jCTree)));
                }
                jCTree = this.safeNext(iterator);
                continue;
            }
            if (!this.isHidden(jCTree2, this.newParent)) {
                this.append(Diff.insert(jCTree2, this.getOldPos(jCTree), lineInsertionType, name));
            }
            jCTree2 = this.safeNext(iterator2);
        }
        while (jCTree != null) {
            if (!this.isHidden(jCTree, this.oldParent)) {
                this.append(Diff.delete(jCTree, this.getOldPos(jCTree)));
            }
            if (this.oldTopLevel != null) {
                n2 = this.model.getEndPos(jCTree, this.oldTopLevel);
            }
            jCTree = this.safeNext(iterator);
        }
        while (jCTree2 != null) {
            if (!this.isHidden(jCTree2, this.newParent)) {
                this.append(Diff.insert(jCTree2, n2, lineInsertionType, name));
            }
            jCTree2 = this.safeNext(iterator2);
        }
    }

    private JCTree safeNext(Iterator<? extends JCTree> iterator) {
        return iterator.hasNext() ? iterator.next() : null;
    }

    protected void diffParameterList(java.util.List<? extends JCTree> list, java.util.List<? extends JCTree> list2) {
        JCTree jCTree;
        if (list == list2) {
            return;
        }
        assert (list != null && list2 != null);
        int n = -2;
        Iterator<? extends JCTree> iterator = list.iterator();
        Iterator<? extends JCTree> iterator2 = list2.iterator();
        while (iterator.hasNext() && iterator2.hasNext()) {
            jCTree = iterator.next();
            this.diffTree(jCTree, iterator2.next());
            if (this.oldTopLevel == null) continue;
            n = this.model.getEndPos(jCTree, this.oldTopLevel);
        }
        while (iterator.hasNext()) {
            jCTree = iterator.next();
            this.append(Diff.delete(jCTree, this.getOldPos(jCTree)));
        }
        while (iterator2.hasNext()) {
            this.append(Diff.insert(iterator2.next(), n, LineInsertionType.BEFORE));
        }
    }

    protected void diffList2(java.util.List<? extends JCTree> list, java.util.List<? extends JCTree> list2, int n, PositionEstimator positionEstimator) {
        if (list == list2) {
            return;
        }
        assert (list != null && list2 != null);
        int n2 = n;
        ListMatcher<? extends JCTree> listMatcher = ListMatcher.instance(list, list2);
        if (!listMatcher.match()) {
            return;
        }
        Iterator<? extends JCTree> iterator = list.iterator();
        ListMatcher.ResultItem<? extends JCTree>[] resultItemArray = listMatcher.getTransformedResult();
        ListMatcher.Separator separator = listMatcher.separatorInstance();
        separator.compute();
        int[][] nArray = positionEstimator.getMatrix();
        int n3 = n;
        int n4 = 0;
        block6: for (int i = 0; i < resultItemArray.length; ++i) {
            ListMatcher.ResultItem<? extends JCTree> resultItem = resultItemArray[i];
            switch (resultItem.operation) {
                case MODIFY: {
                    this.tokenSequence.moveIndex(nArray[n4][4]);
                    if (this.tokenSequence.moveNext()) {
                        n3 = this.tokenSequence.offset();
                        if (JavaTokenId.COMMA == this.tokenSequence.token().id()) {
                            n3 += JavaTokenId.COMMA.fixedText().length();
                        }
                    }
                    JCTree jCTree = iterator.next();
                    ++n4;
                    this.append(Diff.modify("", n2, jCTree, (JCTree)resultItem.element, "", ListType.PARAMETER));
                    n2 = this.endPos(jCTree);
                    continue block6;
                }
                case INSERT: {
                    String string;
                    String string2 = separator.head(i) ? positionEstimator.head() : (separator.prev(i) ? positionEstimator.sep() : null);
                    String string3 = string = separator.next(i) ? positionEstimator.sep() : null;
                    if (positionEstimator.getIndentString() != null && !positionEstimator.getIndentString().equals(" ")) {
                        string2 = string2 + positionEstimator.getIndentString();
                    }
                    this.append(Diff.insert(n3, string2, (JCTree)resultItem.element, string, LineInsertionType.NONE));
                    continue block6;
                }
                case DELETE: {
                    int n5 = 0;
                    if (n4 == 0 && nArray[n4 + 1][2] != -1 && nArray[n4 + 1][2] == nArray[n4 + 1][3]) {
                        ++n5;
                    }
                    int n6 = this.toOff(separator.head(i) || separator.prev(i) ? nArray[n4][1] : nArray[n4][2 + n5]);
                    int n7 = this.toOff(separator.tail(i) || separator.next(i) ? nArray[n4 + 1][2] : nArray[n4][4]);
                    assert (n6 != -1 && n7 != -1) : "Invalid offset!";
                    this.append(Diff.delete(n6, n7));
                    this.tokenSequence.moveIndex(nArray[n4][4]);
                    if (this.tokenSequence.moveNext()) {
                        n3 = this.tokenSequence.offset();
                        if (JavaTokenId.COMMA == this.tokenSequence.token().id()) {
                            n3 += JavaTokenId.COMMA.fixedText().length();
                        }
                    }
                    JCTree jCTree = iterator.next();
                    ++n4;
                    n2 = this.endPos((JCTree)resultItem.element);
                    continue block6;
                }
                case NOCHANGE: {
                    this.tokenSequence.moveIndex(nArray[n4][4]);
                    if (this.tokenSequence.moveNext()) {
                        n3 = this.tokenSequence.offset();
                        if (JavaTokenId.COMMA == this.tokenSequence.token().id()) {
                            n3 += JavaTokenId.COMMA.fixedText().length();
                        }
                    }
                    JCTree jCTree = iterator.next();
                    ++n4;
                    n2 = this.endPos(jCTree);
                }
            }
        }
    }

    private int toOff(int n) {
        if (n == -1) {
            return -1;
        }
        this.tokenSequence.moveIndex(n);
        return this.tokenSequence.offset();
    }

    protected void diffParameterList(java.util.List<? extends JCTree> list, java.util.List<? extends JCTree> list2, int n, ListType listType) {
        if (list == list2) {
            return;
        }
        assert (list != null && list2 != null);
        int n2 = n;
        ListMatcher<? extends JCTree> listMatcher = ListMatcher.instance(list, list2);
        if (!listMatcher.match()) {
            return;
        }
        Iterator<? extends JCTree> iterator = list.iterator();
        ListMatcher.ResultItem<? extends JCTree>[] resultItemArray = listMatcher.getTransformedResult();
        ListMatcher.Separator separator = listMatcher.separatorInstance();
        separator.compute();
        block6: for (int i = 0; i < resultItemArray.length; ++i) {
            ListMatcher.ResultItem<? extends JCTree> resultItem = resultItemArray[i];
            switch (resultItem.operation) {
                case MODIFY: {
                    JCTree jCTree = iterator.next();
                    this.append(Diff.modify("", n2, jCTree, (JCTree)resultItem.element, "", ListType.PARAMETER));
                    n2 = this.endPos(jCTree);
                    continue block6;
                }
                case INSERT: {
                    String string;
                    String string2 = separator.head(i) ? listType.head() : (string = separator.prev(i) ? listType.sep() : null);
                    String string3 = separator.tail(i) ? listType.tail() : (separator.next(i) ? listType.sep() : null);
                    int n3 = n2;
                    if (iterator.hasNext() && n2 != n && (n3 = TokenUtilities.moveFwdToToken(this.tokenSequence, n2, listType.sep)) > 0) {
                        n3 += listType.sep.fixedText().length();
                    }
                    this.append(Diff.insert(string, (JCTree)resultItem.element, n3, string3, ListType.PARAMETER));
                    continue block6;
                }
                case DELETE: {
                    String string;
                    String string4 = separator.head(i) ? listType.headToken() : (string = separator.prev(i) ? listType.sepToken() : null);
                    String string3 = separator.tail(i) ? listType.tailToken() : (separator.next(i) ? listType.sepToken() : null);
                    this.append(Diff.delete(string, (JCTree)resultItem.element, n2, string3));
                    JCTree jCTree = iterator.next();
                    n2 = this.endPos((JCTree)resultItem.element);
                    continue block6;
                }
                case NOCHANGE: {
                    JCTree jCTree = iterator.next();
                    n2 = this.endPos(jCTree);
                }
            }
        }
    }

    protected void diffList(java.util.List<? extends JCTree> list, java.util.List<? extends JCTree> list2, int n, PositionEstimator positionEstimator, Measure measure) {
        this.diffList(list, list2, n, positionEstimator, measure, null);
    }

    protected void diffList(java.util.List<? extends JCTree> list, java.util.List<? extends JCTree> list2, int n, PositionEstimator positionEstimator, Measure measure, Name name) {
        if (list == list2) {
            return;
        }
        assert (list != null && list2 != null);
        ListMatcher<? extends JCTree> listMatcher = ListMatcher.instance(list, list2, measure);
        if (!listMatcher.match()) {
            return;
        }
        Iterator<? extends JCTree> iterator = list.iterator();
        ListMatcher.ResultItem<? extends JCTree>[] resultItemArray = listMatcher.getTransformedResult();
        int n2 = n;
        int n3 = 0;
        block6: for (int i = 0; i < resultItemArray.length; ++i) {
            JCTree jCTree = null;
            ListMatcher.ResultItem<? extends JCTree> resultItem = resultItemArray[i];
            switch (resultItem.operation) {
                case MODIFY: {
                    jCTree = iterator.next();
                    if (this.treesMatch(jCTree, (JCTree)resultItem.element, false)) {
                        this.diffTree(jCTree, (JCTree)resultItem.element);
                    } else {
                        this.append(Diff.modify(jCTree, n2, (JCTree)resultItem.element));
                    }
                    n2 = positionEstimator.getPositions(n3)[1];
                    ++n3;
                    continue block6;
                }
                case INSERT: {
                    int n4 = positionEstimator.getInsertPos(n3);
                    if (n4 < 0 && list.isEmpty() && n3 == 0) {
                        n4 = n;
                        StringBuilder stringBuilder = new StringBuilder();
                        StringBuilder stringBuilder2 = new StringBuilder();
                        n4 = positionEstimator.prepare(n, stringBuilder, stringBuilder2);
                        String string = null;
                        if (i + 1 == resultItemArray.length) {
                            string = stringBuilder2.toString();
                        }
                        this.append(Diff.insert(n4, stringBuilder.toString(), (JCTree)resultItem.element, string, positionEstimator.lineInsertType(), name));
                        continue block6;
                    }
                    this.append(Diff.insert((JCTree)resultItem.element, n4, positionEstimator.lineInsertType(), name));
                    continue block6;
                }
                case DELETE: {
                    jCTree = iterator.next();
                    int[] nArray = positionEstimator.getPositions(n3);
                    ++n3;
                    n2 = nArray[1];
                    this.append(Diff.delete(nArray[0], nArray[1]));
                    continue block6;
                }
                case NOCHANGE: {
                    jCTree = iterator.next();
                    n2 = positionEstimator.getPositions(n3)[1];
                    ++n3;
                }
            }
        }
    }

    private java.util.List filterHidden(java.util.List<JCTree> list) {
        ArrayList<JCTree> arrayList = new ArrayList<JCTree>();
        for (JCTree jCTree : list) {
            javax.lang.model.element.Name name;
            if (Tree.Kind.METHOD == jCTree.getKind() && "<init>".contentEquals(name = ((MethodTree)((Object)jCTree)).getName()) && jCTree.pos == this.oldParent.pos) continue;
            arrayList.add(jCTree);
        }
        return arrayList;
    }

    private boolean isHidden(JCTree jCTree, JCTree jCTree2) {
        if (jCTree2 == null) {
            return false;
        }
        if (jCTree.pos == -2) {
            return true;
        }
        return this.model.isSynthetic(jCTree);
    }

    protected void diffPrecedingComments(JCTree jCTree, JCTree jCTree2) {
        CommentSet commentSet = this.comments.getComments(jCTree2);
        if (!commentSet.hasChanges()) {
            return;
        }
        java.util.List<Comment> list = this.comments.getComments(jCTree).getPrecedingComments();
        java.util.List<Comment> list2 = commentSet.getPrecedingComments();
        this.diffCommentLists(jCTree, jCTree2, list, list2, false);
    }

    protected void diffTrailingComments(JCTree jCTree, JCTree jCTree2) {
        CommentSet commentSet = this.comments.getComments(jCTree2);
        if (!commentSet.hasChanges()) {
            return;
        }
        java.util.List<Comment> list = this.comments.getComments(jCTree).getTrailingComments();
        java.util.List<Comment> list2 = commentSet.getTrailingComments();
        this.diffCommentLists(jCTree, jCTree2, list, list2, true);
    }

    private void diffCommentLists(JCTree jCTree, JCTree jCTree2, java.util.List<Comment> list, java.util.List<Comment> list2, boolean bl) {
        int n = this.getOldPos(jCTree);
        Iterator<Comment> iterator = list.iterator();
        Iterator<Comment> iterator2 = list2.iterator();
        Comment comment = this.safeNext(iterator);
        Comment comment2 = this.safeNext(iterator2);
        while (comment != null && comment2 != null) {
            n = comment.pos();
            if (this.commentsMatch(comment, comment2)) {
                comment = this.safeNext(iterator);
                comment2 = this.safeNext(iterator2);
                continue;
            }
            if (!this.listContains(list2, comment)) {
                if (!this.listContains(list, comment2)) {
                    this.append(Diff.modify(jCTree, jCTree2, comment, comment2));
                    comment = this.safeNext(iterator);
                    comment2 = this.safeNext(iterator2);
                    continue;
                }
                this.append(Diff.delete(jCTree, jCTree2, comment));
                comment = this.safeNext(iterator);
                continue;
            }
            this.append(Diff.insert(n, LineInsertionType.BEFORE, jCTree, jCTree2, comment2, bl));
            comment2 = this.safeNext(iterator2);
        }
        while (comment != null) {
            this.append(Diff.delete(jCTree, jCTree2, comment));
            comment = this.safeNext(iterator);
        }
        while (comment2 != null) {
            this.append(Diff.insert(n, LineInsertionType.BEFORE, jCTree, jCTree2, comment2, bl));
            n += comment2.endPos() - comment2.pos();
            comment2 = this.safeNext(iterator);
        }
    }

    private Comment safeNext(Iterator<Comment> iterator) {
        return iterator.hasNext() ? iterator.next() : null;
    }

    private boolean commentsMatch(Comment comment, Comment comment2) {
        if (comment == null && comment2 == null) {
            return true;
        }
        if (comment == null || comment2 == null) {
            return false;
        }
        return comment.equals(comment2);
    }

    private boolean listContains(java.util.List<Comment> list, Comment comment) {
        for (Comment comment2 : list) {
            if (!comment2.equals(comment)) continue;
            return true;
        }
        return false;
    }

    private static JCTree leftMostTree(JCTree jCTree) {
        switch (jCTree.tag) {
            case 26: {
                return TreeDiff.leftMostTree(((JCTree.JCMethodInvocation)jCTree).meth);
            }
            case 30: {
                return TreeDiff.leftMostTree(((JCTree.JCAssign)jCTree).lhs);
            }
            case 74: 
            case 75: 
            case 76: 
            case 83: 
            case 84: 
            case 85: 
            case 86: 
            case 87: 
            case 88: 
            case 89: 
            case 90: {
                return TreeDiff.leftMostTree(((JCTree.JCAssignOp)jCTree).lhs);
            }
            case 55: 
            case 56: 
            case 57: 
            case 58: 
            case 59: 
            case 60: 
            case 61: 
            case 62: 
            case 63: 
            case 64: 
            case 65: 
            case 66: 
            case 67: 
            case 68: 
            case 69: 
            case 70: 
            case 71: 
            case 72: 
            case 73: {
                return TreeDiff.leftMostTree(((JCTree.JCBinary)jCTree).lhs);
            }
            case 3: {
                JCTree.JCClassDecl jCClassDecl = (JCTree.JCClassDecl)jCTree;
                if (jCClassDecl.mods.pos == -1) break;
                return jCClassDecl.mods;
            }
            case 18: {
                return TreeDiff.leftMostTree(((JCTree.JCConditional)jCTree).cond);
            }
            case 20: {
                return TreeDiff.leftMostTree(((JCTree.JCExpressionStatement)jCTree).expr);
            }
            case 33: {
                return TreeDiff.leftMostTree(((JCTree.JCArrayAccess)jCTree).indexed);
            }
            case 4: {
                JCTree.JCMethodDecl jCMethodDecl = (JCTree.JCMethodDecl)jCTree;
                if (jCMethodDecl.mods.pos != -1) {
                    return jCMethodDecl.mods;
                }
                if (jCMethodDecl.restype != null) {
                    return TreeDiff.leftMostTree(jCMethodDecl.restype);
                }
                return jCMethodDecl;
            }
            case 34: {
                return TreeDiff.leftMostTree(((JCTree.JCFieldAccess)jCTree).selected);
            }
            case 39: {
                return TreeDiff.leftMostTree(((JCTree.JCTypeApply)jCTree).clazz);
            }
            case 38: {
                return TreeDiff.leftMostTree(((JCTree.JCArrayTypeTree)jCTree).elemtype);
            }
            case 32: {
                return TreeDiff.leftMostTree(((JCTree.JCInstanceOf)jCTree).expr);
            }
            case 52: 
            case 53: {
                return TreeDiff.leftMostTree(((JCTree.JCUnary)jCTree).arg);
            }
            case 5: {
                JCTree.JCVariableDecl jCVariableDecl = (JCTree.JCVariableDecl)jCTree;
                if (jCVariableDecl.mods.pos != -1) {
                    return jCVariableDecl.mods;
                }
                return TreeDiff.leftMostTree(jCVariableDecl.vartype);
            }
            case 1: {
                JCTree.JCCompilationUnit jCCompilationUnit = (JCTree.JCCompilationUnit)jCTree;
                assert (jCCompilationUnit.defs.size() > 0);
                return jCCompilationUnit.pid != null ? jCCompilationUnit.pid : (JCTree)jCCompilationUnit.defs.head;
            }
        }
        return jCTree;
    }

    private int getOldPos(JCTree jCTree) {
        return TreeDiff.getOldPos(jCTree, this.model, this.undo);
    }

    static int getOldPos(JCTree jCTree, ASTModel aSTModel, UndoList undoList) {
        JCTree jCTree2;
        int n = aSTModel.getStartPos(jCTree);
        if (n == -2 && (jCTree2 = undoList.getOld(TreeDiff.leftMostTree(jCTree))) != null && jCTree2 != jCTree) {
            n = TreeDiff.getOldPos(jCTree2, aSTModel, undoList);
        }
        if (n == -2) {
            n = jCTree.pos == -2 ? TreeDiff.leftMostTree((JCTree)jCTree).pos : jCTree.pos;
        }
        return n;
    }

    protected void diffTree(JCTree jCTree, JCTree jCTree2) {
        if (jCTree == null && jCTree2 != null) {
            throw new IllegalArgumentException("Null is not allowed in parameters.");
        }
        this.diffTree(jCTree, jCTree2, -1, null);
    }

    private void diffTree(JCTree jCTree, JCTree jCTree2, int n, String string) {
        if (jCTree == jCTree2) {
            return;
        }
        this.diffPrecedingComments(jCTree, jCTree2);
        if (jCTree == null) {
            this.append(Diff.insert(n, string, jCTree2, "", LineInsertionType.NONE));
            return;
        }
        int n2 = this.getOldPos(jCTree);
        if (jCTree2 == null) {
            if (n == -1) {
                this.append(Diff.delete(jCTree, n2));
            } else {
                this.append(Diff.delete(n, this.endPos(jCTree)));
            }
            return;
        }
        if (jCTree.tag != 1 && jCTree.tag != 4 && jCTree.tag != 3 && jCTree.tag != 5 && (jCTree.tag != jCTree2.tag || jCTree2.pos == -2 || jCTree.type != jCTree2.type)) {
            this.append(Diff.modify(jCTree, n2, jCTree2));
            return;
        }
        switch (jCTree.tag) {
            case 1: {
                this.diffTopLevel((JCTree.JCCompilationUnit)jCTree, (JCTree.JCCompilationUnit)jCTree2);
                break;
            }
            case 2: {
                this.diffImport((JCTree.JCImport)jCTree, (JCTree.JCImport)jCTree2);
                break;
            }
            case 3: {
                this.diffClassDef((JCTree.JCClassDecl)jCTree, (JCTree.JCClassDecl)jCTree2);
                break;
            }
            case 4: {
                this.diffMethodDef((JCTree.JCMethodDecl)jCTree, (JCTree.JCMethodDecl)jCTree2);
                break;
            }
            case 5: {
                this.diffVarDef((JCTree.JCVariableDecl)jCTree, (JCTree.JCVariableDecl)jCTree2);
                break;
            }
            case 6: {
                break;
            }
            case 7: {
                this.diffBlock((JCTree.JCBlock)jCTree, (JCTree.JCBlock)jCTree2);
                break;
            }
            case 8: {
                this.diffDoLoop((JCTree.JCDoWhileLoop)jCTree, (JCTree.JCDoWhileLoop)jCTree2);
                break;
            }
            case 9: {
                this.diffWhileLoop((JCTree.JCWhileLoop)jCTree, (JCTree.JCWhileLoop)jCTree2);
                break;
            }
            case 10: {
                this.diffForLoop((JCTree.JCForLoop)jCTree, (JCTree.JCForLoop)jCTree2);
                break;
            }
            case 11: {
                this.diffForeachLoop((JCTree.JCEnhancedForLoop)jCTree, (JCTree.JCEnhancedForLoop)jCTree2);
                break;
            }
            case 12: {
                this.diffLabelled((JCTree.JCLabeledStatement)jCTree, (JCTree.JCLabeledStatement)jCTree2);
                break;
            }
            case 13: {
                this.diffSwitch((JCTree.JCSwitch)jCTree, (JCTree.JCSwitch)jCTree2);
                break;
            }
            case 14: {
                this.diffCase((JCTree.JCCase)jCTree, (JCTree.JCCase)jCTree2);
                break;
            }
            case 15: {
                this.diffSynchronized((JCTree.JCSynchronized)jCTree, (JCTree.JCSynchronized)jCTree2);
                break;
            }
            case 16: {
                this.diffTry((JCTree.JCTry)jCTree, (JCTree.JCTry)jCTree2);
                break;
            }
            case 17: {
                this.diffCatch((JCTree.JCCatch)jCTree, (JCTree.JCCatch)jCTree2);
                break;
            }
            case 18: {
                this.diffConditional((JCTree.JCConditional)jCTree, (JCTree.JCConditional)jCTree2);
                break;
            }
            case 19: {
                this.diffIf((JCTree.JCIf)jCTree, (JCTree.JCIf)jCTree2);
                break;
            }
            case 20: {
                this.diffExec((JCTree.JCExpressionStatement)jCTree, (JCTree.JCExpressionStatement)jCTree2);
                break;
            }
            case 21: {
                this.diffBreak((JCTree.JCBreak)jCTree, (JCTree.JCBreak)jCTree2);
                break;
            }
            case 22: {
                this.diffContinue((JCTree.JCContinue)jCTree, (JCTree.JCContinue)jCTree2);
                break;
            }
            case 23: {
                this.diffReturn((JCTree.JCReturn)jCTree, (JCTree.JCReturn)jCTree2);
                break;
            }
            case 24: {
                this.diffThrow((JCTree.JCThrow)jCTree, (JCTree.JCThrow)jCTree2);
                break;
            }
            case 25: {
                this.diffAssert((JCTree.JCAssert)jCTree, (JCTree.JCAssert)jCTree2);
                break;
            }
            case 26: {
                this.diffApply((JCTree.JCMethodInvocation)jCTree, (JCTree.JCMethodInvocation)jCTree2);
                break;
            }
            case 27: {
                this.diffNewClass((JCTree.JCNewClass)jCTree, (JCTree.JCNewClass)jCTree2);
                break;
            }
            case 28: {
                this.diffNewArray((JCTree.JCNewArray)jCTree, (JCTree.JCNewArray)jCTree2);
                break;
            }
            case 29: {
                this.diffParens((JCTree.JCParens)jCTree, (JCTree.JCParens)jCTree2);
                break;
            }
            case 30: {
                this.diffAssign((JCTree.JCAssign)jCTree, (JCTree.JCAssign)jCTree2);
                break;
            }
            case 31: {
                this.diffTypeCast((JCTree.JCTypeCast)jCTree, (JCTree.JCTypeCast)jCTree2);
                break;
            }
            case 32: {
                this.diffTypeTest((JCTree.JCInstanceOf)jCTree, (JCTree.JCInstanceOf)jCTree2);
                break;
            }
            case 33: {
                this.diffIndexed((JCTree.JCArrayAccess)jCTree, (JCTree.JCArrayAccess)jCTree2);
                break;
            }
            case 34: {
                this.diffSelect((JCTree.JCFieldAccess)jCTree, (JCTree.JCFieldAccess)jCTree2);
                break;
            }
            case 35: {
                this.diffIdent((JCTree.JCIdent)jCTree, (JCTree.JCIdent)jCTree2);
                break;
            }
            case 36: {
                this.diffLiteral((JCTree.JCLiteral)jCTree, (JCTree.JCLiteral)jCTree2);
                break;
            }
            case 37: {
                this.diffTypeIdent((JCTree.JCPrimitiveTypeTree)jCTree, (JCTree.JCPrimitiveTypeTree)jCTree2);
                break;
            }
            case 38: {
                this.diffTypeArray((JCTree.JCArrayTypeTree)jCTree, (JCTree.JCArrayTypeTree)jCTree2);
                break;
            }
            case 39: {
                this.diffTypeApply((JCTree.JCTypeApply)jCTree, (JCTree.JCTypeApply)jCTree2);
                break;
            }
            case 40: {
                this.diffTypeParameter((JCTree.JCTypeParameter)jCTree, (JCTree.JCTypeParameter)jCTree2);
                break;
            }
            case 41: {
                this.diffWildcard((JCTree.JCWildcard)jCTree, (JCTree.JCWildcard)jCTree2);
                break;
            }
            case 42: {
                this.diffTypeBoundKind((JCTree.TypeBoundKind)jCTree, (JCTree.TypeBoundKind)jCTree2);
                break;
            }
            case 43: {
                this.diffAnnotation((JCTree.JCAnnotation)jCTree, (JCTree.JCAnnotation)jCTree2);
                break;
            }
            case 91: {
                this.diffLetExpr((JCTree.LetExpr)jCTree, (JCTree.LetExpr)jCTree2);
                break;
            }
            case 46: 
            case 47: 
            case 48: 
            case 49: 
            case 50: 
            case 51: 
            case 52: 
            case 53: 
            case 54: {
                this.diffUnary((JCTree.JCUnary)jCTree, (JCTree.JCUnary)jCTree2);
                break;
            }
            case 55: 
            case 56: 
            case 57: 
            case 58: 
            case 59: 
            case 60: 
            case 61: 
            case 62: 
            case 63: 
            case 64: 
            case 65: 
            case 66: 
            case 67: 
            case 68: 
            case 69: 
            case 70: 
            case 71: 
            case 72: 
            case 73: {
                this.diffBinary((JCTree.JCBinary)jCTree, (JCTree.JCBinary)jCTree2);
                break;
            }
            case 74: 
            case 75: 
            case 76: 
            case 83: 
            case 84: 
            case 85: 
            case 86: 
            case 87: 
            case 88: 
            case 89: 
            case 90: {
                this.diffAssignop((JCTree.JCAssignOp)jCTree, (JCTree.JCAssignOp)jCTree2);
                break;
            }
            case 45: {
                this.diffErroneous((JCTree.JCErroneous)jCTree, (JCTree.JCErroneous)jCTree2);
                break;
            }
            default: {
                String string2 = "Diff not implemented: " + jCTree.getKind().toString() + " " + jCTree.getClass().getName();
                throw new AssertionError((Object)string2);
            }
        }
        this.diffTrailingComments(jCTree, jCTree2);
    }

    protected boolean listsMatch(java.util.List<? extends JCTree> list, java.util.List<? extends JCTree> list2) {
        if (list == list2) {
            return true;
        }
        int n = list.size();
        if (list2.size() != n) {
            return false;
        }
        for (int i = 0; i < n; ++i) {
            if (this.treesMatch(list.get(i), list2.get(i))) continue;
            return false;
        }
        return true;
    }

    private boolean matchImport(JCTree.JCImport jCImport, JCTree.JCImport jCImport2) {
        return jCImport.staticImport == jCImport2.staticImport && this.treesMatch(jCImport.qualid, jCImport2.qualid);
    }

    private boolean matchBlock(JCTree.JCBlock jCBlock, JCTree.JCBlock jCBlock2) {
        return jCBlock.flags == jCBlock2.flags && this.listsMatch(jCBlock.stats, jCBlock2.stats);
    }

    private boolean matchDoLoop(JCTree.JCDoWhileLoop jCDoWhileLoop, JCTree.JCDoWhileLoop jCDoWhileLoop2) {
        return this.treesMatch(jCDoWhileLoop.cond, jCDoWhileLoop2.cond) && this.treesMatch(jCDoWhileLoop.body, jCDoWhileLoop2.body);
    }

    private boolean matchWhileLoop(JCTree.JCWhileLoop jCWhileLoop, JCTree.JCWhileLoop jCWhileLoop2) {
        return this.treesMatch(jCWhileLoop.cond, jCWhileLoop2.cond) && this.treesMatch(jCWhileLoop.body, jCWhileLoop2.body);
    }

    private boolean matchForLoop(JCTree.JCForLoop jCForLoop, JCTree.JCForLoop jCForLoop2) {
        return this.listsMatch(jCForLoop.init, jCForLoop2.init) && this.treesMatch(jCForLoop.cond, jCForLoop2.cond) && this.listsMatch(jCForLoop.step, jCForLoop2.step) && this.treesMatch(jCForLoop.body, jCForLoop2.body);
    }

    private boolean matchForeachLoop(JCTree.JCEnhancedForLoop jCEnhancedForLoop, JCTree.JCEnhancedForLoop jCEnhancedForLoop2) {
        return this.treesMatch(jCEnhancedForLoop.var, jCEnhancedForLoop2.var) && this.treesMatch(jCEnhancedForLoop.expr, jCEnhancedForLoop2.expr) && this.treesMatch(jCEnhancedForLoop.body, jCEnhancedForLoop2.body);
    }

    private boolean matchLabelled(JCTree.JCLabeledStatement jCLabeledStatement, JCTree.JCLabeledStatement jCLabeledStatement2) {
        return jCLabeledStatement.label == jCLabeledStatement2.label && this.treesMatch(jCLabeledStatement.body, jCLabeledStatement2.body);
    }

    private boolean matchSwitch(JCTree.JCSwitch jCSwitch, JCTree.JCSwitch jCSwitch2) {
        return this.treesMatch(jCSwitch.selector, jCSwitch2.selector) && this.listsMatch(jCSwitch.cases, jCSwitch2.cases);
    }

    private boolean matchCase(JCTree.JCCase jCCase, JCTree.JCCase jCCase2) {
        return this.treesMatch(jCCase.pat, jCCase2.pat) && this.listsMatch(jCCase.stats, jCCase2.stats);
    }

    private boolean matchSynchronized(JCTree.JCSynchronized jCSynchronized, JCTree.JCSynchronized jCSynchronized2) {
        return this.treesMatch(jCSynchronized.lock, jCSynchronized2.lock) && this.treesMatch(jCSynchronized.body, jCSynchronized2.body);
    }

    private boolean matchTry(JCTree.JCTry jCTry, JCTree.JCTry jCTry2) {
        return this.treesMatch(jCTry.finalizer, jCTry2.finalizer) && this.listsMatch(jCTry.catchers, jCTry2.catchers) && this.treesMatch(jCTry.body, jCTry2.body);
    }

    private boolean matchCatch(JCTree.JCCatch jCCatch, JCTree.JCCatch jCCatch2) {
        return this.treesMatch(jCCatch.param, jCCatch2.param) && this.treesMatch(jCCatch.body, jCCatch2.body);
    }

    private boolean matchConditional(JCTree.JCConditional jCConditional, JCTree.JCConditional jCConditional2) {
        return this.treesMatch(jCConditional.cond, jCConditional2.cond) && this.treesMatch(jCConditional.truepart, jCConditional2.truepart) && this.treesMatch(jCConditional.falsepart, jCConditional2.falsepart);
    }

    private boolean matchIf(JCTree.JCIf jCIf, JCTree.JCIf jCIf2) {
        return this.treesMatch(jCIf.cond, jCIf2.cond) && this.treesMatch(jCIf.thenpart, jCIf2.thenpart) && this.treesMatch(jCIf.elsepart, jCIf2.elsepart);
    }

    private boolean matchBreak(JCTree.JCBreak jCBreak, JCTree.JCBreak jCBreak2) {
        return jCBreak.label == jCBreak2.label && this.treesMatch(jCBreak.target, jCBreak2.target);
    }

    private boolean matchContinue(JCTree.JCContinue jCContinue, JCTree.JCContinue jCContinue2) {
        return jCContinue.label == jCContinue2.label && this.treesMatch(jCContinue.target, jCContinue2.target);
    }

    private boolean matchAssert(JCTree.JCAssert jCAssert, JCTree.JCAssert jCAssert2) {
        return this.treesMatch(jCAssert.cond, jCAssert2.cond) && this.treesMatch(jCAssert.detail, jCAssert2.detail);
    }

    private boolean matchApply(JCTree.JCMethodInvocation jCMethodInvocation, JCTree.JCMethodInvocation jCMethodInvocation2) {
        return jCMethodInvocation.varargsElement == jCMethodInvocation2.varargsElement && this.listsMatch(jCMethodInvocation.typeargs, jCMethodInvocation2.typeargs) && this.treesMatch(jCMethodInvocation.meth, jCMethodInvocation2.meth) && this.listsMatch(jCMethodInvocation.args, jCMethodInvocation2.args);
    }

    private boolean matchNewClass(JCTree.JCNewClass jCNewClass, JCTree.JCNewClass jCNewClass2) {
        return jCNewClass.constructor == jCNewClass2.constructor && this.listsMatch(jCNewClass.typeargs, jCNewClass2.typeargs) && this.listsMatch(jCNewClass.args, jCNewClass2.args) && jCNewClass.varargsElement == jCNewClass2.varargsElement;
    }

    private boolean matchNewArray(JCTree.JCNewArray jCNewArray, JCTree.JCNewArray jCNewArray2) {
        return this.treesMatch(jCNewArray.elemtype, jCNewArray2.elemtype) && this.listsMatch(jCNewArray.dims, jCNewArray2.dims) && this.listsMatch(jCNewArray.elems, jCNewArray2.elems);
    }

    private boolean matchAssign(JCTree.JCAssign jCAssign, JCTree.JCAssign jCAssign2) {
        return this.treesMatch(jCAssign.lhs, jCAssign2.lhs) && this.treesMatch(jCAssign.rhs, jCAssign2.rhs);
    }

    private boolean matchAssignop(JCTree.JCAssignOp jCAssignOp, JCTree.JCAssignOp jCAssignOp2) {
        return jCAssignOp.operator == jCAssignOp2.operator && this.treesMatch(jCAssignOp.lhs, jCAssignOp2.lhs) && this.treesMatch(jCAssignOp.rhs, jCAssignOp2.rhs);
    }

    private boolean matchUnary(JCTree.JCUnary jCUnary, JCTree.JCUnary jCUnary2) {
        return jCUnary.operator == jCUnary2.operator && this.treesMatch(jCUnary.arg, jCUnary2.arg);
    }

    private boolean matchBinary(JCTree.JCBinary jCBinary, JCTree.JCBinary jCBinary2) {
        return jCBinary.operator == jCBinary2.operator && this.treesMatch(jCBinary.lhs, jCBinary2.lhs) && this.treesMatch(jCBinary.rhs, jCBinary2.rhs);
    }

    private boolean matchTypeCast(JCTree.JCTypeCast jCTypeCast, JCTree.JCTypeCast jCTypeCast2) {
        return this.treesMatch(jCTypeCast.clazz, jCTypeCast2.clazz) && this.treesMatch(jCTypeCast.expr, jCTypeCast2.expr);
    }

    private boolean matchTypeTest(JCTree.JCInstanceOf jCInstanceOf, JCTree.JCInstanceOf jCInstanceOf2) {
        return this.treesMatch(jCInstanceOf.clazz, jCInstanceOf2.clazz) && this.treesMatch(jCInstanceOf.expr, jCInstanceOf2.expr);
    }

    private boolean matchIndexed(JCTree.JCArrayAccess jCArrayAccess, JCTree.JCArrayAccess jCArrayAccess2) {
        return this.treesMatch(jCArrayAccess.indexed, jCArrayAccess2.indexed) && this.treesMatch(jCArrayAccess.index, jCArrayAccess2.index);
    }

    private boolean matchLiteral(JCTree.JCLiteral jCLiteral, JCTree.JCLiteral jCLiteral2) {
        return jCLiteral.typetag == jCLiteral2.typetag && jCLiteral.value == jCLiteral2.value;
    }

    private boolean matchTypeApply(JCTree.JCTypeApply jCTypeApply, JCTree.JCTypeApply jCTypeApply2) {
        return this.treesMatch(jCTypeApply.clazz, jCTypeApply2.clazz) && this.listsMatch(jCTypeApply.arguments, jCTypeApply2.arguments);
    }

    private boolean matchTypeParameter(JCTree.JCTypeParameter jCTypeParameter, JCTree.JCTypeParameter jCTypeParameter2) {
        return jCTypeParameter.name == jCTypeParameter2.name && this.listsMatch(jCTypeParameter.bounds, jCTypeParameter2.bounds);
    }

    private boolean matchWildcard(JCTree.JCWildcard jCWildcard, JCTree.JCWildcard jCWildcard2) {
        return jCWildcard.kind == jCWildcard2.kind && this.treesMatch(jCWildcard.inner, jCWildcard2.inner);
    }

    private boolean matchAnnotation(JCTree.JCAnnotation jCAnnotation, JCTree.JCAnnotation jCAnnotation2) {
        return this.treesMatch(jCAnnotation.annotationType, jCAnnotation2.annotationType) && this.listsMatch(jCAnnotation.args, jCAnnotation2.args);
    }

    private boolean matchModifiers(JCTree.JCModifiers jCModifiers, JCTree.JCModifiers jCModifiers2) {
        return jCModifiers.flags == jCModifiers2.flags && this.listsMatch(jCModifiers.annotations, jCModifiers2.annotations);
    }

    private boolean matchLetExpr(JCTree.LetExpr letExpr, JCTree.LetExpr letExpr2) {
        return this.listsMatch(letExpr.defs, letExpr2.defs) && this.treesMatch(letExpr.expr, letExpr2.expr);
    }

    private void diffTreeToken(String string, int n, JCTree jCTree, JCTree jCTree2, String string2) {
        if (jCTree == jCTree2) {
            return;
        }
        this.append(Diff.modify(string, n, jCTree, jCTree2, string2, null));
    }

    public static class Diff {
        protected DiffTypes type;
        int pos;
        protected JCTree oldTree;
        protected JCTree newTree;
        protected LineInsertionType newLine;
        protected Comment oldComment;
        protected Comment newComment;
        protected boolean trailing;
        protected Name owningClassName;

        static Diff name(int n, Name name, Name name2) {
            return new NameDiff(n, name, name2);
        }

        static Diff name(int n, String string, String string2) {
            return new NameDiff(n, string, string2);
        }

        static Diff flags(int n, int n2, long l, long l2) {
            return new FlagsDiff(n, n2, l, l2);
        }

        static Diff delete(JCTree jCTree, int n) {
            return new Diff(DiffTypes.DELETE, n, jCTree, null);
        }

        static Diff insert(JCTree jCTree, int n, LineInsertionType lineInsertionType) {
            return new Diff(DiffTypes.INSERT, n, null, jCTree, lineInsertionType);
        }

        static Diff insert(JCTree jCTree, int n, LineInsertionType lineInsertionType, Name name) {
            return new Diff(DiffTypes.INSERT, n, null, jCTree, lineInsertionType, null, null, false, name);
        }

        static Diff modify(JCTree jCTree, int n, JCTree jCTree2) {
            return new Diff(DiffTypes.MODIFY, n, jCTree, jCTree2);
        }

        static Diff delete(JCTree jCTree, JCTree jCTree2, Comment comment) {
            return new Diff(DiffTypes.DELETE_COMMENT, comment.pos(), jCTree, jCTree2, LineInsertionType.BEFORE, comment, null, false, null);
        }

        static Diff insert(int n, LineInsertionType lineInsertionType, JCTree jCTree, JCTree jCTree2, Comment comment, boolean bl) {
            return new Diff(DiffTypes.INSERT_COMMENT, n, jCTree, jCTree2, lineInsertionType, null, comment, bl, null);
        }

        static Diff modify(JCTree jCTree, JCTree jCTree2, Comment comment, Comment comment2) {
            return new Diff(DiffTypes.MODIFY_COMMENT, comment.pos(), jCTree, jCTree2, LineInsertionType.NONE, comment, comment2, false, null);
        }

        static Diff insert(String string, JCTree jCTree, int n, String string2, ListType listType) {
            return new TokenDiff(DiffTypes.INSERT_TOKEN, n, string, null, jCTree, string2, listType);
        }

        static Diff delete(String string, JCTree jCTree, int n, String string2) {
            return new TokenDiff(DiffTypes.DELETE_TOKEN, n, string, jCTree, null, string2, null);
        }

        static Diff modify(String string, int n, JCTree jCTree, JCTree jCTree2, String string2, ListType listType) {
            return new TokenDiff(DiffTypes.MODIFY_TOKEN, n, string, jCTree, jCTree2, string2, listType);
        }

        static Diff insert(int n, String string, JCTree jCTree, String string2, LineInsertionType lineInsertionType, Name name) {
            return new OffsetDiff(DiffTypes.INSERT_OFFSET, n, -1, string, jCTree, string2, lineInsertionType, name);
        }

        static Diff insert(int n, String string, JCTree jCTree, String string2, LineInsertionType lineInsertionType) {
            return new OffsetDiff(DiffTypes.INSERT_OFFSET, n, -1, string, jCTree, string2, lineInsertionType, null);
        }

        static Diff delete(int n, int n2) {
            return new OffsetDiff(DiffTypes.DELETE_OFFSET, n, n2, null, null, null, LineInsertionType.NONE, null);
        }

        Diff(DiffTypes diffTypes, int n) {
            this(diffTypes, n, null, null);
        }

        Diff(DiffTypes diffTypes, int n, JCTree jCTree, JCTree jCTree2) {
            this(diffTypes, n, jCTree, jCTree2, LineInsertionType.NONE, null, null, false, null);
        }

        Diff(DiffTypes diffTypes, int n, JCTree jCTree, JCTree jCTree2, LineInsertionType lineInsertionType) {
            this(diffTypes, n, jCTree, jCTree2, lineInsertionType, null, null, false, null);
        }

        Diff(DiffTypes diffTypes, int n, JCTree jCTree, JCTree jCTree2, LineInsertionType lineInsertionType, Comment comment, Comment comment2, boolean bl, Name name) {
            assert (n >= 0) : "invalid source offset";
            this.type = diffTypes;
            this.pos = n;
            this.oldTree = jCTree;
            this.newTree = jCTree2;
            this.newLine = lineInsertionType;
            this.oldComment = comment;
            this.newComment = comment2;
            this.trailing = bl;
            this.owningClassName = name;
        }

        public JCTree getOld() {
            return this.oldTree;
        }

        public JCTree getNew() {
            return this.newTree;
        }

        public LineInsertionType needsNewLine() {
            return this.newLine;
        }

        public int getPos() {
            return this.pos;
        }

        public Comment getOldComment() {
            return this.oldComment;
        }

        public Comment getNewComment() {
            return this.newComment;
        }

        public boolean isTrailingComment() {
            return this.trailing;
        }

        public boolean equals(Object object) {
            if (!(object instanceof Diff)) {
                return false;
            }
            Diff diff = (Diff)object;
            return this.type != diff.type && this.pos != diff.pos && this.oldTree != diff.oldTree && this.newTree != diff.newTree && this.newLine != diff.newLine && this.oldComment != diff.oldComment && this.newComment != diff.newComment && this.trailing != diff.trailing;
        }

        public int hashCode() {
            return this.type.hashCode() + this.pos + (this.oldTree != null ? this.oldTree.hashCode() : 0) + (this.newTree != null ? this.newTree.hashCode() : 0) + this.newLine.hashCode() + (this.oldComment != null ? this.oldComment.hashCode() : 0) + (this.newComment != null ? this.newComment.hashCode() : 0) + Boolean.valueOf(this.trailing).hashCode();
        }

        public String toString() {
            StringBuffer stringBuffer = new StringBuffer();
            stringBuffer.append("tree (");
            stringBuffer.append(this.type.toString());
            stringBuffer.append(") pos=");
            stringBuffer.append(this.pos);
            if (this.trailing) {
                stringBuffer.append(" trailing comment");
            }
            stringBuffer.append("\n");
            if (this.type == DiffTypes.DELETE || this.type == DiffTypes.INSERT || this.type == DiffTypes.MODIFY) {
                this.addDiffString(stringBuffer, this.oldTree, this.newTree);
            } else {
                this.addDiffString(stringBuffer, this.oldComment, this.newComment);
            }
            return stringBuffer.toString();
        }

        private void addDiffString(StringBuffer stringBuffer, Object object, Object object2) {
            if (object != null) {
                stringBuffer.append("< ");
                stringBuffer.append(object.toString());
                stringBuffer.append(object2 != null ? "\n---\n> " : "\n");
            } else {
                stringBuffer.append("> ");
            }
            if (object2 != null) {
                stringBuffer.append(object2.toString());
                stringBuffer.append('\n');
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum DiffTypes {
        MODIFY("modify"),
        INSERT("insert"),
        DELETE("delete"),
        NAME("name"),
        FLAGS("flags"),
        MODIFY_COMMENT("modify_comment"),
        INSERT_COMMENT("insert_comment"),
        DELETE_COMMENT("delete_comment"),
        INSERT_OFFSET("insert_offset"),
        DELETE_OFFSET("delete_offset"),
        MODIFY_TOKEN("modify_token"),
        INSERT_TOKEN("insert_token"),
        DELETE_TOKEN("delete_token");

        public final String name;

        private DiffTypes(String string2) {
            this.name = string2;
        }
    }

    public static class FlagsDiff
    extends Diff {
        private long oldFlags;
        private long newFlags;
        int endPos;

        FlagsDiff(int n, int n2, long l, long l2) {
            super(DiffTypes.FLAGS, n);
            this.oldFlags = l;
            this.newFlags = l2;
            this.endPos = n2;
        }

        public long getOldFlags() {
            return this.oldFlags;
        }

        public long getNewFlags() {
            return this.newFlags;
        }

        public int getOldEndPos() {
            return this.endPos;
        }

        public boolean equals(Object object) {
            if (!(object instanceof FlagsDiff)) {
                return false;
            }
            FlagsDiff flagsDiff = (FlagsDiff)object;
            return super.equals(object) && this.oldFlags == flagsDiff.oldFlags && this.newFlags == flagsDiff.newFlags && this.endPos == flagsDiff.endPos;
        }

        public int hashCode() {
            return super.hashCode() + Long.valueOf(this.oldFlags).hashCode() + Long.valueOf(this.newFlags).hashCode() + this.endPos;
        }

        public String toString() {
            StringBuffer stringBuffer = new StringBuffer();
            stringBuffer.append("tree (");
            stringBuffer.append(this.type.toString());
            stringBuffer.append(") pos=");
            stringBuffer.append(this.pos);
            if (this.trailing) {
                stringBuffer.append(" trailing comment");
            }
            stringBuffer.append("\n< ");
            stringBuffer.append(TreeInfo.flagNames(this.oldFlags));
            stringBuffer.append("\n---\n> ");
            stringBuffer.append(TreeInfo.flagNames(this.newFlags));
            stringBuffer.append('\n');
            return stringBuffer.toString();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum LineInsertionType {
        BEFORE,
        AFTER,
        NONE;

    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum ListType {
        PARAMETER(null, JavaTokenId.COMMA, null, null, null, null),
        TYPE_PARAMETER(JavaTokenId.LT, JavaTokenId.COMMA, JavaTokenId.GT, null, null, "> ");

        public final JavaTokenId head;
        public final JavaTokenId sep;
        public final JavaTokenId tail;
        private final String printHead;
        private final String printSepa;
        private final String printTail;

        private ListType(JavaTokenId javaTokenId, JavaTokenId javaTokenId2, JavaTokenId javaTokenId3, String string2, String string3, String string4) {
            this.head = javaTokenId;
            this.sep = javaTokenId2;
            this.tail = javaTokenId3;
            this.printHead = string2;
            this.printSepa = string3;
            this.printTail = string4;
        }

        public String head() {
            return this.p(this.head, this.printHead);
        }

        public String sep() {
            return this.p(this.sep, this.printSepa);
        }

        public String tail() {
            return this.p(this.tail, this.printTail);
        }

        public String headToken() {
            return this.r(this.head);
        }

        public String sepToken() {
            return this.r(this.sep);
        }

        public String tailToken() {
            return this.r(this.tail);
        }

        private String p(JavaTokenId javaTokenId, String string) {
            if (string != null) {
                return string;
            }
            if (javaTokenId == null) {
                return null;
            }
            return javaTokenId.fixedText();
        }

        private String r(JavaTokenId javaTokenId) {
            return javaTokenId == null ? null : javaTokenId.fixedText();
        }
    }

    public static class NameDiff
    extends Diff {
        private String oldName;
        private String newName;

        NameDiff(int n, Name name, Name name2) {
            this(n, name.toString(), name2.toString());
        }

        NameDiff(int n, String string, String string2) {
            super(DiffTypes.NAME, n);
            this.oldName = string;
            this.newName = string2;
        }

        public String getOldName() {
            return this.oldName;
        }

        public String getNewName() {
            return this.newName;
        }

        public boolean equals(Object object) {
            if (!(object instanceof NameDiff)) {
                return false;
            }
            NameDiff nameDiff = (NameDiff)object;
            return super.equals(object) && this.oldName.equals(nameDiff.oldName) && this.newName.equals(nameDiff.newName);
        }

        public int hashCode() {
            return super.hashCode() + this.oldName.hashCode() + this.newName.hashCode();
        }
    }

    public static class OffsetDiff
    extends Diff {
        private final String head;
        private final String tail;
        private final int endOffset;

        OffsetDiff(DiffTypes diffTypes, int n, int n2, String string, JCTree jCTree, String string2, LineInsertionType lineInsertionType, Name name) {
            super(diffTypes, n, null, jCTree, lineInsertionType);
            this.endOffset = n2;
            this.head = string;
            this.tail = string2;
            this.owningClassName = name;
        }

        public int getStartOffset() {
            return this.getPos();
        }

        public int getEndOffset() {
            return this.endOffset;
        }

        public String getHead() {
            return this.head;
        }

        String getTail() {
            return this.tail;
        }
    }

    public static class TokenDiff
    extends Diff {
        private String preceding;
        private String tail;
        private ListType itemType;

        TokenDiff(DiffTypes diffTypes, int n, String string, JCTree jCTree, JCTree jCTree2, String string2, ListType listType) {
            super(diffTypes, n, jCTree, jCTree2);
            this.preceding = string;
            this.tail = string2;
            this.itemType = listType;
        }

        String getPreceding() {
            return this.preceding;
        }

        String getTail() {
            return this.tail;
        }

        ListType getItemType() {
            return this.itemType;
        }
    }
}

