/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.java.source.script;

import com.sun.tools.javac.main.JavaCompiler;
import com.sun.tools.javac.util.Context;
import com.sun.tools.javac.util.DefaultFileManager;
import com.sun.tools.javac.util.List;
import com.sun.tools.javac.util.Options;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileWriter;
import java.io.IOException;
import java.io.Writer;
import javax.tools.JavaFileObject;
import org.netbeans.modules.java.source.script.ScriptParser;

public class PluginCompiler {
    private static final File generatedCodeDir;
    private final ClassLoader classloader = new ClassLoader(this.getClass().getClassLoader()){

        public Class findClass(String string) throws ClassNotFoundException {
            try {
                FileInputStream fileInputStream = new FileInputStream(new File(generatedCodeDir, string + ".class"));
                int n = fileInputStream.available();
                byte[] byArray = new byte[n];
                int n2 = fileInputStream.read(byArray);
                fileInputStream.close();
                if (n2 != n) {
                    throw new ClassNotFoundException("read failure");
                }
                return this.defineClass(string, byArray, 0, byArray.length);
            }
            catch (Throwable throwable) {
                ClassNotFoundException classNotFoundException = throwable instanceof ClassNotFoundException ? (ClassNotFoundException)throwable : new ClassNotFoundException("load failure", throwable);
                throw classNotFoundException;
            }
        }
    };
    private String className;
    private File source;
    private File genJava;
    private LineWriter out;
    private static int seq;
    private static final char[] hexChars;
    private static final char backslash = '\\';
    ScriptParser.ScriptLog log;

    public boolean needsGeneration(String string, long l, boolean bl) {
        char[] cArray;
        int n;
        int n2 = 0;
        int n3 = 0;
        if (string != null) {
            this.source = new File(string);
            n = string.length();
            cArray = new char[(n < 2 ? 10 : n) + 6];
            while (n2 < n) {
                char c = string.charAt(n2++);
                if (n3 > 0) {
                    if (Character.isJavaIdentifierPart(c)) {
                        cArray[n3++] = c;
                        continue;
                    }
                    if (cArray[n3 - 1] == '_') continue;
                    cArray[n3++] = 95;
                    continue;
                }
                if (!Character.isJavaIdentifierStart(c)) continue;
                cArray[n3++] = c;
            }
            while (n3 > 0 && cArray[n3 - 1] == '_') {
                --n3;
            }
        } else {
            this.source = null;
            cArray = new char[12];
        }
        if (n3 == 0) {
            cArray[n3++] = 67;
            n = seq++;
            do {
                cArray[n3++] = "ABCDEFGHIJKLMNOPQRSTUVWXYZabcdef".charAt(n & 0x1F);
            } while ((n >>>= 5) != 0);
        }
        this.className = new String(cArray, 0, n3);
        String string2 = new String(cArray, 0, PluginCompiler.addExt(cArray, n3, ".java"));
        this.genJava = new File(generatedCodeDir, string2);
        File file = new File(generatedCodeDir, string2.replace(".java", ".class"));
        this.out = null;
        if (bl) {
            return true;
        }
        long l2 = l > 0L ? l : (this.source != null ? this.source.lastModified() : 0L);
        return l2 <= 0L || l2 >= file.lastModified();
    }

    private static int addExt(char[] cArray, int n, String string) {
        int n2 = string.length();
        for (int i = 0; i < n2; ++i) {
            cArray[n + i] = string.charAt(i);
        }
        return n + n2;
    }

    public void startGeneration() throws IOException {
        this.out = new LineWriter(new FileWriter(this.genJava));
    }

    public void write(String string) throws IOException {
        this.out.write(string);
    }

    public void write(int n) throws IOException {
        if (n < 0) {
            this.out.write(45);
            n = -n;
        }
        if (n >= 10) {
            this.write(n / 10);
        }
        this.out.write((char)(48 + n % 10));
    }

    public void write(long l) throws IOException {
        if (l < 0L) {
            this.out.write(45);
            l = -l;
        }
        if (l >= 10L) {
            this.write(l / 10L);
        }
        this.out.write((char)(48L + l % 10L));
    }

    public void writeClassName() throws IOException {
        this.out.write(this.className);
    }

    public void write(char c) throws IOException {
        this.out.write(c);
    }

    private static void oneChar(Writer writer, char c) throws IOException {
        if (c < ' ' || c == '\'' || c >= '\u007f' && c <= '\u00ff') {
            writer.write(92);
            writer.write(hexChars[c >>> 6 & 7]);
            writer.write(hexChars[c >>> 3 & 7]);
            writer.write(hexChars[c >>> 0 & 7]);
        } else if (c == '\"') {
            writer.write(92);
            writer.write(34);
        } else if (c < '\u007f') {
            writer.write(c);
        } else {
            writer.write(92);
            writer.write(117);
            writer.write(hexChars[c >>> 12 & 0xF]);
            writer.write(hexChars[c >>> 8 & 0xF]);
            writer.write(hexChars[c >>> 4 & 0xF]);
            writer.write(hexChars[c >>> 0 & 0xF]);
        }
    }

    public void writeQuoted(String string) throws IOException {
        LineWriter lineWriter = this.out;
        if (string == null) {
            lineWriter.write("null");
        } else {
            int n = string.length();
            ((Writer)lineWriter).write(34);
            for (int i = 0; i < n; ++i) {
                PluginCompiler.oneChar(lineWriter, string.charAt(i));
            }
            ((Writer)lineWriter).write(34);
        }
    }

    public void writeCapitalizedIdent(String string) throws IOException {
        LineWriter lineWriter = this.out;
        if (string == null) {
            lineWriter.write("NULL");
        } else {
            int n = string.length();
            boolean bl = true;
            for (int i = 0; i < n; ++i) {
                char c = string.charAt(i);
                if (Character.isJavaIdentifierPart(c)) {
                    if (bl && Character.isLowerCase(c)) {
                        c = Character.toLowerCase(c);
                    }
                    ((Writer)lineWriter).write(c);
                    bl = false;
                    continue;
                }
                bl = true;
            }
        }
    }

    public void writeQuoted(char c) throws IOException {
        this.out.write(39);
        PluginCompiler.oneChar(this.out, c);
        this.out.write(39);
    }

    public Writer getWriter() {
        return this.out;
    }

    public int getCurrentLineNumber() {
        return this.out.getLineNumber();
    }

    public Class loadClass(String string) throws IOException {
        Object object;
        if (this.out != null) {
            this.out.close();
            Context context = new Context();
            DefaultFileManager.preRegister((Context)context);
            this.log = new ScriptParser.ScriptLog(context);
            object = Options.instance(context);
            String string2 = generatedCodeDir.toString();
            ((Options)object).put("-source", "1.5");
            ((Options)object).put("-target", "1.5");
            ((Options)object).put("-d", string2);
            ((Options)object).put("-sourcepath", string2);
            ((Options)object).put("-g", "-g");
            if (string != null) {
                ((Options)object).put("-Xbootclasspath/p:", string);
            }
            DefaultFileManager defaultFileManager = new DefaultFileManager(context, true, null);
            JavaFileObject javaFileObject = defaultFileManager.getFileForInput(this.genJava.toString());
            List<JavaFileObject> list = List.of(javaFileObject);
            JavaCompiler javaCompiler = new JavaCompiler(context);
            this.log.useSource(javaFileObject);
            try {
                javaCompiler.compile(list);
                if (this.hasErrors()) {
                    throw new IOException("Compilation errors");
                }
            }
            catch (Throwable throwable) {
                IOException iOException = new IOException("Class " + this.className + " compilation exception");
                iOException.initCause(throwable);
                throw iOException;
            }
        }
        try {
            return this.classloader.loadClass(this.className);
        }
        catch (ClassNotFoundException classNotFoundException) {
            object = new IOException("Class " + this.className + " not found");
            ((Throwable)object).initCause(classNotFoundException);
            throw object;
        }
    }

    public boolean hasErrors() {
        return this.log != null && this.log.hasErrors();
    }

    public String getErrors() {
        return this.log == null ? null : this.log.getErrors();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static {
        File file = new File(System.getProperty("user.home"), ".jackpot");
        if (!file.exists() && !file.mkdirs()) {
            File file2 = null;
            try {
                file2 = File.createTempFile("HOHO", null);
                file = new File(file2.getParentFile(), "PluginCache-" + System.getProperty("user.name", "user"));
            }
            catch (IOException iOException) {
                file = new File("/tmp/AuxPluginCache");
            }
            finally {
                if (file2 != null) {
                    file2.delete();
                }
            }
            file.mkdirs();
        }
        generatedCodeDir = file;
        seq = 0;
        hexChars = "0123456789ABCDEF".toCharArray();
    }

    private static class LineWriter
    extends BufferedWriter {
        int line = 0;

        LineWriter(Writer writer) {
            super(writer);
        }

        public void write(String string, int n, int n2) throws IOException {
            this.write(string.toCharArray(), n, n2);
        }

        public void write(char[] cArray, int n, int n2) throws IOException {
            super.write(cArray, n, n2);
            for (int i = n; i < n2; ++i) {
                if (cArray[i] != '\n') continue;
                ++this.line;
            }
        }

        public void write(int n) throws IOException {
            super.write(n);
            if (n == 10) {
                ++this.line;
            }
        }

        public void newLine() throws IOException {
            super.newLine();
            ++this.line;
        }

        int getLineNumber() {
            return this.line;
        }
    }
}

