/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.java.source.usages;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.Serializable;
import java.util.Comparator;
import java.util.EnumSet;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.logging.Logger;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.lang.model.element.ElementKind;
import org.apache.lucene.analysis.Analyzer;
import org.apache.lucene.analysis.KeywordAnalyzer;
import org.apache.lucene.document.Document;
import org.apache.lucene.index.IndexReader;
import org.apache.lucene.index.IndexWriter;
import org.apache.lucene.index.Term;
import org.apache.lucene.index.TermEnum;
import org.apache.lucene.search.BooleanClause;
import org.apache.lucene.search.BooleanQuery;
import org.apache.lucene.search.Hit;
import org.apache.lucene.search.Hits;
import org.apache.lucene.search.IndexSearcher;
import org.apache.lucene.search.Query;
import org.apache.lucene.search.Searcher;
import org.apache.lucene.search.TermQuery;
import org.apache.lucene.search.WildcardQuery;
import org.apache.lucene.store.Directory;
import org.apache.lucene.store.FSDirectory;
import org.apache.lucene.store.LockFactory;
import org.apache.lucene.store.RAMDirectory;
import org.netbeans.api.java.source.ClassIndex;
import org.netbeans.modules.java.source.usages.ClassIndexImpl;
import org.netbeans.modules.java.source.usages.DocumentUtil;
import org.netbeans.modules.java.source.usages.Index;
import org.netbeans.modules.java.source.usages.LuceneIndexMBeanImpl;
import org.netbeans.modules.java.source.usages.NBLockFactory;
import org.netbeans.modules.java.source.usages.ResultConvertor;
import org.netbeans.modules.java.source.util.LowMemoryEvent;
import org.netbeans.modules.java.source.util.LowMemoryListener;
import org.netbeans.modules.java.source.util.LowMemoryNotifier;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class LuceneIndex
extends Index {
    private static final boolean debugIndexMerging = Boolean.getBoolean("LuceneIndex.debugIndexMerge");
    private static final String REFERENCES = "refs";
    private static final Logger LOGGER = Logger.getLogger(LuceneIndex.class.getName());
    private final Directory directory;
    private Long rootTimeStamp;
    private IndexReader reader;
    private IndexWriter writer;
    private Set<String> rootPkgCache;

    public static Index create(File file) throws IOException {
        assert (file != null && file.exists() && file.canRead() && file.canWrite());
        return new LuceneIndex(LuceneIndex.getReferencesCacheFolder(file));
    }

    private LuceneIndex(File file) throws IOException {
        assert (file != null);
        this.directory = FSDirectory.getDirectory(file, (LockFactory)new NBLockFactory());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<String> getUsagesData(String string, Set<ClassIndexImpl.UsageType> set, Index.BooleanOperator booleanOperator) throws IOException {
        if (!this.isValid(false)) {
            return null;
        }
        IndexSearcher indexSearcher = new IndexSearcher(this.getReader());
        try {
            Serializable serializable;
            Object object;
            LinkedList<String> linkedList = new LinkedList<String>();
            Object object2 = null;
            if (set == null) {
                object2 = new WildcardQuery(DocumentUtil.referencesTerm(string, null));
            } else {
                assert (booleanOperator != null);
                switch (booleanOperator) {
                    case AND: {
                        object2 = new WildcardQuery(DocumentUtil.referencesTerm(string, set));
                        break;
                    }
                    case OR: {
                        object = new BooleanQuery();
                        for (ClassIndexImpl.UsageType object3 : set) {
                            serializable = new WildcardQuery(DocumentUtil.referencesTerm(string, EnumSet.of(object3)));
                            ((BooleanQuery)object).add((Query)serializable, BooleanClause.Occur.SHOULD);
                        }
                        object2 = object;
                        break;
                    }
                    default: {
                        throw new IllegalArgumentException(booleanOperator.toString());
                    }
                }
            }
            assert (object2 != null);
            object = indexSearcher.search((Query)object2);
            Object object4 = ((Hits)object).iterator();
            while (object4.hasNext()) {
                Hit hit = (Hit)object4.next();
                serializable = hit.getDocument();
                String string2 = DocumentUtil.getBinaryName(serializable);
                String string3 = DocumentUtil.getRefereneType(serializable, string);
                if (string3 == null) continue;
                linkedList.add(DocumentUtil.encodeUsage(string2, string3));
            }
            object4 = linkedList;
            return object4;
        }
        finally {
            ((Searcher)indexSearcher).close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<String> getUsagesFQN(String string, Set<ClassIndexImpl.UsageType> set, Index.BooleanOperator booleanOperator) throws IOException {
        if (!this.isValid(false)) {
            return null;
        }
        assert (string != null);
        assert (set != null);
        assert (booleanOperator != null);
        IndexSearcher indexSearcher = new IndexSearcher(this.getReader());
        try {
            Serializable serializable;
            Object object;
            Query query;
            LinkedList<String> linkedList = new LinkedList<String>();
            switch (booleanOperator) {
                case AND: {
                    query = new WildcardQuery(DocumentUtil.referencesTerm(string, set));
                    break;
                }
                case OR: {
                    object = new BooleanQuery();
                    for (ClassIndexImpl.UsageType object2 : set) {
                        serializable = new WildcardQuery(DocumentUtil.referencesTerm(string, EnumSet.of(object2)));
                        ((BooleanQuery)object).add((Query)serializable, BooleanClause.Occur.SHOULD);
                    }
                    query = object;
                    break;
                }
                default: {
                    throw new IllegalArgumentException(booleanOperator.toString());
                }
            }
            object = indexSearcher.search(query);
            Object object3 = ((Hits)object).iterator();
            while (object3.hasNext()) {
                Hit hit = (Hit)object3.next();
                serializable = hit.getDocument();
                String string2 = DocumentUtil.getBinaryName((Document)serializable);
                linkedList.add(string2);
            }
            object3 = linkedList;
            return object3;
        }
        finally {
            ((Searcher)indexSearcher).close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<String> getReferencesData(String string) throws IOException {
        if (!this.isValid(false)) {
            return null;
        }
        IndexSearcher indexSearcher = new IndexSearcher(this.getReader());
        try {
            Hits hits = indexSearcher.search(DocumentUtil.binaryNameQuery(string));
            assert (hits.length() <= 1);
            if (hits.length() == 0) {
                List<String> list = null;
                return list;
            }
            Hit hit = (Hit)hits.iterator().next();
            List<String> list = DocumentUtil.getReferences(hit.getDocument());
            return list;
        }
        finally {
            ((Searcher)indexSearcher).close();
        }
    }

    @Override
    public <T> void getDeclaredTypes(String string, ClassIndex.NameKind nameKind, ResultConvertor<T> resultConvertor, Set<? super T> set) throws IOException {
        ElementKind[] elementKindArray;
        Object object;
        if (!this.isValid(false)) {
            LOGGER.fine(String.format("LuceneIndex[%s] is invalid!\n", this.toString()));
            return;
        }
        assert (string != null);
        TreeSet<Term> treeSet = new TreeSet<Term>(new Comparator<Term>(){

            @Override
            public int compare(Term term, Term term2) {
                int n = term.field().compareTo(term2.field());
                if (n == 0) {
                    n = term.text().compareTo(term2.text());
                }
                return n;
            }
        });
        IndexReader indexReader = this.getReader();
        switch (nameKind) {
            case SIMPLE_NAME: {
                treeSet.add(DocumentUtil.simpleNameTerm(string));
                break;
            }
            case PREFIX: {
                if (string.length() == 0) {
                    this.emptyPrefixSearch(indexReader, resultConvertor, set);
                    return;
                }
                object = DocumentUtil.simpleNameTerm(string);
                this.prefixSearh((Term)object, indexReader, treeSet);
                break;
            }
            case CASE_INSENSITIVE_PREFIX: {
                if (string.length() == 0) {
                    this.emptyPrefixSearch(indexReader, resultConvertor, set);
                    return;
                }
                object = DocumentUtil.caseInsensitiveNameTerm(string.toLowerCase());
                this.prefixSearh((Term)object, indexReader, treeSet);
                break;
            }
            case CAMEL_CASE: {
                if (string.length() == 0) {
                    throw new IllegalArgumentException();
                }
                object = new StringBuilder();
                char c = '\u0000';
                for (int i = 0; i < string.length(); ++i) {
                    char c2 = string.charAt(i);
                    if (i == 0) {
                        c = c2;
                    }
                    ((StringBuilder)object).append(c2);
                    if (i == string.length() - 1) {
                        ((StringBuilder)object).append("\\w*");
                        continue;
                    }
                    ((StringBuilder)object).append("[\\p{Lower}\\p{Digit}]*");
                }
                elementKindArray = Pattern.compile(((StringBuilder)object).toString());
                this.regExpSearch((Pattern)elementKindArray, DocumentUtil.simpleNameTerm(Character.toString(c)), indexReader, treeSet);
                break;
            }
            case CASE_INSENSITIVE_REGEXP: {
                if (string.length() == 0 || !Character.isJavaIdentifierStart(string.charAt(0))) {
                    throw new IllegalArgumentException();
                }
                object = Pattern.compile(string, 2);
                this.regExpSearch((Pattern)object, DocumentUtil.caseInsensitiveNameTerm(string.toLowerCase()), indexReader, treeSet);
                break;
            }
            case REGEXP: {
                if (string.length() == 0 || !Character.isJavaIdentifierStart(string.charAt(0))) {
                    throw new IllegalArgumentException();
                }
                object = Pattern.compile(string);
                this.regExpSearch((Pattern)object, DocumentUtil.simpleNameTerm(string), indexReader, treeSet);
                break;
            }
            default: {
                throw new UnsupportedOperationException(nameKind.toString());
            }
        }
        object = indexReader.termDocs();
        LOGGER.fine(String.format("LuceneIndex.getDeclaredTypes[%s] returned %d elements\n", this.toString(), treeSet.size()));
        Iterator iterator = treeSet.iterator();
        elementKindArray = new ElementKind[1];
        TreeSet<Integer> treeSet2 = new TreeSet<Integer>();
        while (iterator.hasNext()) {
            object.seek((Term)iterator.next());
            while (object.next()) {
                treeSet2.add(object.doc());
            }
        }
        for (Integer n : treeSet2) {
            Document document = indexReader.document(n);
            String string2 = DocumentUtil.getBinaryName(document, elementKindArray);
            set.add(resultConvertor.convert(elementKindArray[0], string2));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void regExpSearch(Pattern pattern, Term term, IndexReader indexReader, Set<Term> set) throws IOException {
        char c;
        String string = term.text();
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append(string.charAt(0));
        for (int i = 1; i < string.length() && Character.isJavaIdentifierPart(c = string.charAt(i)); ++i) {
            stringBuilder.append(c);
        }
        String string2 = stringBuilder.toString();
        String string3 = term.field();
        TermEnum termEnum = indexReader.terms(term);
        try {
            Term term2;
            while ((term2 = termEnum.term()) != null && string3 == term2.field() && term2.text().startsWith(string2)) {
                Matcher matcher = pattern.matcher(term2.text());
                if (matcher.matches()) {
                    set.add(term2);
                }
                if (termEnum.next()) continue;
                break;
            }
        }
        finally {
            termEnum.close();
        }
    }

    private <T> void emptyPrefixSearch(IndexReader indexReader, ResultConvertor<T> resultConvertor, Set<? super T> set) throws IOException {
        int n = indexReader.maxDoc();
        ElementKind[] elementKindArray = new ElementKind[1];
        for (int i = 0; i < n; ++i) {
            String string;
            Document document;
            if (indexReader.isDeleted(i) || (document = indexReader.document(i)) == null || (string = DocumentUtil.getBinaryName(document, elementKindArray)) == null) continue;
            set.add(resultConvertor.convert(elementKindArray[0], string));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void prefixSearh(Term term, IndexReader indexReader, Set<Term> set) throws IOException {
        String string = term.field();
        String string2 = term.text();
        TermEnum termEnum = indexReader.terms(term);
        try {
            Term term2;
            while ((term2 = termEnum.term()) != null && string == term2.field() && term2.text().startsWith(string2)) {
                set.add(term2);
                if (termEnum.next()) continue;
                break;
            }
        }
        finally {
            termEnum.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void getPackageNames(String string, boolean bl, Set<String> set) throws IOException {
        if (!this.isValid(false)) {
            return;
        }
        IndexReader indexReader = this.getReader();
        Term term = DocumentUtil.packageNameTerm(string);
        String string2 = term.field();
        if (string.length() == 0) {
            if (bl && this.rootPkgCache != null) {
                set.addAll(this.rootPkgCache);
            } else {
                if (bl) {
                    this.rootPkgCache = new HashSet<String>();
                }
                TermEnum termEnum = indexReader.terms();
                try {
                    do {
                        Term term2;
                        if ((term2 = termEnum.term()) == null || string2 != term2.field()) continue;
                        String string3 = term2.text();
                        if (bl) {
                            int n = string3.indexOf(46, string.length());
                            if (n > 0) {
                                string3 = string3.substring(0, n);
                            }
                            this.rootPkgCache.add(string3);
                        }
                        set.add(string3);
                    } while (termEnum.next());
                }
                finally {
                    termEnum.close();
                }
            }
        } else {
            TermEnum termEnum = indexReader.terms(term);
            try {
                Term term3;
                while ((term3 = termEnum.term()) != null && string2 == term3.field() && term3.text().startsWith(string)) {
                    int n;
                    String string4 = term3.text();
                    if (bl && (n = string4.indexOf(46, string.length())) > 0) {
                        string4 = string4.substring(0, n);
                    }
                    set.add(string4);
                    if (termEnum.next()) continue;
                    break;
                }
            }
            finally {
                termEnum.close();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public boolean isUpToDate(String string, long l) throws IOException {
        if (!this.isValid(false)) {
            return false;
        }
        try {
            IndexSearcher indexSearcher = new IndexSearcher(this.getReader());
            try {
                Hits hits;
                Object object;
                if (string == null) {
                    object = this;
                    synchronized (object) {
                        if (this.rootTimeStamp != null) {
                            boolean bl = this.rootTimeStamp >= l;
                            return bl;
                        }
                    }
                    hits = indexSearcher.search(new TermQuery(DocumentUtil.rootDocumentTerm()));
                } else {
                    hits = indexSearcher.search(DocumentUtil.binaryNameQuery(string));
                }
                assert (hits.length() <= 1);
                if (hits.length() == 0) {
                    boolean bl = false;
                    return bl;
                }
                object = (Hit)hits.iterator().next();
                long l2 = DocumentUtil.getTimeStamp(((Hit)object).getDocument());
                if (string == null) {
                    LuceneIndex luceneIndex = this;
                    synchronized (luceneIndex) {
                        this.rootTimeStamp = new Long(l2);
                    }
                }
                boolean bl = l2 >= l;
                return bl;
            }
            finally {
                ((Searcher)indexSearcher).close();
            }
        }
        catch (FileNotFoundException fileNotFoundException) {
            this.clear();
            return false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void store(Map<String, List<String>> map, List<String> list) throws IOException {
        this.rootPkgCache = null;
        boolean bl = !this.isValid(false);
        long l = System.currentTimeMillis();
        if (!bl) {
            IndexReader indexReader = this.getReader();
            IndexSearcher indexSearcher = new IndexSearcher(indexReader);
            try {
                for (String string : list) {
                    Hits hits = indexSearcher.search(DocumentUtil.binaryContentNameQuery(string));
                    for (int i = 0; i < hits.length(); ++i) {
                        indexReader.deleteDocument(hits.id(i));
                    }
                }
                indexReader.deleteDocuments(DocumentUtil.rootDocumentTerm());
            }
            finally {
                ((Searcher)indexSearcher).close();
            }
        }
        this.storeData(map, bl, l);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void store(Map<String, List<String>> map, Set<String> set) throws IOException {
        this.rootPkgCache = null;
        boolean bl = !this.isValid(false);
        long l = System.currentTimeMillis();
        if (!bl) {
            IndexReader indexReader = this.getReader();
            IndexSearcher indexSearcher = new IndexSearcher(indexReader);
            try {
                for (String string : set) {
                    Hits hits = indexSearcher.search(DocumentUtil.binaryNameQuery(string));
                    if (hits.length() > 1) {
                        Logger.getLogger("global").warning("Multiple index entries for binaryName: " + string);
                    }
                    for (int i = 0; i < hits.length(); ++i) {
                        indexReader.deleteDocument(hits.id(i));
                    }
                }
                indexReader.deleteDocuments(DocumentUtil.rootDocumentTerm());
            }
            finally {
                ((Searcher)indexSearcher).close();
            }
        }
        this.storeData(map, bl, l);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void storeData(Map<String, List<String>> map, boolean bl, long l) throws IOException {
        LuceneIndexMBeanImpl luceneIndexMBeanImpl;
        IndexWriter indexWriter = this.getWriter(bl);
        if (debugIndexMerging) {
            indexWriter.setInfoStream(System.err);
        }
        if ((luceneIndexMBeanImpl = LuceneIndexMBeanImpl.getDefault()) != null) {
            indexWriter.setMergeFactor(luceneIndexMBeanImpl.getMergeFactor());
            indexWriter.setMaxMergeDocs(luceneIndexMBeanImpl.getMaxMergeDocs());
            indexWriter.setMaxBufferedDocs(luceneIndexMBeanImpl.getMaxBufferedDocs());
        }
        LowMemoryNotifier lowMemoryNotifier = LowMemoryNotifier.getDefault();
        LMListener lMListener = new LMListener();
        lowMemoryNotifier.addLowMemoryListener(lMListener);
        RAMDirectory rAMDirectory = null;
        IndexWriter indexWriter2 = null;
        if (lMListener.lowMemory.getAndSet(false)) {
            indexWriter2 = indexWriter;
        } else {
            rAMDirectory = new RAMDirectory();
            indexWriter2 = new IndexWriter(rAMDirectory, (Analyzer)new KeywordAnalyzer(), true);
        }
        try {
            indexWriter2.addDocument(DocumentUtil.createRootTimeStampDocument(l));
            Object object = map.entrySet().iterator();
            while (object.hasNext()) {
                Map.Entry<String, List<String>> entry = object.next();
                object.remove();
                String string = entry.getKey();
                List<String> list = entry.getValue();
                Document document = DocumentUtil.createDocument(string, l, list);
                indexWriter2.addDocument(document);
                if (rAMDirectory == null || !lMListener.lowMemory.getAndSet(false)) continue;
                indexWriter2.close();
                indexWriter.addIndexes(new Directory[]{rAMDirectory});
                rAMDirectory = new RAMDirectory();
                indexWriter2 = new IndexWriter(rAMDirectory, (Analyzer)new KeywordAnalyzer(), true);
            }
            if (rAMDirectory != null) {
                indexWriter2.close();
                indexWriter.addIndexes(new Directory[]{rAMDirectory});
                indexWriter2 = null;
                rAMDirectory = null;
            }
            object = this;
            synchronized (object) {
                this.rootTimeStamp = new Long(l);
            }
        }
        finally {
            lowMemoryNotifier.removeLowMemoryListener(lMListener);
        }
    }

    @Override
    public boolean isValid(boolean bl) throws IOException {
        boolean bl2 = IndexReader.indexExists(this.directory);
        if (bl2 && bl) {
            try {
                this.getReader();
            }
            catch (IOException iOException) {
                bl2 = false;
                this.clear();
            }
        }
        return bl2;
    }

    @Override
    public synchronized void clear() throws IOException {
        String[] stringArray;
        this.close();
        for (String string : stringArray = this.directory.list()) {
            this.directory.deleteFile(string);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public synchronized void close() throws IOException {
        try {
            if (this.reader != null) {
                this.reader.close();
                this.reader = null;
            }
            if (this.writer != null) {
                this.writer.close();
                this.writer = null;
            }
        }
        finally {
            this.directory.close();
        }
    }

    public String toString() {
        return this.directory.toString();
    }

    private synchronized IndexReader getReader() throws IOException {
        if (this.reader == null) {
            if (this.writer != null) {
                this.writer.close();
                this.writer = null;
            }
            this.reader = IndexReader.open(this.directory);
        }
        return this.reader;
    }

    private synchronized IndexWriter getWriter(boolean bl) throws IOException {
        if (this.writer == null) {
            if (this.reader != null) {
                this.reader.close();
                this.reader = null;
            }
            this.writer = new IndexWriter(this.directory, (Analyzer)new KeywordAnalyzer(), bl);
        }
        return this.writer;
    }

    private static File getReferencesCacheFolder(File file) throws IOException {
        File file2 = new File(file, REFERENCES);
        if (!file2.exists()) {
            file2.mkdir();
        }
        return file2;
    }

    private static class LMListener
    implements LowMemoryListener {
        private AtomicBoolean lowMemory = new AtomicBoolean(false);

        private LMListener() {
        }

        public void lowMemory(LowMemoryEvent lowMemoryEvent) {
            this.lowMemory.set(true);
        }
    }
}

