/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.java.source.usages;

import java.io.File;
import java.io.IOException;
import java.lang.ref.WeakReference;
import java.net.URL;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import java.util.logging.Logger;
import javax.lang.model.element.ElementKind;
import org.netbeans.api.java.queries.SourceForBinaryQuery;
import org.netbeans.api.java.source.CancellableTask;
import org.netbeans.api.java.source.ClassIndex;
import org.netbeans.api.java.source.CompilationController;
import org.netbeans.api.java.source.CompilationInfo;
import org.netbeans.api.java.source.JavaSource;
import org.netbeans.modules.java.source.JavaSourceAccessor;
import org.netbeans.modules.java.source.usages.BinaryAnalyser;
import org.netbeans.modules.java.source.usages.ClassIndexImpl;
import org.netbeans.modules.java.source.usages.ClassIndexManager;
import org.netbeans.modules.java.source.usages.Index;
import org.netbeans.modules.java.source.usages.LuceneIndex;
import org.netbeans.modules.java.source.usages.ResultConvertor;
import org.netbeans.modules.java.source.usages.SourceAnalyser;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.URLMapper;
import org.openide.util.Exceptions;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PersistentClassIndex
extends ClassIndexImpl {
    private final Index index;
    private final URL root;
    private final boolean isSource;
    private WeakReference<JavaSource> dirty;
    private static final Logger LOGGER = Logger.getLogger(PersistentClassIndex.class.getName());

    private PersistentClassIndex(URL uRL, File file, boolean bl) throws IOException, IllegalArgumentException {
        assert (uRL != null);
        this.root = uRL;
        this.index = LuceneIndex.create(file);
        this.isSource = bl;
    }

    @Override
    public BinaryAnalyser getBinaryAnalyser() {
        return new BinaryAnalyser(this.index);
    }

    @Override
    public SourceAnalyser getSourceAnalyser() {
        return new SourceAnalyser(this.index);
    }

    @Override
    public FileObject[] getSourceRoots() {
        FileObject[] fileObjectArray;
        if (this.isSource) {
            FileObject[] fileObjectArray2;
            FileObject fileObject = URLMapper.findFileObject((URL)this.root);
            if (fileObject == null) {
                fileObjectArray2 = new FileObject[]{};
            } else {
                FileObject[] fileObjectArray3 = new FileObject[1];
                fileObjectArray2 = fileObjectArray3;
                fileObjectArray3[0] = fileObject;
            }
            fileObjectArray = fileObjectArray2;
        } else {
            fileObjectArray = SourceForBinaryQuery.findSourceRoots((URL)this.root).getRoots();
        }
        return fileObjectArray;
    }

    public static ClassIndexImpl create(URL uRL, File file, boolean bl) throws IOException, IllegalArgumentException {
        return new PersistentClassIndex(uRL, file, bl);
    }

    @Override
    public <T> void search(final String string, final Set<ClassIndexImpl.UsageType> set, final ResultConvertor<T> resultConvertor, final Set<? super T> set2) {
        this.updateDirty();
        if (BinaryAnalyser.OBJECT.equals(string)) {
            this.getDeclaredTypes("", ClassIndex.NameKind.PREFIX, resultConvertor, set2);
            return;
        }
        try {
            ClassIndexManager.getDefault().readLock(new ClassIndexManager.ExceptionAction<Void>(){

                @Override
                public Void run() throws IOException {
                    PersistentClassIndex.this.usages(string, set, resultConvertor, set2);
                    return null;
                }
            });
        }
        catch (IOException iOException) {
            Exceptions.printStackTrace((Throwable)iOException);
        }
    }

    @Override
    public <T> void getDeclaredTypes(final String string, final ClassIndex.NameKind nameKind, final ResultConvertor<T> resultConvertor, final Set<? super T> set) {
        this.updateDirty();
        try {
            ClassIndexManager.getDefault().readLock(new ClassIndexManager.ExceptionAction<Void>(){

                @Override
                public Void run() throws IOException {
                    PersistentClassIndex.this.index.getDeclaredTypes(string, nameKind, resultConvertor, set);
                    return null;
                }
            });
        }
        catch (IOException iOException) {
            Exceptions.printStackTrace((Throwable)iOException);
        }
    }

    @Override
    public void getPackageNames(final String string, final boolean bl, final Set<String> set) {
        try {
            ClassIndexManager.getDefault().readLock(new ClassIndexManager.ExceptionAction<Void>(){

                @Override
                public Void run() throws IOException {
                    PersistentClassIndex.this.index.getPackageNames(string, bl, set);
                    return null;
                }
            });
        }
        catch (IOException iOException) {
            Exceptions.printStackTrace((Throwable)iOException);
        }
    }

    @Override
    public synchronized void setDirty(JavaSource javaSource) {
        if (javaSource == null) {
            this.dirty = null;
        } else if (this.dirty == null || this.dirty.get() != javaSource) {
            this.dirty = new WeakReference<JavaSource>(javaSource);
        }
    }

    public String toString() {
        return "CompromiseUQ[" + this.root.toExternalForm() + "]";
    }

    @Override
    protected final void close() throws IOException {
        this.index.close();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void updateDirty() {
        WeakReference<JavaSource> weakReference;
        Object object = this;
        synchronized (object) {
            weakReference = this.dirty;
        }
        if (weakReference != null && (object = (JavaSource)weakReference.get()) != null) {
            long l = System.currentTimeMillis();
            if (JavaSourceAccessor.INSTANCE.isDispatchThread()) {
                try {
                    ClassIndexManager.getDefault().writeLock(new ClassIndexManager.ExceptionAction<Void>((JavaSource)object){
                        final /* synthetic */ JavaSource val$js;
                        {
                            this.val$js = javaSource;
                        }

                        @Override
                        public Void run() throws IOException {
                            CompilationInfo compilationInfo = JavaSourceAccessor.INSTANCE.getCurrentCompilationInfo(this.val$js, JavaSource.Phase.RESOLVED);
                            if (compilationInfo != null) {
                                SourceAnalyser sourceAnalyser = PersistentClassIndex.this.getSourceAnalyser();
                                long l = System.currentTimeMillis();
                                sourceAnalyser.analyseUnitAndStore(compilationInfo.getCompilationUnit(), JavaSourceAccessor.INSTANCE.getJavacTask(compilationInfo));
                                long l2 = System.currentTimeMillis();
                            }
                            return null;
                        }
                    });
                }
                catch (IOException iOException) {
                    Exceptions.printStackTrace((Throwable)iOException);
                }
            } else {
                try {
                    ((JavaSource)object).runUserActionTask(new CancellableTask<CompilationController>(){

                        @Override
                        public void run(final CompilationController compilationController) {
                            try {
                                ClassIndexManager.getDefault().writeLock(new ClassIndexManager.ExceptionAction<Void>(){

                                    @Override
                                    public Void run() throws IOException {
                                        compilationController.toPhase(JavaSource.Phase.RESOLVED);
                                        SourceAnalyser sourceAnalyser = PersistentClassIndex.this.getSourceAnalyser();
                                        long l = System.currentTimeMillis();
                                        sourceAnalyser.analyseUnitAndStore(compilationController.getCompilationUnit(), JavaSourceAccessor.INSTANCE.getJavacTask(compilationController));
                                        long l2 = System.currentTimeMillis();
                                        return null;
                                    }
                                });
                            }
                            catch (IOException iOException) {
                                Exceptions.printStackTrace((Throwable)iOException);
                            }
                        }

                        @Override
                        public void cancel() {
                        }
                    }, true);
                }
                catch (IOException iOException) {
                    Exceptions.printStackTrace((Throwable)iOException);
                }
            }
            PersistentClassIndex persistentClassIndex = this;
            synchronized (persistentClassIndex) {
                this.dirty = null;
            }
            long l2 = System.currentTimeMillis();
            LOGGER.fine("PersistentClassIndex.updateDirty took: " + (l2 - l) + " ms");
        }
    }

    private <T> void usages(String string, Set<ClassIndexImpl.UsageType> set, ResultConvertor<T> resultConvertor, Set<? super T> set2) {
        List<String> list = this.getUsagesFQN(string, set, Index.BooleanOperator.OR);
        for (String string2 : list) {
            T t = resultConvertor.convert(ElementKind.OTHER, string2);
            if (t == null) continue;
            set2.add(t);
        }
    }

    private List<String> getUsagesFQN(String string, Set<ClassIndexImpl.UsageType> set, Index.BooleanOperator booleanOperator) {
        List<String> list = null;
        try {
            list = this.index.getUsagesFQN(string, set, booleanOperator);
        }
        catch (IOException iOException) {
            Exceptions.printStackTrace((Throwable)iOException);
        }
        if (list == null) {
            list = Collections.emptyList();
        }
        return list;
    }
}

