/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.java.source.usages;

import com.sun.source.tree.ClassTree;
import com.sun.source.tree.CompilationUnitTree;
import com.sun.source.tree.ErroneousTree;
import com.sun.source.tree.IdentifierTree;
import com.sun.source.tree.MemberSelectTree;
import com.sun.source.tree.MethodTree;
import com.sun.source.tree.NewClassTree;
import com.sun.source.tree.ParameterizedTypeTree;
import com.sun.source.tree.Tree;
import com.sun.source.util.TreeScanner;
import com.sun.tools.javac.api.JavacTaskImpl;
import com.sun.tools.javac.code.Symbol;
import com.sun.tools.javac.code.Types;
import com.sun.tools.javac.tree.JCTree;
import com.sun.tools.javac.util.Context;
import com.sun.tools.javac.util.Name;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URL;
import java.util.ArrayList;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.Stack;
import java.util.logging.Logger;
import javax.lang.model.element.Element;
import javax.lang.model.element.ElementKind;
import javax.lang.model.element.TypeElement;
import javax.lang.model.type.ArrayType;
import javax.lang.model.type.DeclaredType;
import javax.lang.model.type.TypeKind;
import javax.lang.model.type.TypeMirror;
import javax.tools.FileObject;
import javax.tools.JavaFileManager;
import javax.tools.JavaFileObject;
import javax.tools.StandardLocation;
import org.netbeans.api.java.classpath.ClassPath;
import org.netbeans.modules.java.source.usages.ClassFileUtil;
import org.netbeans.modules.java.source.usages.ClassIndexImpl;
import org.netbeans.modules.java.source.usages.DocumentUtil;
import org.netbeans.modules.java.source.usages.Index;
import org.netbeans.modules.java.source.usages.SymbolDumper;
import org.openide.filesystems.URLMapper;
import org.openide.util.Exceptions;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SourceAnalyser {
    private final Index index;
    private final Map<String, List<String>> references;
    private final Set<String> toDelete;

    public SourceAnalyser(Index index) {
        assert (index != null);
        this.index = index;
        this.references = new HashMap<String, List<String>>();
        this.toDelete = new HashSet<String>();
    }

    public void store() throws IOException {
        if (this.references.size() > 0 || this.toDelete.size() > 0) {
            this.index.store(this.references, this.toDelete);
            this.references.clear();
            this.toDelete.clear();
        }
    }

    public boolean isValid() throws IOException {
        return this.index.isValid(true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void analyse(Iterable<? extends CompilationUnitTree> iterable, JavacTaskImpl javacTaskImpl, JavaFileManager javaFileManager, JavaFileObject javaFileObject) throws IOException {
        Object object;
        HashMap<String, Map<String, Set<ClassIndexImpl.UsageType>>> hashMap = new HashMap<String, Map<String, Set<ClassIndexImpl.UsageType>>>();
        for (CompilationUnitTree object2 : iterable) {
            Object object3;
            object = new UsagesVisitor(javacTaskImpl, object2, javaFileManager, javaFileObject);
            ((UsagesVisitor)object).scan((Tree)object2, (Map<String, Map<String, Set<ClassIndexImpl.UsageType>>>)hashMap);
            if (((UsagesVisitor)object).rsList == null || ((UsagesVisitor)object).rsList.size() <= 0) continue;
            int n = ((UsagesVisitor)object).sourceName.lastIndexOf(46);
            String string = n == -1 ? "" : ((UsagesVisitor)object).sourceName.substring(0, n);
            String string2 = (n == -1 ? ((UsagesVisitor)object).sourceName : ((UsagesVisitor)object).sourceName.substring(n + 1)) + '.' + "rs";
            FileObject fileObject = javaFileManager.getFileForOutput(StandardLocation.CLASS_OUTPUT, string, string2, javaFileObject);
            assert (fileObject != null);
            BufferedReader bufferedReader = new BufferedReader(fileObject.openReader(false));
            try {
                while ((object3 = bufferedReader.readLine()) != null) {
                    ((UsagesVisitor)object).rsList.add(object3);
                }
            }
            finally {
                bufferedReader.close();
            }
            object3 = new PrintWriter(fileObject.openWriter());
            try {
                for (String string3 : ((UsagesVisitor)object).rsList) {
                    ((PrintWriter)object3).println(string3);
                }
            }
            finally {
                ((PrintWriter)object3).close();
            }
        }
        for (Map.Entry entry : hashMap.entrySet()) {
            object = this.getClassReferences((String)entry.getKey());
            Map map = (Map)entry.getValue();
            for (Map.Entry entry2 : map.entrySet()) {
                object.add(DocumentUtil.encodeUsage((String)entry2.getKey(), (Set)entry2.getValue()));
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void analyseUnitAndStore(CompilationUnitTree compilationUnitTree, JavacTaskImpl javacTaskImpl) throws IOException {
        try {
            HashMap<String, Map<String, Set<ClassIndexImpl.UsageType>>> hashMap = new HashMap<String, Map<String, Set<ClassIndexImpl.UsageType>>>();
            ArrayList<String> arrayList = new ArrayList<String>();
            UsagesVisitor usagesVisitor = new UsagesVisitor(javacTaskImpl, compilationUnitTree, arrayList);
            usagesVisitor.scan((Tree)compilationUnitTree, (Map<String, Map<String, Set<ClassIndexImpl.UsageType>>>)hashMap);
            for (Map.Entry entry : hashMap.entrySet()) {
                String string = (String)entry.getKey();
                List<String> list = this.getClassReferences(string);
                Map map = (Map)entry.getValue();
                for (Map.Entry entry2 : map.entrySet()) {
                    list.add(DocumentUtil.encodeUsage((String)entry2.getKey(), (Set)entry2.getValue()));
                }
            }
            this.index.store(this.references, arrayList);
        }
        finally {
            this.references.clear();
        }
    }

    public void delete(String string) throws IOException {
        if (!this.index.isValid(false)) {
            return;
        }
        this.toDelete.add(string);
    }

    private List<String> getClassReferences(String string) {
        assert (string != null);
        List<String> list = this.references.get(string);
        if (list == null) {
            list = new LinkedList<String>();
            this.references.put(string, list);
        }
        return list;
    }

    private static void dumpUsages(Map<String, Map<String, Set<ClassIndexImpl.UsageType>>> map) throws IOException {
        assert (map != null);
        for (Map.Entry<String, Map<String, Set<ClassIndexImpl.UsageType>>> entry : map.entrySet()) {
            System.out.println("Usages in class: " + entry.getKey());
            for (Map.Entry<String, Set<ClassIndexImpl.UsageType>> entry2 : entry.getValue().entrySet()) {
                System.out.println("\t" + entry2.getKey() + "\t: " + entry2.getValue().toString());
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static class UsagesVisitor
    extends TreeScanner<Void, Map<String, Map<String, Set<ClassIndexImpl.UsageType>>>> {
        private final Stack<String> activeClass;
        private JavaFileManager manager;
        private final JavacTaskImpl jt;
        private final Name errorName;
        private final CompilationUnitTree cu;
        private final Types types;
        private final JavaFileObject sibling;
        private final String sourceName;
        private final boolean signatureFiles;
        private State state;
        private Element enclosingElement = null;
        private Set<String> rsList;
        private List<? super String> topLevels;

        public UsagesVisitor(JavacTaskImpl javacTaskImpl, CompilationUnitTree compilationUnitTree, JavaFileManager javaFileManager, JavaFileObject javaFileObject) {
            assert (javacTaskImpl != null);
            assert (compilationUnitTree != null);
            assert (javaFileManager != null);
            assert (javaFileObject != null);
            this.activeClass = new Stack();
            this.jt = javacTaskImpl;
            this.errorName = Name.Table.instance((Context)javacTaskImpl.getContext()).error;
            this.state = State.OTHER;
            this.types = Types.instance(javacTaskImpl.getContext());
            this.cu = compilationUnitTree;
            this.signatureFiles = true;
            this.manager = javaFileManager;
            this.sibling = javaFileObject;
            this.sourceName = this.manager.inferBinaryName(StandardLocation.SOURCE_PATH, this.sibling);
        }

        protected UsagesVisitor(JavacTaskImpl javacTaskImpl, CompilationUnitTree compilationUnitTree, List<? super String> list) {
            assert (javacTaskImpl != null);
            assert (compilationUnitTree != null);
            this.activeClass = new Stack();
            this.jt = javacTaskImpl;
            this.errorName = Name.Table.instance((Context)javacTaskImpl.getContext()).error;
            this.state = State.OTHER;
            this.types = Types.instance(javacTaskImpl.getContext());
            this.cu = compilationUnitTree;
            this.signatureFiles = false;
            this.manager = null;
            this.sibling = null;
            this.sourceName = "";
            this.topLevels = list;
        }

        final Types getTypes() {
            return this.types;
        }

        @Override
        public Void scan(Tree tree, Map<String, Map<String, Set<ClassIndexImpl.UsageType>>> map) {
            if (tree == null) {
                return null;
            }
            super.scan(tree, map);
            return null;
        }

        @Override
        public Void visitMemberSelect(MemberSelectTree memberSelectTree, Map<String, Map<String, Set<ClassIndexImpl.UsageType>>> map) {
            this.handleVisitIdentSelect(((JCTree.JCFieldAccess)memberSelectTree).sym, map);
            State state = this.state;
            this.state = State.OTHER;
            Void void_ = (Void)super.visitMemberSelect(memberSelectTree, map);
            this.state = state;
            return void_;
        }

        @Override
        public Void visitIdentifier(IdentifierTree identifierTree, Map<String, Map<String, Set<ClassIndexImpl.UsageType>>> map) {
            this.handleVisitIdentSelect(((JCTree.JCIdent)identifierTree).sym, map);
            return (Void)super.visitIdentifier(identifierTree, map);
        }

        private void handleVisitIdentSelect(Symbol symbol, Map<String, Map<String, Set<ClassIndexImpl.UsageType>>> map) {
            if (!this.activeClass.empty() && symbol != null) {
                Symbol symbol2;
                String string;
                if (symbol.getKind().isClass() || symbol.getKind().isInterface()) {
                    String string2 = UsagesVisitor.encodeClassName(symbol);
                    if (string2 != null) {
                        switch (this.state) {
                            case EXTENDS: {
                                this.addUsage(this.activeClass.peek(), string2, map, ClassIndexImpl.UsageType.SUPER_CLASS);
                                break;
                            }
                            case IMPLEMENTS: {
                                this.addUsage(this.activeClass.peek(), string2, map, ClassIndexImpl.UsageType.SUPER_INTERFACE);
                                break;
                            }
                            case OTHER: 
                            case GT: {
                                this.addUsage(this.activeClass.peek(), string2, map, ClassIndexImpl.UsageType.TYPE_REFERENCE);
                            }
                        }
                    }
                } else if (symbol.getKind().isField()) {
                    Symbol symbol3 = symbol.getEnclosingElement();
                    String string3 = UsagesVisitor.encodeClassName(symbol3);
                    if (string3 != null) {
                        this.addUsage(this.activeClass.peek(), string3, map, ClassIndexImpl.UsageType.FIELD_REFERENCE);
                    }
                } else if ((symbol.getKind() == ElementKind.CONSTRUCTOR || symbol.getKind() == ElementKind.METHOD) && (string = UsagesVisitor.encodeClassName(symbol2 = symbol.getEnclosingElement())) != null) {
                    this.addUsage(this.activeClass.peek(), string, map, ClassIndexImpl.UsageType.METHOD_REFERENCE);
                }
            }
        }

        @Override
        public Void visitParameterizedType(ParameterizedTypeTree parameterizedTypeTree, Map<String, Map<String, Set<ClassIndexImpl.UsageType>>> map) {
            this.scan(parameterizedTypeTree.getType(), map);
            State state = this.state;
            this.state = State.GT;
            this.scan(parameterizedTypeTree.getTypeArguments(), map);
            this.state = state;
            return null;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        void dump(TypeElement typeElement, String string, Element element) {
            PrintWriter printWriter = null;
            if (this.rsList != null) {
                this.rsList.add(string);
            }
            try {
                JavaFileObject javaFileObject = this.manager.getJavaFileForOutput(StandardLocation.CLASS_OUTPUT, string, JavaFileObject.Kind.CLASS, this.sibling);
                printWriter = new PrintWriter(new OutputStreamWriter(javaFileObject.openOutputStream(), "UTF-8"));
                SymbolDumper.dump(printWriter, this.types, typeElement, element);
                printWriter.close();
            }
            catch (IOException iOException) {
                Exceptions.printStackTrace((Throwable)iOException);
            }
            finally {
                if (printWriter != null) {
                    printWriter.close();
                }
            }
        }

        protected boolean shouldGenerate(String string, Symbol.ClassSymbol classSymbol) {
            if (!this.signatureFiles || string == null) {
                return false;
            }
            if (classSymbol.getQualifiedName().isEmpty()) {
                return true;
            }
            for (Element element = classSymbol.getEnclosingElement(); element != null && ((Symbol)element).getKind() != ElementKind.PACKAGE; element = ((Symbol)element).getEnclosingElement()) {
                if (((Symbol)element).getKind().isClass() || ((Symbol)element).getKind().isInterface()) continue;
                return true;
            }
            return false;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public Void visitClass(ClassTree classTree, Map<String, Map<String, Set<ClassIndexImpl.UsageType>>> map) {
            Object object;
            Symbol.ClassSymbol classSymbol = ((JCTree.JCClassDecl)classTree).sym;
            boolean bl = false;
            boolean bl2 = true;
            String string = null;
            if (classSymbol != null) {
                bl = this.hasErrorName(classSymbol);
                if (bl) {
                    if (this.activeClass.size() > 0) {
                        this.activeClass.push((String)this.activeClass.get(0));
                        bl2 = false;
                    } else {
                        URI uRI;
                        if (this.cu instanceof JCTree.JCCompilationUnit && (object = ((JCTree.JCCompilationUnit)this.cu).sourcefile) != null && (uRI = object.toUri()) != null && uRI.isAbsolute()) {
                            try {
                                ClassPath classPath;
                                org.openide.filesystems.FileObject fileObject = URLMapper.findFileObject((URL)uRI.toURL());
                                if (fileObject != null && (classPath = ClassPath.getClassPath((org.openide.filesystems.FileObject)fileObject, (String)"classpath/source")) != null) {
                                    string = classPath.getResourceName(fileObject, '.', false);
                                }
                            }
                            catch (MalformedURLException malformedURLException) {
                                Exceptions.printStackTrace((Throwable)malformedURLException);
                            }
                        }
                        if (string != null) {
                            object = string + DocumentUtil.encodeKind(ElementKind.CLASS);
                            if (this.topLevels != null && this.activeClass.isEmpty()) {
                                this.topLevels.add(string);
                            }
                            this.activeClass.push((String)object);
                            bl2 = false;
                            this.addUsage((String)object, string, map, ClassIndexImpl.UsageType.TYPE_REFERENCE);
                        } else {
                            Logger.getLogger("global").warning(String.format("Cannot resolve %s, ignoring whole subtree.\n", classSymbol.toString()));
                        }
                    }
                } else {
                    object = new StringBuilder();
                    ClassFileUtil.encodeClassName(classSymbol, (StringBuilder)object, '.');
                    string = ((StringBuilder)object).toString();
                    ((StringBuilder)object).append(DocumentUtil.encodeKind(classSymbol.getKind()));
                    String string2 = ((StringBuilder)object).toString();
                    if (this.signatureFiles && this.activeClass.isEmpty() && !string.equals(this.sourceName)) {
                        this.rsList = new HashSet<String>();
                    }
                    if (this.topLevels != null && this.activeClass.isEmpty()) {
                        this.topLevels.add(string);
                    }
                    this.activeClass.push(string2);
                    bl2 = false;
                    this.addUsage(string2, string, map, ClassIndexImpl.UsageType.TYPE_REFERENCE);
                }
            }
            if (!bl2) {
                object = this.enclosingElement;
                try {
                    this.enclosingElement = classSymbol;
                    this.scan((Tree)classTree.getModifiers(), map);
                    this.scan(classTree.getTypeParameters(), map);
                    this.state = bl ? State.OTHER : State.EXTENDS;
                    this.scan(classTree.getExtendsClause(), map);
                    this.state = bl ? State.OTHER : State.IMPLEMENTS;
                    this.scan(classTree.getImplementsClause(), map);
                    this.state = State.OTHER;
                    this.scan(classTree.getMembers(), map);
                    this.activeClass.pop();
                }
                finally {
                    this.enclosingElement = object;
                }
            }
            if (!bl && this.shouldGenerate(string, classSymbol)) {
                this.dump(classSymbol, string, this.enclosingElement);
            }
            return null;
        }

        @Override
        public Void visitNewClass(NewClassTree newClassTree, Map<String, Map<String, Set<ClassIndexImpl.UsageType>>> map) {
            String string;
            Symbol symbol;
            Symbol symbol2 = ((JCTree.JCNewClass)newClassTree).constructor;
            if (symbol2 != null && (symbol = symbol2.getEnclosingElement()) != null && symbol.getKind().isClass() && (string = UsagesVisitor.encodeClassName(symbol)) != null) {
                this.addUsage(this.activeClass.peek(), string, map, ClassIndexImpl.UsageType.METHOD_REFERENCE);
            }
            return (Void)super.visitNewClass(newClassTree, map);
        }

        @Override
        public Void visitErroneous(ErroneousTree erroneousTree, Map<String, Map<String, Set<ClassIndexImpl.UsageType>>> map) {
            List<? extends Tree> list = erroneousTree.getErrorTrees();
            for (Tree tree : list) {
                this.scan(tree, map);
            }
            return null;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public Void visitMethod(MethodTree methodTree, Map<String, Map<String, Set<ClassIndexImpl.UsageType>>> map) {
            Element element = this.enclosingElement;
            try {
                this.enclosingElement = ((JCTree.JCMethodDecl)methodTree).sym;
                Void void_ = (Void)super.visitMethod(methodTree, map);
                return void_;
            }
            finally {
                this.enclosingElement = element;
            }
        }

        private void addUsage(String string, String string2, Map<String, Map<String, Set<ClassIndexImpl.UsageType>>> map, ClassIndexImpl.UsageType usageType) {
            Set<ClassIndexImpl.UsageType> set;
            assert (string2 != null);
            assert (map != null);
            assert (usageType != null);
            Map<String, Set<ClassIndexImpl.UsageType>> map2 = map.get(string);
            if (map2 == null) {
                map2 = new HashMap<String, Set<ClassIndexImpl.UsageType>>();
                map.put(string, map2);
            }
            if ((set = map2.get(string2)) == null) {
                set = EnumSet.noneOf(ClassIndexImpl.UsageType.class);
                map2.put(string2, set);
            }
            set.add(usageType);
        }

        private boolean hasErrorName(Symbol symbol) {
            while (symbol != null) {
                if (symbol.name == this.errorName) {
                    return true;
                }
                symbol = symbol.getEnclosingElement();
            }
            return false;
        }

        private static String encodeClassName(Symbol symbol) {
            assert (symbol instanceof Symbol.ClassSymbol);
            TypeElement typeElement = null;
            TypeMirror typeMirror = ((Symbol.ClassSymbol)symbol).asType();
            if (symbol.getEnclosingElement().getKind() == ElementKind.TYPE_PARAMETER) {
                TypeMirror typeMirror2;
                if (typeMirror.getKind() == TypeKind.ARRAY && (typeMirror2 = ((ArrayType)typeMirror).getComponentType()).getKind() == TypeKind.DECLARED) {
                    typeElement = (TypeElement)((DeclaredType)typeMirror2).asElement();
                }
            } else {
                typeElement = (TypeElement)((Object)symbol);
            }
            return typeElement == null ? null : ClassFileUtil.encodeClassName(typeElement);
        }

        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        static enum State {
            EXTENDS,
            IMPLEMENTS,
            GT,
            OTHER;

        }
    }
}

