/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.api.java.platform;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import org.netbeans.api.java.platform.JavaPlatform;
import org.netbeans.api.java.platform.Profile;
import org.netbeans.api.java.platform.Specification;
import org.netbeans.modules.java.platform.FallbackDefaultJavaPlatform;
import org.netbeans.modules.java.platform.JavaPlatformProvider;
import org.openide.modules.SpecificationVersion;
import org.openide.util.Lookup;
import org.openide.util.LookupEvent;
import org.openide.util.LookupListener;

public final class JavaPlatformManager {
    public static final String PROP_INSTALLED_PLATFORMS = "installedPlatforms";
    private static JavaPlatformManager instance;
    private Lookup.Result providers;
    private Collection lastProviders = Collections.EMPTY_SET;
    private boolean providersValid = false;
    private PropertyChangeListener pListener;
    private Collection cachedPlatforms;
    private HashSet listeners;
    static final /* synthetic */ boolean $assertionsDisabled;

    public static synchronized JavaPlatformManager getDefault() {
        if (instance == null) {
            instance = new JavaPlatformManager();
        }
        return instance;
    }

    public JavaPlatform getDefaultPlatform() {
        Collection collection = this.getProviders();
        Iterator iterator = collection.iterator();
        while (iterator.hasNext()) {
            JavaPlatformProvider javaPlatformProvider = (JavaPlatformProvider)iterator.next();
            JavaPlatform javaPlatform = javaPlatformProvider.getDefaultPlatform();
            if (javaPlatform == null) continue;
            return javaPlatform;
        }
        return new FallbackDefaultJavaPlatform();
    }

    public synchronized JavaPlatform[] getInstalledPlatforms() {
        if (this.cachedPlatforms == null) {
            Collection collection = this.getProviders();
            this.cachedPlatforms = new HashSet();
            Iterator iterator = collection.iterator();
            while (iterator.hasNext()) {
                JavaPlatformProvider javaPlatformProvider = (JavaPlatformProvider)iterator.next();
                JavaPlatform[] javaPlatformArray = javaPlatformProvider.getInstalledPlatforms();
                for (int i = 0; i < javaPlatformArray.length; ++i) {
                    this.cachedPlatforms.add(javaPlatformArray[i]);
                }
            }
        }
        return this.cachedPlatforms.toArray(new JavaPlatform[this.cachedPlatforms.size()]);
    }

    public JavaPlatform[] getPlatforms(String string, Specification specification) {
        JavaPlatform[] javaPlatformArray = this.getInstalledPlatforms();
        ArrayList<JavaPlatform> arrayList = new ArrayList<JavaPlatform>();
        for (int i = 0; i < javaPlatformArray.length; ++i) {
            Specification specification2;
            String string2 = string == null ? null : javaPlatformArray[i].getDisplayName();
            Specification specification3 = specification2 = specification == null ? null : javaPlatformArray[i].getSpecification();
            if (string != null && !string2.equalsIgnoreCase(string) || specification != null && !JavaPlatformManager.compatible(specification2, specification)) continue;
            arrayList.add(javaPlatformArray[i]);
        }
        return arrayList.toArray(new JavaPlatform[arrayList.size()]);
    }

    public synchronized void addPropertyChangeListener(PropertyChangeListener propertyChangeListener) {
        if (!$assertionsDisabled && propertyChangeListener == null) {
            throw new AssertionError((Object)"Listener can not be null");
        }
        if (this.listeners == null) {
            this.listeners = new HashSet();
        }
        this.listeners.add(propertyChangeListener);
    }

    public synchronized void removePropertyChangeListener(PropertyChangeListener propertyChangeListener) {
        if (!$assertionsDisabled && propertyChangeListener == null) {
            throw new AssertionError((Object)"Listener can not be null");
        }
        if (this.listeners == null) {
            return;
        }
        this.listeners.remove(propertyChangeListener);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void firePropertyChange(String string) {
        Iterator iterator;
        Object object = this;
        synchronized (object) {
            if (this.listeners == null) {
                return;
            }
            iterator = ((Set)this.listeners.clone()).iterator();
        }
        object = new PropertyChangeEvent(this, string, null, null);
        while (iterator.hasNext()) {
            ((PropertyChangeListener)iterator.next()).propertyChange((PropertyChangeEvent)object);
        }
    }

    private static boolean compatible(Specification specification, Specification specification2) {
        String string = specification2.getName();
        SpecificationVersion specificationVersion = specification2.getVersion();
        return !(string != null && !string.equalsIgnoreCase(specification.getName()) || specificationVersion != null && !specificationVersion.equals((Object)specification.getVersion()) || !JavaPlatformManager.compatibleProfiles(specification.getProfiles(), specification2.getProfiles()));
    }

    private static boolean compatibleProfiles(Profile[] profileArray, Profile[] profileArray2) {
        if (profileArray2 == null) {
            return true;
        }
        if (profileArray == null) {
            return false;
        }
        HashSet<Profile> hashSet = new HashSet<Profile>();
        for (int i = 0; i < profileArray2.length; ++i) {
            Profile profile = profileArray2[i];
            boolean bl = false;
            for (int j = 0; j < profileArray.length; ++j) {
                if (!JavaPlatformManager.compatibleProfile(profileArray[j], profile)) continue;
                bl = true;
                hashSet.add(profileArray[j]);
            }
            if (bl) continue;
            return false;
        }
        return hashSet.size() == profileArray.length;
    }

    private static boolean compatibleProfile(Profile profile, Profile profile2) {
        String string = profile2.getName();
        SpecificationVersion specificationVersion = profile2.getVersion();
        return !(string != null && !string.equals(profile.getName()) || specificationVersion != null && !specificationVersion.equals((Object)profile.getVersion()));
    }

    private synchronized Collection getProviders() {
        if (!this.providersValid) {
            JavaPlatformProvider javaPlatformProvider;
            if (this.providers == null) {
                this.providers = Lookup.getDefault().lookup(new Lookup.Template(JavaPlatformProvider.class));
                this.providers.addLookupListener(new LookupListener(){

                    public void resultChanged(LookupEvent lookupEvent) {
                        JavaPlatformManager.this.resetCache(true);
                        JavaPlatformManager.this.firePropertyChange(JavaPlatformManager.PROP_INSTALLED_PLATFORMS);
                    }
                });
            }
            if (this.pListener == null) {
                this.pListener = new PropertyChangeListener(){

                    public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
                        JavaPlatformManager.this.resetCache(false);
                        JavaPlatformManager.this.firePropertyChange(JavaPlatformManager.PROP_INSTALLED_PLATFORMS);
                    }
                };
            }
            Collection collection = this.providers.allInstances();
            HashSet hashSet = new HashSet(collection);
            hashSet.removeAll(this.lastProviders);
            HashSet hashSet2 = new HashSet(this.lastProviders);
            hashSet2.removeAll(collection);
            Iterator iterator = hashSet2.iterator();
            while (iterator.hasNext()) {
                javaPlatformProvider = (JavaPlatformProvider)iterator.next();
                javaPlatformProvider.removePropertyChangeListener(this.pListener);
            }
            iterator = hashSet.iterator();
            while (iterator.hasNext()) {
                javaPlatformProvider = (JavaPlatformProvider)iterator.next();
                javaPlatformProvider.addPropertyChangeListener(this.pListener);
            }
            this.lastProviders = collection;
            this.providersValid = true;
        }
        return this.lastProviders;
    }

    private synchronized void resetCache(boolean bl) {
        this.cachedPlatforms = null;
        this.providersValid &= !bl;
    }

    static {
        $assertionsDisabled = !JavaPlatformManager.class.desiredAssertionStatus();
        instance = null;
    }
}

