/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.refactoring.plugins;

import java.io.IOException;
import java.net.URL;
import org.netbeans.modules.refactoring.api.Problem;
import org.netbeans.modules.refactoring.api.RefactoringSession;
import org.netbeans.modules.refactoring.api.SingleCopyRefactoring;
import org.netbeans.modules.refactoring.plugins.FileHandlingFactory;
import org.netbeans.modules.refactoring.spi.RefactoringElementsBag;
import org.netbeans.modules.refactoring.spi.RefactoringPlugin;
import org.netbeans.modules.refactoring.spi.SimpleRefactoringElementImplementation;
import org.openide.ErrorManager;
import org.openide.filesystems.FileObject;
import org.openide.loaders.DataFolder;
import org.openide.loaders.DataObject;
import org.openide.text.PositionBounds;
import org.openide.util.Lookup;

public class FileCopyPlugin
implements RefactoringPlugin {
    private SingleCopyRefactoring refactoring;

    public FileCopyPlugin(SingleCopyRefactoring singleCopyRefactoring) {
        this.refactoring = singleCopyRefactoring;
    }

    public Problem preCheck() {
        return null;
    }

    public Problem prepare(RefactoringElementsBag refactoringElementsBag) {
        refactoringElementsBag.add(this.refactoring, new CopyFile((FileObject)this.refactoring.getRefactoringSource().lookup(FileObject.class), refactoringElementsBag.getSession()));
        return null;
    }

    public Problem fastCheckParameters() {
        return null;
    }

    public Problem checkParameters() {
        return null;
    }

    public void cancelRequest() {
    }

    private class CopyFile
    extends SimpleRefactoringElementImplementation {
        private FileObject fo;
        private RefactoringSession session;
        private DataObject newOne;

        public CopyFile(FileObject fileObject, RefactoringSession refactoringSession) {
            this.fo = fileObject;
            this.session = refactoringSession;
        }

        public String getText() {
            return "Copy file " + this.fo.getNameExt();
        }

        public String getDisplayText() {
            return this.getText();
        }

        public void performChange() {
            try {
                FileObject fileObject = FileHandlingFactory.getOrCreateFolder((URL)FileCopyPlugin.this.refactoring.getTarget().lookup(URL.class));
                FileObject fileObject2 = (FileObject)FileCopyPlugin.this.refactoring.getRefactoringSource().lookup(FileObject.class);
                DataObject dataObject = DataObject.find((FileObject)fileObject2);
                this.newOne = dataObject.copy(DataFolder.findFolder((FileObject)fileObject));
                this.newOne.rename(FileCopyPlugin.this.refactoring.getNewName());
                FileCopyPlugin.this.refactoring.getContext().add(this.newOne.getPrimaryFile());
            }
            catch (Exception exception) {
                ErrorManager.getDefault().notify((Throwable)exception);
            }
        }

        public void undoChange() {
            try {
                this.newOne.delete();
            }
            catch (IOException iOException) {
                ErrorManager.getDefault().notify((Throwable)iOException);
            }
        }

        public Lookup getLookup() {
            return Lookup.EMPTY;
        }

        public FileObject getParentFile() {
            return this.fo;
        }

        public PositionBounds getPosition() {
            return null;
        }
    }
}

