/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.editor.java;

import com.sun.source.tree.Tree;
import com.sun.source.util.TreePath;
import java.io.IOException;
import java.util.EnumSet;
import javax.swing.text.Document;
import javax.swing.text.JTextComponent;
import org.netbeans.api.java.source.CancellableTask;
import org.netbeans.api.java.source.CompilationController;
import org.netbeans.api.java.source.JavaSource;
import org.netbeans.lib.editor.codetemplates.api.CodeTemplate;
import org.netbeans.lib.editor.codetemplates.spi.CodeTemplateFilter;
import org.openide.util.Exceptions;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JavaCodeTemplateFilter
implements CodeTemplateFilter,
CancellableTask<CompilationController> {
    private int startOffset;
    private int endOffset;
    private Tree.Kind ctx = null;

    private JavaCodeTemplateFilter(JTextComponent jTextComponent, int n) {
        this.startOffset = n;
        this.endOffset = jTextComponent.getSelectionStart() == n ? jTextComponent.getSelectionEnd() : -1;
        JavaSource javaSource = JavaSource.forDocument((Document)jTextComponent.getDocument());
        if (javaSource != null) {
            try {
                javaSource.runUserActionTask((CancellableTask)this, true);
            }
            catch (IOException iOException) {
                Exceptions.printStackTrace((Throwable)iOException);
            }
        }
    }

    public synchronized boolean accept(CodeTemplate codeTemplate) {
        return this.ctx != null && this.getTemplateContexts(codeTemplate).contains((Object)this.ctx);
    }

    public void cancel() {
    }

    public synchronized void run(CompilationController compilationController) throws IOException {
        TreePath treePath;
        compilationController.toPhase(JavaSource.Phase.PARSED);
        TreePath treePath2 = compilationController.getTreeUtilities().pathFor(this.startOffset);
        this.ctx = treePath2.getLeaf().getKind();
        if (this.endOffset >= 0 && this.startOffset != this.endOffset && (treePath = compilationController.getTreeUtilities().pathFor(this.endOffset)).getLeaf().getKind() != this.ctx) {
            this.ctx = null;
        }
    }

    private EnumSet<Tree.Kind> getTemplateContexts(CodeTemplate codeTemplate) {
        String string = codeTemplate.getAbbreviation().toLowerCase();
        if (string.equals("runn") || string.startsWith("for") || string.startsWith("while") || string.equals("inst") || string.startsWith("if") || string.startsWith("do") || string.startsWith("try")) {
            return EnumSet.of(Tree.Kind.BLOCK);
        }
        return EnumSet.noneOf(Tree.Kind.class);
    }

    public static final class Factory
    implements CodeTemplateFilter.Factory {
        public CodeTemplateFilter createFilter(JTextComponent jTextComponent, int n) {
            return new JavaCodeTemplateFilter(jTextComponent, n);
        }
    }
}

