/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.editor.java;

import com.sun.source.tree.AssignmentTree;
import com.sun.source.tree.CompilationUnitTree;
import com.sun.source.tree.EnhancedForLoopTree;
import com.sun.source.tree.ErroneousTree;
import com.sun.source.tree.Scope;
import com.sun.source.tree.StatementTree;
import com.sun.source.tree.Tree;
import com.sun.source.tree.TryTree;
import com.sun.source.tree.TypeCastTree;
import com.sun.source.tree.VariableTree;
import com.sun.source.util.SourcePositions;
import com.sun.source.util.TreePath;
import com.sun.source.util.TreeScanner;
import com.sun.source.util.Trees;
import java.io.IOException;
import java.util.Collection;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import javax.lang.model.AnnotatedConstruct;
import javax.lang.model.element.Element;
import javax.lang.model.element.ElementKind;
import javax.lang.model.element.ExecutableElement;
import javax.lang.model.element.Modifier;
import javax.lang.model.element.Name;
import javax.lang.model.element.TypeElement;
import javax.lang.model.element.VariableElement;
import javax.lang.model.type.ArrayType;
import javax.lang.model.type.DeclaredType;
import javax.lang.model.type.TypeKind;
import javax.lang.model.type.TypeMirror;
import javax.lang.model.type.TypeVariable;
import javax.lang.model.util.Types;
import javax.swing.text.Document;
import javax.swing.text.JTextComponent;
import org.netbeans.api.java.source.CancellableTask;
import org.netbeans.api.java.source.CompilationController;
import org.netbeans.api.java.source.CompilationInfo;
import org.netbeans.api.java.source.ElementUtilities;
import org.netbeans.api.java.source.JavaSource;
import org.netbeans.api.java.source.TreeUtilities;
import org.netbeans.api.java.source.UiUtils;
import org.netbeans.lib.editor.codetemplates.spi.CodeTemplateInsertRequest;
import org.netbeans.lib.editor.codetemplates.spi.CodeTemplateParameter;
import org.netbeans.lib.editor.codetemplates.spi.CodeTemplateProcessor;
import org.netbeans.lib.editor.codetemplates.spi.CodeTemplateProcessorFactory;
import org.netbeans.modules.editor.java.AutoImport;
import org.netbeans.modules.editor.java.Utilities;
import org.openide.util.Exceptions;

public class JavaCodeTemplateProcessor
implements CodeTemplateProcessor {
    public static final String INSTANCE_OF = "instanceof";
    public static final String ARRAY = "array";
    public static final String ITERABLE = "iterable";
    public static final String TYPE = "type";
    public static final String ITERABLE_ELEMENT_TYPE = "iterableElementType";
    public static final String LEFT_SIDE_TYPE = "leftSideType";
    public static final String RIGHT_SIDE_TYPE = "rightSideType";
    public static final String CAST = "cast";
    public static final String NEW_VAR_NAME = "newVarName";
    public static final String NAMED = "named";
    public static final String UNCAUGHT_EXCEPTION_TYPE = "uncaughtExceptionType";
    private static final String FALSE = "false";
    private static final String NULL = "null";
    private CodeTemplateInsertRequest request;
    private CompilationInfo cInfo = null;
    private TreePath treePath = null;
    private Scope scope = null;
    private TypeElement enclClass = null;
    private Iterable<? extends Element> locals = null;
    private Map<CodeTemplateParameter, String> param2hints = new HashMap<CodeTemplateParameter, String>();
    private Map<CodeTemplateParameter, TypeMirror> param2types = new HashMap<CodeTemplateParameter, TypeMirror>();
    private ErrChecker errChecker = new ErrChecker();

    private JavaCodeTemplateProcessor(CodeTemplateInsertRequest codeTemplateInsertRequest) {
        this.request = codeTemplateInsertRequest;
    }

    public synchronized void updateDefaultValues() {
        boolean bl = true;
        while (bl) {
            bl = false;
            for (Object e : this.request.getMasterParameters()) {
                CodeTemplateParameter codeTemplateParameter = (CodeTemplateParameter)e;
                String string = this.getProposedValue(codeTemplateParameter);
                if (string == null || string.equals(codeTemplateParameter.getValue())) continue;
                codeTemplateParameter.setValue(string);
                bl = true;
            }
        }
        this.updateImports();
    }

    public void parameterValueChanged(CodeTemplateParameter codeTemplateParameter, boolean bl) {
        if (bl) {
            for (Object e : this.request.getMasterParameters()) {
                CodeTemplateParameter codeTemplateParameter2 = (CodeTemplateParameter)e;
                if (!codeTemplateParameter2.isUserModified()) {
                    String string = this.getProposedValue(codeTemplateParameter2);
                    if (string == null || string.equals(codeTemplateParameter2.getValue())) continue;
                    codeTemplateParameter2.setValue(string);
                    continue;
                }
                this.param2types.remove(codeTemplateParameter2);
            }
            this.updateImports();
        }
    }

    public void release() {
    }

    private void updateImports() {
        if (!this.param2types.isEmpty()) {
            AutoImport autoImport = AutoImport.get(this.cInfo);
            for (Map.Entry<CodeTemplateParameter, TypeMirror> entry : this.param2types.entrySet()) {
                CodeTemplateParameter codeTemplateParameter = entry.getKey();
                TypeMirror typeMirror = this.param2types.get(codeTemplateParameter);
                TreePath treePath = this.cInfo.getTreeUtilities().pathFor(this.request.getInsertTextOffset() + codeTemplateParameter.getInsertTextOffset());
                CharSequence charSequence = autoImport.resolveImport(treePath, (DeclaredType)typeMirror);
                if (CAST.equals(this.param2hints.get(codeTemplateParameter))) {
                    codeTemplateParameter.setValue("(" + charSequence + ")");
                    continue;
                }
                if (INSTANCE_OF.equals(this.param2hints.get(codeTemplateParameter))) {
                    String string = codeTemplateParameter.getValue().substring(codeTemplateParameter.getValue().lastIndexOf(46) + 1);
                    codeTemplateParameter.setValue(charSequence + "." + string);
                    continue;
                }
                codeTemplateParameter.setValue(((Object)charSequence).toString());
            }
        }
    }

    private String getProposedValue(CodeTemplateParameter codeTemplateParameter) {
        this.param2hints.remove(codeTemplateParameter);
        this.param2types.remove(codeTemplateParameter);
        String string = null;
        for (Map.Entry entry : codeTemplateParameter.getHints().entrySet()) {
            Object object;
            AnnotatedConstruct annotatedConstruct;
            Map.Entry entry2 = entry;
            if (INSTANCE_OF.equals(entry2.getKey())) {
                annotatedConstruct = this.instanceOf((String)entry2.getValue(), string);
                if (annotatedConstruct != null) {
                    this.param2hints.put(codeTemplateParameter, INSTANCE_OF);
                    return annotatedConstruct.getSimpleName().toString();
                }
                if (string != null) continue;
                annotatedConstruct = this.staticInstanceOf((String)entry2.getValue(), string);
                if (annotatedConstruct != null) {
                    this.param2hints.put(codeTemplateParameter, INSTANCE_OF);
                    object = annotatedConstruct.getEnclosingElement().asType();
                    if (object.getKind() == TypeKind.DECLARED) {
                        this.param2types.put(codeTemplateParameter, (TypeMirror)object);
                    }
                    return Utilities.getTypeName((TypeMirror)object, true) + "." + annotatedConstruct.getSimpleName();
                }
                return this.valueOf((String)entry2.getValue());
            }
            if (ARRAY.equals(entry2.getKey())) {
                annotatedConstruct = this.array();
                if (annotatedConstruct == null) continue;
                this.param2hints.put(codeTemplateParameter, ARRAY);
                return annotatedConstruct.getSimpleName().toString();
            }
            if (ITERABLE.equals(entry2.getKey())) {
                annotatedConstruct = this.iterable();
                if (annotatedConstruct == null) continue;
                this.param2hints.put(codeTemplateParameter, ITERABLE);
                return annotatedConstruct.getSimpleName().toString();
            }
            if (TYPE.equals(entry2.getKey())) {
                annotatedConstruct = this.type((String)entry2.getValue());
                if (annotatedConstruct == null || annotatedConstruct.getKind() == TypeKind.ERROR) continue;
                if (annotatedConstruct.getKind() == TypeKind.TYPEVAR) {
                    annotatedConstruct = ((TypeVariable)annotatedConstruct).getUpperBound();
                }
                if ((object = ((Object)Utilities.getTypeName((TypeMirror)annotatedConstruct, true)).toString()) == null) continue;
                this.param2hints.put(codeTemplateParameter, TYPE);
                if (annotatedConstruct.getKind() == TypeKind.DECLARED) {
                    this.param2types.put(codeTemplateParameter, (TypeMirror)annotatedConstruct);
                }
                return object;
            }
            if (ITERABLE_ELEMENT_TYPE.equals(entry2.getKey())) {
                annotatedConstruct = this.iterableElementType(codeTemplateParameter.getInsertTextOffset() + 1);
                if (annotatedConstruct == null || annotatedConstruct.getKind() == TypeKind.ERROR) continue;
                if (annotatedConstruct.getKind() == TypeKind.TYPEVAR) {
                    annotatedConstruct = ((TypeVariable)annotatedConstruct).getUpperBound();
                }
                if ((object = ((Object)Utilities.getTypeName((TypeMirror)annotatedConstruct, true)).toString()) == null) continue;
                this.param2hints.put(codeTemplateParameter, ITERABLE_ELEMENT_TYPE);
                if (annotatedConstruct.getKind() == TypeKind.DECLARED) {
                    this.param2types.put(codeTemplateParameter, (TypeMirror)annotatedConstruct);
                }
                return object;
            }
            if (LEFT_SIDE_TYPE.equals(entry2.getKey())) {
                annotatedConstruct = this.assignmentSideType(codeTemplateParameter.getInsertTextOffset() + 1, true);
                if (annotatedConstruct == null || annotatedConstruct.getKind() == TypeKind.ERROR) continue;
                if (annotatedConstruct.getKind() == TypeKind.TYPEVAR) {
                    annotatedConstruct = ((TypeVariable)annotatedConstruct).getUpperBound();
                }
                if ((object = ((Object)Utilities.getTypeName((TypeMirror)annotatedConstruct, true)).toString()) == null) continue;
                this.param2hints.put(codeTemplateParameter, LEFT_SIDE_TYPE);
                if (annotatedConstruct.getKind() == TypeKind.DECLARED) {
                    this.param2types.put(codeTemplateParameter, (TypeMirror)annotatedConstruct);
                }
                return object;
            }
            if (RIGHT_SIDE_TYPE.equals(entry2.getKey())) {
                annotatedConstruct = this.assignmentSideType(codeTemplateParameter.getInsertTextOffset() + 1, false);
                if (annotatedConstruct == null || annotatedConstruct.getKind() == TypeKind.ERROR) continue;
                if (annotatedConstruct.getKind() == TypeKind.TYPEVAR) {
                    annotatedConstruct = ((TypeVariable)annotatedConstruct).getUpperBound();
                }
                if ((object = ((Object)Utilities.getTypeName((TypeMirror)annotatedConstruct, true)).toString()) == null) continue;
                this.param2hints.put(codeTemplateParameter, RIGHT_SIDE_TYPE);
                if (annotatedConstruct.getKind() == TypeKind.DECLARED) {
                    this.param2types.put(codeTemplateParameter, (TypeMirror)annotatedConstruct);
                }
                return object;
            }
            if (CAST.equals(entry2.getKey())) {
                annotatedConstruct = this.cast(codeTemplateParameter.getInsertTextOffset() + 1);
                if (annotatedConstruct == null) {
                    this.param2hints.put(codeTemplateParameter, CAST);
                    this.param2types.remove(codeTemplateParameter);
                    return "";
                }
                if (annotatedConstruct.getKind() == TypeKind.ERROR || (object = ((Object)Utilities.getTypeName((TypeMirror)annotatedConstruct, true)).toString()) == null) continue;
                this.param2hints.put(codeTemplateParameter, CAST);
                if (annotatedConstruct.getKind() == TypeKind.DECLARED) {
                    this.param2types.put(codeTemplateParameter, (TypeMirror)annotatedConstruct);
                }
                return "(" + (String)object + ")";
            }
            if (NEW_VAR_NAME.equals(entry2.getKey())) {
                this.param2hints.put(codeTemplateParameter, NEW_VAR_NAME);
                return this.newVarName(codeTemplateParameter.getInsertTextOffset() + 1);
            }
            if (NAMED.equals(entry2.getKey())) {
                string = codeTemplateParameter.getName();
                continue;
            }
            if (!UNCAUGHT_EXCEPTION_TYPE.equals(entry2.getKey()) || (annotatedConstruct = this.uncaughtExceptionType(codeTemplateParameter.getInsertTextOffset() + 1)) == null || annotatedConstruct.getKind() == TypeKind.ERROR) continue;
            if (annotatedConstruct.getKind() == TypeKind.TYPEVAR) {
                annotatedConstruct = ((TypeVariable)annotatedConstruct).getUpperBound();
            }
            if ((object = ((Object)Utilities.getTypeName((TypeMirror)annotatedConstruct, true)).toString()) == null) continue;
            this.param2hints.put(codeTemplateParameter, UNCAUGHT_EXCEPTION_TYPE);
            if (annotatedConstruct.getKind() == TypeKind.DECLARED) {
                this.param2types.put(codeTemplateParameter, (TypeMirror)annotatedConstruct);
            }
            return object;
        }
        return null;
    }

    private VariableElement instanceOf(String string, String string2) {
        try {
            if (this.initParsing()) {
                TypeMirror typeMirror = this.cInfo.getTreeUtilities().parseType(string, this.enclClass);
                VariableElement variableElement = null;
                int n = Integer.MAX_VALUE;
                if (typeMirror != null) {
                    Types types = this.cInfo.getTypes();
                    for (Element element : this.locals) {
                        if (!(element instanceof VariableElement) || !types.isAssignable(element.asType(), typeMirror)) continue;
                        if (string2 == null) {
                            return (VariableElement)element;
                        }
                        int n2 = UiUtils.getDistance((String)element.getSimpleName().toString(), (String)string2);
                        if (n2 >= n) continue;
                        n = n2;
                        variableElement = (VariableElement)element;
                    }
                }
                return variableElement;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return null;
    }

    private VariableElement staticInstanceOf(String string, String string2) {
        try {
            if (this.initParsing()) {
                final TreeUtilities treeUtilities = this.cInfo.getTreeUtilities();
                TypeMirror typeMirror = treeUtilities.parseType(string, this.enclClass);
                VariableElement variableElement = null;
                int n = Integer.MAX_VALUE;
                if (typeMirror != null) {
                    final Types types = this.cInfo.getTypes();
                    if (typeMirror.getKind() == TypeKind.DECLARED) {
                        final DeclaredType declaredType = (DeclaredType)typeMirror;
                        TypeElement typeElement = (TypeElement)declaredType.asElement();
                        final boolean bl = typeElement.getKind().isClass() || typeElement.getKind().isInterface();
                        ElementUtilities.ElementAcceptor elementAcceptor = new ElementUtilities.ElementAcceptor(){

                            public boolean accept(Element element, TypeMirror typeMirror) {
                                return element.getKind().isField() && (!bl || element.getModifiers().contains((Object)Modifier.STATIC)) && treeUtilities.isAccessible(JavaCodeTemplateProcessor.this.scope, element, typeMirror) && (element.getKind().isField() && types.isAssignable(((VariableElement)element).asType(), declaredType) || element.getKind() == ElementKind.METHOD && types.isAssignable(((ExecutableElement)element).getReturnType(), declaredType));
                            }
                        };
                        for (Element element : this.cInfo.getElementUtilities().getMembers((TypeMirror)declaredType, elementAcceptor)) {
                            if (string2 == null) {
                                return (VariableElement)element;
                            }
                            int n2 = UiUtils.getDistance((String)element.getSimpleName().toString(), (String)string2);
                            if (n2 >= n) continue;
                            n = n2;
                            variableElement = (VariableElement)element;
                        }
                    }
                }
                return variableElement;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return null;
    }

    private String valueOf(String string) {
        try {
            TypeMirror typeMirror;
            if (this.initParsing() && (typeMirror = this.cInfo.getTreeUtilities().parseType(string, this.enclClass)) != null) {
                if (typeMirror.getKind() == TypeKind.DECLARED) {
                    return NULL;
                }
                if (typeMirror.getKind() == TypeKind.BOOLEAN) {
                    return FALSE;
                }
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return null;
    }

    private VariableElement array() {
        if (this.initParsing()) {
            for (Element element : this.locals) {
                if (!(element instanceof VariableElement) || element.asType().getKind() != TypeKind.ARRAY) continue;
                return (VariableElement)element;
            }
        }
        return null;
    }

    private VariableElement iterable() {
        if (this.initParsing()) {
            DeclaredType declaredType = this.cInfo.getTypes().getDeclaredType(this.cInfo.getElements().getTypeElement("java.lang.Iterable"), new TypeMirror[0]);
            for (Element element : this.locals) {
                if (!(element instanceof VariableElement) || element.asType().getKind() != TypeKind.ARRAY && !this.cInfo.getTypes().isAssignable(element.asType(), declaredType)) continue;
                return (VariableElement)element;
            }
        }
        return null;
    }

    private TypeMirror type(String string) {
        return this.initParsing() ? this.cInfo.getTreeUtilities().parseType(string, this.enclClass) : null;
    }

    private TypeMirror iterableElementType(int n) {
        try {
            if (this.initParsing()) {
                SourcePositions[] sourcePositionsArray = new SourcePositions[1];
                TreeUtilities treeUtilities = this.cInfo.getTreeUtilities();
                StatementTree statementTree = treeUtilities.parseStatement(this.request.getInsertText(), sourcePositionsArray);
                if (this.errChecker.containsErrors(statementTree)) {
                    return null;
                }
                TreePath treePath = treeUtilities.pathFor(new TreePath(this.treePath, statementTree), n, sourcePositionsArray[0]);
                TreePath treePath2 = Utilities.getPathElementOfKind(Tree.Kind.ENHANCED_FOR_LOOP, treePath);
                if (treePath2 != null) {
                    treeUtilities.attributeTree((Tree)statementTree, this.scope);
                    TypeMirror typeMirror = this.cInfo.getTrees().getTypeMirror(new TreePath(treePath2, ((EnhancedForLoopTree)treePath2.getLeaf()).getExpression()));
                    switch (typeMirror.getKind()) {
                        case ARRAY: {
                            typeMirror = ((ArrayType)typeMirror).getComponentType();
                            return typeMirror;
                        }
                        case DECLARED: {
                            Iterator<? extends TypeMirror> iterator = ((DeclaredType)typeMirror).getTypeArguments().iterator();
                            if (iterator.hasNext()) {
                                return iterator.next();
                            }
                            return this.cInfo.getElements().getTypeElement("java.lang.Object").asType();
                        }
                    }
                }
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return null;
    }

    private TypeMirror assignmentSideType(int n, boolean bl) {
        try {
            if (this.initParsing()) {
                SourcePositions[] sourcePositionsArray = new SourcePositions[1];
                TreeUtilities treeUtilities = this.cInfo.getTreeUtilities();
                StatementTree statementTree = treeUtilities.parseStatement(this.request.getInsertText(), sourcePositionsArray);
                if (this.errChecker.containsErrors(statementTree)) {
                    return null;
                }
                TreePath treePath = treeUtilities.pathFor(new TreePath(this.treePath, statementTree), n, sourcePositionsArray[0]);
                TreePath treePath2 = Utilities.getPathElementOfKind(EnumSet.of(Tree.Kind.ASSIGNMENT, Tree.Kind.VARIABLE), treePath);
                if (treePath2 == null) {
                    return null;
                }
                treeUtilities.attributeTree((Tree)statementTree, this.scope);
                if (treePath2.getLeaf().getKind() == Tree.Kind.ASSIGNMENT) {
                    AssignmentTree assignmentTree = (AssignmentTree)treePath2.getLeaf();
                    TreePath treePath3 = new TreePath(treePath2, bl ? assignmentTree.getVariable() : assignmentTree.getExpression());
                    return this.cInfo.getTrees().getTypeMirror(treePath3);
                }
                VariableTree variableTree = (VariableTree)treePath2.getLeaf();
                TreePath treePath4 = new TreePath(treePath2, bl ? variableTree.getType() : variableTree.getInitializer());
                return this.cInfo.getTrees().getTypeMirror(treePath4);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return null;
    }

    private TypeMirror cast(int n) {
        try {
            if (this.initParsing()) {
                TypeMirror typeMirror;
                SourcePositions[] sourcePositionsArray = new SourcePositions[1];
                TreeUtilities treeUtilities = this.cInfo.getTreeUtilities();
                StatementTree statementTree = treeUtilities.parseStatement(this.request.getInsertText(), sourcePositionsArray);
                if (this.errChecker.containsErrors(statementTree)) {
                    return null;
                }
                TreePath treePath = treeUtilities.pathFor(new TreePath(this.treePath, statementTree), n, sourcePositionsArray[0]);
                TreePath treePath2 = Utilities.getPathElementOfKind(EnumSet.of(Tree.Kind.ASSIGNMENT, Tree.Kind.VARIABLE), treePath);
                if (treePath2 == null) {
                    return null;
                }
                treeUtilities.attributeTree((Tree)statementTree, this.scope);
                if (treePath2.getLeaf().getKind() == Tree.Kind.ASSIGNMENT) {
                    TypeMirror typeMirror2;
                    AssignmentTree assignmentTree = (AssignmentTree)treePath2.getLeaf();
                    TypeMirror typeMirror3 = this.cInfo.getTrees().getTypeMirror(new TreePath(treePath2, assignmentTree.getVariable()));
                    TreePath treePath3 = new TreePath(treePath2, assignmentTree.getExpression());
                    if (treePath3.getLeaf() instanceof TypeCastTree) {
                        treePath3 = new TreePath(treePath3, ((TypeCastTree)treePath3.getLeaf()).getExpression());
                    }
                    if ((typeMirror2 = this.cInfo.getTrees().getTypeMirror(treePath3)) == null || typeMirror3 == null) {
                        return null;
                    }
                    if (this.cInfo.getTypes().isAssignable(typeMirror2, typeMirror3)) {
                        return null;
                    }
                    return typeMirror3;
                }
                VariableTree variableTree = (VariableTree)treePath2.getLeaf();
                TypeMirror typeMirror4 = this.cInfo.getTrees().getTypeMirror(new TreePath(treePath2, variableTree.getType()));
                TreePath treePath4 = new TreePath(treePath2, variableTree.getInitializer());
                if (treePath4.getLeaf() instanceof TypeCastTree) {
                    treePath4 = new TreePath(treePath4, ((TypeCastTree)treePath4.getLeaf()).getExpression());
                }
                if ((typeMirror = this.cInfo.getTrees().getTypeMirror(treePath4)) == null) {
                    return null;
                }
                if (typeMirror4 == null) {
                    return null;
                }
                if (typeMirror.getKind() != TypeKind.ERROR && this.cInfo.getTypes().isAssignable(typeMirror, typeMirror4)) {
                    return null;
                }
                return typeMirror4;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return null;
    }

    private String newVarName(int n) {
        try {
            if (this.initParsing()) {
                SourcePositions[] sourcePositionsArray = new SourcePositions[1];
                TreeUtilities treeUtilities = this.cInfo.getTreeUtilities();
                StatementTree statementTree = treeUtilities.parseStatement(this.request.getInsertText(), sourcePositionsArray);
                if (this.errChecker.containsErrors(statementTree)) {
                    return null;
                }
                TreePath treePath = treeUtilities.pathFor(new TreePath(this.treePath, statementTree), n, sourcePositionsArray[0]);
                TreePath treePath2 = Utilities.getPathElementOfKind(Tree.Kind.VARIABLE, treePath);
                if (treePath2 != null) {
                    Scope scope = treeUtilities.attributeTreeTo((Tree)statementTree, this.scope, treePath2.getLeaf());
                    TypeMirror typeMirror = this.cInfo.getTrees().getTypeMirror(treePath2);
                    boolean bl = ((VariableTree)treePath2.getLeaf()).getModifiers().getFlags().containsAll(EnumSet.of(Modifier.FINAL, Modifier.STATIC));
                    final Name name = ((VariableTree)treePath2.getLeaf()).getName();
                    ElementUtilities.ElementAcceptor elementAcceptor = new ElementUtilities.ElementAcceptor(){

                        public boolean accept(Element element, TypeMirror typeMirror) {
                            switch (element.getKind()) {
                                case EXCEPTION_PARAMETER: 
                                case LOCAL_VARIABLE: 
                                case PARAMETER: {
                                    return name != element.getSimpleName();
                                }
                            }
                            return false;
                        }
                    };
                    Iterator<String> iterator = Utilities.varNamesSuggestions(typeMirror, null, this.cInfo.getTypes(), this.cInfo.getElements(), this.cInfo.getElementUtilities().getLocalVars(scope, elementAcceptor), bl).iterator();
                    if (iterator.hasNext()) {
                        return iterator.next();
                    }
                }
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return null;
    }

    private TypeMirror uncaughtExceptionType(int n) {
        try {
            if (this.initParsing()) {
                SourcePositions[] sourcePositionsArray = new SourcePositions[1];
                TreeUtilities treeUtilities = this.cInfo.getTreeUtilities();
                StatementTree statementTree = treeUtilities.parseStatement(this.request.getInsertText(), sourcePositionsArray);
                if (this.errChecker.containsErrors(statementTree)) {
                    return null;
                }
                TreePath treePath = treeUtilities.pathFor(new TreePath(this.treePath, statementTree), n, sourcePositionsArray[0]);
                if ((treePath = Utilities.getPathElementOfKind(Tree.Kind.TRY, treePath)) != null && ((TryTree)treePath.getLeaf()).getBlock() != null) {
                    treeUtilities.attributeTree((Tree)statementTree, this.scope);
                    Iterator iterator = treeUtilities.getUncaughtExceptions(new TreePath(treePath, ((TryTree)treePath.getLeaf()).getBlock())).iterator();
                    if (iterator.hasNext()) {
                        return (TypeMirror)iterator.next();
                    }
                }
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return null;
    }

    private boolean initParsing() {
        if (this.cInfo == null) {
            JTextComponent jTextComponent = this.request.getComponent();
            final int n = jTextComponent.getCaret().getDot();
            JavaSource javaSource = JavaSource.forDocument((Document)jTextComponent.getDocument());
            if (javaSource != null) {
                try {
                    javaSource.runUserActionTask((CancellableTask)new CancellableTask<CompilationController>(){

                        public void cancel() {
                        }

                        public void run(CompilationController compilationController) throws IOException {
                            Object object;
                            Object object2;
                            boolean bl;
                            compilationController.toPhase(JavaSource.Phase.RESOLVED);
                            JavaCodeTemplateProcessor.this.cInfo = (CompilationInfo)compilationController;
                            final TreeUtilities treeUtilities = JavaCodeTemplateProcessor.this.cInfo.getTreeUtilities();
                            JavaCodeTemplateProcessor.this.treePath = treeUtilities.pathFor(n);
                            JavaCodeTemplateProcessor.this.scope = treeUtilities.scopeFor(n);
                            JavaCodeTemplateProcessor.this.enclClass = JavaCodeTemplateProcessor.this.scope.getEnclosingClass();
                            boolean bl2 = bl = JavaCodeTemplateProcessor.this.enclClass != null ? treeUtilities.isStaticContext(JavaCodeTemplateProcessor.this.scope) : false;
                            if (JavaCodeTemplateProcessor.this.enclClass == null && (object2 = (object = JavaCodeTemplateProcessor.this.treePath.getCompilationUnit()).getTypeDecls().iterator()).hasNext()) {
                                JavaCodeTemplateProcessor.this.enclClass = (TypeElement)JavaCodeTemplateProcessor.this.cInfo.getTrees().getElement(TreePath.getPath((CompilationUnitTree)object, (Tree)object2.next()));
                            }
                            object = compilationController.getTrees();
                            object2 = ((Trees)object).getSourcePositions();
                            final Collection<? extends Element> collection = Utilities.getForwardReferences(JavaCodeTemplateProcessor.this.treePath, n, (SourcePositions)object2, (Trees)object);
                            final ExecutableElement executableElement = JavaCodeTemplateProcessor.this.scope.getEnclosingMethod();
                            ElementUtilities.ElementAcceptor elementAcceptor = new ElementUtilities.ElementAcceptor(){

                                public boolean accept(Element element, TypeMirror typeMirror) {
                                    switch (element.getKind()) {
                                        case LOCAL_VARIABLE: {
                                            if (bl && element.getSimpleName().contentEquals("this") || element.getSimpleName().contentEquals("super")) {
                                                return false;
                                            }
                                        }
                                        case EXCEPTION_PARAMETER: 
                                        case PARAMETER: {
                                            return (executableElement == element.getEnclosingElement() || element.getModifiers().contains((Object)Modifier.FINAL)) && !collection.contains(element);
                                        }
                                        case FIELD: {
                                            if (!collection.contains(element)) break;
                                            return false;
                                        }
                                    }
                                    return (!bl || element.getModifiers().contains((Object)Modifier.STATIC)) && treeUtilities.isAccessible(JavaCodeTemplateProcessor.this.scope, element, typeMirror);
                                }
                            };
                            JavaCodeTemplateProcessor.this.locals = JavaCodeTemplateProcessor.this.cInfo.getElementUtilities().getLocalMembersAndVars(JavaCodeTemplateProcessor.this.scope, elementAcceptor);
                        }
                    }, false);
                }
                catch (IOException iOException) {
                    Exceptions.printStackTrace((Throwable)iOException);
                }
            }
        }
        return this.cInfo != null;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class ErrChecker
    extends TreeScanner<Void, Void> {
        private boolean containsErrors;

        private ErrChecker() {
        }

        public boolean containsErrors(Tree tree) {
            this.containsErrors = false;
            this.scan(tree, null);
            return this.containsErrors;
        }

        @Override
        public Void visitErroneous(ErroneousTree erroneousTree, Void void_) {
            this.containsErrors = true;
            return null;
        }

        @Override
        public Void scan(Tree tree, Void void_) {
            if (this.containsErrors) {
                return null;
            }
            return (Void)super.scan(tree, void_);
        }
    }

    public static final class Factory
    implements CodeTemplateProcessorFactory {
        public CodeTemplateProcessor createProcessor(CodeTemplateInsertRequest codeTemplateInsertRequest) {
            return new JavaCodeTemplateProcessor(codeTemplateInsertRequest);
        }
    }
}

