/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.editor.java;

import com.sun.javadoc.AnnotationDesc;
import com.sun.javadoc.AnnotationTypeDoc;
import com.sun.javadoc.AnnotationTypeElementDoc;
import com.sun.javadoc.AnnotationValue;
import com.sun.javadoc.ClassDoc;
import com.sun.javadoc.Doc;
import com.sun.javadoc.ExecutableMemberDoc;
import com.sun.javadoc.FieldDoc;
import com.sun.javadoc.MethodDoc;
import com.sun.javadoc.PackageDoc;
import com.sun.javadoc.ParamTag;
import com.sun.javadoc.ParameterizedType;
import com.sun.javadoc.ProgramElementDoc;
import com.sun.javadoc.SeeTag;
import com.sun.javadoc.Tag;
import com.sun.javadoc.ThrowsTag;
import com.sun.javadoc.Type;
import com.sun.javadoc.TypeVariable;
import com.sun.javadoc.WildcardType;
import java.awt.event.ActionEvent;
import java.io.IOException;
import java.lang.reflect.Modifier;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URL;
import java.util.Hashtable;
import java.util.Iterator;
import javax.lang.model.element.Element;
import javax.lang.model.element.ElementKind;
import javax.lang.model.element.ExecutableElement;
import javax.lang.model.element.TypeElement;
import javax.lang.model.element.VariableElement;
import javax.lang.model.type.ArrayType;
import javax.lang.model.type.DeclaredType;
import javax.lang.model.type.TypeKind;
import javax.lang.model.type.TypeMirror;
import javax.swing.AbstractAction;
import javax.swing.Action;
import org.netbeans.api.java.source.CancellableTask;
import org.netbeans.api.java.source.ClasspathInfo;
import org.netbeans.api.java.source.CompilationController;
import org.netbeans.api.java.source.CompilationInfo;
import org.netbeans.api.java.source.ElementHandle;
import org.netbeans.api.java.source.ElementUtilities;
import org.netbeans.api.java.source.JavaSource;
import org.netbeans.api.java.source.SourceUtils;
import org.netbeans.api.java.source.UiUtils;
import org.netbeans.modules.editor.java.HTMLJavadocParser;
import org.netbeans.spi.editor.completion.CompletionDocumentation;
import org.openide.filesystems.FileObject;
import org.openide.util.Exceptions;
import org.openide.util.NbBundle;

public class JavaCompletionDoc
implements CompletionDocumentation {
    private ClasspathInfo cpInfo;
    private Doc doc;
    private String content = null;
    private Hashtable<String, ElementHandle<? extends Element>> links = new Hashtable();
    private int linkCounter = 0;
    private URL docURL = null;
    private AbstractAction goToSource = null;
    private static final String PARAM_TAG = "@param";
    private static final String RETURN_TAG = "@return";
    private static final String THROWS_TAG = "@throws";
    private static final String SEE_TAG = "@see";
    private static final String SINCE_TAG = "@since";
    private static final String INHERIT_DOC_TAG = "@inheritDoc";
    private static final String LINKPLAIN_TAG = "@linkplain";
    private static final String CODE_TAG = "@code";
    private static final String DEPRECATED_TAG = "@deprecated";

    public static final JavaCompletionDoc create(CompilationController compilationController, Element element) {
        return new JavaCompletionDoc(compilationController, element, null);
    }

    private JavaCompletionDoc(CompilationController compilationController, Element element, URL uRL) {
        ElementUtilities elementUtilities = compilationController.getElementUtilities();
        this.cpInfo = compilationController.getClasspathInfo();
        this.doc = elementUtilities.javaDocFor(element);
        if (element != null) {
            Object object;
            final FileObject fileObject = SourceUtils.getFile((Element)element, (ClasspathInfo)compilationController.getClasspathInfo());
            if (fileObject != null) {
                object = ElementHandle.create((Element)element);
                this.goToSource = new AbstractAction((ElementHandle)object){
                    final /* synthetic */ ElementHandle val$handle;
                    {
                        this.val$handle = elementHandle;
                    }

                    public void actionPerformed(ActionEvent actionEvent) {
                        UiUtils.open((FileObject)fileObject, (ElementHandle)this.val$handle);
                    }
                };
            }
            if (uRL != null) {
                this.docURL = uRL;
            } else {
                this.docURL = SourceUtils.getJavadoc((Element)element, (ClasspathInfo)this.cpInfo);
                if (this.docURL != null && (object = this.getFragment(element)).length() > 0) {
                    try {
                        this.docURL = new URL(this.docURL.toExternalForm() + "#" + object);
                    }
                    catch (MalformedURLException malformedURLException) {
                        // empty catch block
                    }
                }
            }
        }
        this.content = this.prepareContent(elementUtilities);
    }

    public String getText() {
        return this.content;
    }

    public URL getURL() {
        return this.docURL;
    }

    public CompletionDocumentation resolveLink(final String string) {
        final CompletionDocumentation[] completionDocumentationArray = new CompletionDocumentation[1];
        try {
            JavaSource javaSource;
            final ElementHandle<? extends Element> elementHandle = this.links.get(string);
            FileObject fileObject = elementHandle != null ? SourceUtils.getFile(elementHandle, (ClasspathInfo)this.cpInfo) : null;
            JavaSource javaSource2 = javaSource = fileObject != null ? JavaSource.forFileObject((FileObject)fileObject) : JavaSource.create((ClasspathInfo)this.cpInfo, (FileObject[])new FileObject[0]);
            if (javaSource != null) {
                javaSource.runUserActionTask((CancellableTask)new CancellableTask<CompilationController>(){

                    public void run(CompilationController compilationController) throws IOException {
                        compilationController.toPhase(JavaSource.Phase.ELEMENTS_RESOLVED);
                        if (elementHandle != null) {
                            completionDocumentationArray[0] = new JavaCompletionDoc(compilationController, elementHandle.resolve((CompilationInfo)compilationController), null);
                        } else {
                            int n = string.indexOf(35);
                            URI uRI = URI.create(n < 0 ? string : string.substring(0, n));
                            if (uRI != null) {
                                String string5;
                                int n2;
                                if (!uRI.isAbsolute()) {
                                    uRI = uRI.normalize();
                                }
                                n2 = (n2 = (string5 = uRI.toString()).lastIndexOf("..")) < 0 ? 0 : n2 + 3;
                                int n3 = string5.lastIndexOf(46);
                                if (n3 >= 0) {
                                    string5 = string5.substring(n2, n3);
                                }
                                String string2 = string5.replace('/', '.');
                                Element element = compilationController.getElements().getTypeElement(string2);
                                if (element != null) {
                                    if (n >= 0) {
                                        String string3 = string.substring(n + 1);
                                        String string4 = (n = string3.indexOf(40)) < 0 ? string3 : string3.substring(0, n);
                                        for (Element element2 : element.getEnclosedElements()) {
                                            if (!element2.getSimpleName().contentEquals(string4) || !string3.contentEquals(JavaCompletionDoc.this.getFragment(element2))) continue;
                                            element = element2;
                                            break;
                                        }
                                    }
                                    completionDocumentationArray[0] = new JavaCompletionDoc(compilationController, element, new URL(JavaCompletionDoc.this.docURL, string));
                                }
                            }
                        }
                    }

                    public void cancel() {
                    }
                }, true);
            }
        }
        catch (IOException iOException) {
            Exceptions.printStackTrace((Throwable)iOException);
        }
        return completionDocumentationArray[0];
    }

    public Action getGotoSourceAction() {
        return this.goToSource;
    }

    private String prepareContent(ElementUtilities elementUtilities) {
        StringBuilder stringBuilder = new StringBuilder();
        if (this.doc != null) {
            if (this.doc instanceof ProgramElementDoc) {
                stringBuilder.append(this.getContainingClassOrPacakgeHeader(elementUtilities, (ProgramElementDoc)this.doc));
            }
            if (this.doc.isMethod() || this.doc.isConstructor() || this.doc.isAnnotationTypeElement()) {
                stringBuilder.append(this.getMethodHeader(elementUtilities, (ExecutableMemberDoc)this.doc));
            } else if (this.doc.isField() || this.doc.isEnumConstant()) {
                stringBuilder.append(this.getFieldHeader(elementUtilities, (FieldDoc)this.doc));
            } else if (this.doc.isClass() || this.doc.isInterface() || this.doc.isAnnotationType()) {
                stringBuilder.append(this.getClassHeader(elementUtilities, (ClassDoc)this.doc));
            }
            stringBuilder.append("<p>");
            if (this.doc.commentText().length() > 0 || this.doc.tags().length > 0) {
                stringBuilder.append(this.getDeprecatedTag(elementUtilities, this.doc));
                stringBuilder.append(this.inlineTags(elementUtilities, this.doc, this.doc.inlineTags()));
                stringBuilder.append("</p><p>");
                stringBuilder.append(this.getTags(elementUtilities, this.doc));
            } else {
                String string;
                String string2 = string = this.docURL != null ? HTMLJavadocParser.getJavadocText(this.docURL, false) : null;
                if (string != null) {
                    stringBuilder.append(string);
                } else {
                    stringBuilder.append(NbBundle.getMessage(JavaCompletionDoc.class, (String)"javadoc_content_not_found"));
                }
            }
            stringBuilder.append("</p>");
        } else {
            stringBuilder.append(NbBundle.getMessage(JavaCompletionDoc.class, (String)"javadoc_content_not_found"));
        }
        return stringBuilder.toString();
    }

    private CharSequence getContainingClassOrPacakgeHeader(ElementUtilities elementUtilities, ProgramElementDoc programElementDoc) {
        StringBuilder stringBuilder = new StringBuilder();
        ClassDoc classDoc = programElementDoc.containingClass();
        if (classDoc != null) {
            Element element = elementUtilities.elementFor((Doc)classDoc);
            if (element != null) {
                switch (element.getEnclosingElement().getKind()) {
                    case ANNOTATION_TYPE: 
                    case CLASS: 
                    case ENUM: 
                    case INTERFACE: 
                    case PACKAGE: {
                        if (classDoc.containingClass() == null && classDoc.containingPackage() == null) break;
                        stringBuilder.append("<font size='+0'><b>");
                        this.createLink(stringBuilder, element, classDoc.qualifiedName());
                        stringBuilder.append("</b></font>");
                    }
                }
            }
        } else {
            PackageDoc packageDoc = programElementDoc.containingPackage();
            if (packageDoc != null) {
                stringBuilder.append("<font size='+0'><b>");
                this.createLink(stringBuilder, elementUtilities.elementFor((Doc)packageDoc), packageDoc.name());
                stringBuilder.append("</b></font>");
            }
        }
        return stringBuilder;
    }

    private CharSequence getMethodHeader(ElementUtilities elementUtilities, ExecutableMemberDoc executableMemberDoc) {
        int n;
        Type[] typeArray;
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("<pre>");
        stringBuilder.append(this.getAnnotations(elementUtilities, (ProgramElementDoc)executableMemberDoc));
        int n2 = stringBuilder.length();
        stringBuilder.append(Modifier.toString(executableMemberDoc.modifierSpecifier() & 0xFFFFFEFF));
        n2 = stringBuilder.length() - n2;
        TypeVariable[] typeVariableArray = executableMemberDoc.typeParameters();
        if (typeVariableArray.length > 0) {
            if (n2 > 0) {
                stringBuilder.append(' ');
                ++n2;
            }
            stringBuilder.append("&lt;");
            for (int i = 0; i < typeVariableArray.length; ++i) {
                n2 += this.appendType(elementUtilities, stringBuilder, (Type)typeVariableArray[i], false, true);
                if (i >= typeVariableArray.length - 1) continue;
                stringBuilder.append(",");
                ++n2;
            }
            stringBuilder.append("&gt;");
            n2 += 2;
        }
        if (!executableMemberDoc.isConstructor()) {
            if (n2 > 0) {
                stringBuilder.append(' ');
                ++n2;
            }
            n2 += this.appendType(elementUtilities, stringBuilder, ((MethodDoc)executableMemberDoc).returnType(), false, false);
        }
        String string = executableMemberDoc.name();
        n2 += string.length();
        stringBuilder.append(" <b>").append(string).append("</b>");
        if (!executableMemberDoc.isAnnotationTypeElement()) {
            stringBuilder.append('(');
            ++n2;
            typeArray = executableMemberDoc.parameters();
            for (n = 0; n < typeArray.length; ++n) {
                boolean bl = n == typeArray.length - 1 && executableMemberDoc.isVarArgs();
                this.appendType(elementUtilities, stringBuilder, typeArray[n].type(), bl, false);
                stringBuilder.append(' ').append(typeArray[n].name());
                String string2 = typeArray[n].type().dimension();
                if (string2.length() > 0 && bl) {
                    string2 = string2.substring(2) + "...";
                }
                if (n >= typeArray.length - 1) continue;
                stringBuilder.append(",\n");
                this.appendSpace(stringBuilder, n2);
            }
            stringBuilder.append(')');
        }
        if ((typeArray = executableMemberDoc.thrownExceptionTypes()).length > 0) {
            stringBuilder.append("\nthrows ");
            for (n = 0; n < typeArray.length; ++n) {
                this.appendType(elementUtilities, stringBuilder, typeArray[n], false, false);
                if (n >= typeArray.length - 1) continue;
                stringBuilder.append(", ");
            }
        }
        stringBuilder.append("</pre>");
        return stringBuilder;
    }

    private CharSequence getFieldHeader(ElementUtilities elementUtilities, FieldDoc fieldDoc) {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("<pre>");
        stringBuilder.append(this.getAnnotations(elementUtilities, (ProgramElementDoc)fieldDoc));
        int n = stringBuilder.length();
        stringBuilder.append(fieldDoc.modifiers());
        n = stringBuilder.length() - n;
        if (n > 0) {
            stringBuilder.append(' ');
        }
        this.appendType(elementUtilities, stringBuilder, fieldDoc.type(), false, false);
        stringBuilder.append(" <b>").append(fieldDoc.name()).append("</b>");
        stringBuilder.append("</pre>");
        return stringBuilder;
    }

    private CharSequence getClassHeader(ElementUtilities elementUtilities, ClassDoc classDoc) {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("<pre>");
        stringBuilder.append(this.getAnnotations(elementUtilities, (ProgramElementDoc)classDoc));
        int n = classDoc.modifierSpecifier() & 0xFFFFFDFF;
        if (classDoc.isEnum()) {
            n &= 0xFFFFFFEF;
        }
        stringBuilder.append(Modifier.toString(n));
        if (stringBuilder.length() > 0) {
            stringBuilder.append(' ');
        }
        if (classDoc.isAnnotationType()) {
            stringBuilder.append("@interface ");
        } else if (classDoc.isEnum()) {
            stringBuilder.append("enum ");
        } else if (classDoc.isInterface()) {
            stringBuilder.append("interface ");
        } else {
            stringBuilder.append("class ");
        }
        stringBuilder.append("<b>").append(classDoc.name());
        TypeVariable[] typeVariableArray = classDoc.typeParameters();
        if (typeVariableArray.length > 0) {
            stringBuilder.append("&lt;");
            for (int i = 0; i < typeVariableArray.length; ++i) {
                this.appendType(elementUtilities, stringBuilder, (Type)typeVariableArray[i], false, true);
                if (i >= typeVariableArray.length - 1) continue;
                stringBuilder.append(",");
            }
            stringBuilder.append("&gt;");
        }
        stringBuilder.append("</b>");
        if (!classDoc.isAnnotationType()) {
            Type[] typeArray;
            Type type;
            if (classDoc.isClass() && (type = classDoc.superclassType()) != null) {
                stringBuilder.append("\nextends ");
                this.appendType(elementUtilities, stringBuilder, type, false, false);
            }
            if ((typeArray = classDoc.interfaceTypes()).length > 0) {
                stringBuilder.append(classDoc.isInterface() ? "\nextends " : "\nimplements ");
                for (int i = 0; i < typeArray.length; ++i) {
                    this.appendType(elementUtilities, stringBuilder, typeArray[i], false, false);
                    if (i >= typeArray.length - 1) continue;
                    stringBuilder.append(", ");
                }
            }
        }
        stringBuilder.append("</pre>");
        return stringBuilder;
    }

    private CharSequence getAnnotations(ElementUtilities elementUtilities, ProgramElementDoc programElementDoc) {
        StringBuilder stringBuilder = new StringBuilder();
        for (AnnotationDesc annotationDesc : programElementDoc.annotations()) {
            AnnotationTypeDoc annotationTypeDoc = annotationDesc.annotationType();
            if (annotationTypeDoc == null) continue;
            this.appendType(elementUtilities, stringBuilder, (Type)annotationTypeDoc, false, false);
            AnnotationDesc.ElementValuePair[] elementValuePairArray = annotationDesc.elementValues();
            if (elementValuePairArray.length > 0) {
                stringBuilder.append('(');
                for (int i = 0; i < elementValuePairArray.length; ++i) {
                    AnnotationTypeElementDoc annotationTypeElementDoc = elementValuePairArray[i].element();
                    this.createLink(stringBuilder, elementUtilities.elementFor((Doc)annotationTypeElementDoc), annotationTypeElementDoc.name());
                    stringBuilder.append('=');
                    this.appendAnnotationValue(elementUtilities, stringBuilder, elementValuePairArray[i].value());
                    if (i >= elementValuePairArray.length - 1) continue;
                    stringBuilder.append(",");
                }
                stringBuilder.append(')');
            }
            stringBuilder.append('\n');
        }
        return stringBuilder;
    }

    private void appendAnnotationValue(ElementUtilities elementUtilities, StringBuilder stringBuilder, AnnotationValue annotationValue) {
        Object object = annotationValue.value();
        if (object instanceof AnnotationValue[]) {
            int n = ((AnnotationValue[])object).length;
            if (n > 1) {
                stringBuilder.append('{');
            }
            for (int i = 0; i < ((AnnotationValue[])object).length; ++i) {
                this.appendAnnotationValue(elementUtilities, stringBuilder, ((AnnotationValue[])object)[i]);
                if (i >= ((AnnotationValue[])object).length - 1) continue;
                stringBuilder.append(",");
            }
            if (n > 1) {
                stringBuilder.append('}');
            }
        } else if (object instanceof Doc) {
            this.createLink(stringBuilder, elementUtilities.elementFor((Doc)object), ((Doc)object).name());
        } else {
            stringBuilder.append(object.toString());
        }
    }

    private CharSequence getTags(ElementUtilities elementUtilities, Doc doc) {
        int n;
        StringBuilder stringBuilder = new StringBuilder();
        StringBuilder stringBuilder2 = new StringBuilder();
        StringBuilder stringBuilder3 = new StringBuilder();
        StringBuilder stringBuilder4 = new StringBuilder();
        String string = null;
        for (Tag tag : doc.tags()) {
            Tag[] tagArray;
            Type type;
            if (PARAM_TAG.equals(tag.kind())) {
                stringBuilder2.append("<code>").append(((ParamTag)tag).parameterName()).append("</code>");
                type = tag.inlineTags();
                if (((Type)type).length > 0) {
                    stringBuilder2.append(" - ");
                    stringBuilder2.append(this.inlineTags(elementUtilities, doc, (Tag[])type));
                }
                stringBuilder2.append("<br>");
                continue;
            }
            if (THROWS_TAG.equals(tag.kind())) {
                stringBuilder3.append("<code>");
                type = ((ThrowsTag)tag).exceptionType();
                if (type != null) {
                    this.createLink(stringBuilder3, elementUtilities.elementFor((Doc)type.asClassDoc()), type.simpleTypeName());
                } else {
                    stringBuilder3.append(((ThrowsTag)tag).exceptionName());
                }
                stringBuilder3.append("</code>");
                tagArray = tag.inlineTags();
                if (tagArray.length > 0) {
                    stringBuilder3.append(" - ");
                    stringBuilder3.append(this.inlineTags(elementUtilities, doc, tagArray));
                }
                stringBuilder3.append("<br>");
                continue;
            }
            if (RETURN_TAG.equals(tag.kind())) {
                stringBuilder4.append(this.inlineTags(elementUtilities, doc, tag.inlineTags()));
                stringBuilder4.append("<br>");
                continue;
            }
            if (SEE_TAG.equals(tag.kind())) {
                type = (SeeTag)tag;
                tagArray = type.referencedClass();
                String string2 = type.referencedClassName();
                String string3 = type.referencedMemberName();
                String string4 = type.label();
                if (string3 != null) {
                    if (tagArray != null) {
                        this.createLink(stringBuilder, elementUtilities.elementFor((Doc)type.referencedMember()), "<code>" + (string4 != null && string4.length() > 0 ? string4 : tagArray.simpleTypeName() + "." + string3) + "</code>");
                    } else {
                        stringBuilder.append(string2);
                        stringBuilder.append('.');
                        stringBuilder.append(string3);
                    }
                    stringBuilder.append(", ");
                    continue;
                }
                if (string2 != null) {
                    if (tagArray != null) {
                        this.createLink(stringBuilder, elementUtilities.elementFor((Doc)tagArray), "<code>" + (string4 != null && string4.length() > 0 ? string4 : tagArray.simpleTypeName()) + "</code>");
                    } else {
                        stringBuilder.append(string2);
                    }
                    stringBuilder.append(", ");
                    continue;
                }
                stringBuilder.append(type.text()).append(", ");
                continue;
            }
            if (!SINCE_TAG.equals(tag.kind())) continue;
            string = tag.text();
        }
        StringBuilder stringBuilder5 = new StringBuilder();
        if (stringBuilder2.length() > 0) {
            stringBuilder5.append("<b>").append(NbBundle.getMessage(JavaCompletionDoc.class, (String)"JCD-params")).append("</b><blockquote>").append((CharSequence)stringBuilder2).append("</blockquote>");
        }
        if (stringBuilder4.length() > 0) {
            stringBuilder5.append("<b>").append(NbBundle.getMessage(JavaCompletionDoc.class, (String)"JCD-returns")).append("</b><blockquote>").append((CharSequence)stringBuilder4).append("</blockquote>");
        }
        if (stringBuilder3.length() > 0) {
            stringBuilder5.append("<b>").append(NbBundle.getMessage(JavaCompletionDoc.class, (String)"JCD-throws")).append("</b><blockquote>").append((CharSequence)stringBuilder3).append("</blockquote>");
        }
        if (string != null) {
            stringBuilder5.append("<b>").append(NbBundle.getMessage(JavaCompletionDoc.class, (String)"JCD-since")).append("</b><blockquote>").append(string).append("</blockquote>");
        }
        if ((n = stringBuilder.length()) > 0) {
            stringBuilder5.append("<b>").append(NbBundle.getMessage(JavaCompletionDoc.class, (String)"JCD-see")).append("</b><blockquote>").append((CharSequence)stringBuilder.delete(n - 2, n)).append("</blockquote>");
        }
        return stringBuilder5;
    }

    private CharSequence getDeprecatedTag(ElementUtilities elementUtilities, Doc doc) {
        StringBuilder stringBuilder = new StringBuilder();
        for (Tag tag : doc.tags()) {
            if (!DEPRECATED_TAG.equals(tag.kind())) continue;
            stringBuilder.append("<b>").append(NbBundle.getMessage(JavaCompletionDoc.class, (String)"JCD-deprecated")).append("</b> <i>").append(tag.text()).append("</i></p><p>");
        }
        return stringBuilder;
    }

    private CharSequence inlineTags(ElementUtilities elementUtilities, Doc doc, Tag[] tagArray) {
        StringBuilder stringBuilder = new StringBuilder();
        for (Tag tag : tagArray) {
            SeeTag seeTag;
            if (SEE_TAG.equals(tag.kind())) {
                seeTag = (SeeTag)tag;
                ClassDoc classDoc = seeTag.referencedClass();
                String string = seeTag.referencedMemberName();
                String string2 = seeTag.label();
                boolean bl = LINKPLAIN_TAG.equals(seeTag.name());
                if (string != null) {
                    if (classDoc != null) {
                        this.createLink(stringBuilder, elementUtilities.elementFor((Doc)seeTag.referencedMember()), (bl ? "" : "<code>") + (string2 != null && string2.length() > 0 ? string2 : classDoc.simpleTypeName() + "." + string) + (bl ? "" : "</code>"));
                        continue;
                    }
                    stringBuilder.append(seeTag.referencedClassName());
                    stringBuilder.append('.');
                    stringBuilder.append(string);
                    continue;
                }
                if (classDoc != null) {
                    this.createLink(stringBuilder, elementUtilities.elementFor((Doc)classDoc), (bl ? "" : "<code>") + (string2 != null && string2.length() > 0 ? string2 : classDoc.simpleTypeName()) + (bl ? "" : "</code>"));
                    continue;
                }
                stringBuilder.append(seeTag.referencedClassName());
                continue;
            }
            if (INHERIT_DOC_TAG.equals(tag.kind())) {
                if (doc.isMethod()) {
                    seeTag = ((MethodDoc)doc).overriddenMethod();
                    if (seeTag == null) continue;
                    stringBuilder.append(this.inlineTags(elementUtilities, (Doc)seeTag, seeTag.inlineTags()));
                    continue;
                }
                if (!doc.isClass() && !doc.isInterface() || (seeTag = ((ClassDoc)doc).superclass()) == null) continue;
                stringBuilder.append(this.inlineTags(elementUtilities, (Doc)seeTag, seeTag.inlineTags()));
                continue;
            }
            if (CODE_TAG.equals(tag.kind())) {
                stringBuilder.append("<code>");
                stringBuilder.append(tag.text());
                stringBuilder.append("</code>");
                continue;
            }
            stringBuilder.append(tag.text());
        }
        return stringBuilder;
    }

    private CharSequence getFragment(Element element) {
        StringBuilder stringBuilder = new StringBuilder();
        if (!element.getKind().isClass() && !element.getKind().isInterface()) {
            if (element.getKind() == ElementKind.CONSTRUCTOR) {
                stringBuilder.append(element.getEnclosingElement().getSimpleName());
            } else {
                stringBuilder.append(element.getSimpleName());
            }
            if (element.getKind() == ElementKind.METHOD || element.getKind() == ElementKind.CONSTRUCTOR) {
                ExecutableElement executableElement = (ExecutableElement)element;
                stringBuilder.append('(');
                Iterator<? extends VariableElement> iterator = executableElement.getParameters().iterator();
                while (iterator.hasNext()) {
                    VariableElement variableElement = iterator.next();
                    this.appendType(stringBuilder, variableElement.asType(), executableElement.isVarArgs() && !iterator.hasNext());
                    if (!iterator.hasNext()) continue;
                    stringBuilder.append(", ");
                }
                stringBuilder.append(')');
            }
        }
        return stringBuilder;
    }

    private void appendType(StringBuilder stringBuilder, TypeMirror typeMirror, boolean bl) {
        switch (typeMirror.getKind()) {
            case ARRAY: {
                this.appendType(stringBuilder, ((ArrayType)typeMirror).getComponentType(), false);
                stringBuilder.append(bl ? "..." : "[]");
                break;
            }
            case DECLARED: {
                stringBuilder.append(((TypeElement)((DeclaredType)typeMirror).asElement()).getQualifiedName());
                break;
            }
            default: {
                stringBuilder.append(typeMirror);
            }
        }
    }

    private void appendSpace(StringBuilder stringBuilder, int n) {
        while (n-- >= 0) {
            stringBuilder.append(' ');
        }
    }

    private int appendType(ElementUtilities elementUtilities, StringBuilder stringBuilder, Type type, boolean bl, boolean bl2) {
        Object object;
        int n = 0;
        WildcardType wildcardType = type.asWildcardType();
        if (wildcardType != null) {
            stringBuilder.append('?');
            ++n;
            object = wildcardType.extendsBounds();
            if (object != null && ((Type[])object).length > 0) {
                stringBuilder.append(" extends ");
                n += 9;
                n += this.appendType(elementUtilities, stringBuilder, (Type)object[0], false, false);
            }
            if ((object = wildcardType.superBounds()) != null && ((Type[])object).length > 0) {
                stringBuilder.append(" super ");
                n += 7;
                n += this.appendType(elementUtilities, stringBuilder, (Type)object[0], false, false);
            }
        } else {
            object = type.asTypeVariable();
            if (object != null) {
                n += this.createLink(stringBuilder, null, object.simpleTypeName());
                Type[] typeArray = object.bounds();
                if (bl2 && typeArray != null && typeArray.length > 0) {
                    stringBuilder.append(" extends ");
                    n += 9;
                    for (int i = 0; i < typeArray.length; ++i) {
                        n += this.appendType(elementUtilities, stringBuilder, typeArray[i], false, false);
                        if (i >= typeArray.length - 1) continue;
                        stringBuilder.append(" & ");
                        n += 3;
                    }
                }
            } else {
                Type[] typeArray;
                String string = type.simpleTypeName();
                ClassDoc classDoc = type.asClassDoc();
                if (classDoc != null && classDoc.isAnnotationType()) {
                    string = "@" + string;
                }
                n += this.createLink(stringBuilder, elementUtilities.elementFor((Doc)type.asClassDoc()), string);
                ParameterizedType parameterizedType = type.asParameterizedType();
                if (parameterizedType != null && (typeArray = parameterizedType.typeArguments()).length > 0) {
                    stringBuilder.append("&lt;");
                    for (int i = 0; i < typeArray.length; ++i) {
                        n += this.appendType(elementUtilities, stringBuilder, typeArray[i], false, false);
                        if (i >= typeArray.length - 1) continue;
                        stringBuilder.append(",");
                        ++n;
                    }
                    stringBuilder.append("&gt;");
                    n += 2;
                }
            }
        }
        object = type.dimension();
        if (((String)object).length() > 0) {
            if (bl) {
                object = ((String)object).substring(2) + "...";
            }
            stringBuilder.append((String)object);
            n += ((String)object).length();
        }
        return n;
    }

    private int createLink(StringBuilder stringBuilder, Element element, String string) {
        if (element != null && element.asType().getKind() != TypeKind.ERROR) {
            String string2 = "*" + this.linkCounter++;
            this.links.put(string2, (ElementHandle<? extends Element>)ElementHandle.create((Element)element));
            stringBuilder.append("<a href='").append(string2).append("'>");
        }
        stringBuilder.append(string);
        if (element != null) {
            stringBuilder.append("</a>");
        }
        return string.length();
    }
}

