/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.editor.java;

import java.awt.event.ActionEvent;
import java.util.ArrayList;
import java.util.List;
import javax.swing.AbstractButton;
import javax.swing.Action;
import javax.swing.JMenu;
import javax.swing.JMenuItem;
import javax.swing.KeyStroke;
import javax.swing.event.DocumentListener;
import javax.swing.text.BadLocationException;
import javax.swing.text.Caret;
import javax.swing.text.Document;
import javax.swing.text.JTextComponent;
import javax.swing.text.Keymap;
import javax.swing.text.TextAction;
import org.netbeans.api.editor.fold.FoldHierarchy;
import org.netbeans.api.editor.fold.FoldType;
import org.netbeans.api.editor.fold.FoldUtilities;
import org.netbeans.api.java.queries.SourceLevelQuery;
import org.netbeans.editor.BaseAction;
import org.netbeans.editor.BaseDocument;
import org.netbeans.editor.BaseKit;
import org.netbeans.editor.Formatter;
import org.netbeans.editor.LocaleSupport;
import org.netbeans.editor.Syntax;
import org.netbeans.editor.SyntaxUpdateTokens;
import org.netbeans.editor.TokenContextPath;
import org.netbeans.editor.TokenID;
import org.netbeans.editor.Utilities;
import org.netbeans.editor.ext.Completion;
import org.netbeans.editor.ext.CompletionJavaDoc;
import org.netbeans.editor.ext.ExtEditorUI;
import org.netbeans.editor.ext.ExtKit;
import org.netbeans.editor.ext.java.JavaDrawLayerFactory;
import org.netbeans.editor.ext.java.JavaFoldManager;
import org.netbeans.editor.ext.java.JavaFormatter;
import org.netbeans.editor.ext.java.JavaSyntax;
import org.netbeans.editor.ext.java.JavaTokenContext;
import org.netbeans.lib.editor.codetemplates.api.CodeTemplateManager;
import org.netbeans.modules.editor.NbEditorKit;
import org.netbeans.modules.editor.NbEditorUtilities;
import org.netbeans.modules.editor.java.BracketCompletion;
import org.netbeans.modules.editor.java.GoToSupport;
import org.netbeans.modules.editor.java.JavaDocument;
import org.netbeans.modules.editor.java.SelectCodeElementAction;
import org.netbeans.modules.java.editor.JavaEditorModule;
import org.netbeans.modules.java.editor.codegen.GenerateCodeAction;
import org.netbeans.modules.java.editor.imports.FastImportAction;
import org.netbeans.modules.java.editor.imports.JavaFixAllImports;
import org.netbeans.modules.java.editor.overridden.GoToSuperTypeAction;
import org.netbeans.modules.java.editor.rename.InstantRenameAction;
import org.openide.awt.Mnemonics;
import org.openide.filesystems.FileObject;
import org.openide.loaders.DataObject;
import org.openide.util.NbBundle;

public class JavaKit
extends NbEditorKit {
    public static final String JAVA_MIME_TYPE = "text/x-java";
    private static final String[] getSetIsPrefixes = new String[]{"get", "set", "is"};
    public static final String makeGetterAction = "make-getter";
    public static final String makeSetterAction = "make-setter";
    public static final String makeIsAction = "make-is";
    public static final String addWatchAction = "add-watch";
    public static final String toggleBreakpointAction = "toggle-breakpoint";
    public static final String abbrevDebugLineAction = "abbrev-debug-line";
    public static final String fixImportsAction = "fix-imports";
    public static final String fastImportAction = "fast-import";
    public static final String tryCatchAction = "try-catch";
    public static final String javaDocShowAction = "javadoc-show-action";
    public static final String expandAllJavadocFolds = "expand-all-javadoc-folds";
    public static final String collapseAllJavadocFolds = "collapse-all-javadoc-folds";
    public static final String expandAllCodeBlockFolds = "expand-all-code-block-folds";
    public static final String collapseAllCodeBlockFolds = "collapse-all-code-block-folds";
    public static final String selectNextElementAction = "select-element-next";
    public static final String selectPreviousElementAction = "select-element-previous";
    static final long serialVersionUID = -5445829962533684922L;

    public JavaKit() {
        JavaEditorModule.init();
    }

    public String getContentType() {
        return JAVA_MIME_TYPE;
    }

    public Syntax createSyntax(Document document) {
        return new JavaSyntax(this.getSourceLevel((BaseDocument)document));
    }

    public Completion createCompletion(ExtEditorUI extEditorUI) {
        return null;
    }

    public CompletionJavaDoc createCompletionJavaDoc(ExtEditorUI extEditorUI) {
        return null;
    }

    public Document createDefaultDocument() {
        JavaDocument javaDocument = new JavaDocument(((Object)((Object)this)).getClass());
        Object object = javaDocument.getProperty("mimeType");
        if (object == null) {
            javaDocument.putProperty("mimeType", this.getContentType());
        }
        return javaDocument;
    }

    public String getSourceLevel(BaseDocument baseDocument) {
        DataObject dataObject = NbEditorUtilities.getDataObject((Document)baseDocument);
        return dataObject != null ? SourceLevelQuery.getSourceLevel((FileObject)dataObject.getPrimaryFile()) : null;
    }

    public Formatter createFormatter() {
        return new JavaFormatter(((Object)((Object)this)).getClass());
    }

    protected void initDocument(BaseDocument baseDocument) {
        baseDocument.addDocumentListener((DocumentListener)new JavaDrawLayerFactory.LParenWatcher());
        baseDocument.putProperty(SyntaxUpdateTokens.class, (Object)new SyntaxUpdateTokens(){
            private List tokenList = new ArrayList();

            public void syntaxUpdateStart() {
                this.tokenList.clear();
            }

            public List syntaxUpdateEnd() {
                return this.tokenList;
            }

            public void syntaxUpdateToken(TokenID tokenID, TokenContextPath tokenContextPath, int n, int n2) {
                if (JavaTokenContext.LINE_COMMENT == tokenID) {
                    this.tokenList.add(new SyntaxUpdateTokens.TokenInfo((SyntaxUpdateTokens)this, tokenID, tokenContextPath, n, n2));
                }
            }
        });
        CodeTemplateManager.get((Document)baseDocument);
    }

    protected Action[] createActions() {
        Action[] actionArray = new Action[]{new JavaDefaultKeyTypedAction(), new ExtKit.PrefixMakerAction(makeGetterAction, "get", getSetIsPrefixes), new ExtKit.PrefixMakerAction(makeSetterAction, "set", getSetIsPrefixes), new ExtKit.PrefixMakerAction(makeIsAction, "is", getSetIsPrefixes), new AbbrevDebugLineAction(), new ExtKit.CommentAction("//"), new ExtKit.UncommentAction("//"), new JavaGenerateGoToPopupAction(), new JavaInsertBreakAction(), new JavaDeleteCharAction("delete-previous", false), new ExpandAllJavadocFolds(), new CollapseAllJavadocFolds(), new ExpandAllCodeBlockFolds(), new CollapseAllCodeBlockFolds(), new JavaGenerateFoldPopupAction(), new JavaGoToDeclarationAction(), new JavaGoToSourceAction(), new InstantRenameAction(), new JavaFixImports(), new GenerateCodeAction(), new SelectCodeElementAction(selectNextElementAction, true), new SelectCodeElementAction(selectPreviousElementAction, false), new FastImportAction(), new GoToSuperTypeAction()};
        return TextAction.augmentList(super.createActions(), actionArray);
    }

    public static class AbbrevDebugLineAction
    extends BaseAction {
        public AbbrevDebugLineAction() {
            super(JavaKit.abbrevDebugLineAction);
        }

        public void actionPerformed(ActionEvent actionEvent, JTextComponent jTextComponent) {
            if (jTextComponent != null) {
                if (!jTextComponent.isEditable() || !jTextComponent.isEnabled()) {
                    jTextComponent.getToolkit().beep();
                    return;
                }
                BaseDocument baseDocument = (BaseDocument)jTextComponent.getDocument();
                StringBuffer stringBuffer = new StringBuffer("System.out.println(\"");
                String string = (String)baseDocument.getProperty((Object)"title");
                if (string != null) {
                    stringBuffer.append(string);
                    stringBuffer.append(':');
                }
                try {
                    stringBuffer.append(Utilities.getLineOffset((BaseDocument)baseDocument, (int)jTextComponent.getCaret().getDot()) + 1);
                }
                catch (BadLocationException badLocationException) {
                    // empty catch block
                }
                stringBuffer.append(' ');
                BaseKit baseKit = Utilities.getKit((JTextComponent)jTextComponent);
                if (baseKit == null) {
                    return;
                }
                Action action = baseKit.getActionByName("insert-content");
                if (action != null) {
                    Utilities.performAction((Action)action, (ActionEvent)new ActionEvent(jTextComponent, 1001, stringBuffer.toString()), (JTextComponent)jTextComponent);
                }
            }
        }
    }

    public static class CollapseAllCodeBlockFolds
    extends BaseAction {
        public CollapseAllCodeBlockFolds() {
            super(JavaKit.collapseAllCodeBlockFolds);
            this.putValue("ShortDescription", NbBundle.getBundle(JavaKit.class).getString(JavaKit.collapseAllCodeBlockFolds));
            this.putValue("PopupMenuText", NbBundle.getBundle(JavaKit.class).getString("popup-collapse-all-code-block-folds"));
        }

        public void actionPerformed(ActionEvent actionEvent, JTextComponent jTextComponent) {
            FoldHierarchy foldHierarchy = FoldHierarchy.get((JTextComponent)jTextComponent);
            ArrayList<FoldType> arrayList = new ArrayList<FoldType>();
            arrayList.add(JavaFoldManager.CODE_BLOCK_FOLD_TYPE);
            arrayList.add(JavaFoldManager.IMPORTS_FOLD_TYPE);
            FoldUtilities.collapse((FoldHierarchy)foldHierarchy, arrayList);
        }
    }

    public static class CollapseAllJavadocFolds
    extends BaseAction {
        public CollapseAllJavadocFolds() {
            super(JavaKit.collapseAllJavadocFolds);
            this.putValue("ShortDescription", NbBundle.getBundle(JavaKit.class).getString(JavaKit.collapseAllJavadocFolds));
            this.putValue("PopupMenuText", NbBundle.getBundle(JavaKit.class).getString("popup-collapse-all-javadoc-folds"));
        }

        public void actionPerformed(ActionEvent actionEvent, JTextComponent jTextComponent) {
            FoldHierarchy foldHierarchy = FoldHierarchy.get((JTextComponent)jTextComponent);
            FoldUtilities.collapse((FoldHierarchy)foldHierarchy, (FoldType)JavaFoldManager.JAVADOC_FOLD_TYPE);
        }
    }

    public static class ExpandAllCodeBlockFolds
    extends BaseAction {
        public ExpandAllCodeBlockFolds() {
            super(JavaKit.expandAllCodeBlockFolds);
            this.putValue("ShortDescription", NbBundle.getBundle(JavaKit.class).getString(JavaKit.expandAllCodeBlockFolds));
            this.putValue("PopupMenuText", NbBundle.getBundle(JavaKit.class).getString("popup-expand-all-code-block-folds"));
        }

        public void actionPerformed(ActionEvent actionEvent, JTextComponent jTextComponent) {
            FoldHierarchy foldHierarchy = FoldHierarchy.get((JTextComponent)jTextComponent);
            ArrayList<FoldType> arrayList = new ArrayList<FoldType>();
            arrayList.add(JavaFoldManager.CODE_BLOCK_FOLD_TYPE);
            arrayList.add(JavaFoldManager.IMPORTS_FOLD_TYPE);
            FoldUtilities.expand((FoldHierarchy)foldHierarchy, arrayList);
        }
    }

    public static class ExpandAllJavadocFolds
    extends BaseAction {
        public ExpandAllJavadocFolds() {
            super(JavaKit.expandAllJavadocFolds);
            this.putValue("ShortDescription", NbBundle.getBundle(JavaKit.class).getString(JavaKit.expandAllJavadocFolds));
            this.putValue("PopupMenuText", NbBundle.getBundle(JavaKit.class).getString("popup-expand-all-javadoc-folds"));
        }

        public void actionPerformed(ActionEvent actionEvent, JTextComponent jTextComponent) {
            FoldHierarchy foldHierarchy = FoldHierarchy.get((JTextComponent)jTextComponent);
            FoldUtilities.expand((FoldHierarchy)foldHierarchy, (FoldType)JavaFoldManager.JAVADOC_FOLD_TYPE);
        }
    }

    public static class JavaDefaultKeyTypedAction
    extends ExtKit.ExtDefaultKeyTypedAction {
        protected void insertString(BaseDocument baseDocument, int n, Caret caret, String string, boolean bl) throws BadLocationException {
            char c = string.charAt(0);
            if (c == '\"' || c == '\'') {
                boolean bl2 = BracketCompletion.completeQuote(baseDocument, n, caret, c);
                if (bl2) {
                    caret.setDot(n + 1);
                } else {
                    super.insertString(baseDocument, n, caret, string, bl);
                }
            } else {
                super.insertString(baseDocument, n, caret, string, bl);
                BracketCompletion.charInserted(baseDocument, n, caret, c);
            }
        }

        protected void replaceSelection(JTextComponent jTextComponent, int n, Caret caret, String string, boolean bl) throws BadLocationException {
            char c = string.charAt(0);
            Document document = jTextComponent.getDocument();
            if (c == '\"' || c == '\'') {
                if (document != null) {
                    try {
                        boolean bl2 = false;
                        int n2 = Math.min(caret.getDot(), caret.getMark());
                        int n3 = Math.max(caret.getDot(), caret.getMark());
                        if (n2 != n3) {
                            document.remove(n2, n3 - n2);
                        }
                        int n4 = caret.getDot();
                        if (document instanceof BaseDocument) {
                            bl2 = BracketCompletion.completeQuote((BaseDocument)document, n4, caret, c);
                        }
                        if (bl2) {
                            caret.setDot(n4 + 1);
                        } else if (string != null && string.length() > 0) {
                            document.insertString(n2, string, null);
                        }
                    }
                    catch (BadLocationException badLocationException) {
                        badLocationException.printStackTrace();
                    }
                }
            } else {
                super.replaceSelection(jTextComponent, n, caret, string, bl);
                if (document instanceof BaseDocument) {
                    BracketCompletion.charInserted((BaseDocument)document, caret.getDot() - 1, caret, c);
                }
            }
        }
    }

    public static class JavaDeleteCharAction
    extends ExtKit.ExtDeleteCharAction {
        public JavaDeleteCharAction(String string, boolean bl) {
            super(string, bl);
        }

        protected void charBackspaced(BaseDocument baseDocument, int n, Caret caret, char c) throws BadLocationException {
            BracketCompletion.charBackspaced(baseDocument, n, caret, c);
        }
    }

    private static class JavaFixImports
    extends BaseAction {
        public JavaFixImports() {
            super(JavaKit.fixImportsAction, 142);
            this.putValue("trimmed-text", NbBundle.getBundle(JavaKit.class).getString("fix-imports-trimmed"));
            this.putValue("ShortDescription", NbBundle.getBundle(JavaKit.class).getString("desc-fix-imports"));
            this.putValue("PopupMenuText", NbBundle.getBundle(JavaKit.class).getString("popup-fix-imports"));
        }

        public void actionPerformed(ActionEvent actionEvent, JTextComponent jTextComponent) {
            if (jTextComponent != null) {
                Document document = jTextComponent.getDocument();
                FileObject fileObject = ((DataObject)document.getProperty("stream")).getPrimaryFile();
                JavaFixAllImports.getDefault().fixAllImports(fileObject);
            }
        }
    }

    public static class JavaGenerateFoldPopupAction
    extends NbEditorKit.GenerateFoldPopupAction {
        protected void addAdditionalItems(JTextComponent jTextComponent, JMenu jMenu) {
            this.addAction(jTextComponent, jMenu, JavaKit.collapseAllJavadocFolds);
            this.addAction(jTextComponent, jMenu, JavaKit.expandAllJavadocFolds);
            this.setAddSeparatorBeforeNextAction(true);
            this.addAction(jTextComponent, jMenu, JavaKit.collapseAllCodeBlockFolds);
            this.addAction(jTextComponent, jMenu, JavaKit.expandAllCodeBlockFolds);
        }
    }

    public static class JavaGenerateGoToPopupAction
    extends NbEditorKit.NbGenerateGoToPopupAction {
        public void actionPerformed(ActionEvent actionEvent, JTextComponent jTextComponent) {
        }

        private void addAcceleretors(Action action, JMenuItem jMenuItem, JTextComponent jTextComponent) {
            Keymap keymap = jTextComponent.getKeymap();
            if (keymap != null) {
                KeyStroke keyStroke;
                KeyStroke[] keyStrokeArray = keymap.getKeyStrokesForAction(action);
                if (keyStrokeArray != null && keyStrokeArray.length > 0) {
                    jMenuItem.setAccelerator(keyStrokeArray[0]);
                } else if (action != null && (keyStroke = (KeyStroke)action.getValue("AcceleratorKey")) != null) {
                    jMenuItem.setAccelerator(keyStroke);
                }
            }
        }

        private void addAction(JTextComponent jTextComponent, JMenu jMenu, Action action) {
            if (action != null) {
                String string = (String)action.getValue("Name");
                JMenuItem jMenuItem = null;
                if (action instanceof BaseAction) {
                    jMenuItem = ((BaseAction)action).getPopupMenuItem(jTextComponent);
                }
                if (jMenuItem == null) {
                    String string2 = (String)action.getValue("trimmed-text");
                    if (string2 == null) {
                        string2 = this.getItemText(jTextComponent, string, action);
                    }
                    if (string2 != null) {
                        jMenuItem = new JMenuItem(string2);
                        Mnemonics.setLocalizedText((AbstractButton)jMenuItem, (String)string2);
                        jMenuItem.addActionListener(action);
                        this.addAcceleretors(action, jMenuItem, jTextComponent);
                        jMenuItem.setEnabled(action.isEnabled());
                        Object object = action.getValue("helpID");
                        if (object != null && object instanceof String) {
                            jMenuItem.putClientProperty("HelpID", object);
                        }
                    } else if ("goto-source".equals(string)) {
                        jMenuItem = new JMenuItem(NbBundle.getBundle(JavaKit.class).getString("goto_source_open_source_not_formatted"));
                        this.addAcceleretors(action, jMenuItem, jTextComponent);
                        jMenuItem.setEnabled(false);
                    }
                }
                if (jMenuItem != null) {
                    jMenu.add(jMenuItem);
                }
            }
        }

        protected void addAction(JTextComponent jTextComponent, JMenu jMenu, String string) {
            BaseKit baseKit = Utilities.getKit((JTextComponent)jTextComponent);
            if (baseKit == null) {
                return;
            }
            Action action = baseKit.getActionByName(string);
            if (action != null) {
                this.addAction(jTextComponent, jMenu, action);
            } else {
                jMenu.addSeparator();
            }
        }

        protected String getItemText(JTextComponent jTextComponent, String string, Action action) {
            String string2 = action instanceof BaseAction ? ((BaseAction)action).getPopupMenuText(jTextComponent) : string;
            return string2;
        }

        public JMenuItem getPopupMenuItem(JTextComponent jTextComponent) {
            String string = NbBundle.getBundle(JavaKit.class).getString("generate-goto-popup");
            JMenu jMenu = new JMenu(string);
            this.addAction(jTextComponent, jMenu, "goto-source");
            this.addAction(jTextComponent, jMenu, "goto-declaration");
            this.addAction(jTextComponent, jMenu, "goto-super-implementation");
            this.addAction(jTextComponent, jMenu, "goto");
            return jMenu;
        }
    }

    private static class JavaGoToDeclarationAction
    extends ExtKit.GotoDeclarationAction {
        private JavaGoToDeclarationAction() {
        }

        public boolean gotoDeclaration(JTextComponent jTextComponent) {
            GoToSupport.goTo((Document)((BaseDocument)jTextComponent.getDocument()), jTextComponent.getCaretPosition(), false);
            return true;
        }
    }

    private static class JavaGoToSourceAction
    extends BaseAction {
        static final long serialVersionUID = -6440495023918097760L;

        public JavaGoToSourceAction() {
            super("goto-source", 142);
            this.putValue("trimmed-text", LocaleSupport.getString((String)"goto-source-trimmed"));
        }

        public void actionPerformed(ActionEvent actionEvent, JTextComponent jTextComponent) {
            if (jTextComponent != null) {
                GoToSupport.goTo((Document)((BaseDocument)jTextComponent.getDocument()), jTextComponent.getCaretPosition(), true);
            }
        }

        public String getPopupMenuText(JTextComponent jTextComponent) {
            return NbBundle.getBundle(JavaKit.class).getString("goto_source_open_source_not_formatted");
        }

        protected Class getShortDescriptionBundleClass() {
            return BaseKit.class;
        }
    }

    public static class JavaInsertBreakAction
    extends BaseKit.InsertBreakAction {
        static final long serialVersionUID = -1506173310438326380L;

        protected Object beforeBreak(JTextComponent jTextComponent, BaseDocument baseDocument, Caret caret) {
            int n = caret.getDot();
            if (BracketCompletion.posWithinString(baseDocument, n)) {
                try {
                    baseDocument.insertString(n, "\" + \"", null);
                    caret.setDot(n += 3);
                    return new Integer(n);
                }
                catch (BadLocationException badLocationException) {}
            } else {
                try {
                    if (BracketCompletion.isAddRightBrace(baseDocument, n)) {
                        int n2 = BracketCompletion.getRowOrBlockEnd(baseDocument, n);
                        baseDocument.insertString(n2, "}", null);
                        baseDocument.getFormatter().indentNewLine((Document)baseDocument, n2);
                        caret.setDot(n);
                        return Boolean.TRUE;
                    }
                }
                catch (BadLocationException badLocationException) {
                    // empty catch block
                }
            }
            return null;
        }

        protected void afterBreak(JTextComponent jTextComponent, BaseDocument baseDocument, Caret caret, Object object) {
            if (object != null && object instanceof Integer) {
                int n = caret.getDot();
                caret.setDot(n + 1);
            }
        }
    }
}

