/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.editor.java;

import com.sun.source.tree.Scope;
import java.awt.Color;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.event.KeyEvent;
import java.util.EnumSet;
import javax.lang.model.element.Element;
import javax.lang.model.element.ElementKind;
import javax.lang.model.element.TypeElement;
import javax.lang.model.type.DeclaredType;
import javax.swing.text.JTextComponent;
import org.netbeans.api.java.source.CancellableTask;
import org.netbeans.api.java.source.CompilationController;
import org.netbeans.api.java.source.CompilationInfo;
import org.netbeans.api.java.source.ElementHandle;
import org.netbeans.api.java.source.JavaSource;
import org.netbeans.modules.editor.java.JavaCompletionItem;
import org.netbeans.spi.editor.completion.CompletionTask;
import org.netbeans.spi.editor.completion.LazyCompletionItem;
import org.netbeans.spi.editor.completion.support.CompletionUtilities;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class LazyTypeCompletionItem
extends JavaCompletionItem
implements LazyCompletionItem {
    private ElementHandle<TypeElement> handle;
    private EnumSet<ElementKind> kinds;
    private JavaSource javaSource;
    private String name;
    private String simpleName;
    private String pkgName;
    private JavaCompletionItem delegate = null;
    private LazyTypeCompletionItem nextItem = null;
    private CharSequence sortText;
    private int prefWidth = -1;

    public static final LazyTypeCompletionItem create(ElementHandle<TypeElement> elementHandle, EnumSet<ElementKind> enumSet, int n, JavaSource javaSource) {
        return new LazyTypeCompletionItem(elementHandle, enumSet, n, javaSource);
    }

    private LazyTypeCompletionItem(ElementHandle<TypeElement> elementHandle, EnumSet<ElementKind> enumSet, int n, JavaSource javaSource) {
        super(n);
        this.handle = elementHandle;
        this.kinds = enumSet;
        this.javaSource = javaSource;
        this.name = elementHandle.getQualifiedName();
        int n2 = this.name.lastIndexOf(46);
        this.simpleName = n2 > -1 ? this.name.substring(n2 + 1) : this.name;
        this.pkgName = n2 > -1 ? this.name.substring(0, n2) : "";
        this.sortText = new JavaCompletionItem.ClassSortText(this.simpleName, this.pkgName);
    }

    public boolean accept() {
        if (this.handle != null) {
            if (this.simpleName.length() == 0 || Character.isDigit(this.simpleName.charAt(0))) {
                this.handle = null;
                return false;
            }
            try {
                this.javaSource.runUserActionTask((CancellableTask)new CancellableTask<CompilationController>(){

                    public void cancel() {
                    }

                    public void run(CompilationController compilationController) throws Exception {
                        compilationController.toPhase(JavaSource.Phase.ELEMENTS_RESOLVED);
                        Scope scope = compilationController.getTrees().getScope(compilationController.getTreeUtilities().pathFor(LazyTypeCompletionItem.this.substitutionOffset));
                        LazyTypeCompletionItem lazyTypeCompletionItem = LazyTypeCompletionItem.this;
                        int n = 0;
                        while (n < 50 && lazyTypeCompletionItem != null) {
                            if (lazyTypeCompletionItem.init(compilationController, scope)) {
                                ++n;
                            }
                            lazyTypeCompletionItem = lazyTypeCompletionItem.nextItem;
                        }
                    }
                }, true);
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
        return this.delegate != null;
    }

    @Override
    public void defaultAction(JTextComponent jTextComponent) {
        if (this.delegate != null) {
            this.delegate.defaultAction(jTextComponent);
        }
    }

    @Override
    public void processKeyEvent(KeyEvent keyEvent) {
        if (this.delegate != null) {
            this.delegate.processKeyEvent(keyEvent);
        }
    }

    @Override
    public int getPreferredWidth(Graphics graphics, Font font) {
        if (this.prefWidth < 0) {
            this.prefWidth = CompletionUtilities.getPreferredWidth((String)(this.simpleName + " (" + this.pkgName + ")"), null, (Graphics)graphics, (Font)font);
        }
        return this.prefWidth;
    }

    @Override
    public void render(Graphics graphics, Font font, Color color, Color color2, int n, int n2, boolean bl) {
        if (this.delegate != null) {
            this.delegate.render(graphics, font, color, color2, n, n2, bl);
        }
    }

    @Override
    public CompletionTask createDocumentationTask() {
        if (this.delegate != null) {
            return this.delegate.createDocumentationTask();
        }
        return null;
    }

    @Override
    public CompletionTask createToolTipTask() {
        if (this.delegate != null) {
            return this.delegate.createToolTipTask();
        }
        return null;
    }

    public int getSortPriority() {
        return 700;
    }

    public CharSequence getSortText() {
        return this.sortText;
    }

    public CharSequence getInsertPrefix() {
        return this.simpleName;
    }

    void setNextItem(LazyTypeCompletionItem lazyTypeCompletionItem) {
        this.nextItem = lazyTypeCompletionItem;
    }

    boolean init(CompilationController compilationController, Scope scope) {
        TypeElement typeElement;
        if (this.simpleName.length() >= 0 && !Character.isDigit(this.simpleName.charAt(0)) && (typeElement = (TypeElement)this.handle.resolve((CompilationInfo)compilationController)) != null && compilationController.getTrees().isAccessible(scope, typeElement) && this.isOfKind(typeElement, this.kinds)) {
            this.delegate = JavaCompletionItem.createTypeItem(typeElement, (DeclaredType)typeElement.asType(), this.substitutionOffset, true, compilationController.getElements().isDeprecated(typeElement), false);
        }
        this.handle = null;
        return this.delegate != null;
    }

    private boolean isOfKind(Element element, EnumSet<ElementKind> enumSet) {
        if (enumSet.contains((Object)element.getKind())) {
            return true;
        }
        for (Element element2 : element.getEnclosedElements()) {
            if (!this.isOfKind(element2, enumSet)) continue;
            return true;
        }
        return false;
    }
}

