/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.java.editor.codegen;

import com.sun.source.tree.BlockTree;
import com.sun.source.tree.ClassTree;
import com.sun.source.tree.ExpressionTree;
import com.sun.source.tree.IdentifierTree;
import com.sun.source.tree.MethodTree;
import com.sun.source.tree.Scope;
import com.sun.source.tree.StatementTree;
import com.sun.source.tree.Tree;
import com.sun.source.tree.VariableTree;
import com.sun.source.util.SourcePositions;
import com.sun.source.util.TreePath;
import com.sun.source.util.Trees;
import java.awt.Dialog;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.EnumSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import javax.lang.model.element.Element;
import javax.lang.model.element.ExecutableElement;
import javax.lang.model.element.Modifier;
import javax.lang.model.element.TypeElement;
import javax.lang.model.element.VariableElement;
import javax.lang.model.type.DeclaredType;
import javax.lang.model.type.ExecutableType;
import javax.lang.model.type.TypeKind;
import javax.lang.model.type.TypeMirror;
import javax.lang.model.util.ElementFilter;
import javax.lang.model.util.Elements;
import javax.swing.text.Document;
import javax.swing.text.JTextComponent;
import org.netbeans.api.java.source.CancellableTask;
import org.netbeans.api.java.source.CompilationController;
import org.netbeans.api.java.source.CompilationInfo;
import org.netbeans.api.java.source.ElementHandle;
import org.netbeans.api.java.source.JavaSource;
import org.netbeans.api.java.source.TreeMaker;
import org.netbeans.api.java.source.WorkingCopy;
import org.netbeans.modules.editor.java.Utilities;
import org.netbeans.modules.java.editor.codegen.CodeGenerator;
import org.netbeans.modules.java.editor.codegen.ConstructorGenerator;
import org.netbeans.modules.java.editor.codegen.ui.DelegatePanel;
import org.netbeans.modules.java.editor.codegen.ui.ElementNode;
import org.openide.DialogDescriptor;
import org.openide.DialogDisplayer;
import org.openide.util.Exceptions;
import org.openide.util.NbBundle;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DelegateMethodGenerator
implements CodeGenerator {
    private ElementNode.Description description;

    private DelegateMethodGenerator(ElementNode.Description description) {
        this.description = description;
    }

    @Override
    public String getDisplayName() {
        return NbBundle.getMessage(DelegateMethodGenerator.class, (String)"LBL_delegate_method");
    }

    @Override
    public void invoke(JTextComponent jTextComponent) {
        JavaSource javaSource;
        final DelegatePanel delegatePanel = new DelegatePanel(jTextComponent, this.description);
        DialogDescriptor dialogDescriptor = new DialogDescriptor((Object)delegatePanel, NbBundle.getMessage(ConstructorGenerator.class, (String)"LBL_generate_delegate"));
        Dialog dialog = DialogDisplayer.getDefault().createDialog(dialogDescriptor);
        dialog.setVisible(true);
        if (dialogDescriptor.getValue() == DialogDescriptor.OK_OPTION && (javaSource = JavaSource.forDocument((Document)jTextComponent.getDocument())) != null) {
            try {
                final int n = jTextComponent.getCaretPosition();
                javaSource.runModificationTask((CancellableTask)new CancellableTask<WorkingCopy>(){

                    public void cancel() {
                    }

                    public void run(WorkingCopy workingCopy) throws IOException {
                        Tree tree;
                        workingCopy.toPhase(JavaSource.Phase.ELEMENTS_RESOLVED);
                        TreePath treePath = workingCopy.getTreeUtilities().pathFor(n);
                        treePath = Utilities.getPathElementOfKind(Tree.Kind.CLASS, treePath);
                        int n2 = 0;
                        SourcePositions sourcePositions = workingCopy.getTrees().getSourcePositions();
                        Iterator<? extends Tree> iterator = ((ClassTree)treePath.getLeaf()).getMembers().iterator();
                        while (iterator.hasNext()) {
                            tree = iterator.next();
                            if (sourcePositions.getStartPosition(treePath.getCompilationUnit(), tree) >= (long)n) break;
                            ++n2;
                        }
                        tree = (iterator = delegatePanel.getDelegateField()) != null ? (VariableElement)iterator.resolve((CompilationInfo)workingCopy) : null;
                        ArrayList<ExecutableElement> arrayList = new ArrayList<ExecutableElement>();
                        for (ElementHandle<? extends Element> elementHandle : delegatePanel.getDelegateMethods()) {
                            arrayList.add((ExecutableElement)elementHandle.resolve((CompilationInfo)workingCopy));
                        }
                        DelegateMethodGenerator.generateDelegatingMethods(workingCopy, treePath, (VariableElement)((Object)tree), arrayList, n2);
                    }
                }).commit();
            }
            catch (IOException iOException) {
                Exceptions.printStackTrace((Throwable)iOException);
            }
        }
    }

    public static ElementNode.Description getAvailableMethods(JTextComponent jTextComponent, final ElementHandle<? extends Element> elementHandle) {
        JavaSource javaSource;
        if (elementHandle.getKind().isField() && (javaSource = JavaSource.forDocument((Document)jTextComponent.getDocument())) != null) {
            try {
                final int n = jTextComponent.getCaretPosition();
                final ElementNode.Description[] descriptionArray = new ElementNode.Description[1];
                javaSource.runUserActionTask((CancellableTask)new CancellableTask<CompilationController>(){

                    public void cancel() {
                    }

                    /*
                     * WARNING - void declaration
                     */
                    public void run(CompilationController compilationController) throws IOException {
                        VariableElement variableElement = (VariableElement)elementHandle.resolve((CompilationInfo)compilationController);
                        if (variableElement.asType().getKind() == TypeKind.DECLARED) {
                            DeclaredType declaredType = (DeclaredType)variableElement.asType();
                            Trees trees = compilationController.getTrees();
                            Scope scope = compilationController.getTreeUtilities().scopeFor(n);
                            LinkedHashMap linkedHashMap = new LinkedHashMap();
                            for (ExecutableElement object : ElementFilter.methodsIn(compilationController.getElements().getAllMembers((TypeElement)declaredType.asElement()))) {
                                void var9_10;
                                if (!trees.isAccessible(scope, object, declaredType)) continue;
                                List list = (List)linkedHashMap.get(object.getEnclosingElement());
                                if (list == null) {
                                    ArrayList arrayList = new ArrayList();
                                    linkedHashMap.put(object.getEnclosingElement(), arrayList);
                                }
                                var9_10.add(ElementNode.Description.create(object, null, true, false));
                            }
                            ArrayList arrayList = new ArrayList();
                            for (Map.Entry entry : linkedHashMap.entrySet()) {
                                arrayList.add(ElementNode.Description.create((Element)entry.getKey(), (List)entry.getValue(), false, false));
                            }
                            if (!arrayList.isEmpty()) {
                                Collections.reverse(arrayList);
                            }
                            descriptionArray[0] = ElementNode.Description.create(arrayList);
                        }
                    }
                }, true);
                return descriptionArray[0];
            }
            catch (IOException iOException) {
                Exceptions.printStackTrace((Throwable)iOException);
            }
        }
        return null;
    }

    private static void generateDelegatingMethods(WorkingCopy workingCopy, TreePath treePath, VariableElement variableElement, Iterable<? extends ExecutableElement> iterable, int n) {
        assert (treePath.getLeaf().getKind() == Tree.Kind.CLASS);
        TypeElement typeElement = (TypeElement)workingCopy.getTrees().getElement(treePath);
        if (typeElement != null) {
            TreeMaker treeMaker = workingCopy.getTreeMaker();
            ClassTree classTree = (ClassTree)treePath.getLeaf();
            for (ExecutableElement executableElement : iterable) {
                classTree = treeMaker.insertClassMember(classTree, n, (Tree)DelegateMethodGenerator.createDelegatingMethod(workingCopy, variableElement, executableElement, (DeclaredType)typeElement.asType()));
            }
            workingCopy.rewrite(treePath.getLeaf(), (Tree)classTree);
        }
    }

    private static MethodTree createDelegatingMethod(WorkingCopy workingCopy, VariableElement variableElement, ExecutableElement executableElement, DeclaredType declaredType) {
        Object object;
        TreeMaker treeMaker = workingCopy.getTreeMaker();
        ExecutableType executableType = (ExecutableType)workingCopy.getTypes().asMemberOf((DeclaredType)variableElement.asType(), executableElement);
        EnumSet<Modifier> enumSet = EnumSet.copyOf(executableElement.getModifiers());
        enumSet.remove((Object)Modifier.ABSTRACT);
        ArrayList<VariableTree> arrayList = new ArrayList<VariableTree>();
        ArrayList<IdentifierTree> arrayList2 = new ArrayList<IdentifierTree>();
        Iterator<? extends VariableElement> iterator = executableElement.getParameters().iterator();
        Iterator<? extends TypeMirror> iterator2 = executableType.getParameterTypes().iterator();
        while (iterator.hasNext() && iterator2.hasNext()) {
            object = iterator.next();
            arrayList.add(treeMaker.Variable(treeMaker.Modifiers(EnumSet.noneOf(Modifier.class)), (CharSequence)object.getSimpleName(), treeMaker.Type(iterator2.next()), null));
            arrayList2.add(treeMaker.Identifier((CharSequence)object.getSimpleName()));
        }
        object = treeMaker.MethodInvocation(Collections.emptyList(), (ExpressionTree)treeMaker.MemberSelect((ExpressionTree)treeMaker.Identifier((CharSequence)variableElement.getSimpleName()), (CharSequence)executableElement.getSimpleName()), arrayList2);
        StatementTree statementTree = executableElement.getReturnType().getKind() == TypeKind.VOID ? treeMaker.ExpressionStatement((ExpressionTree)object) : treeMaker.Return((ExpressionTree)object);
        BlockTree blockTree = treeMaker.Block(Collections.singletonList(statementTree), false);
        ArrayList<ExpressionTree> arrayList3 = new ArrayList<ExpressionTree>();
        for (TypeMirror typeMirror : executableType.getThrownTypes()) {
            arrayList3.add((ExpressionTree)workingCopy.getTreeMaker().Type(typeMirror));
        }
        return treeMaker.Method(treeMaker.Modifiers(enumSet), (CharSequence)executableElement.getSimpleName(), treeMaker.Type(executableType.getReturnType()), Collections.emptyList(), arrayList, arrayList3, blockTree, null);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class Factory
    implements CodeGenerator.Factory {
        Factory() {
        }

        @Override
        public Iterable<? extends CodeGenerator> create(CompilationController compilationController, TreePath treePath) throws IOException {
            Object object;
            TypeElement typeElement;
            if ((treePath = Utilities.getPathElementOfKind(Tree.Kind.CLASS, treePath)) == null) {
                return Collections.emptySet();
            }
            compilationController.toPhase(JavaSource.Phase.ELEMENTS_RESOLVED);
            Elements elements = compilationController.getElements();
            TypeElement typeElement2 = (TypeElement)compilationController.getTrees().getElement(treePath);
            if (!typeElement2.getKind().isClass()) {
                return Collections.emptySet();
            }
            Trees trees = compilationController.getTrees();
            LinkedHashMap<Element, ArrayList<ElementNode.Description>> linkedHashMap = new LinkedHashMap<Element, ArrayList<ElementNode.Description>>();
            for (Scope scope = trees.getScope(treePath); scope != null && (typeElement = scope.getEnclosingClass()) != null; scope = scope.getEnclosingScope()) {
                object = (DeclaredType)typeElement.asType();
                for (VariableElement object2 : ElementFilter.fieldsIn(elements.getAllMembers(typeElement))) {
                    if (object2.asType().getKind().isPrimitive() || !trees.isAccessible(scope, object2, (DeclaredType)object)) continue;
                    ArrayList<ElementNode.Description> arrayList = (ArrayList<ElementNode.Description>)linkedHashMap.get(object2.getEnclosingElement());
                    if (arrayList == null) {
                        arrayList = new ArrayList<ElementNode.Description>();
                        linkedHashMap.put(object2.getEnclosingElement(), arrayList);
                    }
                    arrayList.add(ElementNode.Description.create(object2, null, false, false));
                }
            }
            object = new ArrayList();
            for (Map.Entry entry : linkedHashMap.entrySet()) {
                object.add(ElementNode.Description.create((Element)entry.getKey(), (List)entry.getValue(), false, false));
            }
            if (object.isEmpty()) {
                return Collections.emptySet();
            }
            Collections.reverse(object);
            return Collections.singleton(new DelegateMethodGenerator(ElementNode.Description.create((List<ElementNode.Description>)object)));
        }
    }
}

