/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.java.editor.codegen;

import com.sun.source.util.TreePath;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.io.IOException;
import java.util.ArrayList;
import javax.swing.SwingUtilities;
import javax.swing.text.BadLocationException;
import javax.swing.text.Document;
import javax.swing.text.JTextComponent;
import org.netbeans.api.java.source.CancellableTask;
import org.netbeans.api.java.source.CompilationController;
import org.netbeans.api.java.source.JavaSource;
import org.netbeans.editor.BaseAction;
import org.netbeans.modules.java.editor.codegen.CodeGenerator;
import org.netbeans.modules.java.editor.codegen.ConstructorGenerator;
import org.netbeans.modules.java.editor.codegen.DelegateMethodGenerator;
import org.netbeans.modules.java.editor.codegen.EqualsHashCodeGenerator;
import org.netbeans.modules.java.editor.codegen.GetterSetterGenerator;
import org.netbeans.modules.java.editor.codegen.ImplementOverrideMethodGenerator;
import org.netbeans.modules.java.editor.codegen.ui.GenerateCodePanel;
import org.netbeans.modules.java.editor.overridden.PopupUtil;
import org.openide.util.Exceptions;
import org.openide.util.NbBundle;

public class GenerateCodeAction
extends BaseAction {
    public static final String generateCode = "generate-code";
    private CodeGenerator.Factory[] generators = new CodeGenerator.Factory[]{new ConstructorGenerator.Factory(), new GetterSetterGenerator.Factory(), new EqualsHashCodeGenerator.Factory(), new DelegateMethodGenerator.Factory(), new ImplementOverrideMethodGenerator.Factory()};

    public GenerateCodeAction() {
        super(generateCode);
        this.putValue("trimmed-text", NbBundle.getBundle(GenerateCodeAction.class).getString("generate-code-trimmed"));
        this.putValue("ShortDescription", NbBundle.getBundle(GenerateCodeAction.class).getString("desc-generate-code"));
        this.putValue("PopupMenuText", NbBundle.getBundle(GenerateCodeAction.class).getString("popup-generate-code"));
    }

    public void actionPerformed(ActionEvent actionEvent, JTextComponent jTextComponent) {
        try {
            JavaSource javaSource = JavaSource.forDocument((Document)jTextComponent.getDocument());
            if (javaSource != null) {
                final int n = jTextComponent.getCaretPosition();
                final ArrayList arrayList = new ArrayList();
                javaSource.runUserActionTask((CancellableTask)new CancellableTask<CompilationController>(){

                    public void cancel() {
                    }

                    public void run(CompilationController compilationController) throws Exception {
                        compilationController.toPhase(JavaSource.Phase.PARSED);
                        TreePath treePath = compilationController.getTreeUtilities().pathFor(n);
                        for (CodeGenerator.Factory factory : GenerateCodeAction.this.getCodeGeneratorFactories()) {
                            for (CodeGenerator codeGenerator : factory.create(compilationController, treePath)) {
                                arrayList.add(codeGenerator);
                            }
                        }
                    }
                }, true);
                if (arrayList.size() > 0) {
                    Rectangle rectangle = jTextComponent.modelToView(jTextComponent.getCaretPosition());
                    Point point = new Point(rectangle.x, rectangle.y + rectangle.height);
                    SwingUtilities.convertPointToScreen(point, jTextComponent);
                    GenerateCodePanel generateCodePanel = new GenerateCodePanel(jTextComponent, arrayList);
                    PopupUtil.showPopup(generateCodePanel, null, point.x, point.y, true, rectangle.height);
                } else {
                    jTextComponent.getToolkit().beep();
                }
            }
        }
        catch (IOException iOException) {
            Exceptions.printStackTrace((Throwable)iOException);
        }
        catch (BadLocationException badLocationException) {
            Exceptions.printStackTrace((Throwable)badLocationException);
        }
    }

    private CodeGenerator.Factory[] getCodeGeneratorFactories() {
        return this.generators;
    }
}

