/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.java.editor.imports;

import com.sun.source.tree.IdentifierTree;
import com.sun.source.tree.MemberSelectTree;
import com.sun.source.tree.Scope;
import com.sun.source.tree.Tree;
import com.sun.source.tree.VariableTree;
import com.sun.source.util.TreePath;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.lang.model.element.Element;
import javax.lang.model.element.ElementKind;
import javax.lang.model.element.PackageElement;
import javax.lang.model.element.TypeElement;
import javax.lang.model.type.DeclaredType;
import javax.lang.model.type.TypeKind;
import javax.lang.model.type.TypeMirror;
import javax.lang.model.util.Types;
import org.netbeans.api.java.source.ClassIndex;
import org.netbeans.api.java.source.CompilationInfo;
import org.netbeans.api.java.source.ElementHandle;
import org.netbeans.api.java.source.support.CancellableTreePathScanner;
import org.openide.util.Union2;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ComputeImports {
    private static final String ERROR = "<error>";
    private boolean cancelled;
    private TreeVisitorImpl visitor;
    private static EnumSet<TypeKind> INVALID_TYPES = EnumSet.of(TypeKind.NULL, TypeKind.NONE, TypeKind.OTHER, TypeKind.ERROR);

    public synchronized void cancel() {
        this.cancelled = true;
        if (this.visitor != null) {
            this.visitor.cancel();
        }
    }

    private synchronized boolean isCancelled() {
        return this.cancelled;
    }

    public Pair<Map<String, List<TypeElement>>, Map<String, List<TypeElement>>> computeCandidates(CompilationInfo compilationInfo) {
        return this.computeCandidates(compilationInfo, Collections.<String>emptySet());
    }

    private synchronized void setVisitor(TreeVisitorImpl treeVisitorImpl) {
        this.visitor = treeVisitorImpl;
    }

    Pair<Map<String, List<TypeElement>>, Map<String, List<TypeElement>>> computeCandidates(CompilationInfo compilationInfo, Set<String> set) {
        HashMap<String, List<TypeElement>> hashMap = new HashMap<String, List<TypeElement>>();
        HashMap<String, List<TypeElement>> hashMap2 = new HashMap<String, List<TypeElement>>();
        TreeVisitorImpl treeVisitorImpl = new TreeVisitorImpl(compilationInfo);
        this.setVisitor(treeVisitorImpl);
        treeVisitorImpl.scan(compilationInfo.getCompilationUnit(), new HashMap());
        this.setVisitor(null);
        HashSet<String> hashSet = new HashSet<String>(treeVisitorImpl.unresolved);
        hashSet.addAll(set);
        for (String object : hashSet) {
            if (this.isCancelled()) {
                return new Pair<Map<String, List<TypeElement>>, Map<String, List<TypeElement>>>(Collections.emptyMap(), Collections.emptyMap());
            }
            Object object2 = new ArrayList();
            for (ElementHandle elementHandle : compilationInfo.getJavaSource().getClasspathInfo().getClassIndex().getDeclaredTypes(object, ClassIndex.NameKind.SIMPLE_NAME, EnumSet.allOf(ClassIndex.SearchScope.class))) {
                TypeElement typeElement = compilationInfo.getElements().getTypeElement(elementHandle.getQualifiedName());
                if (typeElement == null) {
                    Logger.getLogger(ComputeImports.class.getName()).log(Level.INFO, "Cannot resolve type element \"" + elementHandle + "\".");
                    continue;
                }
                object2.add(typeElement);
            }
            Collections.sort(object2, new Comparator<TypeElement>(){

                @Override
                public int compare(TypeElement typeElement, TypeElement typeElement2) {
                    return typeElement == typeElement2 ? 0 : typeElement.getQualifiedName().toString().compareTo(typeElement2.getQualifiedName().toString());
                }
            });
            hashMap.put(object, new ArrayList(object2));
            hashMap2.put(object, (List<TypeElement>)object2);
        }
        boolean bl = true;
        while (bl) {
            if (this.isCancelled()) {
                return new Pair<Map<String, List<TypeElement>>, Map<String, List<TypeElement>>>(Collections.emptyMap(), Collections.emptyMap());
            }
            bl = false;
            for (Object object2 : treeVisitorImpl.hints) {
                bl |= object2.filter(compilationInfo, hashMap2, hashMap);
            }
        }
        return new Pair<Map<String, List<TypeElement>>, Map<String, List<TypeElement>>>(hashMap, hashMap2);
    }

    private static boolean filter(Types types, List<TypeElement> list, List<TypeElement> list2, boolean bl, boolean bl2) {
        boolean bl3 = false;
        HashMap<TypeElement, Object> hashMap = new HashMap<TypeElement, Object>();
        for (TypeElement object : list) {
            Object object2 = new ArrayList();
            for (TypeElement typeElement : list2) {
                TypeMirror typeMirror = types.erasure(object.asType());
                TypeMirror typeMirror2 = types.erasure(typeElement.asType());
                if (!types.isAssignable(typeMirror2, typeMirror)) continue;
                object2.add(typeElement);
            }
            hashMap.put(object, object2);
        }
        HashSet hashSet = new HashSet();
        for (Object object2 : hashMap.keySet()) {
            List list3 = (List)hashMap.get(object2);
            if (list3.isEmpty() && !bl) {
                list.remove(object2);
                bl3 = true;
            }
            hashSet.addAll(list3);
        }
        if (!bl2) {
            bl3 = list2.retainAll(hashSet) | bl3;
        }
        return bl3;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static final class AccessibleHint
    implements Hint {
        private String simpleName;
        private Scope scope;

        public AccessibleHint(String string, Scope scope) {
            this.simpleName = string;
            this.scope = scope;
        }

        @Override
        public boolean filter(CompilationInfo compilationInfo, Map<String, List<TypeElement>> map, Map<String, List<TypeElement>> map2) {
            List<TypeElement> list = map2.get(this.simpleName);
            if (list == null || list.isEmpty()) {
                return false;
            }
            ArrayList<TypeElement> arrayList = new ArrayList<TypeElement>();
            for (TypeElement typeElement : list) {
                if (compilationInfo.getTrees().isAccessible(this.scope, typeElement)) continue;
                arrayList.add(typeElement);
            }
            map.get(this.simpleName).removeAll(arrayList);
            return list.removeAll(arrayList);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static final class EnclosedHint
    implements Hint {
        private String simpleName;
        private String methodName;
        private boolean allowPrefix;

        public EnclosedHint(String string, String string2, boolean bl) {
            this.simpleName = string;
            this.methodName = string2;
            this.allowPrefix = bl;
        }

        @Override
        public boolean filter(CompilationInfo compilationInfo, Map<String, List<TypeElement>> map, Map<String, List<TypeElement>> map2) {
            List<TypeElement> list = map2.get(this.simpleName);
            if (list == null || list.isEmpty()) {
                return false;
            }
            ArrayList<TypeElement> arrayList = new ArrayList<TypeElement>();
            for (TypeElement typeElement : list) {
                boolean bl = false;
                for (Element element : typeElement.getEnclosedElements()) {
                    String string = element.getSimpleName().toString();
                    if (this.methodName.contentEquals(string)) {
                        bl = true;
                        break;
                    }
                    if (!this.allowPrefix || !string.startsWith(this.methodName)) continue;
                    bl = true;
                    break;
                }
                if (bl) continue;
                arrayList.add(typeElement);
            }
            return list.removeAll(arrayList);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static interface Hint {
        public boolean filter(CompilationInfo var1, Map<String, List<TypeElement>> var2, Map<String, List<TypeElement>> var3);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class Pair<A, B> {
        public A a;
        public B b;

        public Pair(A a, B b) {
            this.a = a;
            this.b = b;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class TreeVisitorImpl
    extends CancellableTreePathScanner<Void, Map<String, Object>> {
        private CompilationInfo info;
        private Set<String> unresolved;
        private List<Hint> hints;

        public TreeVisitorImpl(CompilationInfo compilationInfo) {
            this.info = compilationInfo;
            this.unresolved = new HashSet<String>();
            this.hints = new ArrayList<Hint>();
        }

        public Void visitMemberSelect(MemberSelectTree memberSelectTree, Map<String, Object> map) {
            if (memberSelectTree.getExpression().getKind() == Tree.Kind.IDENTIFIER) {
                map.put("request", null);
            }
            this.scan(memberSelectTree.getExpression(), map);
            Union2 union2 = (Union2)map.remove("result");
            map.remove("request");
            if (union2 != null && union2.hasFirst()) {
                boolean bl;
                String string = memberSelectTree.getIdentifier().toString();
                if (ComputeImports.ERROR.equals(string)) {
                    string = "";
                }
                boolean bl2 = bl = this.getCurrentPath().getParentPath().getLeaf().getKind() == Tree.Kind.METHOD_INVOCATION;
                if (!"class".equals(string)) {
                    this.hints.add(new EnclosedHint((String)union2.first(), string, !bl));
                }
            }
            return null;
        }

        public Void visitVariable(VariableTree variableTree, Map<String, Object> map) {
            this.scan(variableTree.getModifiers(), map);
            if (variableTree.getType().getKind() == Tree.Kind.IDENTIFIER) {
                map.put("request", null);
            }
            this.scan(variableTree.getType(), map);
            Union2 union2 = (Union2)map.remove("result");
            map.remove("request");
            Union2 union22 = null;
            if (union2 != null && variableTree.getInitializer() != null) {
                TypeMirror typeMirror;
                Element element = this.info.getTrees().getElement(new TreePath(this.getCurrentPath(), variableTree.getInitializer()));
                TypeMirror typeMirror2 = typeMirror = element != null ? element.asType() : null;
                if (typeMirror != null && typeMirror.getKind() == TypeKind.DECLARED) {
                    union22 = Union2.createSecond((Object)((DeclaredType)typeMirror));
                } else if (variableTree.getInitializer().getKind() == Tree.Kind.NEW_CLASS || variableTree.getInitializer().getKind() == Tree.Kind.NEW_ARRAY) {
                    map.put("request", null);
                }
            }
            this.scan(variableTree.getInitializer(), map);
            union22 = union22 == null ? (Union2)map.remove("result") : union22;
            map.remove("result");
            map.remove("request");
            if (!(union2 == null || union22 == null || union2 instanceof TypeMirror && union22 instanceof TypeMirror)) {
                this.hints.add(new TypeHint((Union2<String, DeclaredType>)union2, (Union2<String, DeclaredType>)union22));
            }
            return null;
        }

        public Void visitIdentifier(IdentifierTree identifierTree, Map<String, Object> map) {
            super.visitIdentifier(identifierTree, map);
            Element element = this.info.getTrees().getElement(this.getCurrentPath());
            if (element != null && (element.getKind().isClass() || element.getKind().isInterface() || element.getKind() == ElementKind.PACKAGE)) {
                Object object;
                TypeMirror typeMirror = element.asType();
                String string = null;
                if (typeMirror.getKind() == TypeKind.ERROR) {
                    string = element.getSimpleName().toString();
                }
                if (typeMirror.getKind() == TypeKind.PACKAGE) {
                    object = ((PackageElement)element).getQualifiedName().toString();
                    if (this.info.getElements().getPackageElement((CharSequence)object) == null) {
                        string = element.getSimpleName().toString();
                    }
                }
                if (ComputeImports.ERROR.equals(string)) {
                    string = null;
                }
                if (string != null) {
                    this.unresolved.add(string);
                    object = this.info.getTrees().getScope(this.getCurrentPath());
                    this.hints.add(new AccessibleHint(string, (Scope)object));
                    if (map.containsKey("request")) {
                        map.put("result", Union2.createFirst((Object)string));
                    }
                } else if (map.containsKey("request") && typeMirror.getKind() == TypeKind.DECLARED) {
                    map.put("result", Union2.createSecond((Object)((DeclaredType)typeMirror)));
                }
            }
            map.remove("request");
            return null;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static final class TypeHint
    implements Hint {
        private Union2<String, DeclaredType> left;
        private Union2<String, DeclaredType> right;

        public TypeHint(Union2<String, DeclaredType> union2, Union2<String, DeclaredType> union22) {
            this.left = union2;
            this.right = union22;
        }

        @Override
        public boolean filter(CompilationInfo compilationInfo, Map<String, List<TypeElement>> map, Map<String, List<TypeElement>> map2) {
            Element element;
            List<TypeElement> list = null;
            List<TypeElement> list2 = null;
            boolean bl = false;
            boolean bl2 = false;
            if (this.left.hasSecond()) {
                element = ((DeclaredType)this.left.second()).asElement();
                if (element instanceof TypeElement) {
                    list = Collections.singletonList((TypeElement)element);
                    bl = true;
                }
            } else {
                list = map2.get(this.left.first());
            }
            if (this.right.hasSecond()) {
                element = ((DeclaredType)this.right.second()).asElement();
                if (element instanceof TypeElement) {
                    list2 = Collections.singletonList((TypeElement)element);
                    bl2 = true;
                }
            } else {
                list2 = map2.get(this.right.first());
            }
            if (list != null && list2 != null && !list.isEmpty() && !list2.isEmpty()) {
                return ComputeImports.filter(compilationInfo.getTypes(), list, list2, bl, bl2);
            }
            return false;
        }
    }
}

