/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.java.editor.overridden;

import java.util.Collection;
import javax.lang.model.element.Element;
import javax.lang.model.element.ElementKind;
import javax.lang.model.element.ExecutableElement;
import javax.lang.model.element.Modifier;
import javax.lang.model.element.PackageElement;
import javax.lang.model.element.TypeElement;
import javax.lang.model.element.TypeParameterElement;
import javax.lang.model.element.VariableElement;
import javax.lang.model.util.SimpleElementVisitor6;
import javax.swing.Icon;
import org.netbeans.api.java.source.ClasspathInfo;
import org.netbeans.api.java.source.CompilationInfo;
import org.netbeans.api.java.source.ElementHandle;
import org.netbeans.api.java.source.SourceUtils;
import org.netbeans.api.java.source.UiUtils;
import org.netbeans.modules.editor.java.Utilities;
import org.openide.filesystems.FileObject;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ElementDescription {
    private ClasspathInfo originalCPInfo;
    private ElementHandle<Element> handle;
    private ElementHandle<TypeElement> outtermostElement;
    private Collection<Modifier> modifiers;
    private String displayName;

    public ElementDescription(CompilationInfo compilationInfo, Element element) {
        this.originalCPInfo = compilationInfo.getClasspathInfo();
        this.handle = ElementHandle.create((Element)element);
        this.outtermostElement = ElementHandle.create((Element)SourceUtils.getOutermostEnclosingTypeElement((Element)element));
        this.modifiers = element.getModifiers();
        this.displayName = element.accept(new ElementNameVisitor(), true);
    }

    public FileObject getSourceFile() {
        FileObject fileObject = SourceUtils.getFile(this.outtermostElement, (ClasspathInfo)this.originalCPInfo);
        if (fileObject != null) {
            return SourceUtils.getFile(this.outtermostElement, (ClasspathInfo)ClasspathInfo.create((FileObject)fileObject));
        }
        return null;
    }

    public ElementHandle<Element> getHandle() {
        return this.handle;
    }

    public Icon getIcon() {
        return UiUtils.getElementIcon((ElementKind)this.handle.getKind(), this.modifiers);
    }

    public String getDisplayName() {
        return this.displayName;
    }

    public Collection<Modifier> getModifiers() {
        return this.modifiers;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class ElementNameVisitor
    extends SimpleElementVisitor6<String, Boolean> {
        private ElementNameVisitor() {
        }

        @Override
        public String visitPackage(PackageElement packageElement, Boolean bl) {
            return bl != false ? packageElement.getQualifiedName().toString() : packageElement.getSimpleName().toString();
        }

        @Override
        public String visitType(TypeElement typeElement, Boolean bl) {
            if (typeElement.getQualifiedName() == null || typeElement.getSimpleName() == null) {
                return "annonymous inner";
            }
            return bl != false ? typeElement.getQualifiedName().toString() : typeElement.getSimpleName().toString();
        }

        @Override
        public String visitExecutable(ExecutableElement executableElement, Boolean bl) {
            StringBuffer stringBuffer = new StringBuffer();
            stringBuffer.append(executableElement.getEnclosingElement().accept(this, bl));
            stringBuffer.append(".");
            stringBuffer.append(executableElement.getSimpleName());
            stringBuffer.append("(");
            boolean bl2 = false;
            for (VariableElement variableElement : executableElement.getParameters()) {
                if (bl2) {
                    stringBuffer.append(", ");
                }
                bl2 = true;
                stringBuffer.append(variableElement.accept(this, bl));
            }
            stringBuffer.append(")");
            return stringBuffer.toString();
        }

        @Override
        public String visitVariable(VariableElement variableElement, Boolean bl) {
            return Utilities.getTypeName(variableElement.asType(), false) + " " + variableElement.getSimpleName();
        }

        @Override
        public String visitTypeParameter(TypeParameterElement typeParameterElement, Boolean bl) {
            return typeParameterElement.getSimpleName().toString();
        }
    }
}

