/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.java.editor.rename;

import com.sun.source.util.TreePath;
import java.awt.event.ActionEvent;
import java.io.IOException;
import java.util.EnumSet;
import java.util.HashSet;
import java.util.Set;
import javax.lang.model.element.Element;
import javax.lang.model.element.ElementKind;
import javax.lang.model.element.ExecutableElement;
import javax.lang.model.util.ElementFilter;
import javax.swing.Action;
import javax.swing.text.BadLocationException;
import javax.swing.text.JTextComponent;
import org.netbeans.api.java.source.CancellableTask;
import org.netbeans.api.java.source.CompilationController;
import org.netbeans.api.java.source.CompilationInfo;
import org.netbeans.api.java.source.JavaSource;
import org.netbeans.editor.BaseAction;
import org.netbeans.editor.BaseDocument;
import org.netbeans.editor.Utilities;
import org.netbeans.modules.editor.highlights.spi.Highlight;
import org.netbeans.modules.java.editor.rename.InstantRenamePerformer;
import org.netbeans.modules.java.editor.semantic.ColoringAttributes;
import org.netbeans.modules.java.editor.semantic.FindLocalUsagesQuery;
import org.netbeans.modules.refactoring.api.ui.RefactoringActionsFactory;
import org.openide.ErrorManager;
import org.openide.cookies.EditorCookie;
import org.openide.filesystems.FileObject;
import org.openide.loaders.DataObject;
import org.openide.nodes.Node;
import org.openide.util.Lookup;
import org.openide.util.lookup.AbstractLookup;
import org.openide.util.lookup.InstanceContent;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class InstantRenameAction
extends BaseAction {
    private static final Set<ElementKind> LOCAL_CLASS_PARENTS = EnumSet.of(ElementKind.CONSTRUCTOR, ElementKind.INSTANCE_INIT, ElementKind.METHOD, ElementKind.STATIC_INIT);

    public InstantRenameAction() {
        super("in-place-refactoring", 142);
    }

    public void actionPerformed(ActionEvent actionEvent, JTextComponent jTextComponent) {
        try {
            final int n = jTextComponent.getCaretPosition();
            String string = Utilities.getIdentifier((BaseDocument)Utilities.getDocument((JTextComponent)jTextComponent), (int)n);
            if (string == null) {
                Utilities.setStatusBoldText((JTextComponent)jTextComponent, (String)"Cannot perform instant rename here.");
                return;
            }
            DataObject dataObject = (DataObject)jTextComponent.getDocument().getProperty("stream");
            JavaSource javaSource = JavaSource.forFileObject((FileObject)dataObject.getPrimaryFile());
            final boolean[] blArray = new boolean[1];
            final Set[] setArray = new Set[1];
            javaSource.runUserActionTask((CancellableTask)new CancellableTask<CompilationController>(){

                public void cancel() {
                }

                public void run(CompilationController compilationController) throws Exception {
                    if (compilationController.toPhase(JavaSource.Phase.RESOLVED).compareTo((Enum)JavaSource.Phase.RESOLVED) < 0) {
                        return;
                    }
                    setArray[0] = InstantRenameAction.computeChangePoints((CompilationInfo)compilationController, n, blArray);
                }
            }, true);
            if (blArray[0]) {
                if (setArray[0] != null) {
                    this.doInstantRename(setArray[0], jTextComponent, n, string);
                } else {
                    this.doFullRename((EditorCookie)dataObject.getCookie(EditorCookie.class), dataObject.getNodeDelegate());
                }
            } else {
                Utilities.setStatusBoldText((JTextComponent)jTextComponent, (String)"Cannot perform instant rename here.");
            }
        }
        catch (BadLocationException badLocationException) {
            ErrorManager.getDefault().notify((Throwable)badLocationException);
        }
        catch (IOException iOException) {
            ErrorManager.getDefault().notify((Throwable)iOException);
        }
    }

    protected Class getShortDescriptionBundleClass() {
        return InstantRenameAction.class;
    }

    private void doInstantRename(Set<Highlight> set, JTextComponent jTextComponent, int n, String string) throws BadLocationException {
        InstantRenamePerformer.performInstantRename(jTextComponent, set, n);
    }

    private void doFullRename(EditorCookie editorCookie, Node node) {
        InstanceContent instanceContent = new InstanceContent();
        instanceContent.add((Object)editorCookie);
        instanceContent.add((Object)node);
        AbstractLookup abstractLookup = new AbstractLookup((AbstractLookup.Content)instanceContent);
        Action action = RefactoringActionsFactory.renameAction().createContextAwareInstance((Lookup)abstractLookup);
        action.actionPerformed(RefactoringActionsFactory.DEFAULT_EVENT);
    }

    static Set<Highlight> computeChangePoints(CompilationInfo compilationInfo, final int n, final boolean[] blArray) throws IOException {
        TreePath treePath = compilationInfo.getTreeUtilities().pathFor(n);
        Element element = compilationInfo.getTrees().getElement(treePath);
        if (element == null) {
            blArray[0] = false;
            return null;
        }
        final Highlight highlight = org.netbeans.modules.java.editor.semantic.Utilities.createHighlight(compilationInfo.getCompilationUnit(), compilationInfo.getTrees().getSourcePositions(), compilationInfo.getDocument(), treePath, EnumSet.of(ColoringAttributes.MARK_OCCURRENCES), null);
        compilationInfo.getDocument().render(new Runnable(){

            public void run() {
                blArray[0] = highlight.getStart() <= n && n <= highlight.getEnd();
            }
        });
        if (!blArray[0]) {
            return null;
        }
        if (element.getKind() == ElementKind.CONSTRUCTOR) {
            element = element.getEnclosingElement();
        }
        if (InstantRenameAction.allowInstantRename(element)) {
            HashSet<Highlight> hashSet = new HashSet<Highlight>(new FindLocalUsagesQuery().findUsages(element, compilationInfo, compilationInfo.getDocument()));
            if (element.getKind().isClass()) {
                for (ExecutableElement executableElement : ElementFilter.constructorsIn(element.getEnclosedElements())) {
                    Highlight highlight2;
                    TreePath treePath2 = compilationInfo.getTrees().getPath(executableElement);
                    if (treePath2 == null || (highlight2 = org.netbeans.modules.java.editor.semantic.Utilities.createHighlight(compilationInfo.getCompilationUnit(), compilationInfo.getTrees().getSourcePositions(), compilationInfo.getDocument(), treePath2, EnumSet.of(ColoringAttributes.MARK_OCCURRENCES), null)) == null) continue;
                    hashSet.add(highlight2);
                }
            }
            return hashSet;
        }
        return null;
    }

    private static boolean allowInstantRename(Element element) {
        if (org.netbeans.modules.java.editor.semantic.Utilities.isPrivateElement(element)) {
            return true;
        }
        if (element.getKind() == ElementKind.CLASS) {
            Element element2 = element.getEnclosingElement();
            return LOCAL_CLASS_PARENTS.contains((Object)element2.getKind());
        }
        return false;
    }
}

